/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc.importExport;

import com.exasol.jdbc.Translator;
import com.exasol.jdbc.importExport.EXARetryPushException;
import com.exasol.jdbc.importExport.HTTPThread;
import com.exasol.jdbc.importExport.KeyManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.sql.SQLException;
import java.util.HashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class HttpPush {
    private Socket sock = null;
    private HashMap hd = new HashMap();
    private String commandstring;
    private String urlstring;
    private String[] fileNames;
    private DataOutputStream out = null;
    private DataInputStream in = null;
    private String remotehost = "";
    private String cookie = "";
    private int remoteport = 0;
    private boolean secure = false;
    HTTPThread caller = null;

    private static final int swabInt(int v) {
        return v >>> 24 | v << 24 | v << 8 & 0xFF0000 | v >> 8 & 0xFF00;
    }

    public HttpPush(Socket socket, String[] fNames, String ck, boolean sec, boolean indirect) throws IOException, SQLException {
        this.fileNames = fNames;
        this.sock = socket;
        this.cookie = ck;
        this.secure = sec;
        this.in = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
        this.out = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
        if (indirect) {
            this.out.writeInt(0x2212102);
            this.out.writeInt(HttpPush.swabInt(1));
            this.out.writeInt(HttpPush.swabInt(1));
            this.out.flush();
            try {
                if (HttpPush.swabInt(this.in.readInt()) != 1) {
                    throw new SQLException(Translator.WrongProtocolNumber(), "04507");
                }
            }
            catch (IOException ioex) {
                throw new EXARetryPushException(ioex);
            }
            this.remoteport = HttpPush.swabInt(this.in.readInt());
            byte[] buff = new byte[16];
            this.in.readFully(buff);
            this.remotehost = new String(buff, 0, 15).trim();
        }
    }

    public void connect(HTTPThread callerThread) throws IOException, InterruptedException {
        int data;
        this.caller = callerThread;
        if (this.caller.ThreadWasInterrupted()) {
            this.close();
            throw new InterruptedException("HTTPThread canceled.");
        }
        if (this.secure) {
            try {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init((KeyStore)null);
                SSLContext scx = SSLContext.getInstance("SSL");
                KeyManager k = new KeyManager();
                scx.init(k.getKeyManager().getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
                SSLSocketFactory sslSocketFactory = scx.getSocketFactory();
                if (this.caller.ThreadWasInterrupted()) {
                    this.close();
                    throw new InterruptedException("HTTPS Thread canceled.");
                }
                SSLSocket s = (SSLSocket)sslSocketFactory.createSocket(this.sock, this.remotehost, this.remoteport, true);
                s.setUseClientMode(false);
                s.setEnableSessionCreation(true);
                s.setNeedClientAuth(false);
                s.setWantClientAuth(false);
                if (this.caller.ThreadWasInterrupted()) {
                    s.close();
                    this.close();
                    throw new InterruptedException("HTTPS Thread canceled.");
                }
                s.startHandshake();
                this.sock = s;
                this.in = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
                this.out = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
            }
            catch (IOException | InterruptedException ex) {
                throw ex;
            }
            catch (Throwable t) {
                throw new IOException("Exception in connect: " + t.toString());
            }
        }
        ByteArrayOutputStream command = new ByteArrayOutputStream();
        ByteArrayOutputStream url = new ByteArrayOutputStream();
        ByteArrayOutputStream header = new ByteArrayOutputStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.caller.NowConnected();
        String key = "";
        String value = "";
        int state = 0;
        while (this.in.available() == 0 && state == 3 || this.caller.ThreadWasInterrupted()) {
            if (!this.caller.ThreadWasInterrupted()) continue;
            this.close();
            throw new InterruptedException("HTTP Thread canceled.");
        }
        while (state != 3 && !this.caller.ThreadWasInterrupted() && (data = this.in.read()) != -1) {
            switch (state) {
                case 0: {
                    if (data == 32) {
                        command.close();
                        state = 1;
                        break;
                    }
                    if (data == 10) {
                        command.close();
                        state = 4;
                        break;
                    }
                    command.write(data);
                    break;
                }
                case 1: {
                    if (data == 32) {
                        url.close();
                        state = 2;
                        break;
                    }
                    if (data == 10) {
                        url.close();
                        state = 4;
                        break;
                    }
                    url.write(data);
                    break;
                }
                case 2: {
                    if (data != 10) break;
                    state = 4;
                    break;
                }
                case 4: {
                    if (data == 10) {
                        state = 3;
                        break;
                    }
                    if ("\r ".indexOf(data) >= 0) break;
                    if (data == 58) {
                        buffer.close();
                        key = buffer.toString();
                        buffer = new ByteArrayOutputStream();
                        state = 5;
                        break;
                    }
                    buffer.write(data);
                    break;
                }
                case 5: {
                    if ("\n".indexOf(data) >= 0) {
                        state = 6;
                        break;
                    }
                    if ("\r".indexOf(data) >= 0) break;
                    buffer.write(data);
                    break;
                }
                case 6: {
                    if (" ".indexOf(data) >= 0) {
                        state = 5;
                        break;
                    }
                    buffer.close();
                    value = buffer.toString();
                    if (key == null) {
                        throw new IOException("internal error");
                    }
                    this.hd.put(key, value);
                    if (data == 10) {
                        state = 3;
                        break;
                    }
                    buffer = new ByteArrayOutputStream();
                    buffer.write(data);
                    state = 4;
                }
            }
        }
        this.commandstring = command.toString();
        this.urlstring = url.toString();
    }

    public String getRemoteHost() {
        return this.remotehost;
    }

    public int getRemotePort() {
        return this.remoteport;
    }

    public HashMap getHeader() {
        return this.hd;
    }

    public String getCommand() {
        return this.commandstring;
    }

    public String getURL() {
        return this.urlstring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(PushFileInterface file) throws IOException {
        try {
            this.out.write("HTTP/1.1 200 OK\r\n".getBytes());
            this.out.write("Server: EXALoader\r\n".getBytes());
            this.out.write("Content-type: application/octet-stream\r\n".getBytes());
            this.out.write("Content-disposition: attachment; filename=".getBytes());
            for (int i = 0; i < this.fileNames.length; ++i) {
                this.out.write(this.fileNames[i].getBytes());
                if (i >= this.fileNames.length - 1) continue;
                this.out.write(" ,".getBytes());
            }
            this.out.write("\r\nConnection: close\r\n\r\n".getBytes());
            this.out.flush();
            byte[] buf = file.getBuffer();
            while (file.hasMoreElements()) {
                int nextel = file.nextElement();
                this.out.write(buf, 0, nextel);
            }
            this.out.flush();
        }
        finally {
            this.close();
            file.close();
        }
    }

    public void pushFileNotFound(String message) throws IOException {
        try {
            this.out.write("HTTP/1.1 404 Not found\r\n\r\n".getBytes());
            this.out.flush();
        }
        finally {
            this.close();
        }
    }

    public void pushPermissionDenied(String message) throws IOException {
        try {
            this.out.write("HTTP/1.1 401 Unauthorized\r\n\r\n".getBytes());
            this.out.flush();
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pull(PullFileInterface file) throws IOException {
        try {
            this.out.write("HTTP/1.1 100 OK\r\n".getBytes());
            this.out.write("Server: EXALoader\r\n\r\n".getBytes());
            this.out.flush();
            try {
                String line;
                int length;
                while ((length = Integer.parseInt(line = this.in.readLine(), 16)) != 0) {
                    byte[] buffer = new byte[length + 2];
                    this.in.readFully(buffer, 0, length + 2);
                    file.putBuffer(buffer, length);
                }
            }
            finally {
                file.close();
            }
            this.out.write("HTTP/1.1 200 OK\r\n".getBytes());
            this.out.write("Server: EXALoader\r\n".getBytes());
            this.out.write("Connection: close\r\n\r\n".getBytes());
        }
        finally {
            this.out.flush();
            this.close();
        }
    }

    public void close() throws IOException {
        this.out.close();
        this.sock.close();
        if (null != this.caller) {
            this.caller.NowDisconnected();
        }
    }

    public static class ServerState {
        static final int COMMAND = 0;
        static final int URL = 1;
        static final int VERSION = 2;
        static final int EOF = 3;
        static final int KEY = 4;
        static final int VALUE = 5;
        static final int NEWLINE = 6;
    }

    public static interface PushFileInterface {
        public byte[] getBuffer();

        public boolean hasMoreElements() throws IOException;

        public int nextElement() throws IOException;

        public void close() throws IOException;
    }

    public static interface PullFileInterface {
        public void putBuffer(byte[] var1, int var2) throws IOException;

        public void close() throws IOException;
    }
}

