/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc.importExport;

import com.exasol.jdbc.importExport.FileValidator;
import com.exasol.jdbc.importExport.QueryPattern;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryManipulator {
    public static String GetCommentsFromLast(Matcher match, String key, FileValidator FV) {
        String Comments = "";
        if (match.group(key) != null) {
            Pattern commentPattern = Pattern.compile("(/\\*(.*?)\\*/)", 34);
            Matcher commentMatcher = commentPattern.matcher(match.group(key));
            while (commentMatcher.find()) {
                String CommentHash = commentMatcher.group(1);
                String value = FV.getCommentForHash(CommentHash);
                if (value == null) continue;
                if (value.trim().startsWith("--")) {
                    Comments = Comments.concat(value);
                    continue;
                }
                Comments = Comments.concat(value + " ");
            }
        }
        return Comments;
    }

    public static String extractEndingQueries(String SQL, Matcher match, String key) {
        String sql_end = match.end(key) >= SQL.length() ? "" : SQL.substring(match.end(key)).replaceAll("^\\s+", "");
        return sql_end;
    }

    public static String addMultiFilesTagAndSemicolon(String SQL, boolean isMultiFiles) {
        int SemicolonIndx;
        if (SQL == null) {
            return null;
        }
        String multiFiles = "";
        if (isMultiFiles) {
            multiFiles = " MULTIPLE LOCAL FILES";
        }
        Matcher match = Pattern.compile("^.*" + System.getProperty("line.separator") + "(?<LastLine>.*)$", 34).matcher(SQL);
        boolean appendToNewLine = false;
        if (match.matches()) {
            appendToNewLine = match.group("LastLine").contains("--");
        }
        if (appendToNewLine) {
            multiFiles = System.getProperty("line.separator") + multiFiles;
        }
        SQL = (SemicolonIndx = QueryManipulator.SemicolonIndex(SQL)) < 0 ? SQL + multiFiles + ";" : SQL.substring(0, SemicolonIndx) + multiFiles + SQL.substring(SemicolonIndx);
        return SQL;
    }

    public static String extractInbetweenQueryForError(String SQL, Matcher match, String firstKey, String errorKey) {
        String sql_end = match.end(firstKey) >= SQL.length() ? "" : SQL.substring(match.end(firstKey), match.start(errorKey)).trim();
        return sql_end;
    }

    public static String ReplaceMultiLineComment(String SQL, char ch) {
        Matcher match = Pattern.compile("/\\*(.*?)\\*/", 34).matcher(SQL);
        while (match.find()) {
            for (int i = 0; i < match.groupCount(); ++i) {
                char[] chArray = new char[match.group(i).length()];
                Arrays.fill(chArray, ch);
                SQL = SQL.replace(match.group(i), new String(chArray));
            }
        }
        return SQL;
    }

    public static String ReplaceSingleLineComment(String SQL, char ch) {
        Matcher match = Pattern.compile("--.*?(" + System.getProperty("line.separator") + "|\\n|$)", 34).matcher(SQL);
        while (match.find()) {
            for (int i = 0; i < match.groupCount(); ++i) {
                char[] chArray = new char[match.group(i).length()];
                Arrays.fill(chArray, ch);
                SQL = SQL.replace(match.group(i), new String(chArray));
            }
        }
        return SQL;
    }

    public static int SemicolonIndex(String SQL) {
        boolean QueryContainsSemicolon = QueryManipulator.RemoveComment(SQL).trim().endsWith(";");
        if (QueryContainsSemicolon) {
            return QueryManipulator.ReplaceSingleLineComment(QueryManipulator.ReplaceMultiLineComment(SQL, '*'), '*').indexOf(59);
        }
        return -1;
    }

    public static String RemoveComment(String SQL) {
        StringBuilder result = new StringBuilder();
        boolean inSingleLineComment = false;
        boolean inMultiLineComment = false;
        for (int i = 0; i < SQL.length(); ++i) {
            char currentChar = SQL.charAt(i);
            if (inSingleLineComment) {
                if (currentChar != '\n' && currentChar != '\r') continue;
                inSingleLineComment = false;
                continue;
            }
            if (inMultiLineComment) {
                if (currentChar != '*' || i >= SQL.length() - 1 || SQL.charAt(i + 1) != '/') continue;
                inMultiLineComment = false;
                ++i;
                continue;
            }
            if (currentChar == '-' && i < SQL.length() - 1 && SQL.charAt(i + 1) == '-') {
                inSingleLineComment = true;
                ++i;
                continue;
            }
            if (currentChar == '/' && i < SQL.length() - 1 && SQL.charAt(i + 1) == '*') {
                inMultiLineComment = true;
                ++i;
                continue;
            }
            result.append(currentChar);
        }
        return result.toString();
    }

    public static String BuildImpExpQuery(String URL2, String URLError, FileValidator FV) throws SQLException {
        if (URL2 == null) {
            throw new SQLException("[ERROR] Local File URL is null");
        }
        if (URL2.trim().length() == 0) {
            throw new SQLException("[ERROR] Local File URL is Empty");
        }
        String EndQuery = "";
        if (FV.getErrFiles() != null) {
            if (URLError == null) {
                throw new SQLException("[ERROR] Local Error File URL is null");
            }
            if (URLError.trim().length() == 0) {
                throw new SQLException("[ERROR] Local Error File URL is Empty");
            }
            String sql = QueryManipulator.extractInbetweenQueryForError(FV.getSql(), FV.getMatcher(), QueryPattern.regexMainKey, QueryPattern.regexErrorKey);
            String FileErrorMsg = sql + " ERRORS INTO CSV AT '" + URLError + "' FILE '" + FV.getCookieErr() + "' " + QueryPattern.CreateFilenameQueryComment(FV.getErrFiles()) + QueryManipulator.GetCommentsFromLast(FV.getMatcher(), QueryPattern.regexErrorKey, FV);
            EndQuery = EndQuery + FileErrorMsg + QueryManipulator.extractEndingQueries(FV.getSql(), FV.getMatcher(), QueryPattern.regexErrorKey);
        } else {
            EndQuery = QueryManipulator.extractEndingQueries(FV.getSql(), FV.getMatcher(), QueryPattern.regexMainKey);
        }
        String SQL = FV.getSql().substring(0, FV.getMatcher().end(QueryPattern.regexMainKey) - FV.getMatcher().group(QueryPattern.regexMainKey).length()) + (FV.isCSV() ? "CSV" : "FBV") + " AT '" + URL2 + "' FILE '" + FV.getCookie() + "'";
        String FilesAndComments = QueryPattern.CreateFilenameQueryComment(FV.getFiles()) + " " + QueryManipulator.GetCommentsFromLast(FV.getMatcher(), QueryPattern.regexMainKey, FV);
        SQL = SQL + " " + FilesAndComments + EndQuery;
        SQL = FV.replaceHashWithComments(SQL);
        if (SQL != null) {
            SQL = QueryManipulator.addMultiFilesTagAndSemicolon(SQL, FV.getFiles().length > 1);
        }
        return SQL;
    }
}

