/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.org.bouncycastle.asn1.x509;

import java.math.BigInteger;
import java.util.Enumeration;
import thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import thirdparty.org.bouncycastle.asn1.ASN1Integer;
import thirdparty.org.bouncycastle.asn1.ASN1Object;
import thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import thirdparty.org.bouncycastle.asn1.DERSequence;

public class RSAPublicKeyStructure
extends ASN1Object {
    private BigInteger modulus;
    private BigInteger publicExponent;

    public static RSAPublicKeyStructure getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return RSAPublicKeyStructure.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static RSAPublicKeyStructure getInstance(Object object) {
        if (object == null || object instanceof RSAPublicKeyStructure) {
            return (RSAPublicKeyStructure)object;
        }
        if (object instanceof ASN1Sequence) {
            return new RSAPublicKeyStructure((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid RSAPublicKeyStructure: " + object.getClass().getName());
    }

    public RSAPublicKeyStructure(BigInteger bigInteger, BigInteger bigInteger2) {
        this.modulus = bigInteger;
        this.publicExponent = bigInteger2;
    }

    public RSAPublicKeyStructure(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.modulus = ASN1Integer.getInstance(enumeration.nextElement()).getPositiveValue();
        this.publicExponent = ASN1Integer.getInstance(enumeration.nextElement()).getPositiveValue();
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(new ASN1Integer(this.getModulus()));
        aSN1EncodableVector.add(new ASN1Integer(this.getPublicExponent()));
        return new DERSequence(aSN1EncodableVector);
    }
}

