/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.org.bouncycastle.crypto.fpe;

import thirdparty.org.bouncycastle.crypto.BlockCipher;
import thirdparty.org.bouncycastle.crypto.CipherParameters;
import thirdparty.org.bouncycastle.crypto.DataLengthException;
import thirdparty.org.bouncycastle.crypto.OutputLengthException;
import thirdparty.org.bouncycastle.crypto.params.FPEParameters;
import thirdparty.org.bouncycastle.util.Pack;

public abstract class FPEEngine {
    protected final BlockCipher baseCipher;
    protected boolean forEncryption;
    protected FPEParameters fpeParameters;

    protected FPEEngine(BlockCipher blockCipher) {
        this.baseCipher = blockCipher;
    }

    public int processBlock(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (this.fpeParameters == null) {
            throw new IllegalStateException("FPE engine not initialized");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("input length cannot be negative");
        }
        if (byArray == null || byArray2 == null) {
            throw new NullPointerException("buffer value is null");
        }
        if (byArray.length < n + n2) {
            throw new DataLengthException("input buffer too short");
        }
        if (byArray2.length < n3 + n2) {
            throw new OutputLengthException("output buffer too short");
        }
        if (this.forEncryption) {
            return this.encryptBlock(byArray, n, n2, byArray2, n3);
        }
        return this.decryptBlock(byArray, n, n2, byArray2, n3);
    }

    protected static short[] toShortArray(byte[] byArray) {
        if ((byArray.length & 1) != 0) {
            throw new IllegalArgumentException("data must be an even number of bytes for a wide radix");
        }
        short[] sArray = new short[byArray.length / 2];
        for (int i = 0; i != sArray.length; ++i) {
            sArray[i] = Pack.bigEndianToShort(byArray, i * 2);
        }
        return sArray;
    }

    protected static byte[] toByteArray(short[] sArray) {
        byte[] byArray = new byte[sArray.length * 2];
        for (int i = 0; i != sArray.length; ++i) {
            Pack.shortToBigEndian(sArray[i], byArray, i * 2);
        }
        return byArray;
    }

    public abstract void init(boolean var1, CipherParameters var2);

    public abstract String getAlgorithmName();

    protected abstract int encryptBlock(byte[] var1, int var2, int var3, byte[] var4, int var5);

    protected abstract int decryptBlock(byte[] var1, int var2, int var3, byte[] var4, int var5);
}

