/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes;

import thirdparty.org.bouncycastle.asn1.ASN1Object;
import thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import thirdparty.org.bouncycastle.oer.OEROptional;
import thirdparty.org.bouncycastle.oer.its.ItsUtils;
import thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes.Psid;
import thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes.ServiceSpecificPermissions;

public class PsidSsp
extends ASN1Object {
    private final Psid psid;
    private final ServiceSpecificPermissions ssp;

    public PsidSsp(Psid psid, ServiceSpecificPermissions serviceSpecificPermissions) {
        this.psid = psid;
        this.ssp = serviceSpecificPermissions;
    }

    private PsidSsp(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("expected sequence size of 2");
        }
        this.psid = Psid.getInstance(aSN1Sequence.getObjectAt(0));
        this.ssp = OEROptional.getValue(ServiceSpecificPermissions.class, aSN1Sequence.getObjectAt(1));
    }

    public static PsidSsp getInstance(Object object) {
        if (object instanceof PsidSsp) {
            return (PsidSsp)object;
        }
        if (object != null) {
            return new PsidSsp(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Psid getPsid() {
        return this.psid;
    }

    public ServiceSpecificPermissions getSsp() {
        return this.ssp;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return ItsUtils.toSequence(this.psid, OEROptional.getInstance(this.ssp));
    }

    public static class Builder {
        private Psid psid;
        private ServiceSpecificPermissions ssp;

        public Builder setPsid(Psid psid) {
            this.psid = psid;
            return this;
        }

        public Builder setSsp(ServiceSpecificPermissions serviceSpecificPermissions) {
            this.ssp = serviceSpecificPermissions;
            return this;
        }

        public PsidSsp createPsidSsp() {
            return new PsidSsp(this.psid, this.ssp);
        }
    }
}

