/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.StreamEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EncryptedOutputStream
extends OutputStream {
    private OutputStream father = null;
    private StreamEncoder encryptor = null;
    ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
    byte[] header = null;

    public EncryptedOutputStream(OutputStream outputS) {
        this.father = outputS;
    }

    public void SetEncryptor(StreamEncoder encryptor2) {
        this.encryptor = encryptor2;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] tmp = new byte[]{(byte)b};
        this.write(tmp, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.memoryStream.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.father.close();
    }

    public void setHeader() throws IOException {
        if (this.memoryStream.size() != 21) {
            throw new IOException("Wrong usage of encryptHeader()");
        }
        this.header = this.memoryStream.toByteArray();
        if (null != this.encryptor) {
            this.encryptor.EncryptBytes(this.header, 0, this.header.length);
        }
        this.memoryStream = new ByteArrayOutputStream();
    }

    @Override
    public void flush() throws IOException {
        ByteArrayOutputStream outMessage = new ByteArrayOutputStream();
        if (null != this.header) {
            outMessage.write(this.header);
            this.header = null;
        }
        if (null == this.encryptor) {
            this.memoryStream.writeTo(outMessage);
        } else {
            byte[] b = this.memoryStream.toByteArray();
            this.encryptor.EncryptBytes(b, 0, b.length);
            outMessage.write(b);
        }
        this.memoryStream.close();
        outMessage.writeTo(this.father);
        outMessage.close();
        this.memoryStream = new ByteArrayOutputStream();
        this.father.flush();
        this.header = null;
    }
}

