/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.StreamEncoder;

public class RC4_encoder
extends StreamEncoder {
    public static int ENCRYPTION_KEY_LEN = 256;
    private byte[] eSBox = new byte[256];
    private byte[] dSBox = new byte[256];
    int ePos1 = 0;
    int dPos1 = 0;
    int ePos2 = 0;
    int dPos2 = 0;

    @Override
    public int SetKeys(byte[] eKey, byte[] dKey) {
        this.dPos2 = 0;
        this.ePos2 = 0;
        this.dPos1 = 0;
        this.ePos1 = 0;
        this.eSBox = this.calculateSboxBase(eKey);
        this.dSBox = this.calculateSboxBase(dKey);
        return 0;
    }

    @Override
    public int EncryptBytes(byte[] bytes, int offset, int len) {
        byte tmp = 0;
        for (int n = offset; n < offset + len; ++n) {
            this.ePos1 = this.ePos1 + 1 & 0xFF;
            this.ePos2 = this.ePos2 + this.eSBox[this.ePos1] & 0xFF;
            tmp = this.eSBox[this.ePos1];
            this.eSBox[this.ePos1] = this.eSBox[this.ePos2];
            this.eSBox[this.ePos2] = tmp;
            bytes[n] = (byte)(bytes[n] ^ this.eSBox[this.eSBox[this.ePos1] + this.eSBox[this.ePos2] & 0xFF]);
        }
        return 0;
    }

    @Override
    public int DecryptBytes(byte[] bytes, int offset, int len) {
        byte tmp = 0;
        for (int n = offset; n < offset + len; ++n) {
            this.dPos1 = this.dPos1 + 1 & 0xFF;
            this.dPos2 = this.dPos2 + this.dSBox[this.dPos1] & 0xFF;
            tmp = this.dSBox[this.dPos1];
            this.dSBox[this.dPos1] = this.dSBox[this.dPos2];
            this.dSBox[this.dPos2] = tmp;
            bytes[n] = (byte)(bytes[n] ^ this.dSBox[this.dSBox[this.dPos1] + this.dSBox[this.dPos2] & 0xFF]);
        }
        return 0;
    }

    byte[] calculateSboxBase(byte[] key) {
        int i = 0;
        int j = 0;
        byte[] sbox = new byte[256];
        for (i = 0; i < 256; ++i) {
            sbox[i] = (byte)i;
        }
        j = 0;
        for (i = 0; i < 256; ++i) {
            j = j + key[i % key.length] + sbox[i] & 0xFF;
            byte tmp = sbox[i];
            sbox[i] = sbox[j];
            sbox[j] = tmp;
        }
        return sbox;
    }
}

