/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.org.bouncycastle.asn1.cms;

import thirdparty.org.bouncycastle.asn1.ASN1Choice;
import thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import thirdparty.org.bouncycastle.asn1.ASN1Object;
import thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import thirdparty.org.bouncycastle.asn1.ASN1Util;
import thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import thirdparty.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import thirdparty.org.bouncycastle.asn1.cms.RecipientKeyIdentifier;

public class KeyAgreeRecipientIdentifier
extends ASN1Object
implements ASN1Choice {
    private IssuerAndSerialNumber issuerSerial;
    private RecipientKeyIdentifier rKeyID;

    public static KeyAgreeRecipientIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException("choice item must be explicitly tagged");
        }
        return KeyAgreeRecipientIdentifier.getInstance(aSN1TaggedObject.getExplicitBaseObject());
    }

    public static KeyAgreeRecipientIdentifier getInstance(Object object) {
        if (object == null || object instanceof KeyAgreeRecipientIdentifier) {
            return (KeyAgreeRecipientIdentifier)object;
        }
        if (object instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object;
            if (aSN1TaggedObject.hasContextTag(0)) {
                return new KeyAgreeRecipientIdentifier(RecipientKeyIdentifier.getInstance(aSN1TaggedObject, false));
            }
            throw new IllegalArgumentException("Invalid KeyAgreeRecipientIdentifier tag: " + ASN1Util.getTagText(aSN1TaggedObject));
        }
        return new KeyAgreeRecipientIdentifier(IssuerAndSerialNumber.getInstance(object));
    }

    public KeyAgreeRecipientIdentifier(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.issuerSerial = issuerAndSerialNumber;
        this.rKeyID = null;
    }

    public KeyAgreeRecipientIdentifier(RecipientKeyIdentifier recipientKeyIdentifier) {
        this.issuerSerial = null;
        this.rKeyID = recipientKeyIdentifier;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.issuerSerial;
    }

    public RecipientKeyIdentifier getRKeyID() {
        return this.rKeyID;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.issuerSerial != null) {
            return this.issuerSerial.toASN1Primitive();
        }
        return new DERTaggedObject(false, 0, (ASN1Encodable)this.rKeyID);
    }
}

