/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TextUtil {
    private static char[] extracFirstWordPatternInstructions = new char[]{'|', '\u0000', ']', '^', '\u0000', '\u0003', '|', '\u0000', '\f', '\\', 's', '\u0003', '|', '\u0000', '\u0003', 'G', '\u0000', '\ufff7', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', '(', '\u0001', '\u0003', '|', '\u0000', '\u0012', '\\', 'w', '\u0003', '|', '\u0000', '\u0006', 'G', '\u0000', '\ufffa', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', ')', '\u0001', '\u0003', '\\', 's', '\u0003', '|', '\u0000', '\u0006', 'G', '\u0000', '\ufffa', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', '(', '\u0002', '\u0003', '|', '\u0000', '\u0015', '|', '\u0000', '\f', '.', '\u0000', '\u0003', '|', '\u0000', '\u0003', 'G', '\u0000', '\ufff7', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', ')', '\u0002', '\u0003', '$', '\u0000', '\u0003', 'E', '\u0000', '\u0000'};
    private static char[] trimPatternInstructions = new char[]{'|', '\u0000', '?', '^', '\u0000', '\u0003', '|', '\u0000', '\f', '\\', 's', '\u0003', '|', '\u0000', '\u0003', 'G', '\u0000', '\ufff7', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', '(', '\u0001', '\u0003', '|', '\u0000', '\f', '8', '\u0000', '\t', '.', '\u0000', '\u0003', 'E', '\u0000', '\u0000', ')', '\u0001', '\u0003', '|', '\u0000', '\f', '\\', 's', '\u0003', '|', '\u0000', '\u0003', 'G', '\u0000', '\ufff7', '|', '\u0000', '\u0003', 'N', '\u0000', '\u0003', '$', '\u0000', '\u0003', 'E', '\u0000', '\u0000'};
    public static final int NORMAL = 0;
    public static final int MULTILINECOMMENT = 1;
    public static final int COMMENT = 2;
    public static final int SINGLEQUOTE = 3;
    public static final int DOUBLEQUOTE = 4;

    public static String[] split(String pattern, String in) {
        Pattern rev = Pattern.compile(pattern);
        return rev.split(in, 0);
    }

    public static final String stripQuotes(String s) {
        if (s == null || s.length() < 2) {
            return s;
        }
        if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            return s.substring(1, s.length() - 2);
        }
        return s;
    }

    public static synchronized String getComments(String input) {
        Matcher match = Pattern.compile("/\\*(.*?)\\*/|--(.*?)$", 34).matcher(input);
        String Comments = "";
        while (match.find()) {
            Comments = Comments + match.group(0);
        }
        return Comments;
    }

    public static synchronized String[] getSQLandComments(String input) {
        String[] res = new String[2];
        res[0] = TextUtil.getComments(input);
        String CommentReplaceRegex = "(/\\*((.|" + System.getProperty("line.separator") + ")*?)\\*/|--(.*?)(" + System.getProperty("line.separator") + "|$))";
        res[1] = input.replaceAll(CommentReplaceRegex, "");
        return res;
    }
}

