/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import resources.dependencies.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import resources.dependencies.org.bouncycastle.asn1.ASN1OctetString;
import resources.dependencies.org.bouncycastle.asn1.cms.CompressedData;
import resources.dependencies.org.bouncycastle.asn1.cms.ContentInfo;
import resources.dependencies.org.bouncycastle.cms.CMSException;
import resources.dependencies.org.bouncycastle.cms.CMSTypedStream;
import resources.dependencies.org.bouncycastle.cms.CMSUtils;
import resources.dependencies.org.bouncycastle.operator.InputExpander;
import resources.dependencies.org.bouncycastle.operator.InputExpanderProvider;
import resources.dependencies.org.bouncycastle.util.Encodable;

public class CMSCompressedData
implements Encodable {
    ContentInfo contentInfo;
    CompressedData comData;

    public CMSCompressedData(byte[] byArray) throws CMSException {
        this(CMSUtils.readContentInfo(byArray));
    }

    public CMSCompressedData(InputStream inputStream) throws CMSException {
        this(CMSUtils.readContentInfo(inputStream));
    }

    public CMSCompressedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        try {
            this.comData = CompressedData.getInstance(contentInfo.getContent());
        }
        catch (ClassCastException classCastException) {
            throw new CMSException("Malformed content.", classCastException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("Malformed content.", illegalArgumentException);
        }
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentInfo.getContentType();
    }

    public ASN1ObjectIdentifier getCompressedContentType() {
        return this.comData.getEncapContentInfo().getContentType();
    }

    public CMSTypedStream getContentStream(InputExpanderProvider inputExpanderProvider) {
        ContentInfo contentInfo = this.comData.getEncapContentInfo();
        ASN1OctetString aSN1OctetString = (ASN1OctetString)contentInfo.getContent();
        InputExpander inputExpander = inputExpanderProvider.get(this.comData.getCompressionAlgorithmIdentifier());
        InputStream inputStream = inputExpander.getInputStream(aSN1OctetString.getOctetStream());
        return new CMSTypedStream(contentInfo.getContentType(), inputStream);
    }

    public byte[] getContent(InputExpanderProvider inputExpanderProvider) throws CMSException {
        ContentInfo contentInfo = this.comData.getEncapContentInfo();
        ASN1OctetString aSN1OctetString = (ASN1OctetString)contentInfo.getContent();
        InputExpander inputExpander = inputExpanderProvider.get(this.comData.getCompressionAlgorithmIdentifier());
        InputStream inputStream = inputExpander.getInputStream(aSN1OctetString.getOctetStream());
        try {
            return CMSUtils.streamToByteArray(inputStream);
        }
        catch (IOException iOException) {
            throw new CMSException("exception reading compressed stream.", iOException);
        }
    }

    public ContentInfo toASN1Structure() {
        return this.contentInfo;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.contentInfo.getEncoded();
    }
}

