/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.cms;

import resources.dependencies.org.bouncycastle.asn1.DEROctetString;
import resources.dependencies.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import resources.dependencies.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import resources.dependencies.org.bouncycastle.asn1.cms.RecipientIdentifier;
import resources.dependencies.org.bouncycastle.asn1.cms.RecipientInfo;
import resources.dependencies.org.bouncycastle.cms.CMSException;
import resources.dependencies.org.bouncycastle.cms.RecipientInfoGenerator;
import resources.dependencies.org.bouncycastle.operator.AsymmetricKeyWrapper;
import resources.dependencies.org.bouncycastle.operator.GenericKey;
import resources.dependencies.org.bouncycastle.operator.OperatorException;

public abstract class KeyTransRecipientInfoGenerator
implements RecipientInfoGenerator {
    protected final AsymmetricKeyWrapper wrapper;
    private IssuerAndSerialNumber issuerAndSerial;
    private byte[] subjectKeyIdentifier;

    protected KeyTransRecipientInfoGenerator(IssuerAndSerialNumber issuerAndSerialNumber, AsymmetricKeyWrapper asymmetricKeyWrapper) {
        this.issuerAndSerial = issuerAndSerialNumber;
        this.wrapper = asymmetricKeyWrapper;
    }

    protected KeyTransRecipientInfoGenerator(byte[] byArray, AsymmetricKeyWrapper asymmetricKeyWrapper) {
        this.subjectKeyIdentifier = byArray;
        this.wrapper = asymmetricKeyWrapper;
    }

    @Override
    public final RecipientInfo generate(GenericKey genericKey) throws CMSException {
        byte[] byArray;
        try {
            byArray = this.wrapper.generateWrappedKey(genericKey);
        }
        catch (OperatorException operatorException) {
            throw new CMSException("exception wrapping content key: " + operatorException.getMessage(), operatorException);
        }
        RecipientIdentifier recipientIdentifier = this.issuerAndSerial != null ? new RecipientIdentifier(this.issuerAndSerial) : new RecipientIdentifier(new DEROctetString(this.subjectKeyIdentifier));
        return new RecipientInfo(new KeyTransRecipientInfo(recipientIdentifier, this.wrapper.getAlgorithmIdentifier(), new DEROctetString(byArray)));
    }
}

