/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc.importExport;

import com.exasol.jdbc.importExport.ConnectionParser;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImportExportQuery {
    public final String ClassName = "ImportExportQuery";
    protected String SQL = null;
    protected String FirstPart = null;
    protected String SecondPart = null;
    protected String ThirdPart = null;
    protected String CertificateParameter = null;
    protected String PublicKey = null;
    protected boolean IsCSV = true;
    protected boolean IsSecure = true;
    protected final String FirstPartKey = "FirstPart";
    protected final String SecondPartKey = "SecondPart";
    protected final String ThirdPartKey = "ThirdPart";
    protected ConnectionParser connectionParser = null;

    public String getCertificateParameter() {
        return this.CertificateParameter;
    }

    public String getPublicKey() {
        return this.PublicKey;
    }

    public String getSQL() {
        return this.SQL;
    }

    public String getFirstPart() {
        return this.FirstPart;
    }

    public String getSecondPart() {
        return this.SecondPart;
    }

    public String getThirdPart() {
        return this.ThirdPart;
    }

    public boolean isCSV() {
        return this.IsCSV;
    }

    public boolean isSecure() {
        return this.IsSecure;
    }

    public ConnectionParser getConnectionParser() {
        return this.connectionParser;
    }

    ImportExportQuery(String sql, boolean isCSV, boolean isSecure) {
        this.SQL = sql;
        this.IsCSV = isCSV;
        this.IsSecure = isSecure;
    }

    public void parse() throws SQLException {
        Matcher matcher = Pattern.compile("(?<FirstPart>.*?)(?<SecondPart>\\s+LOCAL\\s+.*?(SECURE.*?)?(CSV|FBV)(.*?FILE.*?['\"][^'\"]+['\"])+)(?<ThirdPart>.*)", 42).matcher(this.SQL);
        if (matcher.matches()) {
            this.FirstPart = matcher.group("FirstPart");
            this.SecondPart = matcher.group("SecondPart");
            this.ThirdPart = matcher.group("ThirdPart");
            this.connectionParser = new ConnectionParser(this.SecondPart);
            this.connectionParser.parse();
            if (this.connectionParser.getQuery2() != null && this.connectionParser.getQuery2().length() > 0) {
                this.ThirdPart = this.connectionParser.getQuery2() + " " + this.ThirdPart;
            }
        } else {
            throw new SQLException("SQL Syntax is invalid");
        }
        this.ValidateCertificateParameters();
    }

    public void ValidateCertificateParameters() throws SQLException {
        boolean inEndCertificateParams;
        boolean inMiddleCertificateParams = this.connectionParser.getCertificateParam() != null || this.connectionParser.getPublicKey() != null;
        String inEndCertificateParameter = ConnectionParser.GetCertificateParameter(this.ThirdPart);
        String inEndPublicKey = ConnectionParser.GetPublicKey(this.ThirdPart);
        boolean bl = inEndCertificateParams = inEndCertificateParameter != null || inEndPublicKey != null;
        if (inMiddleCertificateParams && inEndCertificateParams) {
            throw new SQLException("Certificate Parameters are provided in multiple places.");
        }
        if (inMiddleCertificateParams) {
            this.CertificateParameter = this.connectionParser.getCertificateParam();
            this.PublicKey = this.connectionParser.getPublicKey();
        }
        if (inEndCertificateParams) {
            this.CertificateParameter = inEndCertificateParameter;
            this.PublicKey = inEndPublicKey;
            if (null != this.PublicKey) {
                this.ThirdPart = this.ThirdPart.replace(this.PublicKey, "");
            }
            if (null != this.CertificateParameter) {
                this.ThirdPart = this.ThirdPart.replace(this.CertificateParameter, "");
            }
        }
    }
}

