/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.asn1.crmf;

import resources.dependencies.org.bouncycastle.asn1.ASN1Encodable;
import resources.dependencies.org.bouncycastle.asn1.ASN1EncodableVector;
import resources.dependencies.org.bouncycastle.asn1.ASN1Object;
import resources.dependencies.org.bouncycastle.asn1.ASN1Primitive;
import resources.dependencies.org.bouncycastle.asn1.ASN1Sequence;
import resources.dependencies.org.bouncycastle.asn1.ASN1TaggedObject;
import resources.dependencies.org.bouncycastle.asn1.ASN1Util;
import resources.dependencies.org.bouncycastle.asn1.DERSequence;
import resources.dependencies.org.bouncycastle.asn1.DERTaggedObject;
import resources.dependencies.org.bouncycastle.asn1.crmf.PKMACValue;
import resources.dependencies.org.bouncycastle.asn1.x509.GeneralName;
import resources.dependencies.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class POPOSigningKeyInput
extends ASN1Object {
    private GeneralName sender;
    private PKMACValue publicKeyMAC;
    private SubjectPublicKeyInfo publicKey;

    private POPOSigningKeyInput(ASN1Sequence aSN1Sequence) {
        ASN1Encodable aSN1Encodable = aSN1Sequence.getObjectAt(0);
        if (aSN1Encodable instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Encodable;
            this.sender = GeneralName.getInstance(ASN1Util.getExplicitContextBaseObject(aSN1TaggedObject, 0));
        } else {
            this.publicKeyMAC = PKMACValue.getInstance(aSN1Encodable);
        }
        this.publicKey = SubjectPublicKeyInfo.getInstance(aSN1Sequence.getObjectAt(1));
    }

    public static POPOSigningKeyInput getInstance(Object object) {
        if (object instanceof POPOSigningKeyInput) {
            return (POPOSigningKeyInput)object;
        }
        if (object != null) {
            return new POPOSigningKeyInput(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public POPOSigningKeyInput(GeneralName generalName, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.sender = generalName;
        this.publicKey = subjectPublicKeyInfo;
    }

    public POPOSigningKeyInput(PKMACValue pKMACValue, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.publicKeyMAC = pKMACValue;
        this.publicKey = subjectPublicKeyInfo;
    }

    public GeneralName getSender() {
        return this.sender;
    }

    public PKMACValue getPublicKeyMAC() {
        return this.publicKeyMAC;
    }

    public SubjectPublicKeyInfo getPublicKey() {
        return this.publicKey;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        if (this.sender != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, (ASN1Encodable)this.sender));
        } else {
            aSN1EncodableVector.add(this.publicKeyMAC);
        }
        aSN1EncodableVector.add(this.publicKey);
        return new DERSequence(aSN1EncodableVector);
    }
}

