/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.cert.cmp;

import java.math.BigInteger;
import resources.dependencies.org.bouncycastle.asn1.cmp.CMPCertificate;
import resources.dependencies.org.bouncycastle.asn1.cmp.CertStatus;
import resources.dependencies.org.bouncycastle.asn1.cmp.PKIStatusInfo;
import resources.dependencies.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import resources.dependencies.org.bouncycastle.cert.X509CertificateHolder;
import resources.dependencies.org.bouncycastle.cert.cmp.CMPException;
import resources.dependencies.org.bouncycastle.cert.cmp.CMPUtil;
import resources.dependencies.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import resources.dependencies.org.bouncycastle.operator.DigestCalculatorProvider;
import resources.dependencies.org.bouncycastle.util.Arrays;

public class CertificateStatus {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private CertStatus certStatus;

    CertificateStatus(DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder, CertStatus certStatus) {
        this.digestAlgFinder = digestAlgorithmIdentifierFinder;
        this.certStatus = certStatus;
    }

    public PKIStatusInfo getStatusInfo() {
        return this.certStatus.getStatusInfo();
    }

    public BigInteger getCertRequestID() {
        return this.certStatus.getCertReqId().getValue();
    }

    public boolean isVerified(X509CertificateHolder x509CertificateHolder, DigestCalculatorProvider digestCalculatorProvider) throws CMPException {
        return this.isVerified(new CMPCertificate(x509CertificateHolder.toASN1Structure()), x509CertificateHolder.getSignatureAlgorithm(), digestCalculatorProvider);
    }

    public boolean isVerified(CMPCertificate cMPCertificate, AlgorithmIdentifier algorithmIdentifier, DigestCalculatorProvider digestCalculatorProvider) throws CMPException {
        byte[] byArray = CMPUtil.calculateCertHash(cMPCertificate, algorithmIdentifier, digestCalculatorProvider, this.digestAlgFinder);
        return Arrays.constantTimeAreEqual(this.certStatus.getCertHash().getOctets(), byArray);
    }
}

