/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import resources.dependencies.org.bouncycastle.asn1.ASN1Set;
import resources.dependencies.org.bouncycastle.asn1.BEROctetString;
import resources.dependencies.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import resources.dependencies.org.bouncycastle.asn1.cms.ContentInfo;
import resources.dependencies.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import resources.dependencies.org.bouncycastle.asn1.cms.EncryptedData;
import resources.dependencies.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import resources.dependencies.org.bouncycastle.cms.CMSEncryptedData;
import resources.dependencies.org.bouncycastle.cms.CMSEncryptedGenerator;
import resources.dependencies.org.bouncycastle.cms.CMSException;
import resources.dependencies.org.bouncycastle.cms.CMSTypedData;
import resources.dependencies.org.bouncycastle.cms.CMSUtils;
import resources.dependencies.org.bouncycastle.operator.OutputEncryptor;

public class CMSEncryptedDataGenerator
extends CMSEncryptedGenerator {
    private CMSEncryptedData doGenerate(CMSTypedData cMSTypedData, OutputEncryptor outputEncryptor) throws CMSException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = outputEncryptor.getOutputStream(byteArrayOutputStream);
            cMSTypedData.write((OutputStream)object);
            ((OutputStream)object).close();
        }
        catch (IOException iOException) {
            throw new CMSException("");
        }
        object = byteArrayOutputStream.toByteArray();
        AlgorithmIdentifier algorithmIdentifier = outputEncryptor.getAlgorithmIdentifier();
        BEROctetString bEROctetString = new BEROctetString((byte[])object);
        EncryptedContentInfo encryptedContentInfo = CMSUtils.getEncryptedContentInfo(cMSTypedData.getContentType(), algorithmIdentifier, (byte[])object);
        ASN1Set aSN1Set = CMSUtils.getAttrBERSet(this.unprotectedAttributeGenerator);
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.encryptedData, new EncryptedData(encryptedContentInfo, aSN1Set));
        return new CMSEncryptedData(contentInfo);
    }

    public CMSEncryptedData generate(CMSTypedData cMSTypedData, OutputEncryptor outputEncryptor) throws CMSException {
        return this.doGenerate(cMSTypedData, outputEncryptor);
    }
}

