/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.jcajce.provider.symmetric;

import resources.dependencies.org.bouncycastle.crypto.CipherKeyGenerator;
import resources.dependencies.org.bouncycastle.crypto.engines.Grainv1Engine;
import resources.dependencies.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import resources.dependencies.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import resources.dependencies.org.bouncycastle.jcajce.provider.symmetric.util.BaseStreamCipher;
import resources.dependencies.org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import resources.dependencies.org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public final class Grainv1 {
    private Grainv1() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "Grainv1 IV";
        }
    }

    public static class Base
    extends BaseStreamCipher {
        public Base() {
            super(new Grainv1Engine(), 8);
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Grainv1", 80, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = Grainv1.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.Grainv1", PREFIX + "$Base");
            configurableProvider.addAlgorithm("KeyGenerator.Grainv1", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("AlgorithmParameters.Grainv1", PREFIX + "$AlgParams");
        }
    }
}

