/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.pkcs.bc;

import java.io.IOException;
import resources.dependencies.org.bouncycastle.asn1.pkcs.PBMAC1Params;
import resources.dependencies.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import resources.dependencies.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import resources.dependencies.org.bouncycastle.operator.MacCalculator;
import resources.dependencies.org.bouncycastle.operator.OperatorCreationException;
import resources.dependencies.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import resources.dependencies.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import resources.dependencies.org.bouncycastle.pkcs.bc.BcPKCS12PBMac1CalculatorBuilder;

public class BcPKCS12PBMac1CalculatorBuilderProvider
implements PKCS12MacCalculatorBuilderProvider {
    @Override
    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            @Override
            public MacCalculator build(char[] cArray) throws OperatorCreationException {
                BcPKCS12PBMac1CalculatorBuilder bcPKCS12PBMac1CalculatorBuilder;
                if (!PKCSObjectIdentifiers.id_PBMAC1.equals(algorithmIdentifier.getAlgorithm())) {
                    throw new OperatorCreationException("protection algorithm not PB mac based");
                }
                try {
                    bcPKCS12PBMac1CalculatorBuilder = new BcPKCS12PBMac1CalculatorBuilder(PBMAC1Params.getInstance(algorithmIdentifier.getParameters()));
                }
                catch (IOException iOException) {
                    throw new OperatorCreationException("invalid parameters in protection algorithm: " + iOException.getMessage());
                }
                return bcPKCS12PBMac1CalculatorBuilder.build(cArray);
            }

            @Override
            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), algorithmIdentifier.getParameters());
            }
        };
    }
}

