/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.BigDecimalColumn;
import com.exasol.jdbc.BoolColumn;
import com.exasol.jdbc.CharColumn;
import com.exasol.jdbc.Column;
import com.exasol.jdbc.ConnectionLost;
import com.exasol.jdbc.DateColumn;
import com.exasol.jdbc.DecimalColumn;
import com.exasol.jdbc.DoubleColumn;
import com.exasol.jdbc.DummyColumn;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAHandle;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.EXAParameterMetaData;
import com.exasol.jdbc.EXAResultSet;
import com.exasol.jdbc.EXARowCount;
import com.exasol.jdbc.EXASQLException;
import com.exasol.jdbc.EXAStatement;
import com.exasol.jdbc.ExceptionFactory;
import com.exasol.jdbc.ExecutionStatus;
import com.exasol.jdbc.NoResultException;
import com.exasol.jdbc.NotImplemented;
import com.exasol.jdbc.ProtocolAttribute;
import com.exasol.jdbc.SmallDecimalColumn;
import com.exasol.jdbc.TimestampColumn;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.VarCharColumn;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;

public abstract class AbstractEXAPreparedStatement
extends EXAStatement
implements PreparedStatement {
    protected Vector columns;
    protected ExecutionStatus execStatus = null;
    protected int batch_pos;
    private int handle = -1;
    protected static int capacityDefault = 32;
    protected int capacity = capacityDefault;
    private EXAResultSet statementMetadata = null;
    protected EXAResultSet parameterMetadata = null;
    protected final int bytePrecision = 3;
    protected final int smallintPrecision = 10;
    protected final int intPrecision = 19;
    protected final int bigintPrecision = 36;
    private long maxMessageSize = 0x2000000L;

    public long SetMaxPreparedParamBlockSize(long size) {
        this.log("SetMaxPreparedParamBlockSize()");
        if (size < 0L) {
            return this.maxMessageSize;
        }
        if (size < 1024L) {
            this.maxMessageSize = 1024L;
            return 1024L;
        }
        if (size > 0x4000000L) {
            this.maxMessageSize = 0x4000000L;
            return 0x4000000L;
        }
        this.maxMessageSize = size;
        return this.maxMessageSize;
    }

    AbstractEXAPreparedStatement(String sql, EXAConnection c) throws SQLException {
        super(c);
        this.log("EXAPreparedStatement(" + sql + ")");
        this.execStatus = new ExecutionStatus();
        this.batch_pos = 0;
        try {
            this.results = this.connection.communication_resultset(sql.getBytes(c.getEncoding()), (byte)10, this.execStatus, null);
            if (this.results != null && this.results.length > 0) {
                if (this.results[0] instanceof EXASQLException) {
                    throw ExceptionFactory.createSQLException((EXASQLException)this.results[0], this.connection);
                }
                if (this.results.length != 2 && this.results.length != 3) {
                    throw new SQLException("Unknown protocol change in CMD_CREATE_PREPARED, results.length=" + this.results.length + ", SessionID: " + this.connection.getSessionID());
                }
                if (this.results[0] instanceof EXAHandle) {
                    this.handle = ((EXAHandle)this.results[0]).GetHandle();
                }
                if (this.results.length == 2 && this.results[1] instanceof EXAResultSet) {
                    this.statementMetadata = (EXAResultSet)this.results[1];
                    this.current_result = 1;
                }
                if (this.results.length == 3) {
                    if (this.results[1] instanceof EXAResultSet && ((EXAResultSet)this.results[1]).GetHandle() == -5) {
                        this.parameterMetadata = (EXAResultSet)this.results[1];
                    }
                    if (this.results[2] instanceof EXAResultSet) {
                        this.statementMetadata = (EXAResultSet)this.results[2];
                    }
                    this.current_result = 2;
                }
            }
            this.columns = new Vector();
            this.log("EXAPreparedStatement() prepared statement created - handle: " + this.handle);
        }
        catch (IOException e) {
            throw new ConnectionLost(e.toString(), this.connection.getSessionID());
        }
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        this.log("getParameterMetaData() - handle: " + this.handle);
        if (this.results == null || this.results.length < 1) {
            throw new NoResultException();
        }
        if (this.results[1] instanceof EXASQLException) {
            throw ((EXASQLException)this.results[1]).getSQLExceptionIntern(this.connection);
        }
        if (this.results.length == 1) {
            throw new NoResultException();
        }
        if (this.results.length == 2) {
            EXAResultSet res = new EXAResultSet(this.debug);
            res.setMaxRows(this.maxRows);
            EXAParameterMetaData parammeta = new EXAParameterMetaData(res, this.debug);
            parammeta.setStatement(this);
            return parammeta;
        }
        if (this.results[2] instanceof EXASQLException) {
            throw ((EXASQLException)this.results[2]).getSQLExceptionIntern(this.connection);
        }
        if (this.results[1] instanceof EXAResultSet && this.results[2] instanceof EXAResultSet || this.results[1] instanceof EXAResultSet && this.results[2] instanceof EXARowCount) {
            EXAParameterMetaData parammeta = new EXAParameterMetaData((EXAResultSet)this.results[1], this.debug);
            parammeta.setStatement(this);
            return parammeta;
        }
        return null;
    }

    @Override
    public synchronized void addBatch() throws SQLException {
        if (this.capacity <= this.batch_pos + 1) {
            this.capacity *= 2;
            for (int i = 0; i < this.columns.size(); ++i) {
                Column c = (Column)this.columns.get(i);
                c.resize(this.capacity);
            }
        }
        ++this.batch_pos;
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        this.log("clearParameters() - handle: " + this.handle);
        this.columns.clear();
        this.batch_pos = 0;
        this.capacity = capacityDefault;
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        this.log("clearBatch() - handle: " + this.handle);
        try {
            this.clearParameters();
        }
        catch (SQLException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        this.log("executeBatch() - handle: " + this.handle);
        int retUp = this.executeUpdate();
        int[] ret = new int[retUp];
        for (int i = 0; i < retUp; ++i) {
            ret[i] = -2;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean execute() throws SQLException {
        this.log("execute() - handle: " + this.handle);
        try {
            this.connection.setSchemaMayHaveChanged();
            try {
                this._execute(0, 0);
            }
            catch (IOException io) {
                throw new ConnectionLost(io.getMessage(), this.connection.getSessionID());
            }
            this.current_result = 0;
            if (this.results != null && this.results.length > 0) {
                if (this.results[0] instanceof EXASQLException) {
                    SQLException sex;
                    if (((EXASQLException)this.results[0]).getSQLCode().equals("00000") && this.connection.isWorkerConnection()) {
                        this.connection.closeSocket();
                    }
                    if ((sex = ((EXASQLException)this.results[0]).getSQLExceptionIntern(this.connection)) instanceof SQLDataException) {
                        int[] updateCounts = new int[this.batch_pos];
                        for (int i = 0; i < updateCounts.length; ++i) {
                            updateCounts[i] = -3;
                        }
                        throw new BatchUpdateException(sex.getMessage(), sex.getSQLState(), sex.getErrorCode(), updateCounts, (Throwable)sex);
                    }
                    throw sex;
                }
                boolean bl = this.results[0] instanceof EXAResultSet;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.clearParameters();
        }
    }

    private synchronized void _execute(int startLine, int packetNumber) throws IOException, SQLException {
        int line = startLine;
        this.execStatus = new ExecutionStatus();
        this.log(" _execute(" + startLine + ", " + packetNumber + ") - SessionID: " + this.connection.getSessionID());
        long dataSize = 0L;
        ByteArrayOutputStream databas = new ByteArrayOutputStream();
        EXAOutputStream dataos = new EXAOutputStream(databas, this.connection);
        int cols = this.columns.size();
        if (cols > 0 && this.batch_pos == 0) {
            this.batch_pos = 1;
        }
        while (line < this.batch_pos) {
            for (int col = 0; col < this.columns.size(); ++col) {
                Column c = (Column)this.columns.get(col);
                dataSize += c.value_to_jdbc(dataos, line);
            }
            if (dataSize > this.maxMessageSize) {
                ++line;
                break;
            }
            ++line;
        }
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        EXAOutputStream os = new EXAOutputStream(bas, this.connection);
        os.writeInt(this.handle);
        os.writeInt(1);
        os.writeByte((byte)1);
        os.writeInt(cols);
        if (cols > 0) {
            os.writeLong(this.batch_pos);
            os.writeLong(line - startLine);
        } else {
            os.writeLong(0L);
            os.writeLong(0L);
        }
        block13: for (int i = 0; i < cols; ++i) {
            Column c = (Column)this.columns.get(i);
            int cType = c.getType();
            os.writeString("Param(" + i + ")_" + c.getTypeName());
            try {
                os.writeInt(c.getEXAType());
            }
            catch (Exception e) {
                System.err.println("EXAPreparedStatement.executeUpdate(): Tried to send unknown type code!");
            }
            switch (cType) {
                case 1: 
                case 12: {
                    if (this.parameterMetadata != null && this.parameterMetadata.getColumnCount() >= i + 1 && this.parameterMetadata.getPrecision(i + 1) > c.getPrecision()) {
                        c.setPrecision(this.parameterMetadata.getPrecision(i + 1));
                    }
                    switch (cType) {
                        case 12: {
                            os.writeByte((byte)1);
                            if (c.getPrecision() >= 40) break;
                            c.setPrecision(40);
                            break;
                        }
                        case 1: {
                            if (this.parameterMetadata.getColumnType(i + 1) == 12) {
                                os.writeByte((byte)1);
                                break;
                            }
                            os.writeByte((byte)0);
                        }
                    }
                    os.writeInt(c.getPrecision());
                    os.writeInt(c.getPrecision() * 4);
                    this.log(" Param(" + i + ") " + c.getTypeName() + "(" + c.getPrecision() + ")");
                    continue block13;
                }
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    os.writeInt(c.getPrecision());
                    os.writeInt(c.getScale());
                    this.log(" Param(" + i + ") " + c.getTypeName() + "(" + c.getPrecision() + ", " + c.getScale() + ")");
                    continue block13;
                }
                case 93: {
                    if (this.connection.getActiveProtocolVersion() >= 19) {
                        os.writeInt(c.getScale());
                        this.log(" Param(" + i + ") " + c.getTypeName() + "(" + c.getScale() + ")");
                        continue block13;
                    }
                    this.log(" Param(" + i + ") " + c.getTypeName());
                    continue block13;
                }
                default: {
                    this.log(" Param(" + i + ") " + c.getTypeName());
                }
            }
        }
        databas.writeTo(bas);
        ProtocolAttribute[] attribs = null;
        if (line < this.batch_pos || line == this.batch_pos && packetNumber > 0) {
            ProtocolAttribute attr = new ProtocolAttribute(ProtocolAttribute.ATTR_PACKET_PART_NUMBER.id);
            attr.value = line < this.batch_pos ? Integer.valueOf(packetNumber) : Integer.valueOf(-packetNumber);
            this.log(" attribute packetNumber " + packetNumber + " added.");
            attribs = new ProtocolAttribute[]{attr};
        }
        byte[] msg = bas.toByteArray();
        this.log(" going to execute with params: " + cols + ", lines: " + startLine + " - " + line + ", batch_pos: " + this.batch_pos + ", bytes_to_send: " + msg.length);
        this.results = this.connection.communication_resultset(msg, (byte)11, this.execStatus, attribs);
        if (line < this.batch_pos) {
            this.log(" next parameter package:");
            this._execute(line, packetNumber + 1);
        }
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        this.log("executeQuery() - handle: " + this.handle);
        if (this.execute()) {
            if (this.results.length == 0) {
                throw new SQLException(Translator.Query_did_not_return_a_result());
            }
            if (this.results.length > 1) {
                throw new SQLException(Translator.Query_returned_more_than_one_result());
            }
            return this.getResultSet();
        }
        throw new SQLException(Translator.Query_returned_update_count());
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.log("executeLargeUpdate() - handle: " + this.handle);
        if (this.execute()) {
            throw new SQLException(Translator.Statement_returned_resultset());
        }
        long result = this.getLargeUpdateCount();
        if (result < 0L) {
            return 0L;
        }
        return result;
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        this.log("executeUpdate()");
        return (int)this.executeLargeUpdate();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.log("getMetaData()");
        if (this.debug != null) {
            this.debug.log("getMetaData() - prepared stmt result set meta data");
        }
        return this.statementMetadata;
    }

    public void setMaxVarcharLen(int i, int prec) throws SQLException {
        this.log("setMaxVarcharLen(" + i + ", " + prec + ")");
        if (!(this.columns.get(i - 1) instanceof VarCharColumn)) {
            throw new SQLException("Method called for the wrong column type: " + ((Column)this.columns.get(i - 1)).getTypeName());
        }
        ((VarCharColumn)this.columns.get(i - 1)).setMaxColumnSize(prec);
    }

    public void setMaxCharLen(int i, int prec) throws SQLException {
        this.log("setMaxCharLen(" + i + ", " + prec + ")");
        if (!(this.columns.get(i - 1) instanceof CharColumn)) {
            throw new SQLException("Method called for the wrong column type: " + ((Column)this.columns.get(i - 1)).getTypeName());
        }
        ((CharColumn)this.columns.get(i - 1)).setMaxColumnSize(prec);
    }

    public void setMaxScale(int i, int sc) throws SQLException {
        this.log("setMaxScale(" + i + ", " + sc + ")");
        if (!(this.columns.get(i - 1) instanceof SmallDecimalColumn || this.columns.get(i - 1) instanceof DecimalColumn || this.columns.get(i - 1) instanceof BigDecimalColumn)) {
            throw new SQLException("Method called for the wong column type: " + ((Column)this.columns.get(i - 1)).getTypeName());
        }
        ((Column)this.columns.get(i - 1)).setScale(sc);
    }

    @Override
    public void setArray(int i, Array x) throws SQLException, ArrayIndexOutOfBoundsException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setAsciiStream(int i, InputStream x, int length) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == x) {
            this.setNull(i, 1);
        } else {
            Column c;
            if (i > this.columns.size()) {
                if (i > this.columns.size() + 1) {
                    c = new DummyColumn();
                    for (int j = this.columns.size(); j < i - 1; ++j) {
                        this.columns.add(j, c);
                    }
                }
                VarCharColumn col = new VarCharColumn();
                ((Column)col).resize(this.capacity);
                this.columns.add(i - 1, col);
            }
            c = (Column)this.columns.get(i - 1);
            if (0 == this.batch_pos && c instanceof DummyColumn) {
                c = new VarCharColumn();
                c.resize(this.capacity);
                this.columns.set(i - 1, c);
            }
            c.setAsciiStream(this.batch_pos, x, length);
        }
    }

    @Override
    public void setBigDecimal(int i, BigDecimal x) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == x) {
            this.setNull(i, 3);
        } else {
            Column c;
            int xScale = x.scale();
            if (i > this.columns.size()) {
                if (i > this.columns.size() + 1) {
                    c = new DummyColumn();
                    for (int j = this.columns.size(); j < i - 1; ++j) {
                        this.columns.add(j, c);
                    }
                }
                BigDecimalColumn col = new BigDecimalColumn(36, xScale);
                ((Column)col).resize(this.capacity);
                this.columns.add(i - 1, col);
            }
            c = (Column)this.columns.get(i - 1);
            if (0 == this.batch_pos && c instanceof DummyColumn) {
                c = new BigDecimalColumn(36, xScale);
                c.resize(this.capacity);
                this.columns.set(i - 1, c);
            }
            if (xScale > c.getScale()) {
                c.setScale(xScale);
            }
            c.setBigDecimal(this.batch_pos, x);
        }
    }

    @Override
    public void setBinaryStream(int i, InputStream x, int length) throws SQLException, ArrayIndexOutOfBoundsException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setBoolean(int i, boolean x) throws SQLException, ArrayIndexOutOfBoundsException {
        Column c;
        if (i > this.columns.size()) {
            if (i > this.columns.size() + 1) {
                c = new DummyColumn();
                for (int j = this.columns.size(); j < i - 1; ++j) {
                    this.columns.add(j, c);
                }
            }
            BoolColumn col = new BoolColumn();
            ((Column)col).resize(this.capacity);
            this.columns.add(i - 1, col);
        }
        c = (Column)this.columns.get(i - 1);
        if (0 == this.batch_pos && c instanceof DummyColumn) {
            c = new BoolColumn();
            c.resize(this.capacity);
            this.columns.set(i - 1, c);
        }
        c.setBoolean(this.batch_pos, x);
    }

    @Override
    public void setByte(int i, byte x) throws SQLException, ArrayIndexOutOfBoundsException {
        Column c;
        if (i > this.columns.size()) {
            if (i > this.columns.size() + 1) {
                c = new DummyColumn();
                for (int j = this.columns.size(); j < i - 1; ++j) {
                    this.columns.add(j, c);
                }
            }
            SmallDecimalColumn col = new SmallDecimalColumn(3, 0);
            ((Column)col).resize(this.capacity);
            this.columns.add(i - 1, col);
        }
        c = (Column)this.columns.get(i - 1);
        if (0 == this.batch_pos && c instanceof DummyColumn) {
            c = new SmallDecimalColumn(3, 0);
            c.resize(this.capacity);
            this.columns.set(i - 1, c);
        }
        c.setByte(this.batch_pos, x);
    }

    @Override
    public void setBytes(int i, byte[] x) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == x) {
            this.setNull(i, 12);
        } else {
            Column c;
            if (i > this.columns.size()) {
                if (i > this.columns.size() + 1) {
                    c = new DummyColumn();
                    for (int j = this.columns.size(); j < i - 1; ++j) {
                        this.columns.add(j, c);
                    }
                }
                VarCharColumn col = new VarCharColumn();
                ((Column)col).resize(this.capacity);
                this.columns.add(i - 1, col);
            }
            c = (Column)this.columns.get(i - 1);
            if (0 == this.batch_pos && c instanceof DummyColumn) {
                c = new VarCharColumn();
                c.resize(this.capacity);
                this.columns.set(i - 1, c);
            }
            c.setString(this.batch_pos, new String(x));
        }
    }

    @Override
    public void setCharacterStream(int i, Reader reader, int length) throws SQLException, ArrayIndexOutOfBoundsException {
        Column c;
        if (i > this.columns.size()) {
            if (i > this.columns.size() + 1) {
                c = new DummyColumn();
                for (int j = this.columns.size(); j < i - 1; ++j) {
                    this.columns.add(j, c);
                }
            }
            VarCharColumn col = new VarCharColumn();
            ((Column)col).resize(this.capacity);
            this.columns.add(i - 1, col);
        }
        c = (Column)this.columns.get(i - 1);
        if (0 == this.batch_pos && c instanceof DummyColumn) {
            c = new VarCharColumn();
            c.resize(this.capacity);
            this.columns.set(i - 1, c);
        }
        c.setCharacterStream(this.batch_pos, reader, length);
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException, ArrayIndexOutOfBoundsException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setDate(int i, Date x) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == x) {
            this.setNull(i, 91);
        } else {
            Column c;
            if (i > this.columns.size()) {
                if (i > this.columns.size() + 1) {
                    c = new DummyColumn();
                    for (int j = this.columns.size(); j < i - 1; ++j) {
                        this.columns.add(j, c);
                    }
                }
                DateColumn col = new DateColumn();
                ((Column)col).resize(this.capacity);
                this.columns.add(i - 1, col);
            }
            c = (Column)this.columns.get(i - 1);
            if (0 == this.batch_pos && c instanceof DummyColumn) {
                c = new DateColumn();
                c.resize(this.capacity);
                this.columns.set(i - 1, c);
            }
            c.setDate(this.batch_pos, x);
        }
    }

    @Override
    public void setDate(int i, Date x, Calendar cal) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == x) {
            this.setNull(i, 91);
        } else {
            Column c;
            if (i > this.columns.size()) {
                if (i > this.columns.size() + 1) {
                    c = new DummyColumn();
                    for (int j = this.columns.size(); j < i - 1; ++j) {
                        this.columns.add(j, c);
                    }
                }
                DateColumn col = new DateColumn();
                ((Column)col).resize(this.capacity);
                this.columns.add(i - 1, col);
            }
            c = (Column)this.columns.get(i - 1);
            if (0 == this.batch_pos && c instanceof DummyColumn) {
                c = new DateColumn();
                c.resize(this.capacity);
                this.columns.set(i - 1, c);
            }
            c.setDate(this.batch_pos, x, cal);
        }
    }

    @Override
    public void setDouble(int i, double x) throws SQLException, ArrayIndexOutOfBoundsException {
        Column c;
        if (i > this.columns.size()) {
            if (i > this.columns.size() + 1) {
                c = new DummyColumn();
                for (int j = this.columns.size(); j < i - 1; ++j) {
                    this.columns.add(j, c);
                }
            }
            DoubleColumn col = new DoubleColumn();
            ((Column)col).resize(this.capacity);
            this.columns.add(i - 1, col);
        }
        c = (Column)this.columns.get(i - 1);
        if (0 == this.batch_pos && c instanceof DummyColumn) {
            c = new DoubleColumn();
            c.resize(this.capacity);
            this.columns.set(i - 1, c);
        }
        c.setDouble(this.batch_pos, x);
    }

    @Override
    public void setFloat(int i, float x) throws SQLException, ArrayIndexOutOfBoundsException {
        Column c;
        if (i > this.columns.size()) {
            if (i > this.columns.size() + 1) {
                c = new DummyColumn();
                for (int j = this.columns.size(); j < i - 1; ++j) {
                    this.columns.add(j, c);
                }
            }
            DoubleColumn col = new DoubleColumn();
            ((Column)col).resize(this.capacity);
            this.columns.add(i - 1, col);
        }
        c = (Column)this.columns.get(i - 1);
        if (0 == this.batch_pos && c instanceof DummyColumn) {
            c = new DoubleColumn();
            c.resize(this.capacity);
            this.columns.set(i - 1, c);
        }
        c.setFloat(this.batch_pos, x);
    }

    @Override
    public void setInt(int i, int x) throws SQLException, ArrayIndexOutOfBoundsException {
        Column c;
        if (i > this.columns.size()) {
            if (i > this.columns.size() + 1) {
                c = new DummyColumn();
                for (int j = this.columns.size(); j < i - 1; ++j) {
                    this.columns.add(j, c);
                }
            }
            BigDecimalColumn col = new BigDecimalColumn(19, 0);
            ((Column)col).resize(this.capacity);
            this.columns.add(i - 1, col);
        }
        c = (Column)this.columns.get(i - 1);
        if (0 == this.batch_pos && c instanceof DummyColumn) {
            c = new BigDecimalColumn(19, 0);
            c.resize(this.capacity);
            this.columns.set(i - 1, c);
        }
        c.setInt(this.batch_pos, x);
    }

    @Override
    public void setLong(int i, long x) throws SQLException, ArrayIndexOutOfBoundsException {
        Column c;
        if (i > this.columns.size()) {
            if (i > this.columns.size() + 1) {
                c = new DummyColumn();
                for (int j = this.columns.size(); j < i - 1; ++j) {
                    this.columns.add(j, c);
                }
            }
            BigDecimalColumn col = new BigDecimalColumn(36, 0);
            ((Column)col).resize(this.capacity);
            this.columns.add(i - 1, col);
        }
        c = (Column)this.columns.get(i - 1);
        if (0 == this.batch_pos && c instanceof DummyColumn) {
            c = new BigDecimalColumn(36, 0);
            c.resize(this.capacity);
            this.columns.set(i - 1, c);
        }
        c.setLong(this.batch_pos, x);
    }

    @Override
    public void setNull(int i, int sqlType) throws SQLException, ArrayIndexOutOfBoundsException {
        Column c;
        if (i > this.columns.size()) {
            if (i > this.columns.size() + 1) {
                c = new DummyColumn();
                for (int j = this.columns.size(); j < i - 1; ++j) {
                    this.columns.add(j, c);
                }
            }
            Column col = (Column)this.createNull(sqlType);
            col.resize(this.capacity);
            this.columns.add(i - 1, col);
        }
        c = (Column)this.columns.get(i - 1);
        if (0 == this.batch_pos && c instanceof DummyColumn) {
            c = (Column)this.createNull(sqlType);
            c.resize(this.capacity);
            this.columns.set(i - 1, c);
        }
        c.setNull(this.batch_pos);
    }

    public Object createNull(int i, int sqlType) throws SQLException {
        switch (sqlType) {
            case 16: {
                return new BoolColumn();
            }
        }
        return this.createNull(sqlType);
    }

    protected Object createNull(int sqlType) throws SQLException {
        switch (sqlType) {
            case -5: {
                return new BigDecimalColumn(36, 0);
            }
            case 4: {
                return new BigDecimalColumn(19, 0);
            }
            case 5: {
                return new DecimalColumn(10, 0);
            }
            case -7: 
            case 16: {
                return new BoolColumn();
            }
            case 1: {
                return new CharColumn();
            }
            case 12: {
                return new VarCharColumn();
            }
            case 91: {
                return new DateColumn();
            }
            case 93: {
                return new TimestampColumn();
            }
            case 6: 
            case 8: {
                return new DoubleColumn();
            }
            case 2: 
            case 3: {
                return new BigDecimalColumn(36, 0);
            }
        }
        throw new SQLException(Translator.Cannot_handle_datatype() + sqlType);
    }

    @Override
    public void setNull(int i, int sqlType, String typeName) throws SQLException {
        this.setNull(i, sqlType);
    }

    @Override
    public void setObject(int i, Object x) throws SQLException {
        if (null == x) {
            Column c = null;
            try {
                c = (Column)this.columns.get(i - 1);
                if (c instanceof DummyColumn) {
                    this.setNull(i, 12);
                } else {
                    c.setNull(this.batch_pos);
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                this.setNull(i, 12);
            }
            return;
        }
        if (x instanceof String) {
            this.setString(i, (String)x);
            return;
        }
        if (x instanceof BigDecimal) {
            this.setBigDecimal(i, (BigDecimal)x);
            return;
        }
        if (x instanceof Boolean) {
            this.setBoolean(i, (Boolean)x);
            return;
        }
        if (x instanceof Date) {
            this.setDate(i, (Date)x);
            return;
        }
        if (x instanceof Double) {
            this.setDouble(i, (Double)x);
            return;
        }
        if (x instanceof Float) {
            this.setFloat(i, ((Float)x).floatValue());
            return;
        }
        if (x instanceof Integer) {
            this.setInt(i, (Integer)x);
            return;
        }
        if (x instanceof Long) {
            this.setLong(i, (Long)x);
            return;
        }
        if (x instanceof Short) {
            this.setShort(i, (Short)x);
            return;
        }
        if (x instanceof Time) {
            this.setTime(i, (Time)x);
            return;
        }
        if (x instanceof Timestamp) {
            this.setTimestamp(i, (Timestamp)x);
            return;
        }
        if (x instanceof Byte) {
            this.setByte(i, (Byte)x);
            return;
        }
        if (x instanceof Byte[]) {
            this.setBytes(i, (byte[])x);
            return;
        }
        throw new NotImplemented(this.debug, Translator.Datatype_not_supported_in() + new Exception().getStackTrace()[0].getMethodName() + "(int,Object)");
    }

    @Override
    public void setObject(int i, Object x, int targetSqlType) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == x) {
            this.setNull(i, targetSqlType);
            return;
        }
        if (x instanceof String) {
            this.setString(i, x.toString());
            return;
        }
        if (x instanceof BigDecimal) {
            switch (targetSqlType) {
                case -5: {
                    this.setLong(i, ((BigDecimal)x).longValue());
                    break;
                }
                case -7: 
                case 16: {
                    if (0L == ((BigDecimal)x).longValue()) {
                        this.setBoolean(i, false);
                        break;
                    }
                    this.setBoolean(i, true);
                    break;
                }
                case 1: {
                    this.setFixedChar(i, x.toString());
                    break;
                }
                case 12: {
                    this.setString(i, x.toString());
                    break;
                }
                case 2: 
                case 3: {
                    this.setBigDecimal(i, (BigDecimal)x);
                    break;
                }
                case 8: {
                    this.setDouble(i, ((BigDecimal)x).doubleValue());
                    break;
                }
                case 6: {
                    this.setFloat(i, ((BigDecimal)x).floatValue());
                    break;
                }
                case 4: 
                case 5: {
                    this.setInt(i, ((BigDecimal)x).intValue());
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "BigDecimal to " + this.getSQLTypeName(targetSqlType));
                }
            }
            return;
        }
        if (x instanceof Boolean) {
            switch (targetSqlType) {
                case -5: {
                    if (((Boolean)x).booleanValue()) {
                        this.setLong(i, 1L);
                        break;
                    }
                    this.setLong(i, 0L);
                    break;
                }
                case -7: 
                case 16: {
                    this.setBoolean(i, (Boolean)x);
                    break;
                }
                case 1: {
                    this.setFixedChar(i, ((Boolean)x).toString());
                    break;
                }
                case 12: {
                    this.setString(i, ((Boolean)x).toString());
                    break;
                }
                case 2: 
                case 3: {
                    if (((Boolean)x).booleanValue()) {
                        this.setBigDecimal(i, new BigDecimal(1));
                        break;
                    }
                    this.setBigDecimal(i, new BigDecimal(0));
                    break;
                }
                case 8: {
                    if (((Boolean)x).booleanValue()) {
                        this.setDouble(i, 1.0);
                        break;
                    }
                    this.setDouble(i, 0.0);
                    break;
                }
                case 6: {
                    if (((Boolean)x).booleanValue()) {
                        this.setFloat(i, 1.0f);
                        break;
                    }
                    this.setFloat(i, 0.0f);
                    break;
                }
                case 4: 
                case 5: {
                    if (((Boolean)x).booleanValue()) {
                        this.setInt(i, 1);
                        break;
                    }
                    this.setInt(i, 0);
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "Boolean to " + this.getSQLTypeName(targetSqlType));
                }
            }
            return;
        }
        if (x instanceof Date) {
            switch (targetSqlType) {
                case 1: {
                    this.setFixedChar(i, x.toString());
                    break;
                }
                case 12: {
                    this.setString(i, x.toString());
                    break;
                }
                case 91: {
                    this.setDate(i, (Date)x);
                    break;
                }
                case 93: {
                    this.setTimestamp(i, new Timestamp(((Date)x).getTime()));
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "Date to " + this.getSQLTypeName(targetSqlType));
                }
            }
            return;
        }
        if (x instanceof Double) {
            switch (targetSqlType) {
                case -5: {
                    this.setLong(i, ((Double)x).longValue());
                    break;
                }
                case -7: 
                case 16: {
                    if (0.0 == (Double)x) {
                        this.setBoolean(i, false);
                        break;
                    }
                    this.setBoolean(i, true);
                    break;
                }
                case 1: {
                    this.setFixedChar(i, x.toString());
                    break;
                }
                case 12: {
                    this.setString(i, x.toString());
                    break;
                }
                case 2: 
                case 3: {
                    this.setBigDecimal(i, new BigDecimal((Double)x));
                    break;
                }
                case 8: {
                    this.setDouble(i, (Double)x);
                    break;
                }
                case 6: {
                    this.setFloat(i, ((Double)x).floatValue());
                    break;
                }
                case 4: 
                case 5: {
                    this.setInt(i, ((Double)x).intValue());
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "Double to " + this.getSQLTypeName(targetSqlType));
                }
            }
            return;
        }
        if (x instanceof Float) {
            switch (targetSqlType) {
                case -5: {
                    this.setLong(i, ((Float)x).longValue());
                    break;
                }
                case -7: 
                case 16: {
                    if (0.0f == ((Float)x).floatValue()) {
                        this.setBoolean(i, false);
                        break;
                    }
                    this.setBoolean(i, true);
                    break;
                }
                case 1: {
                    this.setFixedChar(i, x.toString());
                    break;
                }
                case 12: {
                    this.setString(i, x.toString());
                    break;
                }
                case 2: 
                case 3: {
                    this.setBigDecimal(i, new BigDecimal(((Float)x).doubleValue()));
                    break;
                }
                case 8: {
                    this.setDouble(i, ((Float)x).doubleValue());
                    break;
                }
                case 6: {
                    this.setFloat(i, ((Float)x).floatValue());
                    break;
                }
                case 4: 
                case 5: {
                    this.setInt(i, ((Float)x).intValue());
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "Float to " + this.getSQLTypeName(targetSqlType));
                }
            }
            return;
        }
        if (x instanceof Integer) {
            switch (targetSqlType) {
                case -5: {
                    this.setLong(i, ((Integer)x).longValue());
                    break;
                }
                case -7: 
                case 16: {
                    if (0 == (Integer)x) {
                        this.setBoolean(i, false);
                        break;
                    }
                    this.setBoolean(i, true);
                    break;
                }
                case 1: {
                    this.setFixedChar(i, ((Integer)x).toString());
                    break;
                }
                case 12: {
                    this.setString(i, ((Integer)x).toString());
                    break;
                }
                case 2: 
                case 3: {
                    this.setBigDecimal(i, new BigDecimal((Integer)x));
                    break;
                }
                case 8: {
                    this.setDouble(i, ((Integer)x).doubleValue());
                    break;
                }
                case 6: {
                    this.setFloat(i, ((Integer)x).floatValue());
                    break;
                }
                case 4: 
                case 5: {
                    this.setInt(i, (Integer)x);
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "Integer to " + this.getSQLTypeName(targetSqlType));
                }
            }
            return;
        }
        if (x instanceof Long) {
            switch (targetSqlType) {
                case -5: {
                    this.setLong(i, (Long)x);
                    break;
                }
                case -7: 
                case 16: {
                    if (0L == (Long)x) {
                        this.setBoolean(i, false);
                        break;
                    }
                    this.setBoolean(i, true);
                    break;
                }
                case 1: {
                    this.setFixedChar(i, ((Long)x).toString());
                    break;
                }
                case 12: {
                    this.setString(i, ((Long)x).toString());
                    break;
                }
                case 2: 
                case 3: {
                    this.setBigDecimal(i, new BigDecimal((Long)x));
                    break;
                }
                case 8: {
                    this.setDouble(i, ((Long)x).doubleValue());
                    break;
                }
                case 6: {
                    this.setFloat(i, ((Long)x).floatValue());
                    break;
                }
                case 4: 
                case 5: {
                    this.setInt(i, ((Long)x).intValue());
                    break;
                }
                case 91: {
                    this.setDate(i, new Date((Long)x));
                    break;
                }
                case 93: {
                    this.setTimestamp(i, new Timestamp((Long)x));
                    break;
                }
                case 92: {
                    this.setTime(i, new Time((Long)x));
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "Long to " + this.getSQLTypeName(targetSqlType));
                }
            }
            return;
        }
        if (x instanceof Short) {
            switch (targetSqlType) {
                case -5: {
                    this.setLong(i, ((Short)x).shortValue());
                    break;
                }
                case -7: 
                case 16: {
                    if (0L == ((Short)x).longValue()) {
                        this.setBoolean(i, false);
                        break;
                    }
                    this.setBoolean(i, true);
                    break;
                }
                case 1: {
                    this.setFixedChar(i, ((Short)x).toString());
                    break;
                }
                case 12: {
                    this.setString(i, ((Short)x).toString());
                    break;
                }
                case 2: 
                case 3: {
                    this.setBigDecimal(i, new BigDecimal(((Short)x).longValue()));
                    break;
                }
                case 8: {
                    this.setDouble(i, ((Short)x).doubleValue());
                    break;
                }
                case 6: {
                    this.setFloat(i, ((Short)x).floatValue());
                    break;
                }
                case 4: 
                case 5: {
                    this.setInt(i, ((Short)x).intValue());
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "Short to " + this.getSQLTypeName(targetSqlType));
                }
            }
            return;
        }
        if (x instanceof Time) {
            switch (targetSqlType) {
                case 1: {
                    this.setFixedChar(i, x.toString());
                    break;
                }
                case 12: {
                    this.setString(i, x.toString());
                    break;
                }
                case 93: {
                    this.setTimestamp(i, new Timestamp(((Time)x).getTime()));
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "Time to " + this.getSQLTypeName(targetSqlType));
                }
            }
            return;
        }
        if (x instanceof Timestamp) {
            switch (targetSqlType) {
                case 1: {
                    this.setFixedChar(i, x.toString());
                    break;
                }
                case 12: {
                    this.setString(i, x.toString());
                    break;
                }
                case 91: {
                    this.setDate(i, new Date(((Timestamp)x).getTime()));
                    break;
                }
                case 93: {
                    this.setTimestamp(i, (Timestamp)x);
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "Timestamp to " + this.getSQLTypeName(targetSqlType));
                }
            }
            return;
        }
        if (x instanceof Byte) {
            switch (targetSqlType) {
                case -5: {
                    this.setLong(i, ((Byte)x).longValue());
                    break;
                }
                case -7: 
                case 16: {
                    if (0 == (Byte)x) {
                        this.setBoolean(i, false);
                        break;
                    }
                    this.setBoolean(i, true);
                    break;
                }
                case 1: {
                    this.setFixedChar(i, ((Byte)x).toString());
                    break;
                }
                case 12: {
                    this.setString(i, ((Byte)x).toString());
                    break;
                }
                case 2: 
                case 3: {
                    this.setBigDecimal(i, new BigDecimal(((Byte)x).longValue()));
                    break;
                }
                case 8: {
                    this.setDouble(i, ((Byte)x).doubleValue());
                    break;
                }
                case 6: {
                    this.setFloat(i, ((Byte)x).floatValue());
                    break;
                }
                case 4: 
                case 5: {
                    this.setInt(i, ((Byte)x).intValue());
                    break;
                }
                default: {
                    throw new NotImplemented(this.debug, Translator.Conversion_form() + "Byte to " + this.getSQLTypeName(targetSqlType));
                }
            }
            return;
        }
        if (x instanceof Byte[]) {
            throw new NotImplemented(this.debug, Translator.Conversion_form() + "Byte[] to " + this.getSQLTypeName(targetSqlType));
        }
        throw new NotImplemented(this.debug, Translator.Datatype_not_supported_in() + new Exception().getStackTrace()[0].getMethodName() + "(int,Object,int)");
    }

    @Override
    public void setObject(int i, Object x, int targetSqlType, int scale) throws SQLException, ArrayIndexOutOfBoundsException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(int,Object,int,int)");
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException, ArrayIndexOutOfBoundsException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public void setShort(int i, short x) throws SQLException, ArrayIndexOutOfBoundsException {
        Column c;
        if (i > this.columns.size()) {
            if (i > this.columns.size() + 1) {
                c = new DummyColumn();
                for (int j = this.columns.size(); j < i - 1; ++j) {
                    this.columns.add(j, c);
                }
            }
            DecimalColumn col = new DecimalColumn(10, 0);
            ((Column)col).resize(this.capacity);
            this.columns.add(i - 1, col);
        }
        c = (Column)this.columns.get(i - 1);
        if (0 == this.batch_pos && c instanceof DummyColumn) {
            c = new DecimalColumn(10, 0);
            c.resize(this.capacity);
            this.columns.set(i - 1, c);
        }
        c.setShort(this.batch_pos, x);
    }

    @Override
    public void setString(int i, String x) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == x) {
            this.setNull(i, 12);
        } else {
            Column c;
            if (i > this.columns.size()) {
                if (i > this.columns.size() + 1) {
                    c = new DummyColumn();
                    for (int j = this.columns.size(); j < i - 1; ++j) {
                        this.columns.add(j, c);
                    }
                }
                VarCharColumn col = new VarCharColumn();
                ((Column)col).resize(this.capacity);
                this.columns.add(i - 1, col);
            }
            c = (Column)this.columns.get(i - 1);
            if (0 == this.batch_pos && c instanceof DummyColumn) {
                c = new VarCharColumn();
                c.resize(this.capacity);
                this.columns.set(i - 1, c);
            }
            c.setString(this.batch_pos, x);
        }
    }

    public void setFixedChar(int i, String x) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == x) {
            this.setNull(i, 1);
        } else {
            Column c;
            if (i > this.columns.size()) {
                if (i > this.columns.size() + 1) {
                    c = new DummyColumn();
                    for (int j = this.columns.size(); j < i - 1; ++j) {
                        this.columns.add(j, c);
                    }
                }
                CharColumn col = new CharColumn();
                ((Column)col).resize(this.capacity);
                this.columns.add(i - 1, col);
            }
            c = (Column)this.columns.get(i - 1);
            if (0 == this.batch_pos && c instanceof DummyColumn) {
                c = new CharColumn();
                c.resize(this.capacity);
                this.columns.set(i - 1, c);
            }
            c.setString(this.batch_pos, x);
        }
    }

    @Override
    public void setTime(int i, Time x) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == x) {
            this.setNull(i, 93);
        } else {
            Column c;
            if (i > this.columns.size()) {
                if (i > this.columns.size() + 1) {
                    c = new DummyColumn();
                    for (int j = this.columns.size(); j < i - 1; ++j) {
                        this.columns.add(j, c);
                    }
                }
                TimestampColumn col = new TimestampColumn();
                ((Column)col).resize(this.capacity);
                this.columns.add(i - 1, col);
            }
            c = (Column)this.columns.get(i - 1);
            if (0 == this.batch_pos && c instanceof DummyColumn) {
                c = new TimestampColumn();
                c.resize(this.capacity);
                this.columns.set(i - 1, c);
            }
            c.setTime(this.batch_pos, x);
        }
    }

    @Override
    public void setTime(int i, Time x, Calendar cal) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == x) {
            this.setNull(i, 93);
        } else {
            Column c;
            if (i > this.columns.size()) {
                if (i > this.columns.size() + 1) {
                    c = new DummyColumn();
                    for (int j = this.columns.size(); j < i - 1; ++j) {
                        this.columns.add(j, c);
                    }
                }
                TimestampColumn col = new TimestampColumn();
                ((Column)col).resize(this.capacity);
                this.columns.add(i - 1, col);
            }
            c = (Column)this.columns.get(i - 1);
            if (0 == this.batch_pos && c instanceof DummyColumn) {
                c = new TimestampColumn();
                c.resize(this.capacity);
                this.columns.set(i - 1, c);
            }
            c.setTime(this.batch_pos, x, cal);
        }
    }

    @Override
    public void setTimestamp(int i, Timestamp x) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == x) {
            this.setNull(i, 93);
        } else {
            Column c;
            if (i > this.columns.size()) {
                if (i > this.columns.size() + 1) {
                    c = new DummyColumn();
                    for (int j = this.columns.size(); j < i - 1; ++j) {
                        this.columns.add(j, c);
                    }
                }
                TimestampColumn col = new TimestampColumn();
                ((Column)col).resize(this.capacity);
                this.columns.add(i - 1, col);
            }
            c = (Column)this.columns.get(i - 1);
            if (0 == this.batch_pos && c instanceof DummyColumn) {
                c = new TimestampColumn();
                c.resize(this.capacity);
                this.columns.set(i - 1, c);
            }
            c.setTimestamp(this.batch_pos, x);
        }
    }

    @Override
    public void setTimestamp(int i, Timestamp x, Calendar cal) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == x) {
            this.setNull(i, 93);
        } else {
            Column c;
            if (i > this.columns.size()) {
                if (i > this.columns.size() + 1) {
                    c = new DummyColumn();
                    for (int j = this.columns.size(); j < i - 1; ++j) {
                        this.columns.add(j, c);
                    }
                }
                TimestampColumn col = new TimestampColumn();
                ((Column)col).resize(this.capacity);
                this.columns.add(i - 1, col);
            }
            c = (Column)this.columns.get(i - 1);
            if (0 == this.batch_pos && c instanceof DummyColumn) {
                c = new TimestampColumn();
                c.resize(this.capacity);
                this.columns.set(i - 1, c);
            }
            c.setTimestamp(this.batch_pos, x, cal);
        }
    }

    @Override
    public void setUnicodeStream(int i, InputStream x, int length) throws SQLException, ArrayIndexOutOfBoundsException {
        if (null == x) {
            this.setNull(i, 12);
        } else {
            Column c;
            if (i > this.columns.size()) {
                if (i > this.columns.size() + 1) {
                    c = new DummyColumn();
                    for (int j = this.columns.size(); j < i - 1; ++j) {
                        this.columns.add(j, c);
                    }
                }
                VarCharColumn col = new VarCharColumn();
                ((Column)col).resize(this.capacity);
                this.columns.add(i - 1, col);
            }
            c = (Column)this.columns.get(i - 1);
            if (0 == this.batch_pos && c instanceof DummyColumn) {
                c = new VarCharColumn();
                c.resize(this.capacity);
                this.columns.set(i - 1, c);
            }
            c.setUnicodeStream(this.batch_pos, x, length);
        }
    }

    @Override
    public void setURL(int i, URL u) throws SQLException, ArrayIndexOutOfBoundsException {
        if (this.debug != null) {
            this.debug.log("setURL(" + i + "," + u + ")");
        }
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(int i,URL u)");
    }

    private void closePreparedHandle() throws SQLException {
        this.execStatus = new ExecutionStatus();
        if (this.handle >= 0) {
            byte[] to_send = new byte[]{(byte)this.handle, (byte)(this.handle >> 8), (byte)(this.handle >> 16), (byte)(this.handle >> 24)};
            this.log("Closing prepared handle " + this.handle);
            this.results = this.connection.communication_resultset(to_send, (byte)18, this.execStatus, null);
            if (this.results != null && this.results.length > 0 && this.results[0] instanceof EXASQLException) {
                this.handle = -1;
                throw ExceptionFactory.createSQLException((EXASQLException)this.results[0], this.connection);
            }
        }
        this.handle = -1;
    }

    @Override
    public synchronized void close() throws SQLException {
        this.log("close() - handle: " + this.handle);
        try {
            if (this.results != null) {
                this.closeResultSets(this.results);
                this.closePreparedHandle();
            }
        }
        catch (Exception ex) {
            this.log(ex.getMessage());
            if (ex instanceof SQLException) {
                throw (SQLException)ex;
            }
            throw new SQLException(ex.getMessage());
        }
        finally {
            this.IsClosed = true;
        }
    }
}

