/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.EXAURLParser;
import com.exasol.jdbc.Translator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClusterNode {
    private String host;
    private int port;
    private boolean isMarked = false;
    private String fingerprint;

    public ClusterNode(String Host, int Port) throws ConnectionException {
        this.host = Host;
        this.SetPort(Port);
        this.SetFingerprint(null);
    }

    ClusterNode(String Host, int Port, String Fingerprint2) throws ConnectionException {
        this.host = Host;
        this.SetPort(Port);
        this.SetFingerprint(Fingerprint2);
    }

    ClusterNode(String HostAndPort) throws ConnectionException {
        this.UrlParser(HostAndPort, null);
        this.SetFingerprint(null);
    }

    ClusterNode(String HostAndPort, String DefaultPort) throws ConnectionException {
        this.UrlParser(HostAndPort, DefaultPort);
        this.SetFingerprint(null);
    }

    ClusterNode(String HostAndPort, String DefaultPort, String Fingerprint2) throws ConnectionException {
        this.UrlParser(HostAndPort, DefaultPort);
        this.SetFingerprint(Fingerprint2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void UrlParser(String HostAndPort, String DefaultPort) throws ConnectionException {
        if (HostAndPort == null) {
            throw new ConnectionException("[ERROR] URL is null.");
        }
        if (!HostAndPort.matches("([0-9a-zA-Z.\\-\\/:]+)")) {
            int pos = EXAURLParser.getIndexOfCharacters(HostAndPort, "[^0-9a-zA-Z.\\-\\/:]");
            if (pos < 0) throw new ConnectionException(Translator.Invalid_character_in_cluster_string() + " Hostname: " + HostAndPort);
            throw new ConnectionException(Translator.Invalid_character_in_cluster_string() + " Hostname: " + HostAndPort + " Invalid character at: " + pos + " (" + HostAndPort.charAt(pos) + ")");
        }
        String regexHost = "Host";
        String regexPort = "Port";
        Matcher hostExtractor = Pattern.compile("(?<" + regexHost + ">[0-9a-zA-Z.\\-]+)/*(:(?<" + regexPort + ">[0-9]+)){0,1}/*", 32).matcher(HostAndPort);
        if (hostExtractor.matches()) {
            this.host = hostExtractor.group(regexHost);
            String Port = hostExtractor.group(regexPort);
            if (Port != null && Port.trim().length() > 0) {
                this.SetPort(Integer.parseInt(Port));
                return;
            } else if (DefaultPort != null && DefaultPort.trim().length() > 0) {
                if (!DefaultPort.matches("[0-9]+")) throw new ConnectionException("[ERROR] Default Port contains invalid characters. Only Numeric characters are allowed. Default Port: " + DefaultPort);
                this.SetPort(Integer.parseInt(DefaultPort));
                return;
            } else {
                this.SetPort(0);
            }
            return;
        } else {
            if (!HostAndPort.matches("(?<" + regexHost + ">[0-9a-zA-Z.\\-]+)/*(:(?<" + regexPort + ">[0-9]+)){2,}/*")) throw new ConnectionException(Translator.Error_reading_the_hosts_form_cluster_string() + " Hostname: " + HostAndPort);
            throw new ConnectionException(Translator.Cartesian_product_hosts_ports_found() + " Hostname: " + HostAndPort);
        }
    }

    public boolean HasPort() {
        return this.port != 0;
    }

    public int GetPort() {
        return this.port;
    }

    public String GetHost() {
        return this.host;
    }

    public String GetHostAndPort() {
        return this.host + ":" + this.port;
    }

    public void SetPort(int p) throws ConnectionException {
        if (p < 0 || p > 65535) {
            throw new ConnectionException(Translator.Illegal_value_for_port_found_in_the_connection_string() + p);
        }
        this.port = p;
    }

    public void Mark() {
        this.isMarked = true;
    }

    public void UnMark() {
        this.isMarked = false;
    }

    public String GetFingerprint() {
        return this.fingerprint;
    }

    public void SetFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public boolean IsMarked() {
        return this.isMarked;
    }

    public boolean isValid() {
        byte[] bhost = this.host.getBytes();
        for (int i = 0; i < this.host.length(); ++i) {
            if (bhost[i] == 46 || bhost[i] >= 48 && bhost[i] <= 57) continue;
            return true;
        }
        int pos = 0;
        int checks = 0;
        block1: for (int i = 0; i < 4; ++i) {
            while (pos < bhost.length) {
                if (bhost[pos] == 46) {
                    ++checks;
                    ++pos;
                    continue block1;
                }
                ++pos;
            }
        }
        return checks == 3;
    }
}

