/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.Translator;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

public class DebugLog {
    private BufferedWriter w;
    private String filename = null;
    private String dirname = null;
    private static String OS = System.getProperty("os.name").toLowerCase();

    public DebugLog(String logdir, String encoding) throws IOException {
        try {
            Calendar now = Calendar.getInstance();
            String fname = "jdbc_" + now.get(1);
            fname = now.get(2) + 1 < 10 ? fname + "0" + (now.get(2) + 1) : fname + (now.get(2) + 1);
            fname = now.get(5) < 10 ? fname + "0" + now.get(5) + "_" : fname + now.get(5) + "_";
            fname = now.get(11) < 10 ? fname + "0" + now.get(11) : fname + now.get(11);
            fname = now.get(12) < 10 ? fname + "0" + now.get(12) : fname + now.get(12);
            fname = now.get(13) < 10 ? fname + "0" + now.get(13) : fname + now.get(13);
            this.filename = fname = fname + ".log";
            this.dirname = logdir;
            File file = new File(this.dirname, this.filename);
            int num = 1;
            int tries = 0;
            while (!file.createNewFile()) {
                this.filename = fname + "." + num++;
                file = new File(this.dirname, this.filename);
                if (++tries < 100) continue;
            }
            if (tries >= 100) {
                throw new IOException(Translator.Cannot_create_logfile_at_this_location());
            }
            this.w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file.getAbsolutePath(), true), encoding));
            this.w.write("Log opened: " + now.getTime());
            this.w.newLine();
            if (null != OS) {
                StringBuffer os = new StringBuffer();
                os.append(OS + " - ");
                os.append(System.getProperty("os.version", "unknown version"));
                os.append(" - ");
                os.append(System.getProperty("os.arch", "unknown arch"));
                this.w.write("Running on " + os.toString());
                this.w.newLine();
            }
            this.w.write("-------------------------------------------------------");
            this.w.newLine();
            this.w.flush();
        }
        catch (IOException io) {
            throw new IOException(Translator.Opening_log_failed() + io.getMessage());
        }
    }

    public void log(String msg, int level) {
        this.log(msg);
    }

    private String getCurrentTimeStamp() {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date now = new Date();
        String strDate = sdfDate.format(now);
        return strDate;
    }

    public void log(String msg) {
        try {
            this.w.write(this.getCurrentTimeStamp() + " - " + Thread.currentThread().getId() + " - " + msg + "\n");
            this.w.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void log(Properties info) {
        try {
            Enumeration<Object> keys = info.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = info.get(key);
                this.w.write(key.toString() + ": " + value.toString());
                this.w.newLine();
                this.w.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void log(Throwable t) {
        try {
            CharArrayWriter cw = new CharArrayWriter();
            t.printStackTrace(new PrintWriter(cw));
            this.log(this.w.toString(), 0);
        }
        catch (Throwable q) {
            this.log(Translator.Error_writing_log() + q.toString(), 0);
        }
    }

    public void finalize() {
        try {
            if (this.w != null) {
                this.w.close();
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                super.finalize();
            }
            catch (Throwable throwable) {}
        }
    }

    public String getLogFileName() {
        return this.filename;
    }

    public String getLogDirName() {
        return this.dirname;
    }
}

