/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAResult;
import com.exasol.jdbc.EXAResultSet;
import com.exasol.jdbc.NotImplemented;
import com.exasol.jdbc.ProtocolException;
import com.exasol.jdbc.Translator;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;

public class EXARowCount
extends EXAResult {
    private long longRowCount = 0L;

    EXARowCount(EXAInputStream is, DebugLog debug) throws IOException, ProtocolException {
        super("EXARowCount", debug);
        this.longRowCount = is.readLong();
        if (this.longRowCount <= Integer.MIN_VALUE) {
            throw new ProtocolException(Translator.Rowcount_out_of_bounds() + this.longRowCount);
        }
        if (debug != null) {
            debug.log("created rowcount: " + this.longRowCount);
        }
    }

    public long getLongRowCount() {
        return this.longRowCount;
    }

    public void close() throws SQLException {
    }

    public void checkSum() throws SQLException {
        throw new NotImplemented(this.debug, Translator.not_supported_checksum_on_rowcount());
    }

    public int getRowCount() {
        if (this.longRowCount >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.longRowCount;
    }

    @Override
    public EXAResultSet toResultSet() {
        BigDecimal[] values = new BigDecimal[]{new BigDecimal(this.longRowCount)};
        return this.connection.dialectFactory.createResultSet("RowCount", values, this.debug);
    }
}

