/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.AbstractEXAConnection;
import com.exasol.jdbc.ClusterNode;
import com.exasol.jdbc.ParserResult;
import com.exasol.jdbc.TextUtil;
import com.exasol.jdbc.Translator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EXAURLParser {
    public static final String regexCONNSTR = "CONNSTR";
    public static final String regexDBURL = "DBURL";
    public static final String regexURL = "URL";
    public static final String regexDefaultPort = "DefaultPort";
    public static final String regexPARAMS = "PARAMS";
    public static final String regexFINGERPRINT = "FINGERPRINT";
    public static final String regexEXAType = "EXATYPE";

    public int countChar(String str, String find) {
        if (str == null || find == null) {
            return -1;
        }
        Matcher match = Pattern.compile(find, 32).matcher(str);
        int count = 0;
        while (match.find()) {
            ++count;
        }
        return count;
    }

    public static int getIndexOfCharacters(String str, String pattern) {
        if (str == null || pattern == null) {
            return -1;
        }
        Matcher invalidCharacterMatcher = Pattern.compile(pattern, 32).matcher(str);
        if (invalidCharacterMatcher.find()) {
            return invalidCharacterMatcher.start();
        }
        return -1;
    }

    private String[] resolveURLRanges(String url) throws SQLException {
        String[] Hosts = null;
        if (url.contains(",")) {
            Hosts = TextUtil.split(",", url);
        }
        String hosts = "";
        if (Hosts != null) {
            for (int i = 0; i < Hosts.length; ++i) {
                hosts = hosts + this.resolveRanges(Hosts[i]) + ",";
            }
        } else {
            hosts = this.resolveRanges(url);
        }
        if (hosts != null) {
            return TextUtil.split(",+", hosts);
        }
        return url.split("$");
    }

    private String resolveRanges(String url) throws SQLException {
        if (this.countChar(url, "(\\.\\.)") > 1) {
            throw new SQLException(Translator.Cartesian_product_hosts_ports_found() + " URL: " + url);
        }
        Matcher match = Pattern.compile("((?<Start>[0-9]+)\\.\\.(?<End>[0-9]+))", 32).matcher(url);
        if (match.find()) {
            int end;
            String beginUrl = url.substring(0, match.start("Start"));
            String endUrl = url.substring(match.end("End"));
            String startValue = match.group("Start").trim();
            String endValue = match.group("End").trim();
            int start = Integer.parseInt(startValue);
            if (start > (end = Integer.parseInt(endValue))) {
                throw new SQLException(Translator.A_range_must_begin_with_the_smaller_number() + " URL: " + url);
            }
            int nURLs = end - start + 1;
            String URLs = "";
            for (int i = 0; i < nURLs; ++i) {
                String newURL = "";
                String id = Integer.toString(start + i);
                if (id.length() < startValue.length()) {
                    char[] zeros = new char[startValue.length() - id.length()];
                    Arrays.fill(zeros, '0');
                    id = new String(zeros) + id;
                }
                newURL = beginUrl + id + endUrl;
                URLs = URLs + newURL + ",";
            }
            return URLs;
        }
        return url;
    }

    private String getFingerprint(String URL2, String regexFINGERPRINT) throws SQLException {
        Matcher fingerprintMatch = Pattern.compile("\\/(?<" + regexFINGERPRINT + ">[^;|:|,]+)", 32).matcher(URL2);
        String Fingerprint2 = null;
        while (fingerprintMatch.find()) {
            if (Fingerprint2 == null) {
                Fingerprint2 = fingerprintMatch.group(regexFINGERPRINT).trim();
                continue;
            }
            if (Fingerprint2.equalsIgnoreCase(fingerprintMatch.group(regexFINGERPRINT).trim())) continue;
            throw new SQLException(Translator.Error_more_than_one_fingerprint());
        }
        if (Fingerprint2 != null && !Fingerprint2.matches("[0-9a-zA-Z]+")) {
            int pos = EXAURLParser.getIndexOfCharacters(Fingerprint2, "[^0-9a-zA-Z]");
            if (pos >= 0) {
                throw new SQLException("[ERROR] Fingerprint (" + Fingerprint2 + ") contains invalid character at " + pos + " (" + Fingerprint2.charAt(pos) + ").");
            }
            throw new SQLException("[ERROR] Fingerprint (" + Fingerprint2 + ") contains invalid character.");
        }
        return Fingerprint2;
    }

    private String readFile(String fileName) throws SQLException {
        if (fileName == null) {
            throw new SQLException("[ERROR] Filename is null.");
        }
        FileInputStream is = null;
        try {
            File file = new File(fileName);
            file.canRead();
            is = new FileInputStream(file);
        }
        catch (IOException ioex) {
            throw new SQLException(ioex.toString());
        }
        StringBuilder textBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, Charset.forName(StandardCharsets.UTF_8.name())));){
            int c = 0;
            while ((c = ((Reader)reader).read()) != -1) {
                textBuilder.append((char)c);
            }
        }
        catch (IOException e) {
            throw new SQLException(e.toString());
        }
        return textBuilder.toString();
    }

    private String readHostsFromFile(String fileName) throws SQLException {
        String fileBuffer = null;
        try {
            fileBuffer = this.readFile(fileName);
        }
        catch (SQLException e) {
            throw new SQLException(Translator.Error_reading_cluster_string_form_the_file() + fileName + ". " + e.toString());
        }
        CharSequence[] hostList = fileBuffer.split(",|\n|" + System.getProperty("line.separator"));
        return String.join((CharSequence)",", hostList);
    }

    public static HashMap<String, String> extractURL(String url) {
        String exaURLTypes = "exa|exa-debug|exa-worker|exa-worker-debug";
        String pattern = "^(?<DBURL>jdbc:(?<EXATYPE>" + exaURLTypes + "):(?<" + regexURL + ">(.|\\n|" + System.getProperty("line.separator") + "|$)[^;]*))(?<" + regexPARAMS + ">.*$)";
        HashMap<String, String> parts = null;
        Matcher match = Pattern.compile(pattern, 32).matcher(url);
        if (match.matches()) {
            String URL2 = match.group(regexURL);
            Matcher matchDefaultPort = Pattern.compile(":(?<DefaultPort>[0-9]+)(/(?<FINGERPRINT>[0-9a-zA-z]+))*$", 32).matcher(URL2);
            String defaultPort = "";
            String fingerprint = null;
            if (matchDefaultPort.find()) {
                defaultPort = matchDefaultPort.group(regexDefaultPort).trim();
                URL2 = URL2.substring(0, matchDefaultPort.start(regexDefaultPort) - 1);
                String fingerprintExtracted = matchDefaultPort.group(regexFINGERPRINT);
                if (fingerprintExtracted != null && fingerprintExtracted.trim().length() > 0) {
                    fingerprint = fingerprintExtracted.trim();
                }
            }
            parts = new HashMap<String, String>();
            parts.put(regexCONNSTR, url);
            parts.put(regexEXAType, match.group(regexEXAType));
            parts.put(regexDBURL, match.group(regexDBURL));
            parts.put(regexURL, URL2);
            parts.put(regexDefaultPort, defaultPort);
            parts.put(regexPARAMS, match.group(regexPARAMS));
            parts.put(regexFINGERPRINT, fingerprint);
        }
        return parts;
    }

    private HashMap<String, String> parseURL(String url) throws SQLException {
        Matcher filenameMatcher;
        HashMap<String, String> parts = EXAURLParser.extractURL(url);
        if (parts == null) {
            return null;
        }
        String DBURL = parts.get(regexDBURL);
        String URL2 = parts.get(regexURL);
        String host = null;
        String filename = null;
        if (URL2.matches("//(.*):[0-9]+(/[0-9a-zA-Z]+)*")) {
            filenameMatcher = Pattern.compile("//(?<Filename>.*):(?<Port>[0-9]+)(/(?<Fingerprint>[0-9a-zA-Z]+))*", 32).matcher(URL2);
            if (filenameMatcher.find()) {
                filename = filenameMatcher.group("Filename");
                host = this.readHostsFromFile(filename);
            }
        } else if (URL2.matches("//(.*)") && (filenameMatcher = Pattern.compile("//(?<Filename>.*)", 32).matcher(URL2)).matches()) {
            filename = filenameMatcher.group("Filename");
            host = this.readHostsFromFile(filename);
        }
        if (filename != null) {
            String file = "//" + filename;
            DBURL = DBURL.replace(file, host);
            parts.replace(regexDBURL, DBURL);
            URL2 = URL2.replace(file, host);
            parts.replace(regexURL, URL2);
        }
        return parts;
    }

    public ParserResult URLParser(String URL2) throws SQLException {
        HashMap<String, String> mainParts = this.parseURL(URL2);
        if (mainParts == null) {
            return null;
        }
        String fingerprint = this.getFingerprint(mainParts.get(regexURL), regexFINGERPRINT);
        if (fingerprint != null && mainParts.get(regexFINGERPRINT) != null && !fingerprint.equalsIgnoreCase(mainParts.get(regexFINGERPRINT))) {
            throw new SQLException(Translator.Error_more_than_one_fingerprint());
        }
        if (fingerprint == null && mainParts.get(regexFINGERPRINT) != null) {
            fingerprint = mainParts.get(regexFINGERPRINT);
        }
        if (fingerprint != null) {
            mainParts.replace(regexDBURL, mainParts.get(regexDBURL).replace("/" + fingerprint, ""));
            mainParts.replace(regexURL, mainParts.get(regexURL).replace("/" + fingerprint, ""));
        }
        mainParts.put(regexFINGERPRINT, fingerprint);
        ParserResult result = new ParserResult();
        result.params.setProperty("url", mainParts.get(regexCONNSTR));
        if (System.getProperty("com.exasol.jdbc.debug") != null && System.getProperty("com.exasol.jdbc.debug").equalsIgnoreCase("true") || "exa-debug".equals(mainParts.get(regexEXAType)) || "exa-worker-debug".equals(mainParts.get(regexEXAType))) {
            result.params.setProperty("debug", "1");
        }
        if ("exa-worker".equals(mainParts.get(regexEXAType)) || "exa-worker-debug".equals(mainParts.get(regexEXAType))) {
            result.params.setProperty("worker", "1");
        }
        if (!mainParts.get(regexURL).matches("[0-9a-zA-Z:\\.,\\-/]+")) {
            int pos = EXAURLParser.getIndexOfCharacters(mainParts.get(regexURL), "[^0-9a-zA-Z:.,\\-/]");
            if (pos >= 0) {
                throw new SQLException(Translator.Invalid_character_in_cluster_string() + " URL: " + mainParts.get(regexURL) + ". Invalid character at: " + pos + " (" + mainParts.get(regexURL).charAt(pos) + ")");
            }
            throw new SQLException(Translator.Invalid_character_in_cluster_string() + " URL: " + mainParts.get(regexURL));
        }
        String[] URLS = this.resolveURLRanges(mainParts.get(regexURL));
        Vector clusterNodes = result.clusterNodes;
        String defaultPortStr = null;
        String dPort = mainParts.get(regexDefaultPort);
        if (dPort != null && dPort.trim().length() > 0 && dPort.trim().matches("[0-9]+")) {
            defaultPortStr = dPort.trim();
        }
        for (int i = 0; i < URLS.length; ++i) {
            clusterNodes.add(new ClusterNode(URLS[i], defaultPortStr, mainParts.get(regexFINGERPRINT)));
        }
        if (mainParts.get(regexPARAMS) != null) {
            String value;
            String key;
            String params = mainParts.get(regexPARAMS);
            String ignoredParams = null;
            Matcher matchIgnoredParams = null;
            Matcher match = Pattern.compile("(?<Key>[^=;]*)=(?<Value>[^;]*)", 32).matcher(mainParts.get(regexPARAMS));
            while (match.find()) {
                key = match.group("Key");
                value = match.group("Value");
                if (key == null || key.length() == 0) {
                    throw new SQLException("[ERROR] Connection String parameters (" + mainParts.get(regexPARAMS) + ") contains invalid parameters.");
                }
                if (!key.equals("ignoreparams")) continue;
                ignoredParams = value;
                matchIgnoredParams = Pattern.compile("(?<param>[a-zA-Z0-9]+)", 32).matcher(ignoredParams);
            }
            match.reset();
            while (match.find()) {
                key = match.group("Key");
                value = match.group("Value");
                if (key == null || key.length() == 0) {
                    throw new SQLException("[ERROR] Connection String parameters (" + mainParts.get(regexPARAMS) + ") contains invalid parameters.");
                }
                this.validateSupportedKeys(key, matchIgnoredParams, ConnectionObjectType.ConnectionString);
                result.params.put(key, value);
                params = params.replace(";" + key + "=" + value, "");
            }
            if (!params.matches("(;|\\s)*")) {
                throw new SQLException("[ERROR] Connection String contains invalid parameters (" + params + ").");
            }
        }
        return result;
    }

    public void URLParser(Properties properties) throws SQLException {
        Properties propertiesCopy = (Properties)properties.clone();
        String ignoreParams = propertiesCopy.getProperty("ignoreparams", "");
        Matcher matchIgnoredParams = ignoreParams.length() > 0 ? Pattern.compile("(?<param>[a-zA-Z0-9]+)", 32).matcher(ignoreParams) : null;
        Set<Map.Entry<Object, Object>> entries = propertiesCopy.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            String key = (String)entry.getKey();
            this.validateSupportedKeys(key, matchIgnoredParams, ConnectionObjectType.ConnectionProperties);
        }
    }

    private void validateSupportedKeys(String key, Matcher ignored, ConnectionObjectType connectionObjectType) throws SQLException {
        DriverPropertyInfo[] connArgs;
        for (DriverPropertyInfo connArg : connArgs = AbstractEXAConnection.getDefaultProperties()) {
            if (!Objects.equals(connArg.name, key)) continue;
            return;
        }
        if (Objects.equals("snapshottransactions", key)) {
            return;
        }
        if (Objects.equals("TestConnectionStringOnly", key)) {
            return;
        }
        if (Objects.equals("ignoreparams", key)) {
            return;
        }
        if (Objects.equals("comment", key)) {
            return;
        }
        if (ignored != null) {
            ignored.reset();
            while (ignored.find()) {
                if (!key.equals(ignored.group("param"))) continue;
                return;
            }
        }
        if (connectionObjectType == ConnectionObjectType.ConnectionProperties) {
            throw new SQLException("[ERROR] Connection Properties does not support (" + key + ") argument.");
        }
        throw new SQLException("[ERROR] Connection String does not support (" + key + ") argument.");
    }

    private static enum ConnectionObjectType {
        ConnectionString,
        ConnectionProperties;

    }
}

