/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.cert.crmf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import resources.dependencies.org.bouncycastle.asn1.crmf.EncryptedValue;
import resources.dependencies.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import resources.dependencies.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import resources.dependencies.org.bouncycastle.asn1.x509.Certificate;
import resources.dependencies.org.bouncycastle.cert.X509CertificateHolder;
import resources.dependencies.org.bouncycastle.cert.crmf.CRMFException;
import resources.dependencies.org.bouncycastle.cert.crmf.EncryptedValuePadder;
import resources.dependencies.org.bouncycastle.cert.crmf.ValueDecryptorGenerator;
import resources.dependencies.org.bouncycastle.operator.InputDecryptor;
import resources.dependencies.org.bouncycastle.util.Strings;
import resources.dependencies.org.bouncycastle.util.io.Streams;

public class EncryptedValueParser {
    private EncryptedValue value;
    private EncryptedValuePadder padder;

    public EncryptedValueParser(EncryptedValue encryptedValue) {
        this.value = encryptedValue;
    }

    public EncryptedValueParser(EncryptedValue encryptedValue, EncryptedValuePadder encryptedValuePadder) {
        this.value = encryptedValue;
        this.padder = encryptedValuePadder;
    }

    public AlgorithmIdentifier getIntendedAlg() {
        return this.value.getIntendedAlg();
    }

    private byte[] decryptValue(ValueDecryptorGenerator valueDecryptorGenerator) throws CRMFException {
        if (this.value.getValueHint() != null) {
            throw new UnsupportedOperationException();
        }
        InputDecryptor inputDecryptor = valueDecryptorGenerator.getValueDecryptor(this.value.getKeyAlg(), this.value.getSymmAlg(), this.value.getEncSymmKey().getBytes());
        InputStream inputStream = inputDecryptor.getInputStream(new ByteArrayInputStream(this.value.getEncValue().getBytes()));
        try {
            return this.unpadData(Streams.readAll(inputStream));
        }
        catch (IOException iOException) {
            throw new CRMFException("Cannot parse decrypted data: " + iOException.getMessage(), iOException);
        }
    }

    public X509CertificateHolder readCertificateHolder(ValueDecryptorGenerator valueDecryptorGenerator) throws CRMFException {
        return new X509CertificateHolder(Certificate.getInstance(this.decryptValue(valueDecryptorGenerator)));
    }

    public PrivateKeyInfo readPrivateKeyInfo(ValueDecryptorGenerator valueDecryptorGenerator) throws CRMFException {
        return PrivateKeyInfo.getInstance(this.decryptValue(valueDecryptorGenerator));
    }

    public char[] readPassphrase(ValueDecryptorGenerator valueDecryptorGenerator) throws CRMFException {
        return Strings.fromUTF8ByteArray(this.decryptValue(valueDecryptorGenerator)).toCharArray();
    }

    private byte[] unpadData(byte[] byArray) {
        if (this.padder != null) {
            return this.padder.getUnpaddedData(byArray);
        }
        return byArray;
    }
}

