/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.jcajce.provider.digest;

import resources.dependencies.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import resources.dependencies.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import resources.dependencies.org.bouncycastle.crypto.CipherKeyGenerator;
import resources.dependencies.org.bouncycastle.crypto.digests.SHA224Digest;
import resources.dependencies.org.bouncycastle.crypto.macs.HMac;
import resources.dependencies.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import resources.dependencies.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import resources.dependencies.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import resources.dependencies.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import resources.dependencies.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import resources.dependencies.org.bouncycastle.jcajce.provider.symmetric.util.BaseSecretKeyFactory;

public class SHA224 {
    private SHA224() {
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new SHA224Digest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest digest = (Digest)super.clone();
            digest.digest = new SHA224Digest((SHA224Digest)this.digest);
            return digest;
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new SHA224Digest()));
        }
    }

    public static class KeyFactory
    extends BaseSecretKeyFactory {
        public KeyFactory() {
            super("HmacSHA224", null);
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACSHA224", 224, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SHA224.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.SHA-224", PREFIX + "$Digest");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest.SHA224", "SHA-224");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha224, "SHA-224");
            configurableProvider.addAlgorithm("Mac.PBEWITHHMACSHA224", PREFIX + "$HashMac");
            this.addHMACAlgorithm(configurableProvider, "SHA224", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
            this.addHMACAlias(configurableProvider, "SHA224", PKCSObjectIdentifiers.id_hmacWithSHA224);
            configurableProvider.addAlgorithm("SecretKeyFactory.HMACSHA224", PREFIX + "$KeyFactory");
            configurableProvider.addAlgorithm("Alg.Alias.SecretKeyFactory." + PKCSObjectIdentifiers.id_hmacWithSHA224, "HMACSHA224");
        }
    }
}

