/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.operator.bc;

import java.security.SecureRandom;
import resources.dependencies.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import resources.dependencies.org.bouncycastle.crypto.Wrapper;
import resources.dependencies.org.bouncycastle.crypto.params.KeyParameter;
import resources.dependencies.org.bouncycastle.crypto.params.ParametersWithRandom;
import resources.dependencies.org.bouncycastle.operator.GenericKey;
import resources.dependencies.org.bouncycastle.operator.OperatorException;
import resources.dependencies.org.bouncycastle.operator.SymmetricKeyWrapper;
import resources.dependencies.org.bouncycastle.operator.bc.OperatorUtils;

public class BcSymmetricKeyWrapper
extends SymmetricKeyWrapper {
    private SecureRandom random;
    private Wrapper wrapper;
    private KeyParameter wrappingKey;

    public BcSymmetricKeyWrapper(AlgorithmIdentifier algorithmIdentifier, Wrapper wrapper, KeyParameter keyParameter) {
        super(algorithmIdentifier);
        this.wrapper = wrapper;
        this.wrappingKey = keyParameter;
    }

    public BcSymmetricKeyWrapper setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    @Override
    public byte[] generateWrappedKey(GenericKey genericKey) throws OperatorException {
        byte[] byArray = OperatorUtils.getKeyBytes(genericKey);
        if (this.random == null) {
            this.wrapper.init(true, this.wrappingKey);
        } else {
            this.wrapper.init(true, new ParametersWithRandom(this.wrappingKey, this.random));
        }
        return this.wrapper.wrap(byArray, 0, byArray.length);
    }
}

