/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.ChaCha20_encoder;
import com.exasol.jdbc.ClusterNode;
import com.exasol.jdbc.ConnectFailed;
import com.exasol.jdbc.ConnectRefused;
import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.ConnectionLost;
import com.exasol.jdbc.ConnectionToWrongWorker;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.DialectFactory;
import com.exasol.jdbc.DialectGeneric;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXADatabaseMetaData;
import com.exasol.jdbc.EXADriver;
import com.exasol.jdbc.EXAHandle;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.EXAPooledConnection;
import com.exasol.jdbc.EXAResult;
import com.exasol.jdbc.EXAResultSet;
import com.exasol.jdbc.EXARowCount;
import com.exasol.jdbc.EXASQLException;
import com.exasol.jdbc.EXASocketFactory;
import com.exasol.jdbc.EXAStillExecuting;
import com.exasol.jdbc.EXAURLParser;
import com.exasol.jdbc.EncryptedInputStream;
import com.exasol.jdbc.EncryptedOutputStream;
import com.exasol.jdbc.ExceptionFactory;
import com.exasol.jdbc.ExecutionStatus;
import com.exasol.jdbc.GSSAuthentication;
import com.exasol.jdbc.Header;
import com.exasol.jdbc.InMessage;
import com.exasol.jdbc.LoaderException;
import com.exasol.jdbc.NotImplemented;
import com.exasol.jdbc.OutMessage;
import com.exasol.jdbc.Protocol;
import com.exasol.jdbc.ProtocolAttribute;
import com.exasol.jdbc.ProtocolException;
import com.exasol.jdbc.RC4_encoder;
import com.exasol.jdbc.RSA_encoder;
import com.exasol.jdbc.RecoverableOperation;
import com.exasol.jdbc.RollbackException;
import com.exasol.jdbc.SchemaEvent;
import com.exasol.jdbc.SchemaListener;
import com.exasol.jdbc.ServerCommunication;
import com.exasol.jdbc.SimpleDate;
import com.exasol.jdbc.StreamEncoder;
import com.exasol.jdbc.TimeoutException;
import com.exasol.jdbc.Translator;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverPropertyInfo;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public abstract class AbstractEXAConnection
extends ServerCommunication
implements Connection,
Protocol {
    Properties clientInfo = new Properties();
    private boolean isWorkerNode = false;
    private long workerToken = 0L;
    public boolean testReadTimeout = false;
    public static int testReadTimeoutVal = 1;
    protected boolean validateServerCertificate = true;
    protected boolean useLegacyEncryption = false;
    protected boolean enableNumericTypeConversion = true;
    protected String socketFactory = null;
    protected String socketFactoryArg = null;
    protected Exception lastException = null;
    private static final boolean defaultAutocomitMode = true;
    private static final boolean defaultSuperconnectionMode = false;
    private static final String defaultKerberosServiceName = "exasol";
    private static final String defaultClientName = "Generic JDBC client";
    private int lastSerialNumber = 0;
    private static final int MAX_ATTRIBS = 1000;
    private int hostTimeout = 0;
    private int loginTimeout = 0;
    private int feedbackInterval = -1;
    public static int defaultFeedbackInterval = 1;
    private int maxIdentifierLen = 128;
    private boolean snapshotTransactions = false;
    private byte[] kerberosToken = null;
    private String encoding = "utf-8";
    private int executionMode = 0;
    private DatabaseMetaData metadata;
    protected InetAddress exaServer;
    protected int exaPort;
    protected String exaFingerprint;
    protected Vector clusterNodes;
    private String user;
    private String password;
    private Header lastHeader;
    private String currentCatalog = null;
    private int transactionIsolation;
    protected Socket csocket;
    protected InputStream from_database;
    protected EXAOutputStream to_database;
    private boolean vmuMode = false;
    private Properties connectionParam = null;
    boolean connected = false;
    boolean wasDisconnected = false;
    private int queryTimeout = 0;
    private static final boolean defaultEncryptionMode = true;
    private boolean encryptionEnabled = true;
    boolean encryptionRequiredByServer = false;
    private StreamEncoder encryptor = null;
    public static int defaultDriverProtocollVersion = 21;
    private long maxMessageSize = 0x4000000L;
    private String kerberosServiceName = null;
    private String kerberosHostName = null;
    private String kerberosUserName = null;
    private String kerberosConfigFile = null;
    private String kerberosRealm = null;
    private String kerberosTargetName = null;
    private static final int notSpecified = 0;
    private static final int useSSPI = 1;
    private static final int useGSSAPI = 2;
    private static final int defaultKerberosLoginType = 0;
    private int kerberosLoginType = 0;
    private String keystoretype = null;
    private String keystorepath = null;
    private String keystorePassword = null;
    private KeyStore keyStore = null;
    private int loginType = 0;
    private boolean kerberosLogin = false;
    EXAPooledConnection connectionPool = null;
    private boolean certificatePrinted = false;
    private String connectionStatus = null;
    protected static boolean schemaChanged = false;
    private int activeProtocolVersion = defaultDriverProtocollVersion;
    private String dateFormat;
    private String timestampFormat;
    private int timestampPrecision = 6;
    private String dateLanguage;
    private String currentSchema;
    private String databaseName;
    private String databaseProductName;
    private String databaseProductVersion = null;
    private String numericCharacters;
    private long sessionID = -1L;
    private byte[] publicKey;
    private byte[] randomPhrase;
    private byte[] encodedPwd;
    static final int _defaultFetchSize = 2048;
    static final int _maxFetchSize = 65536;
    private int defaultFetchSize = 2048;
    static final int defaultConnectTimeout = 0;
    static final int defaultHostTimeout = 2000;
    static final int defaultLoginTimeout = 0;
    static final int defaultQueryTimeout = 0;
    private Map typeMap = null;
    private SQLWarning warnings;
    private int reconnectCount = 0;
    private static final int maxReconnects = 1;
    private List schemaListeners = null;
    protected int defaultHoldability = 1;
    DialectFactory dialectFactory = new DialectGeneric();
    private int[] workerPorts = null;
    private String[] workerHosts = null;
    private String[] availableWorkerHosts = null;
    private boolean commandWasEnterParallel = false;

    public boolean isWorkerConnection() {
        return this.isWorkerNode;
    }

    protected long GetMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setPool(EXAPooledConnection pool) {
        this.connectionPool = pool;
    }

    public String getConnectionStatus() {
        return this.connectionStatus;
    }

    public boolean getEnableNumericTypeConversion() {
        return this.enableNumericTypeConversion;
    }

    public boolean getSchemaMayHaveChanged() {
        return schemaChanged;
    }

    public void setSchemaMayHaveChanged() {
        schemaChanged = true;
    }

    public int getMaxIdentifierLen() {
        return this.maxIdentifierLen;
    }

    public void metadataAcquired() {
        schemaChanged = false;
    }

    public void Log(String message) {
        this.log(message);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.log("prepareStatement(" + sql + "," + autoGeneratedKeys + ")", 0);
        if (autoGeneratedKeys != 2) {
            throw new NotImplemented(this.debug, "Auto-generated keys.");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new NotImplemented(this.debug, "Not supported.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new NotImplemented(this.debug, "Not supported.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new NotImplemented(this.debug, "Not supported.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new NotImplemented(this.debug, "Not supported.");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new NotImplemented(this.debug, "Not supported.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new NotImplemented(this.debug, "Not supported.");
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.log("prepareStatement(" + sql + "," + resultSetType + "," + resultSetConcurrency + "," + resultSetHoldability + ")", 0);
        if (resultSetConcurrency != 1007) {
            throw new NotImplemented(this.debug, "Updatable ResultSets");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.log("setHoldability(" + holdability + ")", 0);
        this.defaultHoldability = holdability;
        throw new NotImplemented(this.debug, "setHoldability");
    }

    @Override
    public int getHoldability() throws SQLException {
        this.log("getHoldability()", 0);
        return this.defaultHoldability;
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        this.log("setSavepoint()", 0);
        throw new NotImplemented(this.debug, "setSavepoint");
    }

    @Override
    public synchronized Savepoint setSavepoint(String s) throws SQLException {
        this.log("setSavepoint(s)", 0);
        throw new NotImplemented(this.debug, "setSavepoint");
    }

    @Override
    public synchronized void rollback(Savepoint s) throws SQLException {
        this.log("rollback(Savepoint)", 0);
        throw new NotImplemented(this.debug, "rollback to savepoint");
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint s) throws SQLException {
        this.log("releaseSavepoint()", 0);
        throw new NotImplemented(this.debug, "releaseSavepoint");
    }

    protected synchronized byte[] communication(byte[] to_send, int size, byte mode, ExecutionStatus execStatus) throws SQLException {
        if (this.csocket == null || !this.csocket.isConnected() || this.csocket.isClosed()) {
            throw new ConnectionLost("Not connected.", this.getSessionID());
        }
        return this.communication(to_send, size, mode, execStatus, null);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    public Vector getNodes() {
        return this.clusterNodes;
    }

    public boolean IsEncrypted() {
        return this.encryptionEnabled;
    }

    public boolean IsEncryptionRequiredByServer() {
        return this.encryptionRequiredByServer;
    }

    @Override
    public synchronized boolean isValid(int timeout) throws SQLException {
        return this.isValidMS(timeout * 1000, (byte)70);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isValidMS(int timeout, byte command) throws SQLException {
        block18: {
            this.lastException = null;
            if (!this.connected) {
                return false;
            }
            try {
                if (this.activeProtocolVersion < 14) {
                    Statement st = this.createStatement();
                    st.executeUpdate("/*EXAConnection.isValid(" + timeout + ")*/");
                    st.close();
                    break block18;
                }
                EXAResult[] results = this.communication_resultset(new byte[0], command, timeout, new ExecutionStatus(), null);
                if (results != null && results.length > 0) {
                    if (results[0] instanceof EXASQLException) {
                        throw ((EXASQLException)results[0]).getSQLExceptionIntern((EXAConnection)this);
                    }
                    break block18;
                }
                throw new IOException("No valid response from server, connection is not open");
            }
            catch (Exception ex) {
                if (ex instanceof EOFException) {
                    this.log("IOException in isValid(" + timeout + "): " + ex.getMessage() + "\nSessionID=" + this.getSessionID());
                } else if (ex instanceof ConnectionLost) {
                    this.log("ConnectionLost in isValid(" + timeout + "): " + ex.getMessage() + "\nSessionID=" + this.getSessionID());
                } else {
                    if (ex instanceof SQLException) {
                        this.log("SQLException in isValid(" + timeout + "): " + ((SQLException)ex).getSQLState() + " - " + ((SQLException)ex).getMessage());
                        this.lastException = ex;
                        throw (SQLException)ex;
                    }
                    this.log(ex.toString() + " caught in isValid(" + timeout + ")\nSessionID=" + this.getSessionID());
                    if (this.connected) {
                        throw (SQLException)ex;
                    }
                }
            }
            finally {
                if (this.lastException != null && this.connectionPool != null) {
                    if (this.lastException instanceof SQLException) {
                        this.connectionPool.connectionError((SQLException)this.lastException);
                    } else {
                        this.connectionPool.connectionError(new SQLException(this.lastException.getMessage()));
                    }
                }
            }
        }
        return this.connected;
    }

    public AbstractEXAConnection(String host, int port, String user, String password, DebugLog log, Properties param) throws SQLException {
        this(host, port, user, password, log, param, null);
    }

    public AbstractEXAConnection(String host, int port, String login, String password) throws SQLException {
        this(host, port, login, password, null, new Properties(), null);
    }

    public AbstractEXAConnection(String host, int port, String login, String password, DebugLog _debug) throws SQLException {
        this(host, port, login, password, _debug, new Properties(), null);
    }

    public AbstractEXAConnection(Vector clusterDescription, String login, String password, DebugLog log, Properties params, HashMap _attribs) throws SQLException {
        super(log, "EXAConnection", null);
        this.Connect(clusterDescription, login, password, log, params, _attribs);
    }

    public AbstractEXAConnection(String server, int port, String login, String password, DebugLog log, Properties params, HashMap _attribs) throws SQLException {
        super(log, "EXAConnection", null);
        Vector<ClusterNode> v = new Vector<ClusterNode>();
        v.add(new ClusterNode(server, port));
        this.Connect(v, login, password, log, params, _attribs);
    }

    @Override
    public void clearWarnings() {
        this.log("clearWarnings");
        this.warnings = null;
    }

    public synchronized void closeBase() throws SQLException {
        this.log("closeBase()");
        try {
            if (this.wasDisconnected) {
                this.log(" Info: this connection was already disconnected, exiting closeBase()");
                return;
            }
            try {
                this.communication(null, 0, (byte)32, 0, new ExecutionStatus(), null);
            }
            catch (Exception e) {
                this.log(e.toString(), 0);
            }
            try {
                if (this.csocket != null) {
                    this.csocket.close();
                }
            }
            catch (Exception e) {
                this.log(e.toString(), 0);
            }
            this.csocket = null;
            this.log("connection closed", 0);
        }
        finally {
            this.connected = false;
            this.wasDisconnected = true;
            this.reconnectCount = 1;
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        this.log("close()", 0);
        if (this.connectionPool != null) {
            this.log(" Closing a connection from the pool: make it available for reuse.");
            this.connectionPool.free();
            return;
        }
        this.closeBase();
    }

    protected void abort() {
        this.log("abort()");
        try {
            this.closeAbort(false);
        }
        catch (Exception ex) {
            this.log("Exception in abort(): " + ex);
        }
        this.wasDisconnected = true;
        if (this.connectionPool != null) {
            try {
                this.connectionPool.close();
            }
            catch (Exception ex) {
                this.log("Exception in abort() in connectionPool.close(): " + ex);
            }
        }
    }

    protected void CheckDisconnected() throws SQLException {
        if (this.wasDisconnected) {
            this.log("ERROR: connection was already disconnected!", 1);
            throw new SQLException(Translator.No_operations_allowed_on_this_connection_because_it_was_already_closed(), "JY000");
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.log("abort(" + executor + ")");
        AbortCommand command = new AbortCommand();
        if (executor != null) {
            executor.execute(command);
        } else {
            command.run();
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    public void closeAbort(boolean silent) throws SQLException {
        try {
            this.log("closeAbort(" + silent + ")", 0);
            if (this.wasDisconnected) {
                this.log(" Info: this connection was already disconnected, exiting closeAbort()");
                return;
            }
            try {
                if (this.csocket != null) {
                    this.csocket.close();
                }
            }
            catch (Exception e) {
                this.log(e.toString(), 0);
            }
            this.log("connection closed" + (silent ? " without  disconnect" : ""), 0);
        }
        finally {
            if (!silent) {
                this.csocket = null;
                this.connected = false;
                if (this.connectionPool != null) {
                    this.connectionPool.connectionError(null);
                }
            }
        }
    }

    protected void closeSocket() throws SQLException {
        this.closeSocket(true);
    }

    protected void closeSocket(boolean disconnected) throws SQLException {
        this.log("closeSocket()");
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            this.log(ste);
        }
        if (this.csocket == null) {
            return;
        }
        try {
            if (this.csocket != null) {
                this.csocket.close();
            }
        }
        catch (Exception e) {
            this.log(e.toString(), 0);
        }
        this.csocket = null;
        this.connected = false;
        if (this.connectionPool != null) {
            this.connectionPool.connectionError(null);
        }
        this.wasDisconnected = disconnected;
    }

    @Override
    public synchronized void commit() throws SQLException {
        this.log("commit", 1);
        this.CheckDisconnected();
        this.log("createStatement to execute commit");
        Statement st = this.createStatement();
        st.executeUpdate("/*EXAConnection.commit()*/ commit;");
        st.close();
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.log("createStatement()", 1);
        this.CheckDisconnected();
        return this.dialectFactory.createStatement((EXAConnection)this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.log("createStatement()", 1);
        this.CheckDisconnected();
        if (resultSetConcurrency != 1007) {
            throw new NotImplemented(this.debug, Translator.Updatable_result_sets());
        }
        return this.dialectFactory.createStatement((EXAConnection)this, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.log("createStatement()", 1);
        this.CheckDisconnected();
        if (resultSetConcurrency != 1007) {
            throw new NotImplemented(this.debug, Translator.Updatable_result_sets());
        }
        return this.dialectFactory.createStatement((EXAConnection)this, resultSetType, resultSetConcurrency);
    }

    @Override
    public boolean getAutoCommit() {
        boolean autoCommit = this.getBooleanParameter("autocommit", true);
        this.log("EXAConnection.getAutoCommit(): " + autoCommit);
        return autoCommit;
    }

    public boolean isSuperConnection() {
        boolean superConnection = this.getBooleanParameter("superconnection", false);
        this.log("EXAConnection.SUPERCONNECTION_DEFAULT(): " + superConnection);
        return superConnection;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.log("getCatalog(): " + this.currentCatalog, 1);
        return this.currentCatalog;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.log("getMetaData() - connection meta data");
        this.CheckDisconnected();
        if (this.metadata == null) {
            this.metadata = new EXADatabaseMetaData((EXAConnection)this, this.debug);
        }
        return this.metadata;
    }

    @Override
    public int getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public Map getTypeMap() throws SQLException {
        this.log("getTypeMap()", 0);
        return this.typeMap;
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warnings;
    }

    @Override
    public boolean isClosed() {
        this.log("isClosed:" + (this.csocket == null), 3);
        if (this.connectionPool != null && !this.connectionPool.isOccupied()) {
            return true;
        }
        return this.csocket == null;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.log("isReadOnly()", 0);
        return false;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        this.log("prepareCall(" + sql + ")", 0);
        this.CheckDisconnected();
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.log("prepareCall(" + sql + "," + resultSetType + "," + resultSetConcurrency + ")", 0);
        this.CheckDisconnected();
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int dontknow) throws SQLException {
        this.log("prepareCall(" + sql + "," + resultSetType + "," + resultSetConcurrency + "," + dontknow + ")", 0);
        this.CheckDisconnected();
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        this.log("prepareStatement(" + sql + ")", 0);
        this.CheckDisconnected();
        return this.dialectFactory.createPreparedStatement(sql, (EXAConnection)this);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.log("prepareStatement(" + sql + "," + resultSetType + "," + resultSetConcurrency + ")", 0);
        this.CheckDisconnected();
        if (resultSetConcurrency != 1007) {
            throw new NotImplemented(this.debug, Translator.Updatable_result_sets());
        }
        return this.prepareStatement(sql);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.log("prepareStatement(" + sql + "," + columnIndexes + ")", 0);
        this.CheckDisconnected();
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(sql,int[])");
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.log("prepareStatement(" + sql + "," + columnNames + ")", 0);
        this.CheckDisconnected();
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String,String[])");
    }

    public String getHostsList() {
        String hostList = "";
        for (int i = 0; i < this.clusterNodes.size(); ++i) {
            hostList = hostList + ((ClusterNode)this.clusterNodes.get(i)).GetHost() + ":" + ((ClusterNode)this.clusterNodes.get(i)).GetPort();
            if (i >= this.clusterNodes.size() - 1) continue;
            hostList = hostList + ",";
        }
        return hostList;
    }

    private void Connect(Vector clusterDescription, String login, String password, DebugLog log, Properties params, HashMap _attribs) throws SQLException {
        this.log("Connect() start");
        this.warnings = null;
        this.connection = (EXAConnection)this;
        this.clusterNodes = new Vector();
        for (int i = 0; i < clusterDescription.size(); ++i) {
            ClusterNode node = new ClusterNode(((ClusterNode)clusterDescription.get(i)).GetHost(), ((ClusterNode)clusterDescription.get(i)).GetPort());
            node.UnMark();
            node.SetFingerprint(((ClusterNode)clusterDescription.get(i)).GetFingerprint());
            this.clusterNodes.add(node);
        }
        int nodesLeft = this.clusterNodes.size();
        this.connectionParam = (Properties)params.clone();
        Properties debugOutputParams = (Properties)params.clone();
        if (debugOutputParams.getProperty("url") != null && !debugOutputParams.getProperty("url").equals("")) {
            String url = debugOutputParams.getProperty("url");
            url = EXAURLParser.getMaskedString(debugOutputParams, url);
            debugOutputParams.setProperty("url", url);
        }
        debugOutputParams = EXAURLParser.getMaskedProperties(debugOutputParams);
        this.log("Connect connection param: " + debugOutputParams.toString());
        Locale locale = Locale.getDefault();
        this.log("Locale: " + locale.toString() + ", Display Name: " + locale.getDisplayName());
        DecimalFormat decimalPoint = (DecimalFormat)DecimalFormat.getInstance();
        this.log("Decimal Point Separator: " + decimalPoint.getDecimalFormatSymbols().getDecimalSeparator());
        if (this.getParameter("TestConnectionStringOnly") != null && this.getParameter("TestConnectionStringOnly").equals("1")) {
            return;
        }
        if (this.getParameter("worker") != null && this.getParameter("worker").equals("1")) {
            this.isWorkerNode = true;
        }
        if (this.getParameter("workertoken") != null) {
            this.workerToken = Long.valueOf(this.getParameter("workertoken"));
        }
        if (this.isWorkerConnection() && this.workerToken == 0L) {
            throw new ConnectFailed(Translator.Worker_connection_needs_token());
        }
        this.feedbackInterval = this.getIntParameter("feedbackinterval", -1);
        if (-1701 == this.feedbackInterval) {
            this.feedbackInterval = 1;
            this.testReadTimeout = true;
        }
        this.keystoretype = this.getStringParameter("keystoretype", null);
        this.keystorepath = this.getStringParameter("keystore", null);
        this.keystorePassword = this.getStringParameter("keystorepassword", null, true);
        if (this.keystoretype != null) {
            this.log("Keystore Type " + this.keystoretype);
        }
        if (this.keystorepath != null) {
            this.log("Keystore " + this.keystorepath);
        }
        if (this.keystorePassword != null) {
            this.log("Keystore Password ******");
        }
        Random rand = new Random(System.nanoTime());
        this.lastException = new ConnectRefused(Translator.Connection_refused());
        while (true) {
            block68: {
                String currentHostName;
                InetAddress[] expandedHosts;
                int current;
                block67: {
                    try {
                        current = rand.nextInt(this.clusterNodes.size());
                    }
                    catch (Exception ex) {
                        throw new SQLException(ex.toString());
                    }
                    if (((ClusterNode)this.clusterNodes.get(current)).IsMarked()) continue;
                    --nodesLeft;
                    ((ClusterNode)this.clusterNodes.get(current)).Mark();
                    expandedHosts = null;
                    currentHostName = ((ClusterNode)this.clusterNodes.get(current)).GetHost();
                    int currentHostPort = ((ClusterNode)this.clusterNodes.get(current)).GetPort();
                    try {
                        if (log != null) {
                            log.log("Resolving hostname: " + currentHostName + ":" + currentHostPort);
                        }
                        expandedHosts = InetAddress.getAllByName(currentHostName);
                        if (log != null) {
                            log.log("Found " + expandedHosts.length + " addresses.");
                        }
                        ThreadLocalRandom rnd = ThreadLocalRandom.current();
                        for (int i = expandedHosts.length - 1; i >= 0; --i) {
                            int index = ((Random)rnd).nextInt(i + 1);
                            InetAddress swap = expandedHosts[index];
                            expandedHosts[index] = expandedHosts[i];
                            expandedHosts[i] = swap;
                        }
                        if (log == null) break block67;
                        for (InetAddress address : expandedHosts) {
                            log.log(" - " + address.getHostAddress());
                        }
                    }
                    catch (UnknownHostException uhex) {
                        if (log != null) {
                            log.log("Hostname (" + currentHostName + ":" + currentHostPort + ") could not be resolved: " + uhex.getMessage());
                        }
                        this.lastException = new ConnectFailed(Translator.Unknown_host_name() + uhex.getMessage());
                        break block68;
                    }
                }
                this.certificatePrinted = false;
                long loginTimeStart = System.currentTimeMillis();
                InetAddress[] inetAddressArray = expandedHosts;
                int n = inetAddressArray.length;
                for (int i = 0; i < n; ++i) {
                    InetAddress addr;
                    this.exaServer = addr = inetAddressArray[i];
                    this.log("EXAServer " + this.exaServer.getHostAddress());
                    this.exaPort = ((ClusterNode)this.clusterNodes.get(current)).GetPort();
                    this.log("EXAPort " + this.exaPort);
                    String argsFingerprint = this.getStringParameter("fingerprint", null);
                    String hostFingerprint = ((ClusterNode)clusterDescription.get(current)).GetFingerprint();
                    if (argsFingerprint == null && hostFingerprint != null) {
                        this.exaFingerprint = hostFingerprint;
                    } else if (argsFingerprint != null && hostFingerprint == null) {
                        this.exaFingerprint = argsFingerprint;
                    } else if (argsFingerprint != null && hostFingerprint != null && argsFingerprint.equalsIgnoreCase(hostFingerprint)) {
                        this.exaFingerprint = argsFingerprint;
                    } else if (argsFingerprint == hostFingerprint && hostFingerprint == null) {
                        this.exaFingerprint = null;
                    } else {
                        throw new SQLException("[ERROR] Fingerprint is provided in the hostname and in the Fingerprint argument. Provide only one Fingerprint.");
                    }
                    if (this.exaFingerprint != null && this.exaFingerprint.trim().length() > 0) {
                        this.log("EXAFingerprint " + this.exaFingerprint);
                    }
                    this.log("new EXAConnection: " + this.exaServer.getHostAddress() + ":" + this.exaPort + " User: " + login);
                    this.user = login;
                    this.password = password;
                    if (this.getParameter("TestConnectionStringOnly") != null && this.getParameter("TestConnectionStringOnly").equals("1")) {
                        return;
                    }
                    this.currentSchema = this.getParameter("schema");
                    this.transactionIsolation = 8;
                    this.defaultFetchSize = this.getIntParameter("fetchsize", 2048);
                    if (this.defaultFetchSize <= 0) {
                        this.log("Connect(): Ignoring invalid fetch size: " + this.defaultFetchSize + ". Fetch size remains: " + 2048);
                        this.defaultFetchSize = 2048;
                    }
                    this.loginTimeout = this.getIntParameter("logintimeout", 0);
                    if (this.loginTimeout < 0 || this.loginTimeout >= 2147483) {
                        this.loginTimeout = 0;
                    }
                    this.hostTimeout = this.getIntParameter("hosttimeout", 2000);
                    if (this.hostTimeout < 0 || this.hostTimeout >= 2147483) {
                        this.hostTimeout = 0;
                    }
                    this.encryptionEnabled = this.getBooleanParameter("encryption", true);
                    this.queryTimeout = this.getIntParameter("querytimeout", 0);
                    this.kerberosServiceName = this.getStringParameter("kerberosservicename", null);
                    this.kerberosHostName = this.getStringParameter("kerberoshostname", null);
                    this.kerberosRealm = this.getStringParameter("kerberosrealm", null);
                    this.kerberosUserName = this.getStringParameter("kerberosusername", null);
                    this.kerberosConfigFile = this.getStringParameter("kerberosconfig", null);
                    this.kerberosLoginType = 0;
                    String s = this.getStringParameter("logintype", null);
                    if (null == s) {
                        s = this.getStringParameter("loginType", null);
                    }
                    if (null != s) {
                        switch (s) {
                            case "1": 
                            case "sspi": {
                                this.kerberosLoginType = 1;
                                break;
                            }
                            case "2": 
                            case "gss": {
                                this.kerberosLoginType = 2;
                            }
                        }
                    }
                    if (this.kerberosServiceName != null && this.kerberosHostName == null) {
                        this.kerberosHostName = currentHostName;
                    }
                    if (this.kerberosServiceName == null && this.kerberosHostName != null) {
                        this.kerberosServiceName = defaultKerberosServiceName;
                    }
                    boolean bl = this.kerberosLogin = this.kerberosServiceName != null || this.kerberosHostName != null;
                    if (this.kerberosLogin && null != this.user && null == this.kerberosUserName) {
                        this.kerberosUserName = this.user;
                    }
                    if (null != this.user && this.user.startsWith("Kerberos:")) {
                        this.kerberosTargetName = this.user.replaceFirst("Kerberos:", "");
                        this.kerberosLogin = true;
                    }
                    if (null == this.kerberosUserName) {
                        this.kerberosUserName = System.getProperty("user.name");
                    }
                    this.log("kerberosUserName = " + this.kerberosUserName);
                    this.log("kerberosServiceName = " + this.kerberosServiceName);
                    this.log("kerberosHostName = " + this.kerberosHostName);
                    this.log("kerberosLogin = " + this.kerberosLogin);
                    this.log("activeProtocolVersion = " + this.getActiveProtocolVersion());
                    this.log("kerberosConfigFile = " + this.kerberosConfigFile);
                    this.log("kerberosTargetName = " + this.kerberosTargetName);
                    if (this.getActiveProtocolVersion() < 15) {
                        this.kerberosLogin = false;
                    }
                    long loginTimeStop = 0L;
                    try {
                        this.wasDisconnected = false;
                        this.setupConnection(false, _attribs);
                        loginTimeStop = System.currentTimeMillis();
                    }
                    catch (ConnectRefused crex) {
                        loginTimeStop = System.currentTimeMillis();
                        this.lastException = crex;
                        this.log("Connection refused to " + this.exaServer.getHostAddress() + ":" + this.exaPort + " - " + crex.toString());
                        this.closeSocket();
                    }
                    catch (TimeoutException tex) {
                        loginTimeStop = System.currentTimeMillis();
                        this.lastException = tex;
                        this.log("Connection attempt timed out on " + this.exaServer.getHostAddress() + ":" + this.exaPort + " - " + tex.toString());
                        this.closeSocket();
                    }
                    catch (ConnectionToWrongWorker cwrex) {
                        loginTimeStop = System.currentTimeMillis();
                        this.lastException = cwrex;
                        this.log("Host already taken: " + this.exaServer.getHostAddress() + ":" + this.exaPort + " - " + cwrex.toString());
                        this.closeSocket();
                    }
                    catch (ConnectFailed cfex) {
                        boolean isServerReachableButHandshakeTerminated;
                        loginTimeStop = System.currentTimeMillis();
                        this.lastException = cfex;
                        this.log("Connect - got an ConnectFailed exception: " + cfex.getClass().getCanonicalName() + " from " + this.exaServer.getHostAddress() + ":" + this.exaPort + " - " + cfex.toString());
                        String errorMsgRemoteHost = "Remote host closed connection during handshake";
                        String errorFingerprintMsg = "If you trust the server, you can include the fingerprint in the connection string";
                        boolean bl2 = isServerReachableButHandshakeTerminated = cfex.getMessage().contains(errorMsgRemoteHost) && cfex.getMessage().contains(errorFingerprintMsg);
                        if (isServerReachableButHandshakeTerminated || cfex.getMessage().contains("Software caused connection abort: recv failed")) {
                            this.closeSocket(false);
                        } else {
                            this.closeSocket(true);
                            if (cfex.getMessage().contains("Fingerprint did not match.") || cfex.getMessage().contains("If you trust the server, you can include the fingerprint in") || cfex.getMessage().contains("Certificate was not received from the server.") || cfex.getMessage().contains("[ERROR] Keystore Error:")) {
                                throw cfex;
                            }
                        }
                    }
                    catch (SQLException sqlex) {
                        this.lastException = sqlex;
                        this.log("Connect - got an SQLException exception: " + sqlex.getClass().getCanonicalName() + " from " + this.exaServer.getHostAddress() + ":" + this.exaPort + " - " + sqlex.toString());
                        if (!this.wasDisconnected) {
                            this.closeSocket();
                        }
                        throw sqlex;
                    }
                    catch (Exception ex) {
                        this.lastException = new SQLException(ex);
                        this.log("Connect - got an SQLException exception: " + ex.getClass().getCanonicalName() + " from " + this.exaServer.getHostAddress() + ":" + this.exaPort + " - " + ex.toString());
                        this.closeSocket();
                        throw ex;
                    }
                    if (this.IsConnected()) {
                        try {
                            this.schemaListeners = (List)Class.forName("ArrayList").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Exception e) {
                            this.schemaListeners = new Vector();
                        }
                        break;
                    }
                    long loginTimeElapsed = loginTimeStop - loginTimeStart;
                    if (this.loginTimeout <= 0 || loginTimeElapsed < (long)this.loginTimeout) continue;
                    this.log("Connection attempt timed out on " + ((ClusterNode)this.clusterNodes.get(current)).GetHost() + ":" + ((ClusterNode)this.clusterNodes.get(current)).GetPort());
                    throw new ConnectionException("Connection attempt timed out on " + ((ClusterNode)this.clusterNodes.get(current)).GetHost() + ":" + ((ClusterNode)this.clusterNodes.get(current)).GetPort());
                }
            }
            if (0 >= nodesLeft || this.IsConnected()) break;
        }
        if (0 == nodesLeft && !this.IsConnected()) {
            this.log("0 nodes left to try");
            throw (SQLException)this.lastException;
        }
        this.wasDisconnected = false;
        this.log("Connect() end");
    }

    private boolean IsConnected() {
        return this.connected;
    }

    public void addSchemaListener(SchemaListener schemaListener) {
        if (null != this.schemaListeners) {
            this.schemaListeners.add(schemaListener);
        }
    }

    public void removeSchemaListener(SchemaListener schemaListener) {
        if (null != this.schemaListeners) {
            this.schemaListeners.remove(schemaListener);
        }
    }

    public void fireSchemaChanged(String oldName, String newName) {
        if (null == this.schemaListeners) {
            return;
        }
        if (this.schemaListeners.isEmpty()) {
            return;
        }
        SchemaEvent event = new SchemaEvent((EXAConnection)this, oldName, newName);
        for (int i = 0; i < this.schemaListeners.size(); ++i) {
            ((SchemaListener)this.schemaListeners.get(i)).schemaChanged(event);
        }
    }

    private void setupConnection(boolean reconnect, HashMap _attribs) throws SQLException {
        this.log("setupConnection(" + reconnect + ")");
        this.connected = false;
        do {
            try {
                this.activeProtocolVersion = defaultDriverProtocollVersion;
                this.connectAndLogin(reconnect, this.exaServer, this.exaPort, _attribs);
                this.connected = true;
            }
            catch (ConnectionLost cl) {
                this.log(cl.getClass().getCanonicalName() + ": " + cl);
                throw cl;
            }
            catch (ProtocolException pex) {
                this.connected = false;
                if (this.connectionPool != null) {
                    this.connectionPool.connectionError(pex);
                }
                this.log("ProtocolException from " + this.exaServer.getHostAddress() + ":" + this.exaPort + "  - " + pex.getMessage());
                if (0 == pex.getMessage().compareTo(Translator.To_create_an_encrypted_connection_the_server_must_be_at_least_5_0())) {
                    throw pex;
                }
                throw new ProtocolException(Translator.Connection_refused());
            }
            catch (SQLException e) {
                this.log("Exception for " + this.exaServer.getHostAddress() + ":" + this.exaPort + " " + e.toString(), 0);
                if (e instanceof ConnectFailed) {
                    throw e;
                }
                if (this.csocket != null && (e instanceof SQLInvalidAuthorizationSpecException || e instanceof ConnectRefused || e instanceof ConnectionLost || e instanceof TimeoutException || e instanceof ConnectionToWrongWorker)) {
                    throw e;
                }
                this.addWarning(e);
                this.connected = true;
            }
            catch (Exception e) {
                this.log(e.getClass().getCanonicalName() + " for " + this.exaServer.getHostAddress() + ":" + this.exaPort + " " + e.toString(), 0);
                if (e instanceof UnknownHostException) {
                    throw new ConnectFailed(Translator.Unknown_host_name() + e.getMessage());
                }
                throw new ConnectFailed(e.getMessage());
            }
        } while (!this.connected);
        if (!reconnect) {
            this.metadata = new EXADatabaseMetaData((EXAConnection)this, this.debug);
            if (this.getActiveProtocolVersion() < 14) {
                try {
                    if (this.currentSchema != null && this.currentSchema.length() > 0) {
                        this.setSchema(this.currentSchema);
                    }
                }
                catch (SQLException sqlex) {
                    this.log("Error in EXAConnection - failed to open default schema, aborting. " + sqlex.toString(), 0);
                    this.close();
                    throw sqlex;
                }
            }
        }
    }

    protected boolean isParameterAvailable(String key) {
        if (this.connectionParam != null) {
            return this.connectionParam.containsKey(key);
        }
        return false;
    }

    private void addWarning(SQLException ex) {
        if (this.warnings == null) {
            this.warnings = new SQLWarning(ex.getMessage() + " (SessionID: " + this.getSessionID() + ")", ex.getSQLState());
        } else {
            this.warnings.setNextWarning(new SQLWarning(ex.getMessage(), ex.getSQLState()));
        }
    }

    protected int getDefaultFetchSize() {
        if (this.defaultFetchSize <= 0) {
            if (this.debug != null) {
                this.log("getDefaultFetchSize(): Ignoring invalid fetch size: " + this.defaultFetchSize + ". Fetch size will be set to connection default: " + 2048);
            }
            this.defaultFetchSize = 2048;
        }
        return this.defaultFetchSize;
    }

    protected String getParameter(String key) {
        return this.getParameter(key, false);
    }

    protected String getParameter(String key, boolean hideResult) {
        Object obj;
        String result = null;
        if (this.connectionParam != null && (obj = this.connectionParam.get(key)) != null) {
            result = obj.toString();
        }
        if (result != null && !result.trim().isEmpty()) {
            if (hideResult) {
                this.log(" getParameter(" + key + "): ******");
            } else {
                this.log(" getParameter(" + key + "): " + result);
            }
            return result;
        }
        return null;
    }

    protected String getStringParameter(String key, String def) {
        return this.getStringParameter(key, def, false);
    }

    protected String getStringParameter(String key, String def, boolean hideResult) {
        String res = this.getParameter(key, hideResult);
        if (res == null || res.trim() == "") {
            return def;
        }
        return res;
    }

    private boolean getBooleanParameter(String key, boolean def) {
        String val = this.getParameter(key);
        if (val == null) {
            return def;
        }
        return !"0".equals(val) && !"false".equalsIgnoreCase(val);
    }

    private int getIntParameter(String key, int def) {
        String val = this.getParameter(key);
        if (val != null) {
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException ne) {
                this.log("EXAConnection.getIntParameter: non-numeric value for property \"" + key + "\"");
            }
        }
        return def;
    }

    private long getLongParameter(String key, long def) {
        String val = this.getParameter(key);
        if (val != null) {
            try {
                return Long.parseLong(val);
            }
            catch (NumberFormatException ne) {
                this.log("EXAConnection.getIntParameter: non-numeric value for property \"" + key + "\"");
            }
        }
        return def;
    }

    private final void putAttribute(HashMap map, ProtocolAttribute attrib) {
        map.put(attrib.id, attrib);
    }

    private final void putAttribute(HashMap map, ProtocolAttribute attrib, Object value) {
        ProtocolAttribute attr = new ProtocolAttribute(attrib.id);
        attr.value = value;
        map.put(attrib.id, attr);
    }

    private final void putAttribute(HashMap map, ProtocolAttribute attrib, Object value, int length) {
        ProtocolAttribute attr = new ProtocolAttribute(attrib.id);
        attr.value = value;
        attr.binaryLength = length;
        map.put(attrib.id, attr);
    }

    private HashMap setDefaultAttributes(boolean reconnect, HashMap _attribs) throws SQLException {
        String ssid;
        HashMap<Short, ProtocolAttribute> result = new HashMap<Short, ProtocolAttribute>();
        this.useLegacyEncryption = !this.connectionParam.getProperty("legacyencryption", "0").equals("0");
        this.enableNumericTypeConversion = !this.connectionParam.getProperty("enablenumerictypeconversion", "1").equals("0");
        this.socketFactory = this.connectionParam.getProperty("socketfactory", null);
        this.socketFactoryArg = this.connectionParam.getProperty("socketfactoryarg", null);
        String vsc = this.connectionParam.getProperty("validateservercertificate", null);
        if (vsc != null && vsc.equals("0")) {
            this.validateServerCertificate = false;
        } else if (vsc != null && vsc.equals("1")) {
            this.validateServerCertificate = true;
        } else if (vsc != null) {
            throw new ConnectFailed("Invalid value for validateservercertificate: " + vsc);
        }
        if (this.kerberosLogin) {
            ProtocolAttribute attrKerberosTicket = new ProtocolAttribute(ProtocolAttribute.ATTR_KERBEROS_TICKET.id);
            attrKerberosTicket.value = null;
            attrKerberosTicket.binaryLength = 0;
            this.putAttribute(result, attrKerberosTicket);
        } else if (this.user != null && this.user.length() > 0) {
            this.putAttribute(result, ProtocolAttribute.ATTR_USERNAME, this.user);
        }
        if (this.getActiveProtocolVersion() >= 14 && null != this.currentSchema && !reconnect) {
            this.putAttribute(result, ProtocolAttribute.ATTR_CURRENT_SCHEMA, this.currentSchema);
        }
        this.putAttribute(result, ProtocolAttribute.ATTR_DRIVERNAME, EXADriver.getEXADriverName());
        if (this.workerToken != 0L) {
            this.putAttribute(result, ProtocolAttribute.ATTR_PARALLEL_TOKEN, this.workerToken);
        }
        this.putAttribute(result, ProtocolAttribute.ATTR_LANGUAGE, Locale.getDefault().getLanguage());
        this.putAttribute(result, ProtocolAttribute.ATTR_RELEASE_VERSION, EXADriver.getVersionInfo());
        String attr = this.connectionParam.getProperty("clientname", defaultClientName);
        this.setClientInfoBase("clientname", attr, false);
        this.putAttribute(result, ProtocolAttribute.ATTR_CLIENTNAME, this.getClientInfo("clientname"));
        this.putAttribute(result, ProtocolAttribute.ATTR_CLIENTNAME, attr);
        attr = this.connectionParam.getProperty("clientversion", "unknown");
        this.putAttribute(result, ProtocolAttribute.ATTR_CLIENTVERSION, attr);
        attr = this.connectionParam.getProperty("authmethod", null);
        if (this.getActiveProtocolVersion() >= 18 && attr != null) {
            this.putAttribute(result, ProtocolAttribute.ATTR_AUTH_METHOD, attr);
        }
        StringBuffer os = new StringBuffer();
        os.append(System.getProperty("os.name", "unknown os"));
        os.append(" - ");
        os.append(System.getProperty("os.version", "unknown version"));
        os.append(" - ");
        os.append(System.getProperty("os.arch", "unknown arch"));
        this.putAttribute(result, ProtocolAttribute.ATTR_CLIENTOS, os.toString());
        attr = System.getProperty("user.name");
        if (attr != null) {
            this.putAttribute(result, ProtocolAttribute.ATTR_CLIENTOS_USERNAME, attr);
        }
        StringBuffer rtm = new StringBuffer();
        rtm.append(System.getProperty("java.vendor"));
        rtm.append(" - ");
        rtm.append(System.getProperty("java.version"));
        rtm.append(" - ");
        rtm.append(System.getProperty("java.vm.name"));
        rtm.append(" - ");
        rtm.append(System.getProperty("java.vm.info"));
        this.putAttribute(result, ProtocolAttribute.ATTR_CLIENTRUNTIME, rtm.toString());
        if (this.workerToken != 0L && this.sessionID == -1L && (ssid = this.connectionParam.getProperty("sessionid", null)) != null) {
            this.sessionID = Long.valueOf(ssid);
        }
        if (reconnect || this.workerToken != 0L) {
            if (-1L == this.sessionID && this.workerToken == 0L) {
                throw new SQLException(Translator.Connection_was_lost_and_reconnect_could_not_restore_the_session());
            }
            if (this.sessionID != -1L) {
                this.putAttribute(result, ProtocolAttribute.ATTR_SESSIONID, this.sessionID);
            }
        } else {
            boolean ac = this.getAutoCommit();
            String onConnect = this.getParameter("onconnect");
            ProtocolAttribute autocommitAttr = new ProtocolAttribute(ProtocolAttribute.ATTR_AUTOCOMMIT.id);
            if (!ac && (null == onConnect || onConnect.equals(""))) {
                autocommitAttr.value = false;
                result.put(autocommitAttr.id, autocommitAttr);
            }
        }
        if (this.isSuperConnection()) {
            this.putAttribute(result, ProtocolAttribute.ATTR_SUPER_CONNECTION, true);
        }
        if (-1 != this.feedbackInterval) {
            this.putAttribute(result, ProtocolAttribute.ATTR_FEEDBACK_INTERVAL, this.feedbackInterval);
        }
        this.queryTimeout = this.getIntParameter("querytimeout", -1);
        if (-1 != this.queryTimeout) {
            this.putAttribute(result, ProtocolAttribute.ATTR_QUERY_TIMEOUT, this.queryTimeout);
        } else {
            this.queryTimeout = 0;
        }
        if (_attribs != null) {
            result.putAll(_attribs);
        }
        return result;
    }

    private void setClientInfoBase(String name, String value, boolean setInDb) throws SQLClientInfoException {
        switch (name) {
            case "clientname": {
                this.clientInfo.setProperty(name, value);
                if (!setInDb) break;
                try {
                    this.setClientName(value);
                    break;
                }
                catch (SQLException ex) {
                    SQLClientInfoException clientEx = new SQLClientInfoException();
                    clientEx.initCause(ex);
                    throw clientEx;
                }
            }
            case "clientversion": {
                this.clientInfo.setProperty(name, value);
                if (!setInDb) break;
                try {
                    this.setClientVersion(value);
                    break;
                }
                catch (SQLException ex) {
                    SQLClientInfoException clientEx = new SQLClientInfoException();
                    clientEx.initCause(ex);
                    throw clientEx;
                }
            }
            default: {
                this.log("[ERROR] Client info (" + name + " -> \"" + value + "\") not known. ");
            }
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.setClientInfoBase(name, value, true);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String propName = (String)names.nextElement();
            this.setClientInfo(propName, properties.getProperty(propName));
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.clientInfo.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.clientInfo;
    }

    public int[] GetWorkerPorts() {
        String dbg = "";
        if (this.workerPorts != null) {
            for (int i = 0; i < this.workerPorts.length; ++i) {
                dbg = dbg + this.workerPorts[i] + (i == this.workerPorts.length - 1 ? "" : ", ");
            }
        }
        this.log("GetWorkerPorts() - " + dbg);
        return this.workerPorts;
    }

    public String[] GetWorkerHosts() {
        String dbg = "";
        if (this.workerHosts != null) {
            for (int i = 0; i < this.workerHosts.length; ++i) {
                dbg = dbg + this.workerHosts[i] + (i == this.workerHosts.length - 1 ? "" : ", ");
            }
        }
        this.log("GetWorkerHosts() - " + dbg);
        return this.workerHosts;
    }

    public String[] GetAvailableWorkerHosts() {
        String dbg = "";
        if (this.availableWorkerHosts != null) {
            for (int i = 0; i < this.availableWorkerHosts.length; ++i) {
                dbg = dbg + this.availableWorkerHosts[i] + (i == this.availableWorkerHosts.length - 1 ? "" : ", ");
            }
        }
        this.log("GetAvailableWorkerHosts() - " + dbg);
        return this.availableWorkerHosts;
    }

    public long GetWorkerToken() {
        return this.workerToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int EnterParallel(int maxWorkers) throws SQLException {
        this.log("EnterParallel(" + maxWorkers + ")");
        this.CheckDisconnected();
        try {
            this.commandWasEnterParallel = true;
            int nWorkers = 0;
            ExecutionStatus execStatus = new ExecutionStatus();
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            EXAOutputStream os = new EXAOutputStream(bas, (EXAConnection)this);
            try {
                os.writeInt(maxWorkers);
                String ip = this.exaServer.getHostAddress();
                os.writeInt(ip.getBytes(this.connection.getEncoding()).length);
                os.write(ip.getBytes(this.connection.getEncoding()));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new SQLException(e.getMessage());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new SQLException(e.getMessage());
            }
            byte[] to_send = bas.toByteArray();
            byte[] res = this.communication(to_send, to_send != null ? to_send.length : 0, (byte)30, execStatus, null);
            EXAInputStream is = new EXAInputStream(res, (EXAConnection)this);
            try {
                nWorkers = is.readInt();
                this.workerToken = is.readLong();
                this.workerPorts = new int[nWorkers];
                this.workerHosts = new String[nWorkers];
                for (int i = 0; i < nWorkers; ++i) {
                    this.workerPorts[i] = is.readInt();
                    int hostLen = is.readInt();
                    byte[] hostNameBytes = new byte[hostLen];
                    is.read(hostNameBytes);
                    this.workerHosts[i] = new String(hostNameBytes, StandardCharsets.UTF_8);
                }
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage());
            }
            int n = nWorkers;
            return n;
        }
        finally {
            this.commandWasEnterParallel = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int RequestParallelConnections(int maxWorkers) throws SQLException {
        this.log("Request Parallel Connections(" + maxWorkers + ")");
        this.CheckDisconnected();
        if (!this.IsRequestParallelConnectionsSupported()) {
            this.log("Request Parallel Connections is not supported. Please use EnterParallel.");
            throw new SQLException("Request Parallel Connections is not supported. Please use EnterParallel.");
        }
        try {
            this.commandWasEnterParallel = true;
            int nWorkers = 0;
            ExecutionStatus execStatus = new ExecutionStatus();
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            EXAOutputStream os = new EXAOutputStream(bas, (EXAConnection)this);
            try {
                os.writeInt(maxWorkers);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new SQLException(e.getMessage());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new SQLException(e.getMessage());
            }
            byte[] to_send = bas.toByteArray();
            byte[] res = this.communication(to_send, to_send != null ? to_send.length : 0, (byte)29, 0, execStatus, null);
            EXAInputStream is = new EXAInputStream(res, (EXAConnection)this);
            try {
                int i;
                Vector<String> ips = new Vector<String>();
                for (i = 0; i < this.clusterNodes.size(); ++i) {
                    String currentHostName = ((ClusterNode)this.clusterNodes.get(i)).GetHost();
                    int currentHostPort = ((ClusterNode)this.clusterNodes.get(i)).GetPort();
                    try {
                        InetAddress[] expandedHosts;
                        for (InetAddress ip : expandedHosts = InetAddress.getAllByName(currentHostName)) {
                            if (ip instanceof Inet4Address) {
                                ips.add(ip.getHostAddress() + ":" + currentHostPort);
                                continue;
                            }
                            if (ip instanceof Inet6Address) {
                                this.log("IPv6 Address: " + ip.getHostAddress());
                                continue;
                            }
                            this.log("Not an valid IP Address (" + ip.getHostAddress() + ")");
                        }
                        continue;
                    }
                    catch (UnknownHostException uhex) {
                        this.log(Translator.Unknown_host_name() + uhex.getMessage());
                    }
                }
                nWorkers = is.readInt();
                if (ips.size() < nWorkers) {
                    this.log("Insufficient Hosts are provided. Required Hosts: " + nWorkers + ", Provided Hosts: " + ips.size());
                    throw new SQLException("Insufficient Hosts are provided. Required Hosts: " + nWorkers + ", Provided Hosts: " + ips.size());
                }
                this.workerToken = is.readLong();
                this.availableWorkerHosts = new String[nWorkers];
                for (i = 0; i < nWorkers; ++i) {
                    StringBuilder consHostname = new StringBuilder((String)ips.get(i));
                    for (int j = nWorkers; j < ips.size(); ++j) {
                        consHostname.append(",").append((String)ips.get(j));
                    }
                    this.availableWorkerHosts[i] = consHostname.toString();
                }
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage());
            }
            int n = nWorkers;
            return n;
        }
        finally {
            this.commandWasEnterParallel = false;
        }
    }

    public boolean IsRequestParallelConnectionsSupported() {
        return this.getActiveProtocolVersion() >= 20;
    }

    public synchronized ResultSet DescribeResult(int handle) throws SQLException {
        this.log("DescribeResult(" + handle + ")");
        this.CheckDisconnected();
        ExecutionStatus execStatus = new ExecutionStatus();
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        EXAOutputStream os = new EXAOutputStream(bas, this.connection);
        try {
            os.writeInt(handle);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        EXAResult[] results = this.connection.communication_resultset(bas.toByteArray(), (byte)31, execStatus, null);
        this.connection.metadataAcquired();
        if (results != null && results.length > 0) {
            if (results[0] instanceof EXASQLException) {
                throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)results[0];
        }
        return null;
    }

    public String getKerberosUserName() {
        return this.kerberosUserName;
    }

    public String getKerberosHostName() {
        return this.kerberosHostName;
    }

    public String getKerberosTargetNameSSPI() {
        String ret = null;
        ret = this.kerberosTargetName != null ? this.kerberosTargetName : (this.kerberosHostName != null && this.kerberosRealm != null ? this.kerberosServiceName + "/" + this.kerberosHostName + "@" + this.kerberosRealm : (this.kerberosHostName == null && this.kerberosRealm == null ? this.kerberosServiceName : (this.kerberosHostName != null ? this.kerberosServiceName + "/" + this.kerberosHostName : this.kerberosServiceName + "/@" + this.kerberosRealm)));
        this.log("getKerberosTargetNameSSPI: " + ret);
        return ret;
    }

    public String getKerberosTargetNameGSS() {
        String ret = null;
        ret = this.kerberosTargetName != null ? this.kerberosTargetName : this.kerberosServiceName + "@" + this.kerberosHostName;
        this.log("getKerberosTargetNameGSS: " + ret);
        return ret;
    }

    void UseSSPI() throws IOException, SQLException {
    }

    public void SetSocketTimeout(int timeout) throws SocketException {
        if (null != this.csocket) {
            this.csocket.setSoTimeout(timeout);
        }
    }

    public int GetSocketTimeout() throws SocketException {
        if (null != this.csocket) {
            return this.csocket.getSoTimeout();
        }
        return -1;
    }

    private void connectAndLogin(boolean reconnect, InetAddress host, int port, HashMap _attribs) throws Exception, SQLException {
        boolean isLoginCredentialsRequired;
        StackTraceElement[] ste = Thread.currentThread().getStackTrace();
        String methodName = ste[1].getMethodName();
        boolean successfull = true;
        this.log(methodName + "(" + reconnect + ", " + host.getHostAddress() + ", " + port + ")");
        ByteArrayOutputStream outMsg = new ByteArrayOutputStream();
        EXAOutputStream to_msg = new EXAOutputStream(outMsg, (EXAConnection)this);
        to_msg.writeInt(this.getActiveProtocolVersion());
        SimpleDate protocolDate = new SimpleDate();
        protocolDate.fromCalendar(Calendar.getInstance());
        to_msg.writeInt(protocolDate.toInt());
        HashMap attributes = this.setDefaultAttributes(reconnect, _attribs);
        for (ProtocolAttribute attr : attributes.values()) {
            to_msg.writeAttribute(attr);
        }
        to_msg.flush();
        if (null == this.password && !this.kerberosLogin) {
            throw new IOException(Translator.Password_is_null_connect_aborted());
        }
        try {
            if (this.csocket != null) {
                throw new SQLException("Socket connection broken.");
            }
            if (null != this.socketFactory) {
                this.log(methodName + " - create custom socket from factory: " + this.socketFactory + " (" + host.getHostAddress() + ", " + port + ", " + this.hostTimeout + " MS)");
                Class<?> socketFactoryClass = null;
                socketFactoryClass = Class.forName(this.socketFactory);
                if (null == socketFactoryClass) {
                    throw new ClassNotFoundException("Not found: " + this.socketFactory);
                }
                if (null == this.socketFactoryArg) {
                    if (EXASocketFactory.class.isAssignableFrom(socketFactoryClass)) {
                        EXASocketFactory esf = (EXASocketFactory)socketFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        this.csocket = esf.createCustomSocket(host, port, this.hostTimeout);
                    } else {
                        this.csocket = ((SocketFactory)socketFactoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).createSocket(host, port);
                    }
                } else {
                    Class[] cArg = new Class[]{String.class};
                    Constructor<?> ct = socketFactoryClass.getConstructor(cArg);
                    if (null == ct) {
                        throw new ConnectFailed("Cannot find a constructor for the custom socket factory " + socketFactoryClass.getName() + " with an argument of type String.");
                    }
                    if (EXASocketFactory.class.isAssignableFrom(socketFactoryClass)) {
                        EXASocketFactory esf = (EXASocketFactory)ct.newInstance(this.socketFactoryArg);
                        this.csocket = esf.createCustomSocket(host, port, this.hostTimeout);
                    } else {
                        SocketFactory sf = (SocketFactory)ct.newInstance(this.socketFactoryArg);
                        this.csocket = sf.createSocket(host, port);
                    }
                }
                this.encryptionEnabled = this.csocket instanceof SSLSocket;
                this.useLegacyEncryption = false;
            } else {
                if (this.encryptionEnabled && !this.useLegacyEncryption) {
                    if (this.keystorepath != null) {
                        this.keyStore = this.loadKeystore(this.keystoretype, this.keystorepath, this.keystorePassword);
                    }
                    if (!this.certificatePrinted) {
                        this.listCertificates(this.keyStore);
                        this.certificatePrinted = true;
                    }
                    this.log(methodName + " - createTLSSocket(" + host.getHostAddress() + ", " + port + ", " + this.hostTimeout + " MS)");
                    this.csocket = new EXASocketFactoryInstance().createSSLSocket(this.connectionParam, this.keyStore, host, port, "TLS", "TLSv1.2", this.exaFingerprint, this.validateServerCertificate, this.hostTimeout);
                }
                if (this.useLegacyEncryption || !this.encryptionEnabled) {
                    this.log(methodName + " - createSocket(" + host.getHostAddress() + ", " + port + ", " + this.hostTimeout + " MS)");
                    this.csocket = new EXASocketFactoryInstance().createSocket(host, port, this.hostTimeout);
                }
                if (this.csocket == null) {
                    throw new SQLException("Invalid encryption settings requested in the connection string. encryption:" + this.encryptionEnabled + " validateservercertificate: " + this.validateServerCertificate + ", useLegacyEncryption:" + this.useLegacyEncryption);
                }
            }
            this.csocket.setKeepAlive(true);
            this.SetSocketTimeout(this.loginTimeout);
        }
        catch (InstantiationException e1) {
            this.log(methodName + " - got an exception: InstantiationException: " + e1.getMessage());
            throw new ConnectFailed("Socket factory failure: " + e1.toString());
        }
        catch (NoSuchMethodException e2) {
            this.log(methodName + " - got an exception: NoSuchMethodException: " + e2.getMessage());
            throw new ConnectFailed("Socket factory constructor not found: " + e2.toString());
        }
        catch (KeyStoreException e3) {
            this.log(methodName + " - got an exception: KeyStoreException: " + e3.getMessage());
            throw e3;
        }
        catch (Exception e4) {
            this.log(methodName + " - got an exception: " + e4.getClass().getCanonicalName() + ": " + e4.getMessage());
            throw new ConnectFailed(e4.toString());
        }
        this.log(methodName + " - creating socket connection");
        this.from_database = new EncryptedInputStream(new BufferedInputStream(this.csocket.getInputStream()));
        this.to_database = new EXAOutputStream(new EncryptedOutputStream(this.csocket.getOutputStream()), (EXAConnection)this);
        this.to_database.writeInt(0x1121201);
        this.to_database.writeInt(outMsg.size());
        this.to_database.write(outMsg.toByteArray());
        try {
            this.to_database.flush();
        }
        catch (Exception ex) {
            this.log(methodName + " - to_database.flush() - got an exception: " + ex.getClass().getCanonicalName() + ": " + ex.getMessage());
            throw ex;
        }
        if (this.csocket instanceof SSLSocket) {
            this.log(methodName + " - SSLSocket created");
        } else {
            this.log(methodName + " - Socket created");
        }
        this.lastHeader = new Header((EXAConnection)this, this.debug, this.getNextSerialNumber());
        ((EncryptedInputStream)this.from_database).SetMemoryStream(this.lastHeader.read_from(this.from_database, null, this.loginTimeout));
        Vector attribs = this.lastHeader.getAttributes();
        this.updateSessionAttributes(attribs);
        if (this.lastHeader.getSize() > 0) {
            byte[] bytes = new byte[this.lastHeader.getSize()];
            this.from_database.read(bytes);
            EXAResult[] results = this.processMessageBody(bytes);
            if (results != null) {
                for (int i = 0; i < results.length; ++i) {
                    if (!(results[i] instanceof EXASQLException)) continue;
                    throw ExceptionFactory.createSQLException((EXASQLException)results[i], (EXAConnection)this);
                }
            }
        }
        this.kerberosLoginType = this.kerberosLoginType == 0 && System.getProperty("os.name").startsWith("Windows") ? 1 : 2;
        if (this.kerberosLogin) {
            if (null != this.kerberosConfigFile) {
                System.setProperty("java.security.krb5.conf", this.kerberosConfigFile);
            }
            this.log(" System.setProperty(java.security.krb5.conf): " + System.getProperties().getProperty("java.security.krb5.conf"));
            if (null != this.kerberosRealm) {
                System.setProperty("java.security.krb5.realm", this.kerberosRealm);
            }
            this.log(" System.setProperty(java.security.krb5.realm): " + System.getProperties().getProperty("java.security.krb5.realm"));
            try {
                switch (this.kerberosLoginType) {
                    case 2: {
                        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
                        if (null != this.kerberosUserName && null != this.kerberosRealm) {
                            System.setProperty("sun.security.krb5.principal", this.kerberosUserName + "@" + this.kerberosRealm);
                        }
                        GSSAuthentication.authenticate((EXAConnection)this, false);
                        break;
                    }
                    case 1: {
                        this.UseSSPI();
                    }
                }
            }
            catch (Exception ex) {
                throw new SQLInvalidAuthorizationSpecException(ex.getMessage(), "28900");
            }
        }
        this.log(methodName + " - encrypt password");
        RSA_encoder encoder = new RSA_encoder();
        encoder.SetPublicKey(this.publicKey);
        ProtocolAttribute attrPwd = null;
        boolean bl = isLoginCredentialsRequired = !this.kerberosLogin;
        if (isLoginCredentialsRequired && this.workerToken != 0L && (this.getActiveProtocolVersion() <= 19 || this.sessionID <= 0L)) {
            isLoginCredentialsRequired = false;
        }
        if (isLoginCredentialsRequired) {
            int passwordPaddingLength = this.randomPhrase.length - this.password.length() - 2;
            if (passwordPaddingLength > 0) {
                ChaCha20_encoder chachaEncoder = new ChaCha20_encoder();
                byte[] passwordPadding = chachaEncoder.getRandomKey("vui4sxz28dpg3da9s1hc7".getBytes(this.getEncoding()), passwordPaddingLength);
                ByteArrayOutputStream paddedPassword = new ByteArrayOutputStream();
                paddedPassword.write(this.password.getBytes(this.encoding));
                paddedPassword.write(0);
                paddedPassword.write(passwordPadding);
                byte[] passwordBinary = paddedPassword.toByteArray();
                this.encodedPwd = encoder.EncodePwd(passwordBinary, this.randomPhrase);
            } else {
                byte[] passwordBinary = this.password.getBytes(this.encoding);
                this.encodedPwd = encoder.EncodePwd(passwordBinary, this.randomPhrase);
            }
            attrPwd = new ProtocolAttribute(ProtocolAttribute.ATTR_ENCODED_PASSWORD.id);
            attrPwd.value = this.encodedPwd;
            attrPwd.binaryLength = this.encodedPwd.length;
        }
        byte[] encodedSendKey = null;
        byte[] encodedReceiveKey = null;
        if (this.encryptionEnabled && !(this.csocket instanceof SSLSocket)) {
            byte[] sendKey = null;
            byte[] receiveKey = null;
            if (this.getActiveProtocolVersion() >= 14) {
                this.encryptor = new ChaCha20_encoder();
                sendKey = this.encryptor.getRandomKey("xewd9j439cnr4urdu4ru3".getBytes(this.getEncoding()), ChaCha20_encoder.ENCRYPTION_KEY_LEN);
                receiveKey = this.encryptor.getRandomKey("yrke9ek4yy9kd44dk88".getBytes(this.getEncoding()), ChaCha20_encoder.ENCRYPTION_KEY_LEN);
            } else {
                this.encryptor = new RC4_encoder();
                sendKey = this.encryptor.getRandomKey("kmewd9j43239cnre3e324dkurdu4ru3".getBytes(this.getEncoding()), RC4_encoder.ENCRYPTION_KEY_LEN);
                receiveKey = this.encryptor.getRandomKey("ke32rke9ek4yy9kdxefwfef234d44dk88".getBytes(this.getEncoding()), RC4_encoder.ENCRYPTION_KEY_LEN);
            }
            this.encryptor.SetKeys(sendKey, receiveKey);
            encodedSendKey = encoder.EncodePwd(sendKey, this.randomPhrase);
            encodedReceiveKey = encoder.EncodePwd(receiveKey, this.randomPhrase);
        }
        int snapshotTransInt = this.getIntParameter("snapshottransactions", 2);
        ProtocolAttribute snapshotTransactionsAttr = null;
        if ((0 == snapshotTransInt || 1 == snapshotTransInt) && this.getActiveProtocolVersion() >= 14) {
            snapshotTransactionsAttr = new ProtocolAttribute(ProtocolAttribute.ATTR_SNAPSHOT_TRANSACTIONS_ENABLED.id);
            snapshotTransactionsAttr.value = snapshotTransInt == 1;
            snapshotTransactionsAttr.binaryLength = 1;
        }
        if (this.encryptionEnabled && !(this.csocket instanceof SSLSocket)) {
            ProtocolAttribute attrSendKey = new ProtocolAttribute(ProtocolAttribute.ATTR_CLIENT_SEND_KEY.id);
            attrSendKey.value = encodedSendKey;
            attrSendKey.binaryLength = encodedSendKey.length;
            ProtocolAttribute attrReceiveKey = new ProtocolAttribute(ProtocolAttribute.ATTR_CLIENT_RECEIVE_KEY.id);
            attrReceiveKey.value = encodedReceiveKey;
            attrReceiveKey.binaryLength = encodedReceiveKey.length;
            ProtocolAttribute attrKeyLen = new ProtocolAttribute(ProtocolAttribute.ATTR_CLIENT_KEYS_LEN.id);
            if (this.encryptor instanceof ChaCha20_encoder) {
                attrKeyLen.value = ChaCha20_encoder.ENCRYPTION_KEY_LEN;
            } else if (this.encryptor instanceof RC4_encoder) {
                attrKeyLen.value = RC4_encoder.ENCRYPTION_KEY_LEN;
            } else {
                throw new IOException("Unknown encryption class");
            }
            attrKeyLen.binaryLength = 4;
            this.to_database.writeInt(6 + (null != attrPwd ? attrPwd.binaryLength + 6 : 0) + attrSendKey.binaryLength + 6 + attrReceiveKey.binaryLength + 2 + attrKeyLen.binaryLength + (null != snapshotTransactionsAttr ? snapshotTransactionsAttr.binaryLength + 2 : 0));
            this.to_database.write(35);
            this.to_database.writeInt(this.getNextSerialNumber());
            this.to_database.writeInt(4 + (null != snapshotTransactionsAttr ? 1 : 0));
            this.to_database.writeInt(6 + (null != attrPwd ? attrPwd.binaryLength + 6 : 0) + attrSendKey.binaryLength + 6 + attrReceiveKey.binaryLength + 2 + attrKeyLen.binaryLength + (null != snapshotTransactionsAttr ? snapshotTransactionsAttr.binaryLength + 2 : 0));
            this.to_database.writeInt(0);
            if (null != snapshotTransactionsAttr) {
                this.to_database.writeAttribute(snapshotTransactionsAttr);
            }
            if (null != attrPwd) {
                this.to_database.writeAttribute(attrPwd);
            }
            this.to_database.writeAttribute(attrSendKey);
            this.to_database.writeAttribute(attrReceiveKey);
            this.to_database.writeAttribute(attrKeyLen);
        } else {
            this.to_database.writeInt((null != attrPwd ? attrPwd.binaryLength + 6 : 0) + (null != snapshotTransactionsAttr ? snapshotTransactionsAttr.binaryLength + 2 : 0));
            this.to_database.write(35);
            this.to_database.writeInt(this.getNextSerialNumber());
            this.to_database.writeInt(null != attrPwd ? 1 : 0 + (null != snapshotTransactionsAttr ? 1 : 0));
            this.to_database.writeInt((null != attrPwd ? attrPwd.binaryLength + 6 : 0) + (null != snapshotTransactionsAttr ? snapshotTransactionsAttr.binaryLength + 2 : 0));
            this.to_database.writeInt(0);
            if (null != snapshotTransactionsAttr) {
                this.to_database.writeAttribute(snapshotTransactionsAttr);
            }
            if (null != attrPwd) {
                this.to_database.writeAttribute(attrPwd);
            }
        }
        this.to_database.flush();
        this.log(methodName + " - read answer");
        this.lastHeader = new Header((EXAConnection)this, this.debug, this.getNextSerialNumber());
        ((EncryptedInputStream)this.from_database).SetMemoryStream(this.lastHeader.read_from(this.from_database, null, this.loginTimeout));
        if (!reconnect) {
            this.dateFormat = "YYYY-MM-DD";
            this.timestampFormat = "YYYY-MM-DD HH:MI:SS.FF3";
            this.numericCharacters = ".,";
        }
        attribs = this.lastHeader.getAttributes();
        this.updateSessionAttributes(attribs);
        try {
            if (this.lastHeader.getSize() > 0) {
                byte[] bytes = new byte[this.lastHeader.getSize()];
                this.from_database.read(bytes);
                EXAResult[] results = this.processMessageBody(bytes);
                if (results != null) {
                    for (int i = 0; i < results.length; ++i) {
                        if (!(results[i] instanceof EXASQLException)) continue;
                        throw ExceptionFactory.createSQLException((EXASQLException)results[i], (EXAConnection)this);
                    }
                }
            }
        }
        catch (RollbackException rex) {
            this.log(methodName + " - got an exception: RollbackException: " + rex.getMessage());
            if (this.getActiveProtocolVersion() >= 12) {
                if (this.encryptionEnabled && !(this.csocket instanceof SSLSocket)) {
                    this.to_database.SetEncryptor(this.encryptor);
                    ((EncryptedInputStream)this.from_database).SetEncryptor(this.encryptor);
                }
                this.getAttributes();
                this.updateSessionAttributes(attribs);
            }
            throw rex;
        }
        if (this.encryptionEnabled && !(this.csocket instanceof SSLSocket)) {
            this.to_database.SetEncryptor(this.encryptor);
            ((EncryptedInputStream)this.from_database).SetEncryptor(this.encryptor);
        }
        this.getAttributes();
        this.updateSessionAttributes(attribs);
        if (!this.useLegacyEncryption && this.MustUseLegacyEncryption()) {
            this.useLegacyEncryption = true;
            this.connectionParam.setProperty("legacyencryption", "1");
            this.close();
            this.wasDisconnected = false;
            this.reconnectCount = 0;
            this.connectAndLogin(reconnect, host, port, _attribs);
            return;
        }
    }

    public boolean usingSSLSocket() {
        return this.csocket instanceof SSLSocket;
    }

    private String toHexStr(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            sb.append(String.format("%02x", b[i]));
        }
        return sb.toString();
    }

    @Override
    public synchronized void setSchema(String schema) throws SQLException {
        this.log("EXAConnection.setSchema(" + schema + ") protocolVersion=" + this.getActiveProtocolVersion());
        this.CheckDisconnected();
        if (this.getActiveProtocolVersion() < 14 || schema == null) {
            String sql = null;
            sql = schema == null ? "close schema" : "open schema " + schema;
            EXAResult[] results = null;
            ExecutionStatus execStatus = new ExecutionStatus();
            try {
                results = this.connection.communication_resultset(sql.getBytes(this.connection.getEncoding()), (byte)12, execStatus, null);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new SQLException(e.getMessage());
            }
            if (results != null && results.length > 0 && results[0] instanceof EXASQLException) {
                throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
            }
        } else {
            ProtocolAttribute attr = new ProtocolAttribute(ProtocolAttribute.ATTR_CURRENT_SCHEMA.id);
            attr.value = schema;
            ProtocolAttribute[] attribs = new ProtocolAttribute[]{attr};
            try {
                this.setAttributes(attribs);
            }
            catch (IOException e) {
                this.log("EXAConnection.setSchema(): caught IOException: " + e);
                throw new ConnectionLost(e.toString(), this.getSessionID());
            }
            catch (SQLException se) {
                this.log("EXAConnection.setSchema(): caught SQLException: " + se);
                throw se;
            }
        }
        this.getSchema();
    }

    @Override
    public synchronized String getSchema() throws SQLException {
        this.log("EXAConnection.getSchema()");
        this.CheckDisconnected();
        try {
            this.getAttributes();
        }
        catch (IOException e) {
            throw new SQLException(e.getMessage(), "HY000");
        }
        this.log("EXAConnection.getSchema() returns " + this.getCurrentSchema());
        return this.getCurrentSchema();
    }

    protected int getNextSerialNumber() {
        return this.lastSerialNumber++;
    }

    public final synchronized byte[] communication(byte[] to_send, byte mode, ExecutionStatus execStatus, ProtocolAttribute[] attribs) throws SQLException {
        this.executionMode = mode;
        byte[] res = this.communication(to_send, to_send == null ? -1 : to_send.length, mode, execStatus, attribs);
        if (execStatus.cancelInitiated()) {
            res = this.communication(null, 0, (byte)37, execStatus, attribs);
        }
        return res;
    }

    private final synchronized InMessage _communication(OutMessage msg) throws IOException, SQLException {
        msg.write_to_and_no_clean(this.to_database, (EXAConnection)this);
        return new InMessage(this.debug, this.from_database, (EXAConnection)this);
    }

    private final synchronized InMessage communication(OutMessage msg) throws IOException, SQLException {
        this.tmpOutMessage = msg;
        this.tmpOutMessage.flush();
        this.handle(new RecoverableOperation(){

            @Override
            public void op() throws IOException, SQLException {
                AbstractEXAConnection.this.tmpInMessage = AbstractEXAConnection.this._communication(AbstractEXAConnection.this.tmpOutMessage);
            }
        });
        return this.tmpInMessage;
    }

    protected final synchronized EXAResult[] communication_resultset(byte[] to_send, byte mode, ExecutionStatus execStatus, ProtocolAttribute[] attribs) throws SQLException {
        return this.communication_resultset(to_send, mode, 0, execStatus, attribs);
    }

    protected final synchronized EXAResult[] communication_resultset(byte[] to_send, byte mode, int timeout, ExecutionStatus execStatus, ProtocolAttribute[] attribs) throws SQLException {
        this.executionMode = mode;
        int to_send_len = null != to_send ? to_send.length : 0;
        try {
            this.log("start communication_resultset(nBytes: " + to_send_len + ", mode: " + mode + ")");
            byte[] res = this.communication(to_send, to_send != null ? to_send.length : 0, mode, timeout, execStatus, attribs);
            if (execStatus.cancelInitiated()) {
                res = this.communication(null, 0, (byte)37, timeout, execStatus, attribs);
            }
            EXAResult[] eXAResultArray = this.readResults(res, this.lastHeader.getNumberOfResults());
            return eXAResultArray;
        }
        catch (IOException e) {
            this.log(e);
            throw new ConnectionLost(e.toString(), this.getSessionID());
        }
        finally {
            this.log("end communication_resultset(nBytes: " + to_send_len + ", mode: " + mode + ")");
        }
    }

    private EXAResult[] processMessageBody(byte[] bytes) throws IOException, SQLException {
        if (bytes == null) {
            return null;
        }
        EXAInputStream is = new EXAInputStream(bytes, (EXAConnection)this);
        int nr_of_results = this.lastHeader.getNumberOfResults();
        EXAResult[] results = new EXAResult[nr_of_results];
        block5: for (int i = 0; i < nr_of_results; ++i) {
            byte flag = is.readByte();
            switch (flag) {
                case 0: {
                    results[i] = new EXARowCount(is, this.debug);
                    continue block5;
                }
                case 1: {
                    results[i] = this.dialectFactory.createResultSet(is, (EXAConnection)this, this.debug);
                    continue block5;
                }
                case -1: {
                    results[i] = new EXASQLException(is, this.debug);
                    continue block5;
                }
                default: {
                    throw new IOException();
                }
            }
        }
        return results;
    }

    public final synchronized EXAResult[] communication_vector(Vector commands, byte mode, ExecutionStatus execStatus, ProtocolAttribute[] attribs) throws SQLException {
        this.executionMode = mode;
        EXAResult[] results = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            EXAOutputStream os = new EXAOutputStream(out, (EXAConnection)this);
            os.writeInt(commands.size());
            for (int i = 0; i < commands.size(); ++i) {
                os.writeString((String)commands.elementAt(i));
            }
            os.flush();
            results = commands.size() > 0 ? this.communication_resultset(out.toByteArray(), mode, execStatus, attribs) : this.communication_resultset(null, mode, execStatus, attribs);
        }
        catch (IOException e) {
            this.log(e);
            throw new ConnectionLost(e.toString(), this.getSessionID());
        }
        return results;
    }

    private EXAResult readSingleResult(EXAInputStream is) throws IOException, SQLException {
        EXAResult result = null;
        byte flag = is.readByte();
        switch (flag) {
            case 0: {
                result = new EXARowCount(is, this.debug);
                break;
            }
            case 1: {
                result = this.dialectFactory.createResultSet(is, (EXAConnection)this, this.debug);
                if (-4 != ((EXAResultSet)result).GetHandle()) break;
                result = new EXASQLException("HY000", Translator.Query_did_not_return_a_result_set(), this.debug);
                break;
            }
            case -1: {
                result = new EXASQLException(is, this.debug);
                break;
            }
            case 2: {
                result = new EXAHandle(is, this.debug);
                break;
            }
            case 5: {
                result = new EXAStillExecuting(is, this.debug);
                break;
            }
            default: {
                throw new ProtocolException(Translator.Server_returned_unknow_type_of_result() + " (Type: " + flag + ", SessionID: " + this.getSessionID() + ")");
            }
        }
        return result;
    }

    private EXAResult[] readResults(byte[] res, int numberOfResults) throws IOException, SQLException, ProtocolException {
        if (res == null) {
            return null;
        }
        return this.readResults(new EXAInputStream(res, (EXAConnection)this), numberOfResults);
    }

    private EXAResult[] readResults(EXAInputStream is, int numberOfResults) throws IOException, SQLException {
        EXAResult[] results = null;
        int nr_of_results = numberOfResults;
        this.log(nr_of_results + " results in message");
        if (nr_of_results > 0) {
            results = new EXAResult[nr_of_results];
            for (int i = 0; i < nr_of_results; ++i) {
                results[i] = this.readSingleResult(is);
            }
        }
        return results;
    }

    private void checkResults(InMessage msg) throws ProtocolException, IOException, SQLException {
        if (msg == null) {
            throw new ProtocolException("Unexpectedly the input message was null, date: " + LocalDateTime.now() + ", Session ID: " + this.getSessionID());
        }
        EXAResult[] res = this.readResults(msg.getStream(), msg.getHeader().getNumberOfResults());
        if (res != null) {
            for (int i = 0; i < res.length; ++i) {
                if (!(res[i] instanceof EXASQLException)) continue;
                throw ((EXASQLException)res[i]).getSQLExceptionIntern(this.connection);
            }
        }
    }

    protected synchronized byte[] communication(byte[] to_send, int size, byte mode, ExecutionStatus execStatus, ProtocolAttribute[] attribs) throws SQLException {
        return this.communication(to_send, size, mode, 0, execStatus, attribs);
    }

    protected synchronized byte[] communication(byte[] to_send, int size, byte mode, int timeout, ExecutionStatus execStatus, ProtocolAttribute[] attribs) throws SQLException {
        this.executionMode = mode;
        try {
            CommOp operation = new CommOp();
            operation.execStatus = execStatus;
            operation.execStatus.connection = (EXAConnection)this;
            operation.responseTimeout = timeout;
            if (size >= 0) {
                operation.header = new Header((EXAConnection)this, this.debug, this.getNextSerialNumber());
                if (null != attribs) {
                    for (int i = 0; i < attribs.length; ++i) {
                        operation.header.addAttribute(attribs[i]);
                    }
                }
                operation.header.setSize(size);
                operation.header.setMode(mode);
                operation.header.setNumberOfResults(0);
            }
            operation.outBytes = to_send;
            this.handle(operation);
            this.lastHeader = operation.header;
            return operation.inBytes;
        }
        catch (IOException e) {
            this.log(e.toString());
            throw new ConnectionLost(e.toString(), this.getSessionID());
        }
    }

    private byte[] readMessageBody(Header h) throws ConnectionException, IOException, ConnectionLost {
        int left;
        int pos = 0;
        byte[] resbuffer = null;
        if (left > 0) {
            int r;
            resbuffer = new byte[h.getSize()];
            for (left = h.getSize(); left > 0; left -= r) {
                r = 0;
                try {
                    r = this.from_database.read(resbuffer, pos, left);
                    if (r < 0) {
                        throw new ConnectionLost(Translator.Failed_to_read_from_server(), this.getSessionID());
                    }
                }
                catch (InterruptedIOException io) {
                    r = io.bytesTransferred;
                }
                pos += r;
            }
        }
        return resbuffer;
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.log("rollback", 1);
        this.CheckDisconnected();
        this.log("createStatement to execute rollback");
        Statement st = this.createStatement();
        st.executeUpdate("/*EXAConnection.rollback()*/ rollback;");
        st.close();
    }

    @Override
    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this.log("EXAConnection.setAutoCommit(" + autoCommit + ")");
        this.CheckDisconnected();
        ProtocolAttribute attr = new ProtocolAttribute(ProtocolAttribute.ATTR_AUTOCOMMIT.id);
        attr.value = autoCommit;
        ProtocolAttribute[] attribs = new ProtocolAttribute[]{attr};
        try {
            this.setAttributes(attribs);
            this.connectionParam.put("autocommit", autoCommit ? "1" : "0");
        }
        catch (IOException e) {
            this.log("EXAConnection.setAutoCommit(): caught exception: " + e);
            throw new ConnectionLost(Translator.Failed_to_set_autocommit_mode_to() + e.toString(), this.getSessionID());
        }
    }

    public synchronized void setClientName(String value) throws SQLException {
        this.log("EXAConnection.setClientName(" + value + ")");
        this.CheckDisconnected();
        ProtocolAttribute attr = new ProtocolAttribute(ProtocolAttribute.ATTR_CLIENTNAME.id);
        attr.value = value;
        ProtocolAttribute[] attribs = new ProtocolAttribute[]{attr};
        try {
            this.setAttributes(attribs);
        }
        catch (IOException e) {
            this.log("EXAConnection.setClientName(): caught exception: " + e);
            throw new ConnectionLost("Failed to set the client name in the server: " + e.toString(), this.getSessionID());
        }
    }

    public synchronized void setClientVersion(String value) throws SQLException {
        this.log("EXAConnection.setClientVersion(" + value + ")");
        this.CheckDisconnected();
        ProtocolAttribute attr = new ProtocolAttribute(ProtocolAttribute.ATTR_CLIENTVERSION.id);
        attr.value = value;
        ProtocolAttribute[] attribs = new ProtocolAttribute[]{attr};
        try {
            this.setAttributes(attribs);
        }
        catch (IOException e) {
            this.log("EXAConnection.setClientVersion(): caught exception: " + e);
            throw new ConnectionLost("Failed to set the client version in the server: " + e.toString(), this.getSessionID());
        }
    }

    public synchronized void SetSnapshotTransactions(boolean useST) throws SQLException {
        this.log("EXAConnection.useSnpashotTransaction(" + useST + ")");
        this.CheckDisconnected();
        if (this.getActiveProtocolVersion() >= 12) {
            ProtocolAttribute attr = new ProtocolAttribute(ProtocolAttribute.ATTR_SNAPSHOT_TRANSACTIONS_ENABLED.id);
            attr.value = useST;
            ProtocolAttribute[] attribs = new ProtocolAttribute[]{attr};
            try {
                this.setAttributes(attribs);
            }
            catch (IOException e) {
                this.log("EXAConnection.useSnpashotTransaction(): caught exception: " + e);
                throw new ConnectionLost(Translator.Failed_to_set_use_snapshot_transactions_to() + e.toString(), this.getSessionID());
            }
        } else {
            this.log("Attribute ATTR_SNAPSHOT_TRANSACTIONS_ENABLED not implemented for protocol V" + this.getActiveProtocolVersion());
        }
    }

    public synchronized void setFeedbackInterval(int sec) throws SQLException {
        this.log("EXAConnection.setFeedbackInterval(" + sec + ")");
        this.CheckDisconnected();
        if (this.getActiveProtocolVersion() < 9) {
            throw new SQLException(Translator.Failed_to_set_feedback_interval_to() + sec + ". Active protocol version: " + this.getActiveProtocolVersion());
        }
        this.feedbackInterval = sec;
        ProtocolAttribute attr = new ProtocolAttribute(ProtocolAttribute.ATTR_FEEDBACK_INTERVAL.id);
        attr.value = sec;
        ProtocolAttribute[] attribs = new ProtocolAttribute[]{attr};
        try {
            this.setAttributes(attribs);
        }
        catch (IOException e) {
            this.log("EXAConnection.setFeedbackInterval(): caught exception: " + e);
            throw new ConnectionLost(Translator.Failed_to_set_feedback_interval_to() + sec + ". " + e.toString(), this.getSessionID());
        }
    }

    public int getFeedbackInterval() {
        if (-1 == this.feedbackInterval) {
            return defaultFeedbackInterval;
        }
        return this.feedbackInterval;
    }

    public boolean getSnapshotTransactionsEnabled() {
        return this.snapshotTransactions;
    }

    public int getExecutionMode() {
        return this.executionMode;
    }

    @Override
    public synchronized void setCatalog(String catalog) throws SQLException {
        this.log("setCatalog(" + catalog + ")", 1);
        this.CheckDisconnected();
        if (!this.currentCatalog.equalsIgnoreCase(catalog)) {
            throw new SQLException(Translator.No_such_catalog() + catalog);
        }
    }

    @Override
    public synchronized void setReadOnly(boolean ro) throws SQLException {
        this.log("setReadOnly(" + ro + ")", 0);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.transactionIsolation = level;
    }

    public void setTypeMap(Map map) throws SQLException {
        this.log("setTypeMap(" + map + ")", 0);
        this.typeMap = map;
    }

    public synchronized void setQueryTimeout(int seconds) throws SQLException {
        this.log("EXAConnection.setQueryTimeout(" + seconds + ")");
        this.CheckDisconnected();
        ProtocolAttribute attr = new ProtocolAttribute(ProtocolAttribute.ATTR_QUERY_TIMEOUT.id);
        attr.value = seconds;
        ProtocolAttribute[] attribs = new ProtocolAttribute[]{attr};
        try {
            this.setAttributes(attribs);
        }
        catch (IOException e) {
            this.log("EXAConnection.setQueryTimeout(" + seconds + "): caught IOException: " + e.toString());
            throw new SQLException(e.toString());
        }
        catch (SQLException sqlex) {
            this.log("EXAConnection.setQueryTimeout(" + seconds + "): caught SQLException: " + sqlex.toString());
            throw sqlex;
        }
        this.queryTimeout = seconds;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public synchronized String[] getClusterNodes() throws IOException, SQLException {
        this.log("getClusterNodes()");
        this.CheckDisconnected();
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        EXAOutputStream os = new EXAOutputStream(buf, (EXAConnection)this);
        String ip = this.exaServer.getHostAddress();
        os.writeString(ip);
        os.flush();
        this.log("    sending IP: " + ip);
        byte[] res = this.communication(buf.toByteArray(), buf.size(), (byte)16, new ExecutionStatus(), null);
        EXAInputStream is = new EXAInputStream(res, (EXAConnection)this);
        int number = is.readInt();
        String[] names = new String[number];
        for (int i = 0; i < number; ++i) {
            names[i] = is.readString();
            this.log("EXA reports ip " + i + " of " + number + ": " + names[i]);
        }
        return names;
    }

    public Vector getClusterNodesVector() {
        return this.clusterNodes;
    }

    @Override
    public DebugLog getDebug() {
        return this.debug;
    }

    protected int uploadJob(String description, byte flags, Vector sql, Vector dependencies, String owner) throws SQLException, IOException {
        throw new SQLException(Translator.Queueing_system_not_supported());
    }

    protected int uploadJob(String description, byte flags, Vector sql, Vector dependencies) throws SQLException, IOException {
        return this.uploadJob(description, flags, sql, dependencies, this.user);
    }

    protected void setQueuePolicy(int policy) throws SQLException, IOException {
        throw new SQLException(Translator.Queueing_system_not_supported());
    }

    public synchronized void killSession(long id) throws SQLException {
        this.log("killSession(" + id + ")", 0);
        this.CheckDisconnected();
        if (id < 0L) {
            throw ExceptionFactory.createSQLException(Translator.Invalid_process_number(), "08003", (EXAConnection)this);
        }
        ExecutionStatus execStatus = new ExecutionStatus();
        EXAResult[] results = null;
        byte[] b = null;
        if (this.getActiveProtocolVersion() >= 8) {
            b = new byte[8];
            for (int i = 0; i < 8; ++i) {
                b[i] = (byte)(id >>> i * 8);
            }
        } else {
            b = new byte[4];
            for (int i = 0; i < 4; ++i) {
                b[i] = (byte)(id >>> i * 8);
            }
        }
        if ((results = this.connection.communication_resultset(b, (byte)27, execStatus, null)) != null && results.length > 0 && results[0] instanceof EXASQLException) {
            throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
        }
    }

    protected boolean isInVMUMode() {
        return this.vmuMode;
    }

    private String[] ColSplitter(String withClause) throws LoaderException {
        if (null == withClause || withClause.length() == 0) {
            return null;
        }
        int lastPos = 0;
        int klammer = 0;
        boolean anf = false;
        int colNum = 1;
        String[] result = null;
        int currentResult = 0;
        withClause = withClause + ",";
        char[] buff = new char[withClause.length()];
        withClause.getChars(0, withClause.length(), buff, 0);
        block6: for (int pos = 0; pos < buff.length; ++pos) {
            switch (buff[pos]) {
                case '(': {
                    if (anf) continue block6;
                    ++klammer;
                    continue block6;
                }
                case ')': {
                    if (anf) continue block6;
                    --klammer;
                    continue block6;
                }
                case '\"': {
                    if (!anf) {
                        anf = true;
                        continue block6;
                    }
                    anf = false;
                    continue block6;
                }
                case ',': {
                    if (false != klammer || anf) continue block6;
                    if (pos - lastPos < 3) {
                        throw new LoaderException(Translator.Sytax_error_missing_column_description_for_col() + colNum);
                    }
                    ++colNum;
                    if (0 == currentResult) {
                        result = new String[1];
                    } else {
                        String[] tmp = new String[currentResult + 1];
                        for (int i = 0; i < currentResult; ++i) {
                            tmp[i] = result[i];
                        }
                        result = tmp;
                    }
                    result[currentResult] = new String(buff, lastPos, pos - lastPos);
                    lastPos = pos + 1;
                    ++currentResult;
                }
            }
        }
        if (0 == currentResult) {
            result = new String[]{new String(buff)};
        }
        return result;
    }

    private void GetCollsAndTypes(String[] cols, String[] types, String[] parts) throws LoaderException {
        for (int i = 0; i < parts.length; ++i) {
            int pos;
            char[] buff = new char[parts[i].length()];
            parts[i].getChars(0, parts[i].length(), buff, 0);
            int lastPos = 0;
            boolean anf = false;
            int klam = 0;
            boolean wasChar = false;
            block13: for (pos = 0; pos < buff.length && null == cols[i]; ++pos) {
                switch (buff[pos]) {
                    case '\"': {
                        if (!anf) {
                            anf = true;
                            continue block13;
                        }
                        anf = false;
                        continue block13;
                    }
                    case ' ': {
                        if (!anf && wasChar) {
                            cols[i] = new String(buff, lastPos, pos - lastPos);
                            lastPos = pos + 1;
                            continue block13;
                        }
                        if (wasChar) continue block13;
                        ++lastPos;
                        continue block13;
                    }
                    default: {
                        wasChar = true;
                    }
                }
            }
            if (null == cols[i]) {
                throw new LoaderException(Translator.No_column_name_found_for_column() + (i + 1));
            }
            wasChar = false;
            boolean wasKlammer = false;
            while (pos < buff.length && null == types[i]) {
                switch (buff[pos]) {
                    case '(': {
                        ++klam;
                        if (wasKlammer) {
                            throw new LoaderException(Translator.To_many_parantheses_describing_datatype_for_col() + (i + 1));
                        }
                        wasKlammer = true;
                        break;
                    }
                    case ')': {
                        --klam;
                        break;
                    }
                    case ' ': {
                        if (0 == klam && wasChar) {
                            boolean end = true;
                            if (!wasKlammer) {
                                end = false;
                                int count = 0;
                                while (pos + count < buff.length && buff[pos + count] == ' ') {
                                    ++count;
                                }
                                if (pos + count == buff.length) {
                                    end = true;
                                } else if ('(' != buff[pos + count]) {
                                    end = true;
                                }
                            }
                            if (!end) break;
                            types[i] = new String(buff, lastPos, pos - lastPos);
                            break;
                        }
                        if (wasChar) break;
                        ++lastPos;
                        break;
                    }
                    default: {
                        wasChar = true;
                    }
                }
                ++pos;
            }
            if (0 != klam) {
                throw new LoaderException(Translator.Error_found_counting_parantheses_in_datatype_description_for_col() + (i + 1));
            }
            if (lastPos + 1 < pos && null == types[i]) {
                types[i] = new String(buff, lastPos, pos - lastPos);
            }
            if (null == types[i]) {
                throw new LoaderException(Translator.No_datataype_found_for_column() + (i + 1));
            }
            while (pos < buff.length) {
                switch (buff[pos]) {
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new LoaderException(i + 1 + Translator.Too_many_words_found());
                    }
                }
                ++pos;
            }
        }
    }

    protected static String sqlQuote(String str, char quoteChar) {
        char[] ret = new char[(str.length() << 1) + 2];
        int pos = 0;
        ret[pos++] = quoteChar;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == quoteChar) {
                ret[pos++] = ch;
            }
            ret[pos++] = ch;
        }
        ret[pos++] = quoteChar;
        return new String(ret, 0, pos);
    }

    protected int compiledDriverVersion() {
        return defaultDriverProtocollVersion;
    }

    public int getEXAPort() {
        return this.exaPort;
    }

    public String getEXAServer() {
        String ip = new InetSocketAddress(this.exaServer, this.exaPort).getHostString();
        this.log(Thread.currentThread().getStackTrace()[2].getMethodName() + "() : " + ip);
        return ip;
    }

    public String getEXAServerSSLParam() {
        if (this.exaFingerprint != null) {
            return this.exaFingerprint;
        }
        if (!this.validateServerCertificate) {
            return "nocertcheck";
        }
        return null;
    }

    public String getEXAServerIP() {
        String ip = this.exaServer.getHostAddress();
        this.log(Thread.currentThread().getStackTrace()[2].getMethodName() + "() : " + ip);
        return ip;
    }

    protected String getUser() {
        if (this.kerberosLogin && this.kerberosUserName != null) {
            return this.kerberosUserName;
        }
        return this.user;
    }

    protected String getURL() {
        return this.connectionParam.getProperty("url");
    }

    protected static DriverPropertyInfo[] getDefaultProperties() {
        ArrayList<DriverPropertyInfo> resultProps = new ArrayList<DriverPropertyInfo>();
        DriverPropertyInfo newVal = new DriverPropertyInfo("autocommit", "1");
        newVal.description = Translator.Auto_commit_0_disabled_1_enabled();
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("fetchsize", Integer.toString(2048));
        newVal.description = Translator.Default_fetch_size();
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("schema", null);
        newVal.description = Translator.Name_of_initially_opened_schema();
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("fingerprint", null);
        newVal.description = "The fingerprint used by the ssl connection.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("debug", "0");
        newVal.description = Translator.Set_to_1_to_activate_logging();
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("logdir", "");
        newVal.description = "Directory name where to save the logfiles to.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("clientname", defaultClientName);
        newVal.description = "Name of the client application.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("clientversion", null);
        newVal.description = "Version of the client application.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("logintimeout", String.valueOf(0));
        newVal.description = "A timeout in milli seconds that specifies the maximum time interval the driver will try to establish a socket connection for the host available in the connection string.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("hosttimeout", String.valueOf(2000));
        newVal.description = "A timeout in milli seconds that specifies the maximum time interval the driver will try to establish a socket connection on each node given in the connection string.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("encryption", "1");
        newVal.description = "Encrypt the client server communication.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("querytimeout", String.valueOf(0));
        newVal.description = "Query timeout in seconds, default is 0 (infinite).";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("superconnection", "0");
        newVal.description = "Enables the SuperConnection mode.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("feedbackinterval", String.valueOf(defaultFeedbackInterval));
        newVal.description = "While a query is running, the server sends status feedback to the client. This is also used by the driver to cancel queries. The interval is seconds.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("snapshottransactions", String.valueOf(2));
        newVal.description = "Enables snapshot transactions in this session. Accepted Values: 0 (Disable), 1 (Enable), and 2 (the default in the session is used). Default Option: 2";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("kerberosservicename", defaultKerberosServiceName);
        newVal.description = "Kerberos service name. The default (exasol) is used if neither database user nor password are specified in the connection string.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("kerberoshostname", "");
        newVal.description = "Kerberos host name. If not specified, the default kerberos host name will be the same as the one the driver is connecting to the database server.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("kerberosusername", System.getProperty("user.name", ""));
        newVal.description = "Kerberos user name. The default is the name of the OS user running the application.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("kerberosrealm", "");
        newVal.description = "Kerberos REALM name.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("kerberosconfig", "");
        newVal.description = "Kerberos config file (krb5.conf).";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("logintype", String.valueOf(0));
        newVal.description = "Kerberos login type: 0=not specified, 1=use SSPI, 2=use GSSAPI.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("connectionPoolSize", String.valueOf(64));
        newVal.description = "Size of the connection pool if any is used.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("metadataSQL", "0");
        newVal.description = "Data for DatabaseMetaData results will be read using SQL from the server.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("user", null);
        newVal.description = "Database user name.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("password", null);
        newVal.description = "Database users password.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("authmethod", null);
        newVal.description = "Authentication method (accesstoken or refreshtoken), used for OpenID authentication.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("validateservercertificate", "1");
        newVal.description = "Can be used to disable server certificate validation in ssl connections.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("legacyencryption", "0");
        newVal.description = "Enables usage of deprecated ChaCha encryption instead of ssl in the client-server communication.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("socketfactory", null);
        newVal.description = "A custom socket factory.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("enablenumerictypeconversion", "1");
        newVal.description = "Decimal columns in result sets are shown as int types if this is possible.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("socketfactoryarg", null);
        newVal.description = "Parameter for the constructor of the custom socket factory.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("worker", "0");
        newVal.description = "Used in parallel connections, specifies if this connection is a worker connection.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("workertoken", "0");
        newVal.description = "Used in parallel connections to give a recognition token to the worker connection.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("keystoretype", null);
        newVal.description = "Keystore Type.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("keystore", null);
        newVal.description = "Keystore Path File Location.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("keystorepassword", null);
        newVal.description = "Keystore Password.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("onconnect", null);
        newVal.description = "SQL to execute right after the connection is established.";
        newVal.required = false;
        resultProps.add(newVal);
        newVal = new DriverPropertyInfo("sessionid", null);
        newVal.description = "Main Session ID";
        newVal.required = false;
        resultProps.add(newVal);
        resultProps.sort(new Comparator(){

            public int compare(Object synchronizedListOne, Object synchronizedListTwo) {
                return ((DriverPropertyInfo)synchronizedListOne).name.compareTo(((DriverPropertyInfo)synchronizedListTwo).name);
            }
        });
        DriverPropertyInfo[] result = resultProps.toArray(new DriverPropertyInfo[resultProps.size()]);
        return result;
    }

    protected synchronized void setAttributes(ProtocolAttribute[] attribs) throws IOException, SQLException {
        this.log("setAttributes(), setting " + attribs.length + " attributes.");
        this.CheckDisconnected();
        this.tmpOutMessage = new OutMessage(this.debug, (EXAConnection)this);
        this.tmpOutMessage.getHeader().setMode((byte)35);
        for (int i = 0; i < attribs.length; ++i) {
            this.tmpOutMessage.getHeader().addAttribute(attribs[i]);
        }
        this.tmpInMessage = this.communication(this.tmpOutMessage);
        this.checkResults(this.tmpInMessage);
    }

    protected synchronized void getAttributes() throws SQLException, IOException {
        this.log("getAttributes()");
        this.CheckDisconnected();
        byte[] res = this.communication(null, 0, (byte)34, new ExecutionStatus(), null);
        this.log("getAttributes() numeric_characters=" + this.numericCharacters);
    }

    public synchronized byte[] exchangeTicket(byte[] ticket) throws SQLException {
        this.log("exchangeTicket(nBytes=" + ticket.length + ")");
        this.CheckDisconnected();
        ProtocolAttribute attr = new ProtocolAttribute(ProtocolAttribute.ATTR_KERBEROS_TICKET.id);
        attr.value = ticket;
        ProtocolAttribute[] attribs = new ProtocolAttribute[]{attr};
        try {
            this.setAttributes(attribs);
            return this.kerberosToken;
        }
        catch (IOException e) {
            this.log("exchangeTicket(): caught exception: " + e);
            throw new ConnectionLost(e.getMessage(), 0L);
        }
    }

    protected void reconnect() throws SQLException {
        this.log("reconnect()");
        this.CheckDisconnected();
        this.closeAbort(false);
        if (this.reconnectCount++ < 1) {
            try {
                Thread.sleep(600L);
            }
            catch (InterruptedException e1) {
                throw new SQLException(e1.toString());
            }
            try {
                this.setupConnection(true, null);
            }
            catch (ConnectionException e) {
                if (e instanceof ConnectionLost) {
                    this.log("ConnectionLost exception: " + e);
                    this.closeSocket();
                    throw e;
                }
                this.log("Exception: " + e);
                this.closeSocket();
                throw new ConnectFailed(Translator.Connection_was_lost_and_could_not_be_reestablished() + " (SessionID: " + this.getSessionID() + ")");
            }
        }
        this.closeSocket();
        throw new ConnectFailed(Translator.Connection_was_lost_and_could_not_be_reestablished() + " (SessionID: " + this.getSessionID() + ")");
        this.reconnectCount = 0;
    }

    protected static int getProtocolVersion() {
        return defaultDriverProtocollVersion;
    }

    void updateSessionAttributes(Vector attribs) throws SQLException {
        for (int i = 0; i < attribs.size(); ++i) {
            ProtocolAttribute inAttr = (ProtocolAttribute)attribs.elementAt(i);
            if (inAttr.id == ProtocolAttribute.ATTR_SESSIONID.id) {
                this.sessionID = (Long)inAttr.value;
                this.log("Session id received: " + inAttr.value);
                continue;
            }
            if (inAttr.id == ProtocolAttribute.ATTR_CURRENT_SCHEMA.id) {
                if (inAttr.value != null) {
                    this.changeCurrentSchema(inAttr.value.toString());
                    this.log("Current schema: " + inAttr.value.toString());
                    continue;
                }
                this.changeCurrentSchema(null);
                this.log("Current schema: <none>");
                continue;
            }
            if (inAttr.id == ProtocolAttribute.ATTR_CURRENT_CATALOG.id) {
                if (inAttr.value != null) {
                    this.currentCatalog = inAttr.value.toString();
                    this.log("Current catalog: " + inAttr.value);
                    continue;
                }
                this.currentCatalog = null;
                this.log("Current catalog: <none>");
                continue;
            }
            if (inAttr.id == ProtocolAttribute.ATTR_PROTOCOL_VERSION.id) {
                this.activeProtocolVersion = (Integer)inAttr.value;
                this.log("Protocol version: " + inAttr.value);
                continue;
            }
            if (inAttr.id == ProtocolAttribute.ATTR_DATA_MESSAGE_SIZE.id) {
                this.maxMessageSize = (Long)inAttr.value;
                this.log("maxDataMessageSize: " + inAttr.value);
                continue;
            }
            if (inAttr.id == ProtocolAttribute.ATTR_DATE_FORMAT.id) {
                this.dateFormat = inAttr.value != null ? inAttr.value.toString() : "YYYY-MM-DD";
                this.log("NLS date format: " + inAttr.value);
                continue;
            }
            if (inAttr.id == ProtocolAttribute.ATTR_DATETIME_FORMAT.id) {
                this.timestampFormat = inAttr.value != null ? inAttr.value.toString() : "YYYY-MM-DD HH:MI:SS.FF3";
                char lastc = this.timestampFormat.toCharArray()[this.timestampFormat.length() - 1];
                this.timestampPrecision = lastc <= '0' || lastc > '9' ? 0 : lastc - 48;
                this.log("NLS timestamp format: " + this.timestampFormat);
                continue;
            }
            if (inAttr.id == ProtocolAttribute.ATTR_DATE_LANGUAGE.id) {
                this.dateLanguage = inAttr.value != null ? inAttr.value.toString() : "german";
                this.log("NLS date language: " + inAttr.value);
                continue;
            }
            if (inAttr.id == ProtocolAttribute.ATTR_NUMERIC_CHARACTERS.id) {
                this.numericCharacters = inAttr.value != null ? inAttr.value.toString() : ".,";
                this.log("Numeric characters: " + inAttr.value);
                continue;
            }
            if (inAttr.id == ProtocolAttribute.ATTR_PUBLIC_KEY.id) {
                this.publicKey = (byte[])inAttr.value;
                this.log("Public Key: " + inAttr.value);
                continue;
            }
            if (inAttr.id == ProtocolAttribute.ATTR_RANDOM_PHRASE.id) {
                this.randomPhrase = (byte[])inAttr.value;
                this.log("Random phrase: " + inAttr.value);
                continue;
            }
            if (inAttr.id == ProtocolAttribute.ATTR_DB_NAME.id) {
                this.databaseName = inAttr.value.toString();
                this.log("Database Name: " + inAttr.value);
                continue;
            }
            if (inAttr.id == ProtocolAttribute.ATTR_PRODUCT_NAME.id) {
                this.databaseProductName = inAttr.value.toString();
                this.log("Database Product Name: " + inAttr.value);
                continue;
            }
            if (inAttr.id == ProtocolAttribute.ATTR_RELEASE_VERSION.id) {
                this.databaseProductVersion = inAttr.value.toString();
                this.log("Database Product Version: " + inAttr.value);
                continue;
            }
            if (inAttr.id == ProtocolAttribute.ATTR_QUERY_CACHE_ACCESS.id) {
                this.log("Query cache access: " + inAttr.value);
                continue;
            }
            if (inAttr.id == ProtocolAttribute.ATTR_ENCRYPTION_REQUIRED.id) {
                this.encryptionRequiredByServer = (Boolean)inAttr.value;
                this.log("Encryption required: " + inAttr.value);
                if (!this.encryptionRequiredByServer || this.encryptionEnabled) continue;
                throw new ConnectRefused("Illegal encryption settings: server requires encryption but the user has turned encryption off. ");
            }
            if (inAttr.id == ProtocolAttribute.ATTR_FEEDBACK_INTERVAL.id) {
                this.feedbackInterval = (Integer)inAttr.value;
                this.log("Feedback interval: " + inAttr.value);
                continue;
            }
            if (inAttr.id == ProtocolAttribute.ATTR_SNAPSHOT_TRANSACTIONS_ENABLED.id) {
                this.snapshotTransactions = (Boolean)inAttr.value;
                this.log("Snapshot transactions enabled: " + inAttr.value);
                continue;
            }
            if (inAttr.id == ProtocolAttribute.ATTR_KERBEROS_TOKEN.id) {
                this.kerberosToken = (byte[])inAttr.value;
                this.log("kerberosToken recieved, bytes: " + this.kerberosToken.length);
                continue;
            }
            if (inAttr.id != ProtocolAttribute.ATTR_MAX_IDENTIFIER_LENGTH.id) continue;
            this.maxIdentifierLen = (Integer)inAttr.value;
            this.log("Max identifier len: " + this.maxIdentifierLen);
        }
    }

    public int getActiveProtocolVersion() {
        return this.activeProtocolVersion;
    }

    public String getCurrentSchema() throws SQLException {
        return this.currentSchema;
    }

    protected void changeCurrentSchema(String schema) {
        String oldSchema = this.currentSchema;
        this.currentSchema = schema;
        this.fireSchemaChanged(oldSchema, this.currentSchema);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public int getTimestampPrecision() {
        return this.timestampPrecision;
    }

    public String getDateLanguage() {
        return this.dateLanguage;
    }

    public String getNumericCharacters() {
        return this.numericCharacters;
    }

    protected static int getDateFormatWidth(String s) {
        if (s == null) {
            return 10;
        }
        return s.length();
    }

    protected static int getTimestampFormatWidth(String s) {
        if (s == null) {
            return "YYYY-MM-DD HH:MI:SS.123456789".length();
        }
        char[] ch = s.toCharArray();
        int len = ch.length;
        int f = 0;
        if (ch[len - 1] >= '0' && ch[len - 1] <= '9') {
            f = ch[len - 1] - 48;
            len = len - 3 + f;
        } else if (s.endsWith(".FF")) {
            len -= 3;
        }
        if (s.contains("HH24") || s.contains("HH12")) {
            len -= 2;
        }
        return len;
    }

    public long getSessionID() {
        return this.sessionID;
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected String GetDatabaseName() {
        return this.databaseName;
    }

    protected String GetDatabaseProductName() {
        return this.databaseProductName;
    }

    protected String GetDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    private boolean MustUseLegacyEncryption() {
        String dbVersion = this.GetDatabaseProductVersion();
        if (dbVersion.startsWith("6.2")) {
            String db62 = dbVersion.substring(0, 5);
            if (dbVersion.length() > 5) {
                db62 = dbVersion.substring(0, 6);
            }
            switch (db62) {
                case "6.2.0": 
                case "6.2.1": 
                case "6.2.2": 
                case "6.2.3": 
                case "6.2.4": 
                case "6.2.5": 
                case "6.2.6": 
                case "6.2.7": 
                case "6.2.8": 
                case "6.2.9": 
                case "6.2.10": 
                case "6.2.11": 
                case "6.2.12": 
                case "6.2.13": 
                case "6.2.14": {
                    return true;
                }
            }
        } else if (dbVersion.startsWith("7.0")) {
            String db70 = dbVersion.substring(0, 5);
            if (dbVersion.length() > 5) {
                db70 = dbVersion.substring(0, 6);
            }
            switch (db70) {
                case "7.0.0": 
                case "7.0.1": 
                case "7.0.2": 
                case "7.0.3": 
                case "7.0.4": 
                case "7.0.5": 
                case "7.0.6": 
                case "7.0.7": 
                case "7.0.8": 
                case "7.0.9": {
                    return true;
                }
            }
        }
        return false;
    }

    public void listCertificates(KeyStore _keystore) {
        if (_keystore != null) {
            this.log("Listing available certificates from the Keystore");
        } else {
            this.log("Listing available certificates from the default Keystore");
        }
        TrustManagerFactory trustManagerFactory = null;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(_keystore);
            X509TrustManager certificateValidator = (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
            for (X509Certificate cert : certificateValidator.getAcceptedIssuers()) {
                Map<String, String> certData = this.certificateData(cert);
                String certficateInfo = "Certificate: ";
                certficateInfo = certData.containsKey("CN") ? certficateInfo + certData.get("CN") : certficateInfo + certData.values().toArray()[1];
                certficateInfo = certficateInfo + " | " + certData.get("Validity") + " | " + certData.get("Valid Until: ");
                this.log(certficateInfo);
            }
        }
        catch (KeyStoreException | NoSuchAlgorithmException ex) {
            this.log("[Error] Certificate Listing Error. " + ex.getLocalizedMessage());
        }
    }

    private Map<String, String> certificateData(X509Certificate cert) {
        String[] issuer;
        LinkedHashMap<String, String> certData = new LinkedHashMap<String, String>();
        certData.put("Subject", cert.getSubjectDN().toString());
        for (String name : issuer = cert.getSubjectDN().getName().split(", ")) {
            String[] parts = name.split("=");
            if (parts.length <= 1) continue;
            certData.put(parts[0], parts[1]);
        }
        Date currentDate = new Date();
        certData.put("Valid From: ", cert.getNotBefore().toString());
        certData.put("Valid Until: ", cert.getNotAfter().toString());
        if (cert.getNotAfter().after(currentDate) && cert.getNotBefore().before(currentDate)) {
            certData.put("Validity", "VALID");
        } else if (cert.getNotAfter().before(currentDate)) {
            certData.put("Validity", "EXPIRED");
        } else if (cert.getNotBefore().after(currentDate)) {
            certData.put("Validity", "VALID FROM " + cert.getNotBefore().toString());
        } else {
            certData.put("Validity", "INVALID");
        }
        return certData;
    }

    private KeyStore loadKeystore(String keyStoreType, String keyStore, String keyStorePassword) throws KeyStoreException {
        KeyStore KS = null;
        String defaultKeystoreType = KeyStore.getDefaultType();
        String errorMsg = "[ERROR] Keystore Error: ";
        if (keyStorePassword == null) {
            throw new KeyStoreException(errorMsg + "Keystore password is empty.");
        }
        try {
            if (keyStoreType != null) {
                KS = KeyStore.getInstance(keyStoreType);
            } else {
                this.log("Using Default Keystore Type: " + defaultKeystoreType);
                KS = KeyStore.getInstance(defaultKeystoreType);
            }
            KS.load(new FileInputStream(keyStore), keyStorePassword.toCharArray());
            return KS;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new KeyStoreException(errorMsg + ex.getLocalizedMessage());
        }
        catch (KeyStoreException ex) {
            throw new KeyStoreException(errorMsg + ex.getLocalizedMessage());
        }
        catch (FileNotFoundException ex) {
            throw new KeyStoreException(errorMsg + ex.getLocalizedMessage());
        }
        catch (CertificateException ex) {
            throw new KeyStoreException(errorMsg + ex.getLocalizedMessage());
        }
        catch (IOException ex) {
            throw new KeyStoreException(errorMsg + ex.getLocalizedMessage());
        }
    }

    public class AbortCommand
    implements Runnable {
        @Override
        public void run() {
            AbstractEXAConnection.this.abort();
        }
    }

    private class EXASocketFactoryInstance
    extends EXASocketFactory {
        private EXASocketFactoryInstance() {
        }

        @Override
        public Socket createCustomSocket(InetAddress host, int port, int timeout) {
            return null;
        }
    }

    private class CommOp
    implements RecoverableOperation {
        protected Header header = null;
        protected byte[] outBytes = null;
        protected byte[] inBytes = null;
        protected int responseTimeout = 0;
        ExecutionStatus execStatus = null;

        protected CommOp() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void op() throws IOException, SQLException {
            if (this.header != null) {
                this.header.write_to(AbstractEXAConnection.this.to_database);
            }
            if (this.outBytes != null) {
                AbstractEXAConnection.this.to_database.write(this.outBytes, 0, this.outBytes.length);
            }
            AbstractEXAConnection.this.to_database.flush();
            boolean gotResponse = false;
            Header readHeader = new Header(this.header);
            try {
                while (!gotResponse) {
                    if (null != this.execStatus && this.execStatus.mustCancel()) {
                        this.inBytes = null;
                        return;
                    }
                    ((EncryptedInputStream)AbstractEXAConnection.this.from_database).SetMemoryStream(readHeader.read_from(AbstractEXAConnection.this.from_database, this.execStatus, this.responseTimeout));
                    AbstractEXAConnection.this.updateSessionAttributes(readHeader.getAttributes());
                    this.inBytes = AbstractEXAConnection.this.readMessageBody(readHeader);
                    if (AbstractEXAConnection.this.getActiveProtocolVersion() <= 8) {
                        gotResponse = true;
                        continue;
                    }
                    if (null != this.inBytes && 5 == this.inBytes[0] && !AbstractEXAConnection.this.commandWasEnterParallel) {
                        byte[] msgBytes = new byte[this.inBytes.length - 5];
                        System.arraycopy(this.inBytes, 5, msgBytes, 0, msgBytes.length);
                        String statusMessage = null;
                        try {
                            statusMessage = new String(msgBytes, StandardCharsets.UTF_8);
                            if (statusMessage.length() > 0) {
                                this.execStatus.connection.clientLogExternal(statusMessage);
                            }
                            if (statusMessage.toUpperCase(Locale.ENGLISH).contains("<status>EXECUTING</status>".toUpperCase())) {
                                AbstractEXAConnection.this.connectionStatus = "EXECUTING";
                            }
                            if (statusMessage.toUpperCase(Locale.ENGLISH).contains("<status>QUEUED</status>".toUpperCase())) {
                                AbstractEXAConnection.this.connectionStatus = "QUEUED";
                            }
                            if (!AbstractEXAConnection.this.connectionStatus.equals("QUEUED") || !this.execStatus.isCanceled()) continue;
                            this.inBytes = null;
                            AbstractEXAConnection.this.closeAbort(false);
                            return;
                        }
                        catch (Exception ex) {
                            statusMessage = "UNKNOWN";
                        }
                        continue;
                    }
                    if (null != this.inBytes && 5 == this.inBytes[0] && !AbstractEXAConnection.this.commandWasEnterParallel) continue;
                    gotResponse = true;
                }
            }
            finally {
                this.header.setSerialNumber(readHeader.getSerialNumber());
            }
            this.header = readHeader;
        }
    }

    private static final class ConnectionStatus {
        public static final String EXECUTING = "EXECUTING";
        public static final String QUEUED = "QUEUED";
        public static final String UNKNOWN = "UNKNOWN";

        private ConnectionStatus() {
        }
    }
}

