/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.Column;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.Translator;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.text.DecimalFormat;

class DecimalColumn
extends Column {
    long[] values;
    long factor;
    DecimalFormat formatter;
    protected boolean enableNumericTypeConversion = true;

    void setEnableNumericTypeConversion(boolean entc) {
        this.enableNumericTypeConversion = entc;
    }

    DecimalColumn(String name_, long[] values_, int p, int s) {
        super(name_);
        this.values = values_;
        this.precision = p;
        this.scale = s;
        this.formatter = new DecimalFormat(this.repeat('#', this.precision - 1 - this.scale) + "0" + (this.scale > 0 ? "." : "") + this.repeat('0', this.scale));
        this.compFactor();
    }

    DecimalColumn(int p, int s) {
        this.values = new long[initialBatchCapacity];
        this.precision = p;
        this.scale = s;
        this.formatter = new DecimalFormat(this.repeat('#', this.precision - 1 - this.scale) + "0" + (this.scale > 0 ? "." : "") + this.repeat('0', this.scale));
        this.compFactor();
    }

    String repeat(char ch, int count) {
        StringBuffer buf = new StringBuffer();
        for (int t = 0; t < count; ++t) {
            buf.append(ch);
        }
        return buf.toString();
    }

    void compFactor() {
        this.factor = 1L;
        for (int i = 0; i < this.scale; ++i) {
            this.factor *= 10L;
        }
    }

    @Override
    String getClassName() {
        if (0 == this.scale && this.enableNumericTypeConversion) {
            if (this.precision <= 4) {
                return "java.lang.Short";
            }
            if (this.precision <= 9) {
                return "java.lang.Integer";
            }
            if (this.precision <= 18) {
                return "java.lang.Long";
            }
        }
        return "java.math.BigDecimal";
    }

    @Override
    int getDisplaySize() {
        return this.precision + 2;
    }

    @Override
    int getType() {
        if (0 == this.scale && this.enableNumericTypeConversion) {
            if (this.precision <= 4) {
                return 5;
            }
            if (this.precision <= 9) {
                return 4;
            }
            if (this.precision <= 18) {
                return -5;
            }
        }
        return 3;
    }

    @Override
    String getTypeName() {
        if (0 == this.scale && this.enableNumericTypeConversion) {
            if (this.precision <= 4) {
                return "SMALLINT";
            }
            if (this.precision <= 9) {
                return "INTEGER";
            }
            if (this.precision <= 18) {
                return "BIGINT";
            }
        }
        return "DECIMAL";
    }

    @Override
    void setString(int pos, String v) {
        this.validMask[pos] = true;
        this.values[pos] = Long.parseLong(v) * this.factor;
    }

    @Override
    void setByte(int pos, byte v) {
        this.validMask[pos] = true;
        this.values[pos] = (long)v * this.factor;
    }

    @Override
    void setShort(int pos, short v) {
        this.validMask[pos] = true;
        this.values[pos] = (long)v * this.factor;
    }

    @Override
    void setInt(int pos, int v) {
        this.validMask[pos] = true;
        this.values[pos] = (long)v * this.factor;
    }

    @Override
    void setLong(int pos, long v) {
        this.validMask[pos] = true;
        this.values[pos] = v * this.factor;
    }

    @Override
    Object getObject(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("DecimalColumn::getObject: " + Translator.Accessed_null_value());
        }
        switch (this.getType()) {
            case 5: {
                return this.getShort(row);
            }
            case 4: {
                return this.getInt(row);
            }
            case -5: {
                return this.getLong(row);
            }
        }
        return BigDecimal.valueOf(this.values[row], this.scale);
    }

    @Override
    String getString(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("DecimalColumn::getString: " + Translator.Accessed_null_value());
        }
        return this.formatter.format(BigDecimal.valueOf(this.values[row], this.scale));
    }

    @Override
    boolean getBoolean(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("DecimalColumn::getByte: " + Translator.Accessed_null_value());
        }
        long v = this.values[row] / this.factor;
        if (v == 0L) {
            return false;
        }
        if (v == 1L) {
            return true;
        }
        throw new SQLException("DecimalColumn::getBoolean: " + Translator.Conversion_not_possible());
    }

    @Override
    byte getByte(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("DecimalColumn::getByte: " + Translator.Accessed_null_value());
        }
        long v = this.values[row] / this.factor;
        if ((long)((byte)v) != v) {
            throw new SQLDataException(Translator.numeric_value_out_of_range(), new String("22003"));
        }
        return (byte)v;
    }

    @Override
    short getShort(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("DecimalColumn::getShort: " + Translator.Accessed_null_value());
        }
        long v = this.values[row] / this.factor;
        if ((long)((short)v) != v) {
            throw new SQLDataException(Translator.numeric_value_out_of_range(), new String("22003"));
        }
        return (short)v;
    }

    @Override
    int getInt(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("DecimalColumn::getInt: " + Translator.Accessed_null_value());
        }
        long v = this.values[row] / this.factor;
        if ((long)((int)v) != v) {
            throw new SQLDataException(Translator.numeric_value_out_of_range(), new String("22003"));
        }
        return (int)v;
    }

    @Override
    double getDouble(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("DecimalColumn::getDouble: " + Translator.Accessed_null_value());
        }
        return (double)this.values[row] / (double)this.factor;
    }

    @Override
    float getFloat(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("DecimalColumn::getFloat: " + Translator.Accessed_null_value());
        }
        return (float)this.values[row] / (float)this.factor;
    }

    @Override
    long getLong(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("DecimalColumn::getLong: " + Translator.Accessed_null_value());
        }
        return this.values[row] / this.factor;
    }

    @Override
    BigDecimal getBigDecimal(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("DecimalColumn::getBigDecimal: " + Translator.Accessed_null_value());
        }
        return BigDecimal.valueOf(this.values[row], this.scale);
    }

    @Override
    void resize(int size) {
        long[] nv = new long[size];
        boolean[] vm = new boolean[size];
        int s = this.values.length;
        if (s > size) {
            s = size;
        }
        for (int i = 0; i < s; ++i) {
            vm[i] = this.validMask[i];
            nv[i] = this.values[i];
        }
        for (int j = s; j < size; ++j) {
            vm[j] = false;
        }
        this.validMask = vm;
        this.values = nv;
    }

    static Column from_jdbc_type(EXAInputStream is) throws IOException {
        int p = is.readInt();
        int s = is.readInt();
        return new DecimalColumn(p, s);
    }

    @Override
    long value_to_jdbc(EXAOutputStream os, int row) throws IOException {
        if (this.validMask[row]) {
            os.writeByte((byte)1);
            os.writeLong(this.values[row]);
            return 9L;
        }
        os.writeByte((byte)0);
        return 1L;
    }

    @Override
    void value_from_jdbc(EXAInputStream is, int row) throws IOException {
        if (is.nextIsNull()) {
            this.validMask[row] = false;
        } else {
            this.validMask[row] = true;
            this.values[row] = is.readLong();
        }
    }

    @Override
    int getEXAType() {
        return 6;
    }

    @Override
    boolean isSigned() {
        return true;
    }
}

