/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.Column;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.Translator;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.text.DecimalFormat;

class DoubleColumn
extends Column {
    double[] values;
    DecimalFormat formatter1a;
    DecimalFormat formatter1b;
    DecimalFormat formatter2;
    DecimalFormat expFormat = (DecimalFormat)DecimalFormat.getInstance();

    DoubleColumn(String name_, double[] values_) {
        super(name_);
        this.values = values_;
        this.formatter1a = new DecimalFormat("##############0.##");
        this.formatter1b = new DecimalFormat("#####0.##########");
        this.formatter2 = new DecimalFormat("0.00000000E000");
        this.expFormat.applyPattern("+000;-000");
    }

    DoubleColumn() {
        this.values = new double[initialBatchCapacity];
        this.formatter1a = new DecimalFormat("##############0.##");
        this.formatter1b = new DecimalFormat("#####0.##########");
        this.formatter2 = new DecimalFormat("0.00000000E000");
        this.expFormat.applyPattern("+000;-000");
    }

    @Override
    String getClassName() {
        return "java.lang.Double";
    }

    @Override
    int getDisplaySize() {
        return 16;
    }

    @Override
    int getType() {
        return 8;
    }

    @Override
    String getTypeName() {
        return "DOUBLE PRECISION";
    }

    @Override
    Object getObject(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("DoubleColumn::getObject: " + Translator.Accessed_null_value());
        }
        return this.values[row];
    }

    private String reformatExp(String numText) {
        int index = numText.lastIndexOf(69);
        if (index >= 0) {
            try {
                StringBuffer output = new StringBuffer();
                Integer exp = Integer.valueOf(numText.substring(index + 1));
                output.append(numText, 0, index + 1);
                output.append(this.expFormat.format(exp));
                return output.toString();
            }
            catch (Exception e) {
                return numText;
            }
        }
        return numText;
    }

    static final double abs(double v) {
        if (v < 0.0) {
            return -v;
        }
        return v;
    }

    @Override
    String getString(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("DoubleColumn::getString: " + Translator.Accessed_null_value());
        }
        double absolut = DoubleColumn.abs(this.values[row]);
        if (absolut > 0.0 && absolut <= 1.0E-10) {
            return this.reformatExp(this.formatter2.format(this.values[row]));
        }
        if (absolut < 10000.0) {
            return this.formatter1b.format(this.values[row]);
        }
        if (absolut < 1.0E15) {
            return this.formatter1a.format(this.values[row]);
        }
        return this.reformatExp(this.formatter2.format(this.values[row]));
    }

    @Override
    byte getByte(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("DoubleColumn::getByte: " + Translator.Accessed_null_value());
        }
        double v = this.values[row];
        if (v < -128.0 || v > 127.0) {
            throw new SQLDataException(Translator.numeric_value_out_of_range(), "003");
        }
        return (byte)v;
    }

    @Override
    short getShort(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("DoubleColumn::getShort: " + Translator.Accessed_null_value());
        }
        double v = this.values[row];
        if (v < -32768.0 || v > 32767.0) {
            throw new SQLDataException(Translator.numeric_value_out_of_range(), "003");
        }
        return (short)v;
    }

    @Override
    int getInt(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("DoubleColumn::getInt: " + Translator.Accessed_null_value());
        }
        double v = this.values[row];
        if (v < -2.147483648E9 || v > 2.147483647E9) {
            throw new SQLDataException(Translator.numeric_value_out_of_range(), "003");
        }
        return (int)this.values[row];
    }

    @Override
    long getLong(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("DoubleColumn::getLong: " + Translator.Accessed_null_value());
        }
        double v = this.values[row];
        if (v < -9.223372036854776E18 || v > 9.223372036854776E18) {
            throw new SQLDataException(Translator.numeric_value_out_of_range(), "003");
        }
        return (long)this.values[row];
    }

    @Override
    double getDouble(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("DoubleColumn::getDouble: " + Translator.Accessed_null_value());
        }
        return this.values[row];
    }

    @Override
    float getFloat(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("DoubleColumn::getFloat: " + Translator.Accessed_null_value());
        }
        return (float)this.values[row];
    }

    @Override
    BigDecimal getBigDecimal(int row) throws SQLException {
        if (!this.validMask[row]) {
            throw new SQLException("DoubleColumn::getBigDecimal: " + Translator.Accessed_null_value());
        }
        return new BigDecimal(this.values[row]);
    }

    @Override
    void setString(int pos, String v) {
        this.validMask[pos] = true;
        this.values[pos] = Double.parseDouble(v);
    }

    @Override
    void setByte(int pos, byte v) {
        this.validMask[pos] = true;
        this.values[pos] = v;
    }

    @Override
    void setDouble(int pos, double d) {
        this.validMask[pos] = true;
        this.values[pos] = d;
    }

    @Override
    void setFloat(int pos, float f) {
        this.validMask[pos] = true;
        this.values[pos] = f;
    }

    @Override
    void setShort(int pos, short v) {
        this.validMask[pos] = true;
        this.values[pos] = v;
    }

    @Override
    void setInt(int pos, int v) {
        this.validMask[pos] = true;
        this.values[pos] = v;
    }

    @Override
    void setLong(int pos, long v) {
        this.validMask[pos] = true;
        this.values[pos] = v;
    }

    @Override
    void resize(int size) {
        double[] nv = new double[size];
        boolean[] vm = new boolean[size];
        int s = this.values.length;
        if (s > size) {
            s = size;
        }
        for (int i = 0; i < s; ++i) {
            nv[i] = this.values[i];
            vm[i] = this.validMask[i];
        }
        for (int j = s; j < size; ++j) {
            vm[j] = false;
        }
        this.values = nv;
        this.validMask = vm;
    }

    static Column from_jdbc_type(EXAInputStream is) {
        return new DoubleColumn();
    }

    @Override
    long value_to_jdbc(EXAOutputStream os, int row) throws IOException {
        if (this.validMask[row]) {
            os.writeByte((byte)1);
            os.writeDouble(this.values[row]);
            return 9L;
        }
        os.writeByte((byte)0);
        return 1L;
    }

    @Override
    void value_from_jdbc(EXAInputStream is, int row) throws IOException {
        if (is.nextIsNull()) {
            this.validMask[row] = false;
        } else {
            this.validMask[row] = true;
            this.values[row] = is.readDouble();
        }
    }

    @Override
    int getEXAType() {
        return 8;
    }

    @Override
    boolean isSigned() {
        return true;
    }
}

