/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.CharColumn;
import com.exasol.jdbc.Column;
import com.exasol.jdbc.ConnectionException;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.DecimalColumn;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXADriver;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.EXAResult;
import com.exasol.jdbc.EXAResultSet;
import com.exasol.jdbc.EXASQLException;
import com.exasol.jdbc.EXAStatement;
import com.exasol.jdbc.ExecutionStatus;
import com.exasol.jdbc.NotImplemented;
import com.exasol.jdbc.ServerCommunication;
import com.exasol.jdbc.TextUtil;
import com.exasol.jdbc.Translator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Vector;

public class EXADatabaseMetaData
extends ServerCommunication
implements DatabaseMetaData {
    private static final String DB_METADATA = "DB_METADATA";
    private static final String ALL_TABLES = "ALL_TABLES";
    private static final String ALL_PROCEDURES = "ALL_PROCEDURES";
    private static final String TABLE_PRIVILEGES = "TABLE_PRIVILEGES";
    private static final String PROCEDURE_COLUMNS = "PROCEDURE_COLUMNS";
    private static final String FOREIGN_KEYS = "FOREIGN_KEYS";
    private static final String PRIMARY_KEYS = "PRIMARY_KEYS";
    private static final String ALL_COLUMNS = "ALL_COLUMNS";
    private static final String ALL_SCHEMAS = "ALL_SCHEMAS";
    private static final String ALL_CATALOGS = "ALL_CATALOGS";
    private static final String COLUMN_PRIVILEGES = "COLUMN_PRIVILEGES";
    private static final String ALL_INDICES = "ALL_INDICES";
    private static final String SNAPSHOT_EXECUTION = "/*snapshot execution*/ ";
    private String TRANSFERLINKS = "EXA_TRANSFER_LINKS";
    private static final String METADATA_SCHEMA = "\"$ODBCJDBC\"";
    private static final String[] tableTypes = new String[]{"TABLE", "VIEW", "SYSTEM_TABLE"};
    private HashMap staticProps = null;
    private Statement metaStmt;
    private Vector sqlCommands;
    private Vector plsqlCommands;
    private String databaseName;
    private String databaseProductVersion;
    private int databaseProductVersionInt;
    private int databaseSVNRevision;
    private String databaseProductName;
    private int metadataSQL = 0;

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    EXADatabaseMetaData(EXAConnection connection_, DebugLog debug_) throws SQLException {
        super(debug_, "EXADatabaseMetadata", connection_);
        this.log("createStatement to get metadata");
        this.metaStmt = this.connection.createStatement();
        try {
            this.metadataSQL = Integer.parseInt(this.connection.getParameter("metadataSQL"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.metadataSQL != 0) {
            this.metadataSQL = 1;
        }
        this.databaseProductName = this.connection.GetDatabaseProductName();
        this.databaseName = this.connection.GetDatabaseName();
        this.databaseProductVersion = this.connection.GetDatabaseProductVersion();
    }

    private String getProp(String name) throws SQLException {
        String value = null;
        if (this.connection.getActiveProtocolVersion() < 14 || 0 != this.metadataSQL) {
            StringBuffer str = new StringBuffer("/*snapshot execution*/ select \"VALUE\" from ");
            str.append(METADATA_SCHEMA);
            str.append(".");
            str.append(DB_METADATA);
            str.append(" where \"NAME\"='");
            str.append(name);
            str.append("'");
            if (this.metaStmt.execute(str.toString())) {
                ResultSet rs = this.metaStmt.getResultSet();
                rs.first();
                if (!rs.isAfterLast()) {
                    value = rs.getString(1);
                    if (null == value) {
                        value = "";
                    }
                } else {
                    this.log("Failed to retrieve DB metainfo \"" + name + "\"");
                }
            }
        } else {
            ExecutionStatus execStatus = new ExecutionStatus();
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            EXAOutputStream os = new EXAOutputStream(bas, this.connection);
            try {
                if (null == name) {
                    os.writeInt(-1);
                } else {
                    os.writeInt(name.getBytes(this.connection.getEncoding()).length);
                    os.write(name.getBytes(this.connection.getEncoding()));
                }
                os.writeInt(-1);
                os.writeInt(-1);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new SQLException(e.getMessage());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new SQLException(e.getMessage());
            }
            EXAResult[] results = this.connection.communication_resultset(bas.toByteArray(), (byte)122, execStatus, null);
            this.connection.metadataAcquired();
            if (results != null && results.length > 0) {
                if (results[0] instanceof EXASQLException) {
                    throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
                }
                EXAResultSet rs = (EXAResultSet)results[0];
                if (0L >= rs.getNumberOfRows()) {
                    throw new SQLException("Property not found: " + name, "HY000", -1);
                }
                rs.first();
                if (!rs.isAfterLast()) {
                    value = rs.getString(1);
                    if (null == value) {
                        value = "";
                    }
                } else {
                    this.log("Failed to retrieve DB metainfo \"" + name + "\"");
                }
            } else {
                return null;
            }
        }
        return value;
    }

    private boolean getPropBoolean(String name, boolean defaultValue) throws SQLException {
        boolean result = false;
        String value = null;
        if (this.staticProps == null) {
            this.log("getPropBoolean: Need metadata.");
            this.initializeMetadata();
            this.log("Metadata initialized.");
        }
        if ((value = (String)this.staticProps.get(name)) == null) {
            value = this.getProp(name);
        } else {
            this.log("Returning cached DB metainfo " + name + "=" + value);
        }
        if (value == null) {
            result = defaultValue;
            this.log("Returning defaultvalue for DB metainfo " + name + "=" + result);
        } else {
            result = "1".equals(value);
        }
        return result;
    }

    private String getPropString(String name, String defaultValue) throws SQLException {
        String value = null;
        if (this.staticProps == null) {
            this.log("getPropString: Need metadata.");
            this.initializeMetadata();
            this.log("Metadata initialized.");
        }
        if ((value = (String)this.staticProps.get(name)) == null) {
            value = this.getProp(name);
        } else {
            this.log("Returning cached DB metainfo " + name + "=" + value);
        }
        if (value == null) {
            value = defaultValue;
            this.log("Returning defaultvalue for DB metainfo " + name + "=" + value);
        }
        return value;
    }

    private int getPropInt(String name, int defaultValue) throws SQLException {
        int result = defaultValue;
        String value = null;
        if (null == this.staticProps) {
            this.log("getPropIn: Need metadata.");
            this.initializeMetadata();
            this.log("Metadata initialized.");
        }
        if ((value = (String)this.staticProps.get(name)) == null) {
            value = this.getProp(name);
        } else {
            this.log("Returning cached DB metainfo " + name + "=" + value);
        }
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                this.log("Returning defaultvalue for DB metainfo after NumberFormatException in parseInt()" + name + "=" + result);
            }
        } else {
            this.log("Returning defaultvalue for DB metainfo " + name + "=" + result);
        }
        return result;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        this.log("allProceduresAreCallable()");
        return this.getPropBoolean("allProceduresAreCallable", true);
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        this.log("allTablesAreSelectable()");
        return this.getPropBoolean("allTablesAreSelectable", true);
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        this.log("dataDefinitionCausesTransactionCommit()");
        return this.getPropBoolean("dataDefinitionCausesTransactionCommit", false);
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        this.log("dataDefinitionIgnoredInTransactions()");
        return this.getPropBoolean("dataDefinitionIgnoredInTransactions", false);
    }

    @Override
    public boolean deletesAreDetected(int type) {
        this.log("deletesAreDetected(" + type + ")");
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        this.log("doesMaxRowSizeIncludeBlobs()");
        return this.getPropBoolean("doesMaxRowSizeIncludeBlobs", false);
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        if (this.debug != null) {
            this.log("getAttributes(" + catalog + "," + schemaPattern + "," + typeNamePattern + "," + attributeNamePattern + ")");
        }
        EXAResultSet meta = this.connection.dialectFactory.createResultSet(this.debug);
        Column[] cols = new Column[]{new CharColumn(30), new CharColumn(30), new CharColumn(30), new CharColumn(30), new DecimalColumn(18, 0), new CharColumn(30), new DecimalColumn(18, 0), new DecimalColumn(18, 0), new DecimalColumn(18, 0), new DecimalColumn(18, 0), new CharColumn(30), new CharColumn(30), new DecimalColumn(18, 0), new DecimalColumn(18, 0), new DecimalColumn(18, 0), new DecimalColumn(18, 0), new CharColumn(30), new CharColumn(30), new CharColumn(30), new CharColumn(30), new DecimalColumn(18, 0)};
        meta.addColumn(cols[0], "TYPE_CAT");
        meta.addColumn(cols[1], "TYPE_SCHEM");
        meta.addColumn(cols[2], "TYPE_NAME");
        meta.addColumn(cols[3], "ATTR_NAME");
        meta.addColumn(cols[4], "DATA_TYPE");
        meta.addColumn(cols[5], "ATTR_TYPE_NAME");
        meta.addColumn(cols[6], "ATTR_SIZE");
        meta.addColumn(cols[7], "DECIMAL_DIGITS");
        meta.addColumn(cols[8], "NUM_PREC_RADIX");
        meta.addColumn(cols[9], "NULLABLE");
        meta.addColumn(cols[10], "REMARKS");
        meta.addColumn(cols[11], "ATTR_DEF");
        meta.addColumn(cols[12], "SQL_DATA_TYPE");
        meta.addColumn(cols[13], "SQL_DATETIME_SUB");
        meta.addColumn(cols[14], "CHAR_OCTET_LENGTH");
        meta.addColumn(cols[15], "ORDINAL_POSITION");
        meta.addColumn(cols[16], "IS_NULLABLE");
        meta.addColumn(cols[17], "SCOPE_CATALOG");
        meta.addColumn(cols[18], "SCOPE_SCHEMA");
        meta.addColumn(cols[19], "SCOPE_TABLE");
        meta.addColumn(cols[20], "SOURCE_DATA_TYPE");
        meta.resize(0);
        return meta;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        this.log("getBestRowIdentifier(" + schema + "," + table + "," + scope + "," + nullable);
        EXAResultSet result = this.connection.dialectFactory.createResultSet(this.debug);
        result.addColumn(new DecimalColumn(18, 0), "SCOPE");
        result.addColumn(new CharColumn(30), "COLUMN_NAME");
        result.addColumn(new DecimalColumn(18, 0), "DATA_TYPE");
        result.addColumn(new CharColumn(30), "TYPE_NAME");
        result.addColumn(new DecimalColumn(18, 0), "COLUMN_SIZE");
        result.addColumn(new DecimalColumn(18, 0), "BUFFER_LENGTH");
        result.addColumn(new DecimalColumn(18, 0), "DECIMAL_DIGITS");
        result.addColumn(new DecimalColumn(18, 0), "PSEUDO_COLUMN");
        result.resize(0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCatalogs() throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("getCatalogs()");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetCatalogs();
            }
            return this.getCatalogsSql();
        }
    }

    private ResultSet jdbcGetCatalogs() throws SQLException {
        this.log("EXAResultSet.jdbcGetCatalogs()");
        ExecutionStatus execStatus = new ExecutionStatus();
        EXAResult[] results = this.connection.communication_resultset(new byte[0], (byte)61, execStatus, null);
        this.connection.metadataAcquired();
        if (results != null && results.length > 0) {
            if (results[0] instanceof EXASQLException) {
                throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)results[0];
        }
        return null;
    }

    private synchronized ResultSet getCatalogsSql() throws SQLException {
        StringBuffer sql = new StringBuffer("/*snapshot execution*/ select \"TABLE_CAT\" from ");
        sql.append(METADATA_SCHEMA);
        sql.append(".");
        sql.append(ALL_CATALOGS);
        sql.append(" order by \"TABLE_CAT\"");
        ResultSet rs = this.metaStmt.executeQuery(sql.toString());
        return rs;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        this.log("getCatalogSeparator()");
        return this.getPropString("catalogSeparator", ".");
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        this.log("getCatalogTerm()");
        return this.getPropString("catalogTerm", "CATOLOG");
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return this.getFunctionsSql(catalog, schemaPattern, functionNamePattern);
    }

    private ResultSet jdbcGetFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        this.log("EXAResultSet.getFunctions(" + catalog + ", " + schemaPattern + ", " + functionNamePattern + ")");
        ExecutionStatus execStatus = new ExecutionStatus();
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        EXAOutputStream os = new EXAOutputStream(bas, this.connection);
        try {
            if (null == catalog) {
                os.writeInt(-1);
            } else {
                os.writeInt(catalog.getBytes(this.connection.getEncoding()).length);
                os.write(catalog.getBytes(this.connection.getEncoding()));
            }
            if (null == schemaPattern) {
                os.writeInt(-1);
            } else {
                os.writeInt(schemaPattern.getBytes(this.connection.getEncoding()).length);
                os.write(schemaPattern.getBytes(this.connection.getEncoding()));
            }
            if (null == functionNamePattern) {
                os.writeInt(-1);
            } else {
                os.writeInt(functionNamePattern.getBytes(this.connection.getEncoding()).length);
                os.write(functionNamePattern.getBytes(this.connection.getEncoding()));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        EXAResult[] results = this.connection.communication_resultset(bas.toByteArray(), (byte)65, execStatus, null);
        this.connection.metadataAcquired();
        if (results != null && results.length > 0) {
            if (results[0] instanceof EXASQLException) {
                throw ((EXASQLException)results[0]).getSQLException();
            }
            return (EXAResultSet)results[0];
        }
        return null;
    }

    private synchronized ResultSet getFunctionsSql(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        int numWhere;
        this.log("getFunctions(" + catalog + "," + schemaPattern + "," + functionNamePattern + ")");
        StringBuffer sql = new StringBuffer("/*snapshot execution*/ select \"PROCEDURE_CAT\" AS \"FUNCTION_CAT\", \"PROCEDURE_SCHEM\" AS \"FUNCTION_SCHEM\", \"PROCEDURE_NAME\" AS \"FUNCTION_NAME\", cast (\"REMARKS\" as varchar(2000)) as \"REMARKS\", \"PROCEDURE_TYPE\" AS \"FUNCTION_TYPE\", \"PROCEDURE_NAME\" as \"SPECIFIC_NAME\" from ");
        sql.append(METADATA_SCHEMA);
        sql.append(".");
        sql.append(ALL_PROCEDURES);
        Vector<String> wheres = new Vector<String>();
        if (catalog != null) {
            if ("".equals(catalog)) {
                wheres.addElement(" \"PROCEDURE_CAT\" is null ");
            } else {
                wheres.addElement(" \"PROCEDURE_CAT\" like '" + catalog + "' ");
            }
        }
        if (schemaPattern != null) {
            if ("".equals(schemaPattern)) {
                wheres.addElement(" \"PROCEDURE_SCHEM\" is null ");
            } else {
                wheres.addElement(" \"PROCEDURE_SCHEM\" like '" + schemaPattern + "' ");
            }
        }
        if (functionNamePattern != null) {
            if ("".equals(functionNamePattern)) {
                wheres.addElement(" \"PROCEDURE_NAME\" is null ");
            } else {
                wheres.addElement(" \"PROCEDURE_NAME\" like '" + functionNamePattern + "' ");
            }
        }
        if ((numWhere = wheres.size()) > 0) {
            sql.append(" WHERE ");
            for (int i = 0; i < numWhere; ++i) {
                sql.append(wheres.elementAt(i).toString());
                if (i >= numWhere - 1) continue;
                sql.append(" AND ");
            }
        }
        sql.append(" order by \"PROCEDURE_TYPE\",\"PROCEDURE_SCHEM\",\"PROCEDURE_NAME\" ");
        if (this.metaStmt.execute(sql.toString())) {
            ResultSet rs = this.metaStmt.getResultSet();
            return rs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("EXAResultSet.jdbcGetColumnPrivileges(" + catalog + ", " + schema + ", " + table + ", " + columnNamePattern + ")");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetColumnPrivileges(catalog, schema, table, columnNamePattern);
            }
            return this.getColumnPrivilegesSql(catalog, schema, table, columnNamePattern);
        }
    }

    private ResultSet jdbcGetColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        ExecutionStatus execStatus = new ExecutionStatus();
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        EXAOutputStream os = new EXAOutputStream(bas, this.connection);
        try {
            if (null == catalog) {
                os.writeInt(-1);
            } else {
                os.writeInt(catalog.getBytes(this.connection.getEncoding()).length);
                os.write(catalog.getBytes(this.connection.getEncoding()));
            }
            if (null == schema) {
                os.writeInt(-1);
            } else {
                os.writeInt(schema.getBytes(this.connection.getEncoding()).length);
                os.write(schema.getBytes(this.connection.getEncoding()));
            }
            if (null == table) {
                os.writeInt(-1);
            } else {
                os.writeInt(table.getBytes(this.connection.getEncoding()).length);
                os.write(table.getBytes(this.connection.getEncoding()));
            }
            if (null == columnNamePattern) {
                os.writeInt(-1);
            } else {
                os.writeInt(columnNamePattern.getBytes(this.connection.getEncoding()).length);
                os.write(columnNamePattern.getBytes(this.connection.getEncoding()));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        EXAResult[] results = this.connection.communication_resultset(bas.toByteArray(), (byte)62, execStatus, null);
        this.connection.metadataAcquired();
        if (results != null && results.length > 0) {
            if (results[0] instanceof EXASQLException) {
                throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)results[0];
        }
        return null;
    }

    private synchronized ResultSet getColumnPrivilegesSql(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        int numWhere;
        StringBuffer sql = new StringBuffer("/*snapshot execution*/ select \"TABLE_CAT\",\"TABLE_SCHEM\",\"TABLE_NAME\",\"COLUMN_NAME\",\"GRANTOR\",\"GRANTEE\",\"PRIVILEGE\", case \"IS_GRANTABLE\" when false then 'NO' when true then 'YES' else null end as \"IS_GRANTABLE\" from ");
        sql.append(METADATA_SCHEMA);
        sql.append(".");
        sql.append(COLUMN_PRIVILEGES);
        Vector<String> wheres = new Vector<String>();
        if (catalog != null) {
            if ("".equals(catalog)) {
                wheres.addElement(" \"TABLE_CAT\" is null ");
            } else {
                wheres.addElement(" \"TABLE_CAT\" like '" + catalog + "' ");
            }
        }
        if (schema != null) {
            if ("".equals(schema)) {
                wheres.addElement(" \"TABLE_SCHEM\" is null ");
            } else {
                wheres.addElement(" \"TABLE_SCHEM\" like '" + schema + "' ");
            }
        }
        if (table != null) {
            if ("".equals(table)) {
                wheres.addElement(" \"TABLE_NAME\" is null ");
            } else {
                wheres.addElement(" \"TABLE_NAME\" like '" + table + "' ");
            }
        }
        if (columnNamePattern != null) {
            if ("".equals(columnNamePattern)) {
                wheres.addElement(" \"COLUMN_NAME\" is null ");
            } else {
                wheres.addElement(" \"COLUMN_NAME\" like '" + columnNamePattern + "' ");
            }
        }
        if ((numWhere = wheres.size()) > 0) {
            sql.append(" WHERE ");
            for (int i = 0; i < numWhere; ++i) {
                sql.append(wheres.elementAt(i).toString());
                if (i >= numWhere - 1) continue;
                sql.append(" AND ");
            }
        }
        sql.append(" order by \"COLUMN_NAME\",\"PRIVILEGE\",\"GRANTOR\" nulls first,\"GRANTEE\" nulls first");
        if (this.metaStmt.execute(sql.toString())) {
            ResultSet rs = this.metaStmt.getResultSet();
            return rs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("EXAResultSet.jdbcGetColumns(" + catalog + ", " + schemaPattern + ", " + tableNamePattern + ", " + columnNamePattern + ")");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
            }
            return this.getColumnsSql(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
    }

    private ResultSet jdbcGetColumns(String catalog, String schemaPattern, String tablePattern, String columnsPattern) throws SQLException {
        ExecutionStatus execStatus = new ExecutionStatus();
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        EXAOutputStream os = new EXAOutputStream(bas, this.connection);
        try {
            if (null == catalog) {
                os.writeInt(-1);
            } else {
                os.writeInt(catalog.getBytes(this.connection.getEncoding()).length);
                os.write(catalog.getBytes(this.connection.getEncoding()));
            }
            if (null == schemaPattern) {
                os.writeInt(-1);
            } else {
                os.writeInt(schemaPattern.getBytes(this.connection.getEncoding()).length);
                os.write(schemaPattern.getBytes(this.connection.getEncoding()));
            }
            if (null == tablePattern) {
                os.writeInt(-1);
            } else {
                os.writeInt(tablePattern.getBytes(this.connection.getEncoding()).length);
                os.write(tablePattern.getBytes(this.connection.getEncoding()));
            }
            if (null == columnsPattern) {
                os.writeInt(-1);
            } else {
                os.writeInt(columnsPattern.getBytes(this.connection.getEncoding()).length);
                os.write(columnsPattern.getBytes(this.connection.getEncoding()));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        EXAResult[] results = this.connection.communication_resultset(bas.toByteArray(), (byte)60, execStatus, null);
        this.connection.metadataAcquired();
        if (results != null && results.length > 0) {
            if (results[0] instanceof EXASQLException) {
                throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)results[0];
        }
        return null;
    }

    private synchronized ResultSet getColumnsSql(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        int numWhere;
        this.log("getColumns(" + catalog + "," + schemaPattern + "," + tableNamePattern + "," + columnNamePattern + ")");
        StringBuffer sql = this.connection.getActiveProtocolVersion() >= 11 ? new StringBuffer("/*snapshot execution*/ select \"TABLE_CAT\",\"TABLE_SCHEM\",\"TABLE_NAME\",\"COLUMN_NAME\",case when \"DATA_TYPE\"=-7 then 16 else \"DATA_TYPE\" end \"DATA_TYPE\",\"TYPE_NAME\",\"COLUMN_SIZE\",cast(NULL as int) as \"BUFFER_LENGTH\",\"DECIMAL_DIGITS\",\"NUM_PREC_RADIX\",cast (case when \"NULLABLE\"=true then 1 when \"NULLABLE\"=false then 0 else 2 end as INT) \"NULLABLE\",\"COLUMN_COMMENT\" as \"REMARKS\",\"COLUMN_DEF\",cast(NULL as int) as \"SQL_DATA_TYPE\",cast(NULL as int) as \"SQL_DATETIME_SUB\",\"CHAR_OCTET_LENGTH\",cast (\"ORDINAL_POSITION\" as INT) as \"ORDINAL_POSITION\",\"IS_NULLABLE\",\"SCOPE_CATALOG\",\"SCOPE_SCHEMA\",\"SCOPE_TABLE\", cast (\"SOURCE_DATA_TYPE\" as SMALLINT) as \"SOURCE_DATA_TYPE\", cast (case when \"COLUMN_IDENTITY\" is null then 'NO' else 'YES' end as VARCHAR(3)) as \"IS_AUTOINCREMENT\", cast (case when \"COLUMN_IDENTITY\" is null then 'NO' else 'YES' end as VARCHAR(3)) as \"IS_GENERATEDCOLUMN\" from ") : new StringBuffer("/*snapshot execution*/ select \"TABLE_CAT\",\"TABLE_SCHEM\",\"TABLE_NAME\",\"COLUMN_NAME\",case when \"DATA_TYPE\"=-7 then 16 else \"DATA_TYPE\" end \"DATA_TYPE\",\"TYPE_NAME\",\"COLUMN_SIZE\",cast(NULL as int) as \"BUFFER_LENGTH\",\"DECIMAL_DIGITS\",\"NUM_PREC_RADIX\",\"NULLABLE\",\"COLUMN_COMMENT\" as \"REMARKS\",\"COLUMN_DEF\",cast(NULL as int) as \"SQL_DATA_TYPE\",cast(NULL as int) as \"SQL_DATETIME_SUB\",\"CHAR_OCTET_LENGTH\",\"ORDINAL_POSITION\",\"IS_NULLABLE\",\"SCOPE_CATALOG\",\"SCOPE_SCHEMA\",\"SCOPE_TABLE\",\"SOURCE_DATA_TYPE\", 'NO' as \"IS_AUTOINCREMENT\", 'NO' as \"IS_GENERATEDCOLUMN\" from ");
        sql.append(METADATA_SCHEMA);
        sql.append(".");
        sql.append(ALL_COLUMNS);
        Vector<String> wheres = new Vector<String>();
        if (catalog != null) {
            if ("".equals(catalog)) {
                wheres.addElement(" \"TABLE_CAT\" is null ");
            } else {
                wheres.addElement(" \"TABLE_CAT\" like '" + catalog + "' ");
            }
        }
        if (schemaPattern != null) {
            if ("".equals(schemaPattern)) {
                wheres.addElement(" \"TABLE_SCHEM\" is null ");
            } else {
                wheres.addElement(" \"TABLE_SCHEM\" like '" + schemaPattern + "' ");
            }
        }
        if (tableNamePattern != null) {
            if ("".equals(tableNamePattern)) {
                wheres.addElement(" \"TABLE_NAME\" is null ");
            } else {
                wheres.addElement(" \"TABLE_NAME\" like '" + tableNamePattern + "' ");
            }
        }
        if (columnNamePattern != null) {
            if ("".equals(columnNamePattern)) {
                wheres.addElement(" \"COLUMN_NAME\" is null ");
            } else {
                wheres.addElement(" \"COLUMN_NAME\" like '" + columnNamePattern + "' ");
            }
        }
        if ((numWhere = wheres.size()) > 0) {
            sql.append(" WHERE ");
            for (int i = 0; i < numWhere; ++i) {
                sql.append(wheres.elementAt(i).toString());
                if (i >= numWhere - 1) continue;
                sql.append(" AND ");
            }
        }
        sql.append(" order by \"TABLE_CAT\",\"TABLE_SCHEM\",\"TABLE_NAME\",\"ORDINAL_POSITION\" ");
        if (this.metaStmt.execute(sql.toString())) {
            ResultSet res = this.metaStmt.getResultSet();
            this.connection.metadataAcquired();
            return res;
        }
        return null;
    }

    @Override
    public Connection getConnection() {
        this.log("getConnection()");
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        int numWhere;
        this.log("getCrossReference(" + primaryCatalog + "," + primarySchema + "," + primaryTable + "," + foreignCatalog + "," + foreignSchema + "," + foreignTable + ")");
        StringBuffer sql = new StringBuffer("/*snapshot execution*/ select \"PKTABLE_CAT\",\"PKTABLE_SCHEM\",\"PKTABLE_NAME\",\"PKCOLUMN_NAME\",\"FKTABLE_CAT\",\"FKTABLE_SCHEM\",\"FKTABLE_NAME\",\"FKCOLUMN_NAME\",\"KEY_SEQ\",\"UPDATE_RULE\",\"DELETE_RULE\",\"FK_NAME\",\"PK_NAME\",\"DEFERRABILITY\" from ");
        sql.append(METADATA_SCHEMA);
        sql.append(".");
        sql.append(FOREIGN_KEYS);
        Vector<String> wheres = new Vector<String>();
        if (primaryCatalog != null) {
            if ("".equals(primaryCatalog)) {
                wheres.addElement(" \"PKTABLE_CAT\" is null ");
            } else {
                wheres.addElement(" \"PKTABLE_CAT\" like '" + primaryCatalog + "' ");
            }
        }
        if (primarySchema != null) {
            if ("".equals(primarySchema)) {
                wheres.addElement(" \"PKTABLE_SCHEM\" is null ");
            } else {
                wheres.addElement(" \"PKTABLE_SCHEM\" like '" + primarySchema + "' ");
            }
        }
        if (primaryTable != null) {
            if ("".equals(primaryTable)) {
                wheres.addElement(" \"PKTABLE_NAME\" is null ");
            } else {
                wheres.addElement(" \"PKTABLE_NAME\" like '" + primaryTable + "' ");
            }
        }
        if (foreignCatalog != null) {
            if ("".equals(foreignCatalog)) {
                wheres.addElement(" \"FKTABLE_CAT\" is null ");
            } else {
                wheres.addElement(" \"FKTABLE_CAT\" like '" + foreignCatalog + "' ");
            }
        }
        if (foreignSchema != null) {
            if ("".equals(foreignSchema)) {
                wheres.addElement(" \"FKTABLE_SCHEM\" is null ");
            } else {
                wheres.addElement(" \"FKTABLE_SCHEM\" like '" + foreignSchema + "' ");
            }
        }
        if (foreignTable != null) {
            if ("".equals(foreignTable)) {
                wheres.addElement(" \"FKTABLE_NAME\" is null ");
            } else {
                wheres.addElement(" \"FKTABLE_NAME\" like '" + foreignTable + "' ");
            }
        }
        if ((numWhere = wheres.size()) > 0) {
            sql.append(" WHERE ");
            for (int i = 0; i < numWhere; ++i) {
                sql.append(wheres.elementAt(i).toString());
                if (i >= numWhere - 1) continue;
                sql.append(" AND ");
            }
        }
        sql.append(" order by \"FKTABLE_CAT\",\"FKTABLE_SCHEM\",\"FKTABLE_NAME\",\"KEY_SEQ\" ");
        if (this.metaStmt.execute(sql.toString())) {
            ResultSet rs = this.metaStmt.getResultSet();
            return rs;
        }
        return null;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        if (this.debug != null) {
            this.log("getDatabaseMajorVersion()");
        }
        return this.getPropInt("databaseMajorVersion", 0);
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        if (this.debug != null) {
            this.log("getDatabaseMinorVersion()");
        }
        return this.getPropInt("databaseMinorVersion", 0);
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        this.log("getDatabaseProductName()");
        if (null != this.databaseProductName) {
            return this.databaseProductName;
        }
        return this.getPropString("databaseProductName", "");
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        this.log("getDatabaseProductVersion()");
        if (null != this.databaseProductVersion) {
            return this.databaseProductVersion;
        }
        this.databaseProductVersion = this.getPropString("databaseProductVersion", "");
        return this.databaseProductVersion;
    }

    public int getDatabaseProductVersionInt() throws SQLException {
        this.log("getDatabaseProductVersionInt()");
        if (0 == this.databaseProductVersionInt) {
            if (null == this.databaseProductVersion) {
                this.databaseProductVersion = this.getPropString("databaseProductVersion", "");
            }
            char[] tmpVer = new char[100];
            for (int i = 0; i < this.databaseProductVersion.length(); ++i) {
                tmpVer[i] = this.databaseProductVersion.getBytes()[i] == 46 ? 61 : (char)this.databaseProductVersion.getBytes()[i];
            }
            String[] parts = TextUtil.split("=", new String(tmpVer));
            if (0 == parts.length) {
                return 0;
            }
            if (1 == parts.length) {
                this.databaseProductVersionInt = Integer.valueOf(parts[0]) * 10000;
            }
            if (2 == parts.length) {
                this.databaseProductVersionInt = Integer.valueOf(parts[0]) * 10000 + Integer.valueOf(parts[1]) * 100;
            }
            if (3 <= parts.length) {
                this.databaseProductVersionInt = Integer.valueOf(parts[0]) * 10000 + Integer.valueOf(parts[1]) * 100;
                String p2 = parts[2].trim();
                if (p2.length() > 2) {
                    char[] buff = new char[100];
                    p2.getChars(0, 2, buff, 0);
                    p2 = "";
                    p2 = p2 + buff[0];
                    if (buff[1] >= '0' && buff[1] <= '9') {
                        p2 = p2 + buff[1];
                    }
                }
                try {
                    this.databaseProductVersionInt += Integer.valueOf(p2).intValue();
                }
                catch (NumberFormatException nex) {
                    this.log("getDatabaseProductVersionInt() NumberFormatException: " + nex.toString());
                }
            }
        }
        return this.databaseProductVersionInt;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        this.log("getDefaultTransactionIsolation()");
        return this.getPropInt("defaultTransactionIsolation", 8);
    }

    @Override
    public int getDriverMajorVersion() {
        int res = Integer.valueOf("25");
        this.log("getDriverMajorVersion() - " + res);
        return res;
    }

    @Override
    public int getDriverMinorVersion() {
        int res = Integer.valueOf("2");
        this.log("getDriverMinorVersion() - " + res);
        return res;
    }

    public int getDriverIncVersion() {
        int res = Integer.valueOf("4");
        this.log("getDriverIncVersion() - " + res);
        return res;
    }

    @Override
    public String getDriverName() {
        String res = "Exasol JDBC Driver";
        this.log("getDriverName() - " + res);
        return res;
    }

    @Override
    public String getDriverVersion() {
        String res = EXADriver.getVersionInfo();
        this.log("getDriverVersion() - " + res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            int numWhere;
            this.log("getExportedKeys(" + catalog + "," + schema + "," + table + ")");
            StringBuffer sql = new StringBuffer("/*snapshot execution*/ select \"PKTABLE_CAT\",\"PKTABLE_SCHEM\",\"PKTABLE_NAME\",\"PKCOLUMN_NAME\",\"FKTABLE_CAT\",\"FKTABLE_SCHEM\",\"FKTABLE_NAME\",\"FKCOLUMN_NAME\",\"KEY_SEQ\",\"UPDATE_RULE\",\"DELETE_RULE\",\"FK_NAME\",\"PK_NAME\",\"DEFERRABILITY\" from ");
            sql.append(METADATA_SCHEMA);
            sql.append(".");
            sql.append(FOREIGN_KEYS);
            Vector<String> wheres = new Vector<String>();
            if (catalog != null) {
                if ("".equals(catalog)) {
                    wheres.addElement(" \"PKTABLE_CAT\" is null ");
                } else {
                    wheres.addElement(" \"PKTABLE_CAT\" like '" + catalog + "' ");
                }
            }
            if (schema != null) {
                if ("".equals(schema)) {
                    wheres.addElement(" \"PKTABLE_SCHEM\" is null ");
                } else {
                    wheres.addElement(" \"PKTABLE_SCHEM\" like '" + schema + "' ");
                }
            }
            if (table != null) {
                if ("".equals(table)) {
                    wheres.addElement(" \"PKTABLE_NAME\" is null ");
                } else {
                    wheres.addElement(" \"PKTABLE_NAME\" like '" + table + "' ");
                }
            }
            if ((numWhere = wheres.size()) > 0) {
                sql.append(" WHERE ");
                for (int i = 0; i < numWhere; ++i) {
                    sql.append((String)wheres.elementAt(i));
                    if (i >= numWhere - 1) continue;
                    sql.append(" AND ");
                }
            }
            sql.append(" order by \"FKTABLE_CAT\",\"FKTABLE_SCHEM\",\"FKTABLE_NAME\",\"KEY_SEQ\" ");
            if (this.metaStmt.execute(sql.toString())) {
                ResultSet rs = this.metaStmt.getResultSet();
                return rs;
            }
            return null;
        }
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        this.log("getExtraNameCharacters()");
        return this.getPropString("extraNameCharacters", "");
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        this.log("getIdentifierQuoteString()");
        return this.getPropString("identifierQuoteString", "\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            int numWhere;
            this.log("getImportedKeys(" + catalog + "," + schema + "," + table + ")");
            StringBuffer sql = new StringBuffer("/*snapshot execution*/ select \"PKTABLE_CAT\",\"PKTABLE_SCHEM\",\"PKTABLE_NAME\",\"PKCOLUMN_NAME\",\"FKTABLE_CAT\",\"FKTABLE_SCHEM\",\"FKTABLE_NAME\",\"FKCOLUMN_NAME\",\"KEY_SEQ\",\"UPDATE_RULE\",\"DELETE_RULE\",\"FK_NAME\",\"PK_NAME\",\"DEFERRABILITY\" from ");
            sql.append(METADATA_SCHEMA);
            sql.append(".");
            sql.append(FOREIGN_KEYS);
            Vector<String> wheres = new Vector<String>();
            if (catalog != null) {
                if ("".equals(catalog)) {
                    wheres.addElement(" \"FKTABLE_CAT\" is null ");
                } else {
                    wheres.addElement(" \"FKTABLE_CAT\" like '" + catalog + "' ");
                }
            }
            if (schema != null) {
                if ("".equals(schema)) {
                    wheres.addElement(" \"FKTABLE_SCHEM\" is null ");
                } else {
                    wheres.addElement(" \"FKTABLE_SCHEM\" like '" + schema + "' ");
                }
            }
            if (table != null) {
                if ("".equals(table)) {
                    wheres.addElement(" \"FKTABLE_NAME\" is null ");
                } else {
                    wheres.addElement(" \"FKTABLE_NAME\" like '" + table + "' ");
                }
            }
            if ((numWhere = wheres.size()) > 0) {
                sql.append(" WHERE ");
                for (int i = 0; i < numWhere; ++i) {
                    sql.append(wheres.elementAt(i).toString());
                    if (i >= numWhere - 1) continue;
                    sql.append(" AND ");
                }
            }
            sql.append(" order by \"PKTABLE_CAT\",\"PKTABLE_SCHEM\",\"PKTABLE_NAME\",\"KEY_SEQ\" ");
            if (this.metaStmt.execute(sql.toString())) {
                ResultSet rs = this.metaStmt.getResultSet();
                return rs;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            int numWhere;
            this.log("getIndexInfo(" + catalog + "," + schema + "," + table + "," + unique + "," + approximate + ")");
            StringBuffer sql = new StringBuffer("/*snapshot execution*/ select \"TABLE_CAT\",\"TABLE_SCHEM\",\"TABLE_NAME\",\"NON_UNIQUE\",\"INDEX_QUALIFIER\",\"INDEX_NAME\",\"TYPE\",\"ORDINAL_POSITION\",\"COLUMN_NAME\",\"ASC_OR_DESC\",\"CARDINALITY\",\"PAGES\",\"FILTER_CONDITION\" from ");
            sql.append(METADATA_SCHEMA);
            sql.append(".");
            sql.append(ALL_INDICES);
            Vector<String> wheres = new Vector<String>();
            if (catalog != null) {
                if ("".equals(catalog)) {
                    wheres.addElement(" \"TABLE_CAT\" is null ");
                } else {
                    wheres.addElement(" \"TABLE_CAT\" like '" + catalog + "' ");
                }
            }
            if (schema != null) {
                if ("".equals(schema)) {
                    wheres.addElement(" \"TABLE_SCHEM\" is null ");
                } else {
                    wheres.addElement(" \"TABLE_SCHEM\" like '" + schema + "' ");
                }
            }
            if (table != null) {
                if ("".equals(table)) {
                    wheres.addElement(" \"TABLE_NAME\" is null ");
                } else {
                    wheres.addElement(" \"TABLE_NAME\" like '" + table + "' ");
                }
            }
            if (unique) {
                wheres.addElement(" \"NON_UNIQUE\"=false ");
            }
            if ((numWhere = wheres.size()) > 0) {
                sql.append(" WHERE ");
                for (int i = 0; i < numWhere; ++i) {
                    sql.append(wheres.elementAt(i).toString());
                    if (i >= numWhere - 1) continue;
                    sql.append(" AND ");
                }
            }
            sql.append(" order by \"NON_UNIQUE\",\"TYPE\",\"INDEX_NAME\",\"ORDINAL_POSITION\" ");
            if (this.metaStmt.execute(sql.toString())) {
                ResultSet rs = this.metaStmt.getResultSet();
                return rs;
            }
            return null;
        }
    }

    @Override
    public int getJDBCMajorVersion() {
        if (this.debug != null) {
            this.log("getDatabaseMajorVersion()");
        }
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        if (this.debug != null) {
            this.log("getDatabaseMinorVersion()");
        }
        return 1;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        this.log("getMaxBinaryLiteralLength()");
        return this.getPropInt("maxBinaryLiteralLength", 0);
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        this.log("getMaxCatalogNameLength()");
        return this.getPropInt("maxCatalogNameLength", 30);
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        this.log("getMaxCharLiteralLength()");
        return this.getPropInt("maxCharLiteralLength", 99);
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        this.log("getMaxColumnNameLength()");
        return this.getPropInt("maxColumnNameLength", 30);
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        this.log("getMaxColumnsInGroupBy():1000");
        return this.getPropInt("maxColumnsInGroupBy", 1000);
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        this.log("getMaxColumnsInIndex()");
        return this.getPropInt("maxColumnsInIndex", 0);
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        this.log("getMaxColumnsInOrderBy()");
        return this.getPropInt("maxColumnsInOrderBy", 1000);
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        this.log("getMaxColumnsInSelect()");
        return this.getPropInt("maxColumnsInSelect", 1000);
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        this.log("getMaxColumnsInTable()");
        return this.getPropInt("maxColumnsInTable", 1000);
    }

    @Override
    public int getMaxConnections() throws SQLException {
        this.log("getMaxConnections()");
        return this.getPropInt("maxConnections", 1);
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        this.log("getMaxCursorNameLength()");
        return this.getPropInt("maxCursorNameLength", 0);
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        this.log("getMaxIndexLength()");
        return this.getPropInt("maxIndexLength", 0);
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        this.log("getMaxProcedureNameLength()");
        return this.getPropInt("maxProcedureNameLength", 30);
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        this.log("getMaxRowSize()");
        return this.getPropInt("maxRowSize", 32000);
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        this.log("getMaxSchemaNameLength()");
        return this.getPropInt("maxSchemaNameLength", 30);
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        this.log("getMaxStatementLength()");
        return this.getPropInt("maxStatementLength", 100000);
    }

    @Override
    public int getMaxStatements() throws SQLException {
        this.log("getMaxStatements()");
        return this.getPropInt("maxStatements", 100);
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        this.log("getMaxTableNameLength()");
        return this.getPropInt("maxTableNameLength", 30);
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        this.log("getMaxTablesInSelect()");
        return this.getPropInt("maxTablesInSelect", 0);
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        this.log("getMaxUserNameLength()");
        return this.getPropInt("maxUserNameLength", 30);
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        this.log("getNumericFunctions()");
        return this.getPropString("numericFunctions", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("getPrimaryKeys(" + catalog + "," + schema + "," + table + ")");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetPrimaryKeys(catalog, schema, table);
            }
            return this.getPrimaryKeysSql(catalog, schema, table);
        }
    }

    private ResultSet jdbcGetPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        ExecutionStatus execStatus = new ExecutionStatus();
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        EXAOutputStream os = new EXAOutputStream(bas, this.connection);
        try {
            if (null == catalog) {
                os.writeInt(-1);
            } else {
                os.writeInt(catalog.getBytes(this.connection.getEncoding()).length);
                os.write(catalog.getBytes(this.connection.getEncoding()));
            }
            if (null == schema) {
                os.writeInt(-1);
            } else {
                os.writeInt(schema.getBytes(this.connection.getEncoding()).length);
                os.write(schema.getBytes(this.connection.getEncoding()));
            }
            if (null == table) {
                os.writeInt(-1);
            } else {
                os.writeInt(table.getBytes(this.connection.getEncoding()).length);
                os.write(table.getBytes(this.connection.getEncoding()));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        EXAResult[] results = this.connection.communication_resultset(bas.toByteArray(), (byte)63, execStatus, null);
        this.connection.metadataAcquired();
        if (results != null && results.length > 0) {
            if (results[0] instanceof EXASQLException) {
                throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)results[0];
        }
        return null;
    }

    private synchronized ResultSet getPrimaryKeysSql(String catalog, String schema, String table) throws SQLException {
        int numWhere;
        StringBuffer sql = new StringBuffer("/*snapshot execution*/ select \"TABLE_CAT\",\"TABLE_SCHEM\",\"TABLE_NAME\",\"COLUMN_NAME\",\"KEY_SEQ\",\"PK_NAME\" from ");
        sql.append(METADATA_SCHEMA);
        sql.append(".");
        sql.append(PRIMARY_KEYS);
        Vector<String> wheres = new Vector<String>();
        if (catalog != null) {
            if ("".equals(catalog)) {
                wheres.addElement(" \"TABLE_CAT\" is null ");
            } else {
                wheres.addElement(" \"TABLE_CAT\" like '" + catalog + "' ");
            }
        }
        if (schema != null) {
            if ("".equals(schema)) {
                wheres.addElement(" \"TABLE_SCHEM\" is null ");
            } else {
                wheres.addElement(" \"TABLE_SCHEM\" like '" + schema + "' ");
            }
        }
        if (table != null) {
            if ("".equals(table)) {
                wheres.addElement(" \"TABLE_NAME\" is null ");
            } else {
                wheres.addElement(" \"TABLE_NAME\" like '" + table + "' ");
            }
        }
        if ((numWhere = wheres.size()) > 0) {
            sql.append(" WHERE ");
            for (int i = 0; i < numWhere; ++i) {
                sql.append(wheres.elementAt(i).toString());
                if (i >= numWhere - 1) continue;
                sql.append(" AND ");
            }
        }
        sql.append(" order by \"COLUMN_NAME\" ");
        if (this.metaStmt.execute(sql.toString())) {
            ResultSet rs = this.metaStmt.getResultSet();
            return rs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("getProcedureColumns(" + catalog + ", " + schemaPattern + ", " + procedureNamePattern + ", " + columnNamePattern + ")");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetProcedureColumns(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
            }
            return this.getProcedureColumnsSql(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        }
    }

    private ResultSet jdbcGetProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        ExecutionStatus execStatus = new ExecutionStatus();
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        EXAOutputStream os = new EXAOutputStream(bas, this.connection);
        try {
            if (null == catalog) {
                os.writeInt(-1);
            } else {
                os.writeInt(catalog.getBytes(this.connection.getEncoding()).length);
                os.write(catalog.getBytes(this.connection.getEncoding()));
            }
            if (null == schemaPattern) {
                os.writeInt(-1);
            } else {
                os.writeInt(schemaPattern.getBytes(this.connection.getEncoding()).length);
                os.write(schemaPattern.getBytes(this.connection.getEncoding()));
            }
            if (null == procedureNamePattern) {
                os.writeInt(-1);
            } else {
                os.writeInt(procedureNamePattern.getBytes(this.connection.getEncoding()).length);
                os.write(procedureNamePattern.getBytes(this.connection.getEncoding()));
            }
            if (null == columnNamePattern) {
                os.writeInt(-1);
            } else {
                os.writeInt(columnNamePattern.getBytes(this.connection.getEncoding()).length);
                os.write(columnNamePattern.getBytes(this.connection.getEncoding()));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        EXAResult[] results = this.connection.communication_resultset(bas.toByteArray(), (byte)64, execStatus, null);
        this.connection.metadataAcquired();
        if (results != null && results.length > 0) {
            if (results[0] instanceof EXASQLException) {
                throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)results[0];
        }
        return null;
    }

    private synchronized ResultSet getProcedureColumnsSql(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        int numWhere;
        StringBuffer sql = new StringBuffer("/*snapshot execution*/ select \"PROCEDURE_CAT\",\"PROCEDURE_SCHEM\",\"PROCEDURE_NAME\",\"COLUMN_NAME\",cast (\"DATA_TYPE\" as smallint) as \"COLUMN_TYPE\",\"DATA_TYPE\", cast (\"TYPE_NAME\" as varchar(128)) as \"TYPE_NAME\",  cast (\"PRECISION\" as int) as \"PRECISION\", cast (\"LENGTH\" as int) as \"LENGTH\", cast(\"SCALE\" as smallint) as \"SCALE\", cast (\"RADIX\" as smallint) as \"RADIX\", cast (\"NULLABLE\" as smallint) as \"NULLABLE\",\"REMARKS\",  cast (NULL as varchar(2000)) as \"COLUMN_DEF\", cast (NULL as int) as \"SQL_DATA_TYPE\", cast (NULL as int) as \"SQL_DATETIME_SUB\", cast (NULL as int) as \"CHAR_OCTET_LENGTH\", cast (NULL as int) as \"ORDINAL_POSITION\",  cast (NULL as varchar(3)) as \"IS_NULLABLE\", cast (NULL as varchar(128)) as \"SPECIFIC_NAME\" from ");
        sql.append(METADATA_SCHEMA);
        sql.append(".");
        sql.append(PROCEDURE_COLUMNS);
        Vector<String> wheres = new Vector<String>();
        if (catalog != null) {
            if ("".equals(catalog)) {
                wheres.addElement(" \"PROCEDURE_CAT\" is null ");
            } else {
                wheres.addElement(" \"PROCEDURE_CAT\" like '" + catalog + "' ");
            }
        }
        if (schemaPattern != null) {
            if ("".equals(schemaPattern)) {
                wheres.addElement(" \"PROCEDURE_SCHEM\" is null ");
            } else {
                wheres.addElement(" \"PROCEDURE_SCHEM\" like '" + schemaPattern + "' ");
            }
        }
        if (procedureNamePattern != null) {
            if ("".equals(procedureNamePattern)) {
                wheres.addElement(" \"PROCEDURE_NAME\" is null ");
            } else {
                wheres.addElement(" \"PROCEDURE_NAME\" like '" + procedureNamePattern + "' ");
            }
        }
        if (columnNamePattern != null) {
            if ("".equals(columnNamePattern)) {
                wheres.addElement(" \"COLUMN_NAME\" is null ");
            } else {
                wheres.addElement(" \"COLUMN_NAME\" like '" + columnNamePattern + "' ");
            }
        }
        if ((numWhere = wheres.size()) > 0) {
            sql.append(" WHERE ");
            for (int i = 0; i < numWhere; ++i) {
                sql.append(wheres.elementAt(i).toString());
                if (i >= numWhere - 1) continue;
                sql.append(" AND ");
            }
        }
        sql.append(" order by \"PROCEDURE_SCHEM\",\"PROCEDURE_NAME\" ");
        if (this.metaStmt.execute(sql.toString())) {
            ResultSet rs = this.metaStmt.getResultSet();
            return rs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("getProcedures(" + catalog + ", " + schemaPattern + ", " + procedureNamePattern + ")");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetProcedures(catalog, schemaPattern, procedureNamePattern);
            }
            return this.getProceduresSql(catalog, schemaPattern, procedureNamePattern);
        }
    }

    private ResultSet jdbcGetProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        ExecutionStatus execStatus = new ExecutionStatus();
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        EXAOutputStream os = new EXAOutputStream(bas, this.connection);
        try {
            if (null == catalog) {
                os.writeInt(-1);
            } else {
                os.writeInt(catalog.getBytes(this.connection.getEncoding()).length);
                os.write(catalog.getBytes(this.connection.getEncoding()));
            }
            if (null == schemaPattern) {
                os.writeInt(-1);
            } else {
                os.writeInt(schemaPattern.getBytes(this.connection.getEncoding()).length);
                os.write(schemaPattern.getBytes(this.connection.getEncoding()));
            }
            if (null == procedureNamePattern) {
                os.writeInt(-1);
            } else {
                os.writeInt(procedureNamePattern.getBytes(this.connection.getEncoding()).length);
                os.write(procedureNamePattern.getBytes(this.connection.getEncoding()));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        EXAResult[] results = this.connection.communication_resultset(bas.toByteArray(), (byte)65, execStatus, null);
        this.connection.metadataAcquired();
        if (results != null && results.length > 0) {
            if (results[0] instanceof EXASQLException) {
                throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)results[0];
        }
        return null;
    }

    private synchronized ResultSet getProceduresSql(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        int numWhere;
        StringBuffer sql = new StringBuffer("/*snapshot execution*/ select \"PROCEDURE_CAT\",\"PROCEDURE_SCHEM\",\"PROCEDURE_NAME\", cast(-1 as smallint) as \"NUM_INPUT_PARAMS\", cast(-1 as smallint) as \"NUM_OUTPUT_PARAMS\", cast(-1 as smallint) as \"NUM_RESULT_SETS\", cast (\"REMARKS\" as varchar(2000)) as \"REMARKS\", cast(0 as smallint) as \"PROCEDURE_TYPE\", \"PROCEDURE_NAME\" as \"SPECIFIC_NAME\" from ");
        sql.append(METADATA_SCHEMA);
        sql.append(".");
        sql.append(ALL_PROCEDURES);
        Vector<String> wheres = new Vector<String>();
        if (catalog != null) {
            if ("".equals(catalog)) {
                wheres.addElement(" \"PROCEDURE_CAT\" is null ");
            } else {
                wheres.addElement(" \"PROCEDURE_CAT\" like '" + catalog + "' ");
            }
        }
        if (schemaPattern != null) {
            if ("".equals(schemaPattern)) {
                wheres.addElement(" \"PROCEDURE_SCHEM\" is null ");
            } else {
                wheres.addElement(" \"PROCEDURE_SCHEM\" like '" + schemaPattern + "' ");
            }
        }
        if (procedureNamePattern != null) {
            if ("".equals(procedureNamePattern)) {
                wheres.addElement(" \"PROCEDURE_NAME\" is null ");
            } else {
                wheres.addElement(" \"PROCEDURE_NAME\" like '" + procedureNamePattern + "' ");
            }
        }
        if ((numWhere = wheres.size()) > 0) {
            sql.append(" WHERE ");
            for (int i = 0; i < numWhere; ++i) {
                sql.append(wheres.elementAt(i).toString());
                if (i >= numWhere - 1) continue;
                sql.append(" AND ");
            }
        }
        sql.append(" order by \"PROCEDURE_SCHEM\",\"PROCEDURE_NAME\" ");
        if (this.metaStmt.execute(sql.toString())) {
            ResultSet rs = this.metaStmt.getResultSet();
            return rs;
        }
        return null;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        this.log("getProcedureTerm()");
        return this.getPropString("procedureTerm", "PROCEDURE");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        if (this.debug != null) {
            this.log("getResultSetHoldability()");
        }
        return this.getPropInt("resultSetHoldability", 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("getSchemas()");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetSchemas(catalog, schemaPattern);
            }
            return this.getSchemasSql(catalog, schemaPattern);
        }
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        if (this.debug != null) {
            this.log("supportsStoredFunctionsUsingCallSyntax()");
        }
        return this.getPropBoolean("supportsStoredFunctionsUsingCallSyntax", false);
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        if (this.debug != null) {
            this.log("autoCommitFailureClosesAllResultSets()");
        }
        return this.getPropBoolean("autoCommitFailureClosesAllResultSets", false);
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        if (this.debug != null) {
            this.log("getClientInfoProperties()");
        }
        EXAResultSet meta = this.connection.dialectFactory.createResultSet(this.debug);
        Column[] cols = new Column[]{new CharColumn(128), new DecimalColumn(18, 0), new CharColumn(256), new CharColumn(512)};
        meta.addColumn(cols[0], "NAME");
        meta.addColumn(cols[1], "MAX_LEN");
        meta.addColumn(cols[2], "DEFAULT_VALUE");
        meta.addColumn(cols[3], "DESCRIPTION");
        meta.resize(23);
        int row = 0;
        cols[0].setString(row, "autocommit");
        cols[1].setInt(row, 1);
        cols[2].setString(row, Integer.valueOf(1).toString());
        cols[3].setString(row, "Right after the connection is established, setAutocommit is called by the driver. Values: 1 for autocommit true, 0 for autocommit false. ");
        cols[0].setString(++row, "clientname");
        cols[1].setInt(row, this.connection.getMaxIdentifierLen());
        cols[2].setString(row, "Generic client");
        cols[3].setString(row, "Specifies the name of the client app that uses Exasol JDBC. Is shown in the server log files. ");
        cols[0].setString(++row, "clientversion");
        cols[1].setInt(row, this.connection.getMaxIdentifierLen());
        cols[2].setNull(row);
        cols[3].setString(row, "Specifies the version of the client app that uses Exasol JDBC. Is shown in the server log files. ");
        cols[0].setString(++row, "hosttimeout");
        cols[1].setInt(row, Integer.valueOf(Integer.MAX_VALUE).toString().length());
        cols[2].setString(row, Integer.valueOf(2000).toString());
        cols[3].setString(row, "A timeout in milliseconds that specifies the maximum time interval the driver will try to establish a connection on each node given in the connection string. ");
        cols[0].setString(++row, "connectionPoolSize");
        cols[1].setInt(row, Integer.valueOf(Integer.MAX_VALUE).toString().length());
        cols[2].setString(row, Integer.valueOf(EXADriver.connectionPoolSize).toString());
        cols[3].setString(row, "Specifies the size of the connection pool. This has effect on all connections in this instance of the VM and can be changed only once. ");
        cols[0].setString(++row, "debug");
        cols[1].setInt(row, 1);
        cols[2].setString(row, Integer.valueOf(0).toString());
        cols[3].setString(row, "The value 1 switches on the driver's log function. The driver then writes a log file named jdbc_timestamp.log for each established connection. ");
        cols[0].setString(++row, "encryption");
        cols[1].setInt(row, 1);
        cols[2].setString(row, Integer.valueOf(1).toString());
        cols[3].setString(row, "Tells the driver that he has to enable or disable encryption of the socket communications with the server. Default encryption is 1 (enabled).");
        cols[0].setString(++row, "feedbackinterval");
        cols[1].setInt(row, Integer.valueOf(Integer.MAX_VALUE).toString().length());
        cols[2].setString(row, Integer.valueOf(EXAConnection.defaultFeedbackInterval).toString());
        cols[3].setString(row, "Specifies the interval in seconds after that the server gives feedback to the client about a running query. ");
        cols[0].setString(++row, "fetchsize");
        cols[1].setInt(row, Integer.valueOf(Integer.MAX_VALUE).toString().length());
        cols[2].setString(row, Integer.valueOf(2048).toString());
        cols[3].setString(row, "Fetch size in kilobytes for retrieving result sets. ");
        cols[0].setString(++row, "kerberosconfig");
        cols[1].setInt(row, 4096);
        cols[2].setNull(row);
        cols[3].setString(row, "Kerberos config file name and path (will set java.security.krb5.conf). ");
        cols[0].setString(++row, "kerberoshostname");
        cols[1].setInt(row, 255);
        cols[2].setString(row, this.connection.getEXAServer());
        cols[3].setString(row, "Kerberos host name. Default is the host of the EXASOL server where the connection will be made. If in the connection string there are multiple hosts specified, the host chosen to connect to will be used here, too. ");
        cols[0].setString(++row, "kerberosrealm");
        cols[1].setInt(row, 255);
        cols[2].setNull(row);
        cols[3].setString(row, "Kerberos realm. ");
        cols[0].setString(++row, "kerberosservicename");
        cols[1].setInt(row, this.connection.getMaxIdentifierLen());
        cols[2].setString(row, "exasol");
        cols[3].setString(row, "Kerberos service name. ");
        cols[0].setString(++row, "kerberosusername");
        cols[1].setInt(row, this.connection.getMaxIdentifierLen());
        cols[2].setNull(row);
        cols[3].setString(row, "Kerberos user name. ");
        cols[0].setString(++row, "debug");
        cols[1].setInt(row, 4096);
        cols[2].setNull(row);
        cols[3].setString(row, "Defines the directory where the JDBC debug log files should be written to (in debug mode). ");
        cols[0].setString(++row, "logintimeout");
        cols[1].setInt(row, Integer.valueOf(Integer.MAX_VALUE).toString().length());
        cols[2].setString(row, Integer.valueOf(0).toString());
        cols[3].setString(row, "A timeout in seconds that specifies how long the driver will wait for the server until the answer package for a connect request arrives. This timeout has effect only after a socket connection to the server was already established. ");
        cols[0].setString(++row, "metadataSQL");
        cols[1].setInt(row, 1);
        cols[2].setString(row, Integer.valueOf(0).toString());
        cols[3].setString(row, "Used for parallel connections. The identifying token for the worker connection. ");
        cols[0].setString(++row, "querytimeout");
        cols[1].setInt(row, Integer.valueOf(Integer.MAX_VALUE).toString().length());
        cols[2].setString(row, Integer.valueOf(0).toString());
        cols[3].setString(row, "Sets the query timeout for statement execution. Default is 0 (unlimited). ");
        cols[0].setString(++row, "schema");
        cols[1].setInt(row, this.connection.getMaxIdentifierLen());
        cols[2].setNull(row);
        cols[3].setString(row, "If specified, the driver opens the schema right after the connection is established. ");
        cols[0].setString(++row, "worker");
        cols[1].setInt(row, 1);
        cols[2].setString(row, Integer.valueOf(0).toString());
        cols[3].setString(row, "Used for parallel connections. The value 1 tells the driver that a worker connection is to be made. ");
        cols[0].setString(++row, "workertoken");
        cols[1].setInt(row, Long.valueOf(Long.MAX_VALUE).toString().length());
        cols[2].setNull(row);
        cols[3].setString(row, "Used for parallel connections. The identifying token for the worker connection. ");
        cols[0].setString(++row, "superconnection");
        cols[1].setInt(row, 1);
        cols[2].setString(row, Integer.valueOf(0).toString());
        cols[3].setString(row, "Enables the super connection mode if set to 1. Only the user sys set this attribute. Default is 0 (no super connection). ");
        cols[0].setString(++row, "snapshottransactions");
        cols[1].setInt(row, 1);
        cols[2].setString(row, Integer.valueOf(2).toString());
        cols[3].setString(row, "Enables snapshot transactions in this session. Accepted Values: 0 (Disable), 1 (Enable), and 2 (the default in the session is used). Default Option: 2");
        return meta;
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName());
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        this.log("generatedKeyAlwaysReturned() - false");
        return false;
    }

    private ResultSet jdbcGetSchemas(String catalog, String schemaPattern) throws SQLException {
        ExecutionStatus execStatus = new ExecutionStatus();
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        EXAOutputStream os = new EXAOutputStream(bas, this.connection);
        try {
            if (null == catalog) {
                os.writeInt(-1);
            } else {
                os.writeInt(catalog.getBytes(this.connection.getEncoding()).length);
                os.write(catalog.getBytes(this.connection.getEncoding()));
            }
            if (null == schemaPattern) {
                os.writeInt(-1);
            } else {
                os.writeInt(schemaPattern.getBytes(this.connection.getEncoding()).length);
                os.write(schemaPattern.getBytes(this.connection.getEncoding()));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        EXAResult[] results = this.connection.communication_resultset(bas.toByteArray(), (byte)66, execStatus, null);
        this.connection.metadataAcquired();
        if (results != null && results.length > 0) {
            if (results[0] instanceof EXASQLException) {
                throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)results[0];
        }
        return null;
    }

    private synchronized ResultSet getSchemasSql(String catalog, String schemaPattern) throws SQLException {
        StringBuffer sql = new StringBuffer("/*snapshot execution*/ select \"TABLE_SCHEM\",\"TABLE_CAT\" as \"TABLE_CATALOG\" from ");
        sql.append(METADATA_SCHEMA);
        sql.append(".ALL_SCHEMAS ");
        if (null != catalog || null != schemaPattern) {
            sql.append("where ");
        }
        if (null != catalog) {
            sql.append(" \"TABLE_CAT\"='" + catalog + "' ");
            if (null != schemaPattern) {
                sql.append("and ");
            }
        }
        if (null != schemaPattern) {
            sql.append(" \"TABLE_SCHEM\" like '" + schemaPattern + "' ");
        }
        sql.append("order by \"TABLE_CATALOG\",\"TABLE_SCHEM\"");
        return this.metaStmt.executeQuery(sql.toString());
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        this.log("getSchemas()");
        return this.getSchemas(null, null);
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        this.log("getSchemaTerm()");
        return this.getPropString("schemaTerm", "SCHEMA");
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        this.log("getSearchStringEscape()");
        return this.getPropString("searchStringEscape", "");
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        this.log("getSQLKeywords()");
        return this.getPropString("SQLKeywords", "");
    }

    @Override
    public int getSQLStateType() throws SQLException {
        if (this.debug != null) {
            this.log("getSQLStateType()");
        }
        return this.getPropInt("SQLStateType", 0);
    }

    @Override
    public String getStringFunctions() throws SQLException {
        this.log("getStringFunctions()");
        return this.getPropString("stringFunctions", "");
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        if (this.debug != null) {
            this.log("getSuperTables(" + catalog + "," + schemaPattern + "," + tableNamePattern + ")");
        }
        EXAResultSet meta = this.connection.dialectFactory.createResultSet(this.debug);
        Column[] cols = new Column[]{new CharColumn(30), new CharColumn(30), new CharColumn(30), new CharColumn(30)};
        meta.addColumn(cols[0], "TABLE_CAT");
        meta.addColumn(cols[1], "TABLE_SCHEM");
        meta.addColumn(cols[2], "TABLE_NAME");
        meta.addColumn(cols[3], "SUPERTABLE_NAME");
        meta.resize(0);
        return meta;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        if (this.debug != null) {
            this.log("getSuperTypes(" + catalog + "," + schemaPattern + "," + typeNamePattern + ")");
        }
        EXAResultSet meta = this.connection.dialectFactory.createResultSet(this.debug);
        Column[] cols = new Column[]{new CharColumn(30), new CharColumn(30), new CharColumn(30), new CharColumn(30), new CharColumn(30), new CharColumn(30)};
        meta.addColumn(cols[0], "TYPE_CAT");
        meta.addColumn(cols[1], "TYPE_SCHEM");
        meta.addColumn(cols[2], "TYPE_NAME");
        meta.addColumn(cols[3], "SUPERTYPE_CAT");
        meta.addColumn(cols[4], "SUPERTYPE_SCHEM");
        meta.addColumn(cols[5], "SUPERTYPE_NAME");
        meta.resize(0);
        return meta;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        this.log("getSystemFunctions()");
        return this.getPropString("systemFunctions", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("getTablePrivileges(" + catalog + "," + schemaPattern + "," + tableNamePattern + ")");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetTablePrivileges(catalog, schemaPattern, tableNamePattern);
            }
            return this.getTablePrivilegesSql(catalog, schemaPattern, tableNamePattern);
        }
    }

    private ResultSet jdbcGetTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        ExecutionStatus execStatus = new ExecutionStatus();
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        EXAOutputStream os = new EXAOutputStream(bas, this.connection);
        try {
            if (null == catalog) {
                os.writeInt(-1);
            } else {
                os.writeInt(catalog.getBytes(this.connection.getEncoding()).length);
                os.write(catalog.getBytes(this.connection.getEncoding()));
            }
            if (null == schemaPattern) {
                os.writeInt(-1);
            } else {
                os.writeInt(schemaPattern.getBytes(this.connection.getEncoding()).length);
                os.write(schemaPattern.getBytes(this.connection.getEncoding()));
            }
            if (null == tableNamePattern) {
                os.writeInt(-1);
            } else {
                os.writeInt(tableNamePattern.getBytes(this.connection.getEncoding()).length);
                os.write(tableNamePattern.getBytes(this.connection.getEncoding()));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        EXAResult[] results = this.connection.communication_resultset(bas.toByteArray(), (byte)67, execStatus, null);
        this.connection.metadataAcquired();
        if (results != null && results.length > 0) {
            if (results[0] instanceof EXASQLException) {
                throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)results[0];
        }
        return null;
    }

    private synchronized ResultSet getTablePrivilegesSql(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        int numWhere;
        StringBuffer sql = new StringBuffer("/*snapshot execution*/ select \"TABLE_CAT\",\"TABLE_SCHEM\",\"TABLE_NAME\",\"GRANTOR\",\"GRANTEE\",\"PRIVILEGE\",decode(\"IS_GRANTABLE\",true,'YES',false,'NO') as \"IS_GRANTABLE\" from ");
        sql.append(METADATA_SCHEMA);
        sql.append(".");
        sql.append(TABLE_PRIVILEGES);
        Vector<String> wheres = new Vector<String>();
        if (catalog != null) {
            if ("".equals(catalog)) {
                wheres.addElement(" \"TABLE_CAT\" is null ");
            } else {
                wheres.addElement(" \"TABLE_CAT\" like '" + catalog + "' ");
            }
        }
        if (schemaPattern != null) {
            if ("".equals(schemaPattern)) {
                wheres.addElement(" \"TABLE_SCHEM\" is null ");
            } else {
                wheres.addElement(" \"TABLE_SCHEM\" like '" + schemaPattern + "' ");
            }
        }
        if (tableNamePattern != null) {
            if ("".equals(tableNamePattern)) {
                wheres.addElement(" \"TABLE_NAME\" is null ");
            } else {
                wheres.addElement(" \"TABLE_NAME\" like '" + tableNamePattern + "' ");
            }
        }
        if ((numWhere = wheres.size()) > 0) {
            sql.append(" WHERE ");
            for (int i = 0; i < numWhere; ++i) {
                sql.append(wheres.elementAt(i).toString());
                if (i >= numWhere - 1) continue;
                sql.append(" AND ");
            }
        }
        sql.append(" order by \"TABLE_CAT\", \"TABLE_SCHEM\",\"TABLE_NAME\",\"PRIVILEGE\",\"GRANTOR\" nulls first,\"GRANTEE\" nulls first ");
        if (this.metaStmt.execute(sql.toString())) {
            ResultSet rs = this.metaStmt.getResultSet();
            return rs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            String ts = "";
            if (null == types) {
                ts = "null";
            } else {
                for (int i = 0; i < types.length; ++i) {
                    ts = ts + types[i];
                    if (i >= types.length - 1) continue;
                    ts = ts + ",";
                }
            }
            this.log("getTables(" + catalog + ", " + schemaPattern + ", " + tableNamePattern + ", " + ts + ")");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetTables(catalog, schemaPattern, tableNamePattern, types);
            }
            return this.getTablesSql(catalog, schemaPattern, tableNamePattern, types);
        }
    }

    private ResultSet jdbcGetTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        ExecutionStatus execStatus = new ExecutionStatus();
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        EXAOutputStream os = new EXAOutputStream(bas, this.connection);
        try {
            if (null == catalog) {
                os.writeInt(-1);
            } else {
                os.writeInt(catalog.getBytes(this.connection.getEncoding()).length);
                os.write(catalog.getBytes(this.connection.getEncoding()));
            }
            if (null == schemaPattern) {
                os.writeInt(-1);
            } else {
                os.writeInt(schemaPattern.getBytes(this.connection.getEncoding()).length);
                os.write(schemaPattern.getBytes(this.connection.getEncoding()));
            }
            if (null == tableNamePattern) {
                os.writeInt(-1);
            } else {
                os.writeInt(tableNamePattern.getBytes(this.connection.getEncoding()).length);
                os.write(tableNamePattern.getBytes(this.connection.getEncoding()));
            }
            if (null == types) {
                os.writeInt(-1);
            } else {
                for (int i = 0; i < types.length; ++i) {
                    os.writeInt(types[i].getBytes(this.connection.getEncoding()).length);
                    os.write(types[i].getBytes(this.connection.getEncoding()));
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        EXAResult[] results = this.connection.communication_resultset(bas.toByteArray(), (byte)68, execStatus, null);
        this.connection.metadataAcquired();
        if (results != null && results.length > 0) {
            if (results[0] instanceof EXASQLException) {
                throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)results[0];
        }
        return null;
    }

    private synchronized ResultSet getTablesSql(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        int numWhere;
        int i;
        if (this.debug != null) {
            StringBuffer call = new StringBuffer("getTables(");
            call.append(catalog);
            call.append(",");
            call.append(schemaPattern);
            call.append(",");
            call.append(tableNamePattern);
            call.append(",[");
            if (types != null) {
                for (int i2 = 0; i2 < types.length; ++i2) {
                    call.append(types[i2]);
                    call.append(",");
                }
            }
            call.append("])");
            this.log(call.toString());
        }
        StringBuffer sql = new StringBuffer("/*snapshot execution*/ select \"TABLE_CAT\",\"TABLE_SCHEM\",\"TABLE_NAME\",\"TABLE_TYPE\",\"REMARKS\",\"TYPE_CAT\",\"TYPE_SCHEM\",\"TYPE_NAME\",\"SELF_REFERENCING_COL_NAME\",\"REF_GENERATION\" from ");
        sql.append(METADATA_SCHEMA);
        sql.append(".");
        sql.append(ALL_TABLES);
        Vector<String> wheres = new Vector<String>();
        if (catalog != null) {
            if ("".equals(catalog)) {
                wheres.addElement(" \"TABLE_CAT\" is null ");
            } else {
                wheres.addElement(" \"TABLE_CAT\" like '" + catalog + "' ");
            }
        }
        if (schemaPattern != null) {
            if ("".equals(schemaPattern)) {
                wheres.addElement(" \"TABLE_SCHEM\" is null ");
            } else {
                wheres.addElement(" \"TABLE_SCHEM\" like '" + schemaPattern + "' ");
            }
        }
        if (tableNamePattern != null) {
            if ("".equals(tableNamePattern)) {
                wheres.addElement(" \"TABLE_NAME\" is null ");
            } else {
                wheres.addElement(" \"TABLE_NAME\" like '" + tableNamePattern + "' ");
            }
        }
        if (types != null && types.length > 0) {
            StringBuffer tp = new StringBuffer(" \"TABLE_TYPE\" in (");
            for (i = 0; i < types.length; ++i) {
                tp.append("'");
                tp.append(types[i]);
                tp.append("'");
                if (i >= types.length - 1) continue;
                tp.append(',');
            }
            tp.append(") ");
            wheres.addElement(tp.toString());
        }
        if ((numWhere = wheres.size()) > 0) {
            sql.append(" WHERE ");
            for (i = 0; i < numWhere; ++i) {
                sql.append(wheres.elementAt(i).toString());
                if (i >= numWhere - 1) continue;
                sql.append(" AND ");
            }
        }
        sql.append(" order by \"TABLE_TYPE\",\"TABLE_SCHEM\",\"TABLE_NAME\" ");
        if (this.metaStmt.execute(sql.toString())) {
            ResultSet rs = this.metaStmt.getResultSet();
            return rs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTableTypes() throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("getTableTypes()");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetTableTypes();
            }
            return this.getTableTypesSql();
        }
    }

    private ResultSet jdbcGetTableTypes() throws SQLException {
        ExecutionStatus execStatus = new ExecutionStatus();
        EXAResult[] results = this.connection.communication_resultset(new byte[0], (byte)69, execStatus, null);
        this.connection.metadataAcquired();
        if (results != null && results.length > 0) {
            if (results[0] instanceof EXASQLException) {
                throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)results[0];
        }
        return null;
    }

    protected ResultSet getTableTypesSql() throws SQLException {
        ResultSet rs = null;
        try {
            StringBuffer sql = new StringBuffer("/*snapshot execution*/ select \"TABLE_TYPE\" from ");
            sql.append(METADATA_SCHEMA);
            sql.append(".TABLE_TYPES order by \"TABLE_TYPE\"");
            if (this.metaStmt.execute(sql.toString())) {
                rs = this.metaStmt.getResultSet();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (rs == null) {
            rs = this.connection.dialectFactory.createResultSet("TABLE_TYPE", tableTypes, this.debug);
        }
        return rs;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        this.log("getTimeDateFunctions()");
        return this.getPropString("timeDateFunctions", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getTypeInfo() throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("getTypeInfo()");
            if (this.connection.getActiveProtocolVersion() >= 14 && 0 == this.metadataSQL) {
                return this.jdbcGetTypeInfo();
            }
            return this.getTypeInfoSql();
        }
    }

    private ResultSet jdbcGetTypeInfo() throws SQLException {
        ExecutionStatus execStatus = new ExecutionStatus();
        EXAResult[] results = this.connection.communication_resultset(new byte[0], (byte)70, execStatus, null);
        this.connection.metadataAcquired();
        if (results != null && results.length > 0) {
            if (results[0] instanceof EXASQLException) {
                throw ((EXASQLException)results[0]).getSQLExceptionIntern(this.connection);
            }
            return (EXAResultSet)results[0];
        }
        return null;
    }

    protected ResultSet getTypeInfoSql() throws SQLException {
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer("/*snapshot execution*/ SELECT ");
        sql.append("\"TYPE_NAME\",");
        sql.append("case \"DATA_TYPE\" when -7 then 16 else \"DATA_TYPE\" end as \"DATA_TYPE\",");
        sql.append("\"PRECISION\",");
        sql.append("\"LITERAL_PREFIX\",");
        sql.append("\"LITERAL_SUFFIX\",");
        sql.append("\"CREATE_PARAMS\",");
        sql.append("cast (case \"NULLABLE\" when false then 0 when true then 1 end as smallint) as \"NULLABLE\",");
        sql.append("\"CASE_SENSITIVE\",");
        sql.append("\"SEARCHABLE\",");
        sql.append("\"UNSIGNED_ATTRIBUTE\",");
        sql.append("\"FIXED_PREC_SCALE\",");
        sql.append("\"AUTO_INCREMENT\",");
        sql.append("\"LOCAL_TYPE_NAME\",");
        sql.append("cast (\"MINIMUM_SCALE\" as smallint) as \"MINIMUM_SCALE\",");
        sql.append("cast (\"MAXIMUM_SCALE\" as smallint) as \"MAXIMUM_SCALE\",");
        sql.append("\"SQL_DATA_TYPE\",");
        sql.append("\"SQL_DATETIME_SUB\",");
        sql.append("\"NUM_PREC_RADIX\" ");
        sql.append("FROM ");
        sql.append(METADATA_SCHEMA);
        sql.append(".SQL_TYPES ORDER BY \"DATA_TYPE\"");
        if (this.metaStmt.execute(sql.toString())) {
            rs = this.metaStmt.getResultSet();
        }
        if (null == rs) {
            throw new SQLException(Translator.Failed_to_get_types_info_from_server());
        }
        return rs;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        this.log("getUDTs(" + catalog + "," + schemaPattern + "," + typeNamePattern + ")");
        EXAResultSet meta = this.connection.dialectFactory.createResultSet(this.debug);
        Column[] cols = new Column[]{new CharColumn(30), new CharColumn(30), new CharColumn(30), new CharColumn(30), new DecimalColumn(18, 0), new CharColumn(30), new DecimalColumn(18, 0)};
        meta.addColumn(cols[0], "TYPE_CAT");
        meta.addColumn(cols[1], "TYPE_SCHEM");
        meta.addColumn(cols[2], "TYPE_NAME");
        meta.addColumn(cols[3], "CLASS_NAME");
        meta.addColumn(cols[4], "DATA_TYPE");
        meta.addColumn(cols[5], "REMARKS");
        meta.addColumn(cols[6], "BASE_TYPE");
        meta.resize(0);
        return meta;
    }

    @Override
    public String getURL() {
        String url = this.connection.getURL();
        this.log("getURL():" + url);
        return url;
    }

    @Override
    public String getUserName() {
        this.log("getUserName():" + this.connection.getUser());
        return this.connection.getUser();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        this.log("getVersionColumns(" + catalog + "," + schema + "," + table + ")");
        EXAResultSet result = this.connection.dialectFactory.createResultSet(this.debug);
        result.addColumn(new DecimalColumn(18, 0), "SCOPE");
        result.addColumn(new CharColumn(30), "COLUMN_NAME");
        result.addColumn(new DecimalColumn(18, 0), "DATA_TYPE");
        result.addColumn(new CharColumn(30), "TYPE_NAME");
        result.addColumn(new DecimalColumn(18, 0), "COLUMN_SIZE");
        result.addColumn(new DecimalColumn(18, 0), "BUFFER_LENGTH");
        result.addColumn(new DecimalColumn(18, 0), "DECIMAL_DIGITS");
        result.addColumn(new DecimalColumn(18, 0), "PSEUDO_COLUMN");
        result.resize(0);
        return result;
    }

    @Override
    public boolean insertsAreDetected(int type) {
        this.log("insertsAreDetected(" + type + "):false");
        return false;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        this.log("isCatalogAtStart()");
        return this.getPropBoolean("isCatalogAtStart", false);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.log("isReadOnly()");
        return this.getPropBoolean("isReadOnly", true);
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        if (this.debug != null) {
            this.log("locatorsUpdateCopy()");
        }
        return this.getPropBoolean("locatorsUpdateCopy", false);
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        this.log("nullPlusNonNullIsNull()");
        return this.getPropBoolean("nullPlusNonNullIsNull", true);
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        this.log("nullsAreSortedAtEnd()");
        return this.getPropBoolean("nullsAreSortedAtEnd", false);
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        this.log("nullsAreSortedAtStart()");
        return this.getPropBoolean("nullsAreSortedAtStart", false);
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        this.log("nullsAreSortedHigh()");
        return this.getPropBoolean("nullsAreSortedHigh", false);
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        this.log("nullsAreSortedLow()");
        return this.getPropBoolean("nullsAreSortedLow", true);
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        this.log("othersDeletesAreVisible(" + type + "):false");
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        this.log("othersInsertsAreVisible(" + type + "):false");
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        this.log("othersUpdatesAreVisible(" + type + "):false");
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        this.log("ownDeletesAreVisible(" + type + "):false");
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        this.log("ownInsertsAreVisible(" + type + "):false");
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        this.log("ownUpdatesAreVisible(" + type + "):false");
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        this.log("storesLowerCaseIdentifiers()");
        return this.getPropBoolean("storesLowerCaseIdentifiers", false);
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        this.log("storesLowerCaseQuotedIdentifiers()");
        return this.getPropBoolean("storesLowerCaseQuotedIdentifiers", false);
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        this.log("storesMixedCaseIdentifiers()");
        return this.getPropBoolean("storesMixedCaseIdentifiers", false);
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        this.log("storesMixedCaseQuotedIdentifiers()");
        return this.getPropBoolean("storesMixedCaseQuotedIdentifiers", false);
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        this.log("storesUpperCaseIdentifiers()");
        return this.getPropBoolean("storesUpperCaseIdentifiers", true);
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        this.log("storesUpperCaseQuotedIdentifiers()");
        return this.getPropBoolean("storesUpperCaseQuotedIdentifiers", false);
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        this.log("supportsAlterTableWithAddColumn()");
        return this.getPropBoolean("supportsAlterTableWithAddColumn", false);
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        this.log("supportsAlterTableWithDropColumn()");
        return this.getPropBoolean("supportsAlterTableWithDropColumn", false);
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        if (this.debug != null) {
            this.log("supportsANSI92EntryLevelSQL()");
        }
        return this.getPropBoolean("supportsANSI92EntryLevelSQL", false);
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        if (this.debug != null) {
            this.log("supportsANSI92FullSQL()");
        }
        return this.getPropBoolean("supportsANSI92FullSQL", false);
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        if (this.debug != null) {
            this.log("supportsANSI92IntermediateSQL()");
        }
        return this.getPropBoolean("supportsANSI92IntermediateSQL", false);
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        if (this.debug != null) {
            this.log("supportsBatchUpdates()");
        }
        return this.getPropBoolean("supportsBatchUpdates", true);
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        if (this.debug != null) {
            this.log("supportsCatalogsInDataManipulation()");
        }
        return this.getPropBoolean("supportsCatalogsInDataManipulation", false);
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        if (this.debug != null) {
            this.log("supportsCatalogsInIndexDefinitions()");
        }
        return this.getPropBoolean("supportsCatalogsInIndexDefinitions", false);
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        if (this.debug != null) {
            this.log("supportsCatalogsInPrivilegeDefinitions()");
        }
        return this.getPropBoolean("supportsCatalogsInPrivilegeDefinitions", false);
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        if (this.debug != null) {
            this.log("supportsCatalogsInProcedureCalls()");
        }
        return this.getPropBoolean("supportsCatalogsInProcedureCalls", false);
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        if (this.debug != null) {
            this.log("supportsCatalogsInTableDefinitions()");
        }
        return this.getPropBoolean("supportsCatalogsInTableDefinitions", false);
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        if (this.debug != null) {
            this.log("supportsColumnAliasing()");
        }
        return this.getPropBoolean("supportsColumnAliasing", true);
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        if (this.debug != null) {
            this.log("supportsConvert()");
        }
        return this.getPropBoolean("supportsConvert", false);
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        if (this.debug != null) {
            this.log("supportsConvert(" + fromType + "," + toType + "):false");
        }
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        if (this.debug != null) {
            this.log("supportsCoreSQLGrammar()");
        }
        return this.getPropBoolean("supportsCoreSQLGrammar", false);
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        if (this.debug != null) {
            this.log("supportsCorrelatedSubqueries()");
        }
        return this.getPropBoolean("supportsCorrelatedSubqueries", false);
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        if (this.debug != null) {
            this.log("supportsDataDefinitionAndDataManipulationTransactions()");
        }
        return this.getPropBoolean("supportsDataDefinitionAndDataManipulationTransactions", true);
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        if (this.debug != null) {
            this.log("supportsDataManipulationTransactionsOnly()");
        }
        return this.getPropBoolean("supportsDataManipulationTransactionsOnly", false);
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        if (this.debug != null) {
            this.log("supportsDifferentTableCorrelationNames()");
        }
        return this.getPropBoolean("supportsDifferentTableCorrelationNames", false);
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        if (this.debug != null) {
            this.log("supportsExpressionsInOrderBy()");
        }
        return this.getPropBoolean("supportsExpressionsInOrderBy", true);
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        if (this.debug != null) {
            this.log("supportsExtendedSQLGrammar()");
        }
        return this.getPropBoolean("supportsExtendedSQLGrammar", false);
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        if (this.debug != null) {
            this.log("supportsFullOuterJoins()");
        }
        return this.getPropBoolean("supportsFullOuterJoins", false);
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        if (this.debug != null) {
            this.log("supportsGetGeneratedKeys()");
        }
        return this.getPropBoolean("supportsGetGeneratedKeys", false);
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        if (this.debug != null) {
            this.log("supportsGroupBy()");
        }
        return this.getPropBoolean("supportsGroupBy", true);
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        if (this.debug != null) {
            this.log("supportsGroupByBeyondSelect()");
        }
        return this.getPropBoolean("supportsGroupByBeyondSelect", false);
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        if (this.debug != null) {
            this.log("supportsGroupByUnrelated()");
        }
        return this.getPropBoolean("supportsGroupByUnrelated", true);
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        if (this.debug != null) {
            this.log("supportsIntegrityEnhancementFacility()");
        }
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        if (this.debug != null) {
            this.log("supportsLikeEscapeClause()");
        }
        return this.getPropBoolean("supportsLikeEscapeClause", false);
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        if (this.debug != null) {
            this.log("supportsLimitedOuterJoins()");
        }
        return this.getPropBoolean("supportsLimitedOuterJoins", true);
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        if (this.debug != null) {
            this.log("supportsMinimumSQLGrammar()");
        }
        return this.getPropBoolean("supportsMinimumSQLGrammar", false);
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        if (this.debug != null) {
            this.log("supportsMixedCaseIdentifiers()");
        }
        return this.getPropBoolean("supportsMixedCaseIdentifiers", true);
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        if (this.debug != null) {
            this.log("supportsMixedCaseQuotedIdentifiers()");
        }
        return this.getPropBoolean("supportsMixedCaseQuotedIdentifiers", true);
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        if (this.debug != null) {
            this.log("supportsMultipleResultSets()");
        }
        return this.getPropBoolean("supportsMultipleResultSets", true);
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        if (this.debug != null) {
            this.log("supportsMultipleOpenResults()");
        }
        return this.getPropBoolean("supportsMultipleOpenResults", true);
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        if (this.debug != null) {
            this.log("supportsMultipleTransactions()");
        }
        return this.getPropBoolean("supportsMultipleTransactions", false);
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        if (this.debug != null) {
            this.log("supportsNamedParameters()");
        }
        return this.getPropBoolean("supportsNamedParameters", false);
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        if (this.debug != null) {
            this.log("supportsNonNullableColumns()");
        }
        return this.getPropBoolean("supportsNonNullableColumns", false);
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        if (this.debug != null) {
            this.log("supportsOpenCursorsAcrossCommit()");
        }
        return this.getPropBoolean("supportsOpenCursorsAcrossCommit", false);
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        if (this.debug != null) {
            this.log("supportsOpenCursorsAcrossRollback()");
        }
        return this.getPropBoolean("supportsOpenCursorsAcrossRollback", false);
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        if (this.debug != null) {
            this.log("supportsOpenStatementsAcrossCommit()");
        }
        return this.getPropBoolean("supportsOpenStatementsAcrossCommit", true);
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        if (this.debug != null) {
            this.log("supportsOpenStatementsAcrossRollback()");
        }
        return this.getPropBoolean("supportsOpenStatementsAcrossRollback", true);
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        if (this.debug != null) {
            this.log("supportsOrderByUnrelated()");
        }
        return this.getPropBoolean("supportsOrderByUnrelated", true);
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        if (this.debug != null) {
            this.log("supportsOuterJoins()");
        }
        return this.getPropBoolean("supportsOuterJoins", true);
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        if (this.debug != null) {
            this.log("supportsPositionedDelete()");
        }
        return this.getPropBoolean("supportsPositionedDelete", false);
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        if (this.debug != null) {
            this.log("supportsPositionedUpdate()");
        }
        return this.getPropBoolean("supportsPositionedUpdate", false);
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        if (this.debug != null) {
            this.log("supportsResultSetConcurrency(" + type + "," + concurrency + "):false");
        }
        switch (type) {
            case 1003: {
                switch (concurrency) {
                    case 1007: {
                        return true;
                    }
                    case 1008: {
                        return false;
                    }
                }
            }
            case 1004: {
                switch (concurrency) {
                    case 1007: {
                        return true;
                    }
                    case 1008: {
                        return false;
                    }
                }
            }
            case 1005: {
                switch (concurrency) {
                    case 1007: {
                        return true;
                    }
                    case 1008: {
                        return false;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean supportsResultSetHoldability(int i) throws SQLException {
        int holdability;
        if (this.debug != null) {
            this.log("supportsResultSetHoldability(" + i + "): false");
        }
        return (holdability = this.getPropInt("supportedResultSetHoldability", 3)) == i;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        if (this.debug != null) {
            this.log("supportsResultSetType(" + type + ")");
        }
        return this.getPropInt("supportedResultSetTypes", 1004) == type;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSavepoints(): false");
        }
        return this.getPropBoolean("supportsSavepoints", false);
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSchemasInDataManipulation()");
        }
        return this.getPropBoolean("supportsSchemasInDataManipulation", true);
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSchemasInIndexDefinitions()");
        }
        return this.getPropBoolean("supportsSchemasInIndexDefinitions", false);
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSchemasInPrivilegeDefinitions()");
        }
        return this.getPropBoolean("supportsSchemasInPrivilegeDefinitions", false);
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSchemasInProcedureCalls()");
        }
        return this.getPropBoolean("supportsSchemasInProcedureCalls", false);
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSchemasInTableDefinitions()");
        }
        return this.getPropBoolean("supportsSchemasInTableDefinitions", true);
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSelectForUpdate()");
        }
        return this.getPropBoolean("supportsSelectForUpdate", false);
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        if (this.debug != null) {
            this.log("supportsStatementPooling()");
        }
        return this.getPropBoolean("supportsStatementPooling", false);
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        if (this.debug != null) {
            this.log("supportsStoredProcedures()");
        }
        return this.getPropBoolean("supportsStoredProcedures", false);
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSubqueriesInComparisons()");
        }
        return this.getPropBoolean("supportsSubqueriesInComparisons", false);
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSubqueriesInExists()");
        }
        return this.getPropBoolean("supportsSubqueriesInExists", false);
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSubqueriesInIns()");
        }
        return this.getPropBoolean("supportsSubqueriesInIns", false);
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        if (this.debug != null) {
            this.log("supportsSubqueriesInQuantifieds()");
        }
        return this.getPropBoolean("supportsSubqueriesInQuantifieds", false);
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        if (this.debug != null) {
            this.log("supportsTableCorrelationNames()");
        }
        return this.getPropBoolean("supportsTableCorrelationNames", false);
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        if (this.debug != null) {
            this.log("supportsTransactionIsolationLevel(" + level + "):" + (level == 8));
        }
        return level == 8;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        if (this.debug != null) {
            this.log("supportsTransactions()");
        }
        return this.getPropBoolean("supportsTransactions", true);
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        if (this.debug != null) {
            this.log("supportsUnion()");
        }
        return this.getPropBoolean("supportsUnion", false);
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        if (this.debug != null) {
            this.log("supportsUnionAll()");
        }
        return this.getPropBoolean("supportsUnionAll", false);
    }

    @Override
    public boolean updatesAreDetected(int type) {
        if (this.debug != null) {
            this.log("updatesAreDetected(" + type + "):false");
        }
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        if (this.debug != null) {
            this.log("usesLocalFilePerTable()");
        }
        return this.getPropBoolean("usesLocalFilePerTable", false);
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        if (this.debug != null) {
            this.log("usesLocalFiles()");
        }
        return this.getPropBoolean("usesLocalFiles", false);
    }

    public String getDatabaseName() throws SQLException {
        this.log("getDatabaseName()");
        if (null != this.databaseName) {
            return this.databaseName;
        }
        return this.getPropString("databaseName", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeMetadata() throws SQLException {
        EXAConnection eXAConnection = this.connection;
        synchronized (eXAConnection) {
            this.log("initializeMetadata(): start");
            try (EXAStatement st = (EXAStatement)this.connection.createStatement();){
                if (st.getActiveProtocolVersion() >= 14 && this.metadataSQL == 0) {
                    this.readSQLCommands((EXAResultSet)st.GetCommands());
                    this.readStaticProps(st.GetDbMetadata(null, "true"));
                } else {
                    StringBuffer sqlCmd = new StringBuffer("/*snapshot execution*/ select \"COMMAND\",\"IS_PLSQL\" from ");
                    sqlCmd.append(METADATA_SCHEMA);
                    sqlCmd.append(".SQL_COMMANDS order by \"COMMAND\"");
                    StringBuffer propsCmd = new StringBuffer("/*snapshot execution*/ select \"NAME\",\"VALUE\" from ");
                    propsCmd.append(METADATA_SCHEMA);
                    propsCmd.append(".");
                    propsCmd.append(DB_METADATA);
                    propsCmd.append(" where \"STATIC\"=true");
                    this.log("createStatement to initialize metadata");
                    st.addBatch(sqlCmd.toString());
                    st.addBatch(propsCmd.toString());
                    st.executeBatch();
                    EXAResultSet rs1 = (EXAResultSet)st.getResultSet();
                    this.readSQLCommands(rs1);
                    if (!st.getMoreResults()) {
                        throw new SQLException(Translator.Expected_2nd_resultset_unavailable());
                    }
                    this.readStaticProps(st.getResultSet());
                }
            }
            catch (ConnectionException ce) {
                this.log("failed to fetch static metadata from EXA: " + ce.toString());
                throw ce;
            }
            catch (SQLException e) {
                this.log("failed to fetch static metadata from EXA: " + e.toString());
                throw e;
            }
            this.log("initializeMetadata(): end (success)");
        }
    }

    private void readSQLCommands(EXAResultSet rs) throws SQLException {
        this.log("readSQLCommands()");
        if (rs != null) {
            this.sqlCommands = new Vector();
            this.plsqlCommands = new Vector();
            rs.first();
            int i = 0;
            while ((long)i < rs.getNumberOfRows()) {
                String cmd = rs.getString(1);
                boolean isplsql = rs.getBoolean(2);
                if (cmd != null && cmd.length() > 0) {
                    if (isplsql) {
                        this.plsqlCommands.addElement(cmd);
                    } else {
                        this.sqlCommands.addElement(cmd);
                    }
                }
                rs.next();
                ++i;
            }
        }
    }

    private void readStaticProps(ResultSet rs) throws SQLException {
        if (rs != null) {
            rs.first();
            this.staticProps = new HashMap();
            if (!rs.isAfterLast()) {
                do {
                    String key = rs.getString(1);
                    String value = rs.getString(2);
                    if (null == value) {
                        value = "";
                    }
                    this.log("Received static DB metainfo: " + key + "=" + value);
                    this.staticProps.put(key, value);
                } while (rs.next());
            }
        }
    }

    public Vector getSQLCommands() {
        if (null == this.sqlCommands) {
            this.log("getSQLCommands: Need metadata.");
            try {
                this.initializeMetadata();
            }
            catch (Exception ex) {
                this.log("Metadata not initialized: " + ex.toString());
                return null;
            }
            this.log("Metadata initialized.");
        }
        return this.sqlCommands;
    }

    public Vector getPLSQLCommands() {
        if (null == this.plsqlCommands) {
            this.log("getPLSQLCommands: Need metadata.");
            try {
                this.initializeMetadata();
            }
            catch (Exception ex) {
                this.log("Metadata not initialized: " + ex.toString());
                return null;
            }
            this.log("Metadata initialized.");
        }
        return this.plsqlCommands;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

