/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc.importExport;

import com.exasol.jdbc.ClusterNode;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXASocketFactory;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.importExport.EXARetryPushException;
import com.exasol.jdbc.importExport.FileValidator;
import com.exasol.jdbc.importExport.HTTPThread;
import com.exasol.jdbc.importExport.HttpPush;
import com.exasol.jdbc.importExport.MultiFileInputStream;
import com.exasol.jdbc.importExport.QueryManipulator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

public class HttpPushTool {
    final String sql;
    final HttpPush hp;
    final String[] files;
    final String[] errFiles;
    final String cookie;
    final String errCookie;
    DebugLog debug = null;
    final PrintStream logPrinterOut;
    final PrintStream logPrinterErr;
    private static final int MINIMUM_DB_VERSION_SUPPORT_CERTIFICATE_VERIFICATION = 83200;
    HTTPThread hpt = null;

    public void KillHttpPushToolThread() {
        if (this.hpt != null) {
            try {
                this.hpt.InterruptThread();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public HttpPushTool(HttpPush hp, HttpPush hpErr, String sql, String[] files, String[] errFiles, String cookie, String errCookie, DebugLog log, PrintStream logPrinterOut, PrintStream logPrinterErr) {
        this.sql = sql;
        this.hp = hp;
        this.files = files;
        this.errFiles = errFiles;
        this.cookie = cookie;
        this.errCookie = errCookie;
        this.debug = log;
        this.logPrinterOut = logPrinterOut;
        this.logPrinterErr = logPrinterErr;
        this.hpt = new HTTPThread(hp, files, cookie, log, logPrinterOut, logPrinterErr);
        this.hpt.start();
        if (null != hpErr) {
            this.hpt = new HTTPThread(hpErr, errFiles, errCookie, log, logPrinterOut, logPrinterErr);
            this.hpt.start();
        }
    }

    public void logOut(String msg) {
        if (this.debug != null) {
            this.debug.log(msg);
        }
        if (this.logPrinterOut != null) {
            this.logPrinterOut.println(msg);
        }
    }

    public void logErr(String msg) {
        if (this.debug != null) {
            this.debug.log(msg);
        }
        if (this.logPrinterErr != null) {
            this.logPrinterErr.println(msg);
        }
    }

    public void logErr(Throwable t) {
        if (this.debug != null) {
            this.debug.log(t);
        }
        if (this.logPrinterErr != null) {
            t.printStackTrace(this.logPrinterErr);
        }
    }

    public static HttpPushTool transformCommand(String sql, Vector clusterNodes) throws IOException, SQLException {
        return HttpPushTool.transformCommand(sql, clusterNodes, false, null, null, null, 0);
    }

    public static HttpPushTool transformCommand(String sql, Vector clusterNodes, boolean connectionIsEncrypted, DebugLog log) throws IOException, SQLException {
        return HttpPushTool.transformCommand(sql, clusterNodes, connectionIsEncrypted, log, null, null, 0);
    }

    public static HttpPushTool transformCommand(String sql, Vector clusterNodes, boolean connectionIsEncrypted, DebugLog log, int dbVersion) throws IOException, SQLException {
        return HttpPushTool.transformCommand(sql, clusterNodes, connectionIsEncrypted, log, null, null, dbVersion);
    }

    public static HttpPushTool transformCommand(String inputsql, Vector clusterNodes, boolean connectionIsEncrypted, DebugLog log, PrintStream logPrinterOut, PrintStream logPrinterErr, int dbVersion) throws IOException, SQLException {
        Vector<ClusterNode> expandedAllNodes;
        if (inputsql == null || inputsql.equals("")) {
            return null;
        }
        FileValidator pattern = new FileValidator(inputsql);
        if (!pattern.Match()) {
            return null;
        }
        if (connectionIsEncrypted) {
            pattern.setSecure(true);
        }
        if (null == clusterNodes) {
            throw new SQLException("Cannot connect, no hosts known.", "04506");
        }
        if (!pattern.GenerateCookie()) {
            throw new SQLException("Cookie cannot be generated.", "04506");
        }
        if (log != null) {
            log.log(Translator.UseCookie(pattern.getCookie()));
            if (pattern.getCookieErr() != null) {
                log.log(Translator.UseCookie("Error table cookie: " + pattern.getCookie()));
            }
        }
        if (logPrinterOut != null) {
            logPrinterOut.println(Translator.UseCookie(pattern.getCookie()));
            if (pattern.getCookieErr() != null) {
                logPrinterOut.println(Translator.UseCookie("Error table cookie: " + pattern.getCookie()));
            }
        }
        String[] files = pattern.getFiles();
        String errFile = pattern.getErrFiles();
        String[] errFiles = null;
        if (errFile != null) {
            errFiles = new String[]{errFile};
        }
        if (log != null) {
            log.log("HttpPushTool files:");
            for (String file : files) {
                log.log(Translator.File(file));
            }
            if (null != errFiles) {
                for (String _errFile : errFiles) {
                    log.log(Translator.File(_errFile));
                }
            }
        }
        if (logPrinterOut != null) {
            for (String file : files) {
                logPrinterOut.println(Translator.File(file));
            }
            if (null != errFiles) {
                for (String _errFile : errFiles) {
                    logPrinterOut.println(Translator.File(_errFile));
                }
            }
        }
        if ((expandedAllNodes = HttpPushTool.ExpandAll(clusterNodes, log)) == null) {
            throw new IOException("HttpPushTool: Cannot expand host name(s).");
        }
        Vector expandedAllNodesErr = (Vector)expandedAllNodes.clone();
        Socket sock = null;
        Socket errSock = null;
        HttpPush hp = null;
        HttpPush hpErr = null;
        Collections.shuffle(expandedAllNodes);
        Collections.shuffle(expandedAllNodesErr);
        Enumeration<ClusterNode> e = expandedAllNodes.elements();
        while (e.hasMoreElements()) {
            hp = null;
            ClusterNode n = e.nextElement();
            try {
                sock = HttpPushTool.GetNewSocket(n, log, logPrinterErr, inputsql);
            }
            catch (IOException ioex) {
                if (log != null) {
                    log.log("Socket (" + n.GetHost() + ":" + n.GetPort() + ") creation failed. Exception: " + ioex.getMessage());
                }
                if (sock == null) continue;
                try {
                    sock.close();
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                hp = new HttpPush(sock, files, pattern.getCookie(), pattern.IsSecure(), true);
                break;
            }
            catch (EXARetryPushException rp) {
                if (log != null) {
                    log.log("EXARetryPushException occurred during HttpPush initialization of host (" + n.GetHost() + ":" + n.GetPort() + "): " + rp.getMessage());
                }
                if (hp != null) {
                    try {
                        hp.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (sock == null) continue;
                try {
                    sock.close();
                }
                catch (Exception exception) {}
            }
        }
        if (errFiles != null) {
            hpErr = null;
            Enumeration er = expandedAllNodesErr.elements();
            while (er.hasMoreElements()) {
                ClusterNode nr = (ClusterNode)er.nextElement();
                try {
                    errSock = HttpPushTool.GetNewSocket(nr, log, logPrinterErr, inputsql);
                }
                catch (IOException ioex) {
                    if (log != null) {
                        log.log("Socket (" + nr.GetHost() + ":" + nr.GetPort() + ") for error handling creation failed. Exception: " + ioex.getMessage());
                    }
                    if (errSock == null) continue;
                    try {
                        errSock.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                try {
                    hpErr = new HttpPush(errSock, errFiles, pattern.getCookieErr(), pattern.IsSecure(), true);
                    break;
                }
                catch (EXARetryPushException rp) {
                    if (log != null) {
                        log.log("EXARetryPushException occurred during HttpPush initialization of host (" + nr.GetHost() + ":" + nr.GetPort() + ") for error handling: " + rp.getMessage());
                    }
                    if (hpErr != null) {
                        try {
                            hpErr.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (errSock == null) continue;
                    try {
                        errSock.close();
                    }
                    catch (Exception exception) {}
                }
                catch (Exception ex) {
                    throw ex;
                }
            }
        }
        String URL2 = null;
        String myhttp = pattern.IsSecure() ? "https" : "http";
        String sha256PublicKeyHash = null;
        if (hp != null) {
            String remotehost = hp.getRemoteHost();
            int remoteport = hp.getRemotePort();
            if (log != null) {
                log.log("HttpPushTool remote host: " + remotehost + ":" + remoteport);
            }
            URL2 = myhttp + "://" + remotehost + ":" + remoteport;
            try {
                sha256PublicKeyHash = hp.getKeyManager().getCertificateBuilder().getCertificatePublicKeySHA256Hash();
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException ex) {
                if (log != null) {
                    log.log("Certificate SHA256 Public Key Hash Generation Failed. Exception: " + ex.getLocalizedMessage());
                }
            }
        } else {
            if (log != null) {
                log.log("HTTP Protocol cannot be instantiated");
            }
            throw new SQLException("HTTP Protocol cannot be instantiated");
        }
        String URLError = null;
        String sha256PublicKeyHashErr = null;
        if (errFiles != null) {
            if (hpErr != null) {
                String remotehostErr = hpErr.getRemoteHost();
                int remoteportErr = hpErr.getRemotePort();
                if (log != null) {
                    log.log("HttpPushTool Error: remote host: " + remotehostErr + ":" + remoteportErr);
                }
                URLError = myhttp + "://" + remotehostErr + ":" + remoteportErr;
                try {
                    sha256PublicKeyHashErr = hpErr.getKeyManager().getCertificateBuilder().getCertificatePublicKeySHA256Hash();
                }
                catch (IOException | NoSuchAlgorithmException | CertificateException ex) {
                    if (log != null) {
                        log.log("Certificate SHA256 Public Key Hash Generation Failed for error file connection. Exception: " + ex.getLocalizedMessage());
                    }
                }
            } else {
                if (log != null) {
                    log.log("HTTP Protocol cannot be instantiated for error handling files");
                }
                throw new SQLException("HTTP Protocol cannot be instantiated for error handling files");
            }
        }
        String sql = QueryManipulator.BuildImpExpQuery(URL2, URLError, pattern, dbVersion >= 83200, sha256PublicKeyHash, sha256PublicKeyHashErr);
        HttpPushTool ht = new HttpPushTool(hp, hpErr, sql, files, errFiles, pattern.getCookie(), pattern.getCookieErr(), log, logPrinterOut, logPrinterErr);
        if (log != null) {
            log.log("HttpPushTool created. ");
        }
        return ht;
    }

    private static Vector<ClusterNode> ExpandAll(Vector<ClusterNode> clusterNodes, DebugLog log) {
        Vector<ClusterNode> hosts = new Vector<ClusterNode>();
        Enumeration<ClusterNode> e = clusterNodes.elements();
        while (e.hasMoreElements()) {
            ClusterNode n = e.nextElement();
            try {
                InetAddress[] expandedHosts = null;
                if (log != null) {
                    log.log("Resolving hostname: " + n.GetHost() + ":" + n.GetPort());
                }
                try {
                    expandedHosts = InetAddress.getAllByName(n.GetHost());
                }
                catch (UnknownHostException uhex) {
                    if (log == null) continue;
                    log.log("Hostname (" + n.GetHost() + ") could not be resolved: " + uhex.getMessage());
                    continue;
                }
                if (log != null) {
                    log.log("Found " + expandedHosts.length + " addresses.");
                }
                for (InetAddress addr : expandedHosts) {
                    if (log != null) {
                        log.log(" - " + addr.getHostAddress());
                    }
                    hosts.add(new ClusterNode(addr.getHostAddress(), n.GetPort()));
                }
            }
            catch (Exception ex) {
                if (log == null) continue;
                log.log("An unexpected error occurred while processing host (" + n.GetHost() + "): " + ex.getLocalizedMessage());
            }
        }
        return hosts;
    }

    static Socket GetNewSocket(ClusterNode n, DebugLog log, PrintStream logPrinterErr, String sql) throws IOException {
        Socket sock = null;
        try {
            EXASocketFactoryInstance factory = new EXASocketFactoryInstance();
            InetAddress addr = InetAddress.getByName(n.GetHost());
            if (log != null) {
                log.log("HttpPushTool creating socket " + addr.getHostAddress() + " : " + n.GetPort());
            }
            sock = new Socket(addr.getHostAddress(), n.GetPort());
        }
        catch (Exception ex) {
            if (log != null) {
                log.log(ex.toString());
            }
            throw ex;
        }
        if (sock == null) {
            if (log != null) {
                log.log(Translator.Connect_failed());
            }
            if (logPrinterErr != null) {
                logPrinterErr.println(Translator.Connect_failed());
            }
            throw new IOException(Translator.Connect_for_SQL_failed(sql));
        }
        if (log != null) {
            log.log("HttpPushTool socket created.");
        }
        return sock;
    }

    public void close() throws IOException {
        this.hp.close();
    }

    private Thread getPushThread() {
        return this.hpt;
    }

    public String getSQL() {
        return this.sql;
    }

    public void checkForErrors() throws IOException {
        this.hpt.checkForErrors();
    }

    private static class EXASocketFactoryInstance
    extends EXASocketFactory {
        private EXASocketFactoryInstance() {
        }

        @Override
        public Socket createCustomSocket(InetAddress host, int port, int timeout) {
            return null;
        }
    }

    public static class PullFile
    implements HttpPush.PullFileInterface {
        private FileOutputStream fout = null;
        private byte[] buffer = new byte[16384];

        public PullFile(String filename, boolean append) throws IOException {
            try {
                this.fout = new FileOutputStream(new File(filename), append);
            }
            catch (FileNotFoundException ex) {
                throw new FileNotFoundException(ex.toString() + ": " + filename);
            }
        }

        @Override
        public void putBuffer(byte[] buffer, int length) throws IOException {
            this.fout.write(buffer, 0, length);
        }

        @Override
        public void close() throws IOException {
            if (this.fout != null) {
                this.fout.close();
            }
        }
    }

    public static class PushFiles
    implements HttpPush.PushFileInterface,
    AutoCloseable {
        private MultiFileInputStream fin = null;
        private byte[] buffer = new byte[16384];
        private int buffer_full = 0;
        private boolean eof = false;

        @Override
        public void close() throws IOException {
            if (null != this.fin) {
                this.fin.close();
            }
        }

        public PushFiles(String[] filenames) throws IOException {
            this.fin = new MultiFileInputStream(filenames);
        }

        @Override
        public byte[] getBuffer() {
            return this.buffer;
        }

        @Override
        public boolean hasMoreElements() throws IOException {
            this.buffer_full = this.fin.read(this.buffer);
            return this.buffer_full != -1;
        }

        @Override
        public int nextElement() {
            return this.buffer_full;
        }
    }
}

