/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc.importExport;

import com.exasol.jdbc.importExport.FileValidator;
import com.exasol.jdbc.importExport.ImportErrorQuery;
import com.exasol.jdbc.importExport.RegexPattern;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryManipulator {
    public static String addMultiFilesTagAndSemicolon(String SQL, boolean isMultiFiles) {
        int SemicolonIndx;
        if (SQL == null) {
            return null;
        }
        String multiFiles = "";
        if (isMultiFiles) {
            multiFiles = " MULTIPLE LOCAL FILES";
        }
        Matcher match = Pattern.compile("^.*" + System.getProperty("line.separator") + "(?<LastLine>.*)$", 34).matcher(SQL);
        boolean appendToNewLine = false;
        if (match.matches()) {
            appendToNewLine = match.group("LastLine").contains("--");
        }
        if (appendToNewLine) {
            multiFiles = System.getProperty("line.separator") + multiFiles;
        }
        SQL = (SemicolonIndx = QueryManipulator.SemicolonIndex(SQL)) < 0 ? SQL + multiFiles + ";" : SQL.substring(0, SemicolonIndx) + multiFiles + SQL.substring(SemicolonIndx);
        return SQL;
    }

    public static String ReplaceMultiLineComment(String SQL, char ch) {
        Matcher match = Pattern.compile("/\\*(.*?)\\*/", 34).matcher(SQL);
        while (match.find()) {
            for (int i = 0; i < match.groupCount(); ++i) {
                char[] chArray = new char[match.group(i).length()];
                Arrays.fill(chArray, ch);
                SQL = SQL.replace(match.group(i), new String(chArray));
            }
        }
        return SQL;
    }

    public static String ReplaceSingleLineComment(String SQL, char ch) {
        Matcher match = Pattern.compile("--.*?(" + System.getProperty("line.separator") + "|\\n|$)", 34).matcher(SQL);
        while (match.find()) {
            for (int i = 0; i < match.groupCount(); ++i) {
                char[] chArray = new char[match.group(i).length()];
                Arrays.fill(chArray, ch);
                SQL = SQL.replace(match.group(i), new String(chArray));
            }
        }
        return SQL;
    }

    public static int SemicolonIndex(String SQL) {
        boolean QueryContainsSemicolon = QueryManipulator.RemoveComment(SQL).trim().endsWith(";");
        if (QueryContainsSemicolon) {
            return QueryManipulator.ReplaceSingleLineComment(QueryManipulator.ReplaceMultiLineComment(SQL, '*'), '*').indexOf(59);
        }
        return -1;
    }

    public static String RemoveComment(String SQL) {
        StringBuilder result = new StringBuilder();
        boolean inSingleLineComment = false;
        boolean inMultiLineComment = false;
        for (int i = 0; i < SQL.length(); ++i) {
            char currentChar = SQL.charAt(i);
            if (inSingleLineComment) {
                if (currentChar != '\n' && currentChar != '\r') continue;
                inSingleLineComment = false;
                continue;
            }
            if (inMultiLineComment) {
                if (currentChar != '*' || i >= SQL.length() - 1 || SQL.charAt(i + 1) != '/') continue;
                inMultiLineComment = false;
                ++i;
                continue;
            }
            if (currentChar == '-' && i < SQL.length() - 1 && SQL.charAt(i + 1) == '-') {
                inSingleLineComment = true;
                ++i;
                continue;
            }
            if (currentChar == '/' && i < SQL.length() - 1 && SQL.charAt(i + 1) == '*') {
                inMultiLineComment = true;
                ++i;
                continue;
            }
            result.append(currentChar);
        }
        return result.toString();
    }

    public static String IsCertificateVerificationParametersAreProvided(FileValidator FV, boolean addCertificateParams, String publicKey, boolean errorQuery) {
        String certificateParameter = FV.getQueryParser().getCertificateParameter();
        String publicKeyFromQuery = FV.getQueryParser().getPublicKey();
        if (errorQuery) {
            ImportErrorQuery errorQueryObj = (ImportErrorQuery)FV.getQueryParser();
            certificateParameter = errorQueryObj.getConnectionParser2().getCertificateParam();
            publicKeyFromQuery = errorQueryObj.getConnectionParser2().getPublicKey();
        }
        if (certificateParameter != null && publicKeyFromQuery == null) {
            return certificateParameter + " ";
        }
        if (certificateParameter == null && publicKeyFromQuery != null) {
            return publicKeyFromQuery + " ";
        }
        if (certificateParameter != null && publicKeyFromQuery != null) {
            return certificateParameter + " " + publicKeyFromQuery + " ";
        }
        return addCertificateParams ? (publicKey != null ? "PUBLIC KEY '" + publicKey + "' " : "IGNORE CERTIFICATE ") : "";
    }

    public static String BuildImpExpQuery(String URL2, String URLError, FileValidator FV, boolean addCertificateParams, String publicKey, String publicKeyErr) throws SQLException {
        if (URL2 == null) {
            throw new SQLException("Local File URL is null");
        }
        if (URL2.trim().length() == 0) {
            throw new SQLException("Local File URL is Empty");
        }
        String EndQuery = "";
        if (FV.getErrFiles() != null) {
            if (URLError == null) {
                throw new SQLException("Local Error File URL is null");
            }
            if (URLError.trim().length() == 0) {
                throw new SQLException("Local Error File URL is Empty");
            }
            ImportErrorQuery importErrorQuery = (ImportErrorQuery)FV.getQueryParser();
            String CertificateParametersErr = QueryManipulator.IsCertificateVerificationParametersAreProvided(FV, addCertificateParams, publicKeyErr, true);
            EndQuery = " " + importErrorQuery.getForthPart() + " CSV AT '" + URLError + "' " + CertificateParametersErr + "FILE '" + FV.getCookieErr() + "' " + RegexPattern.CreateFilenameQueryComment(FV.getErrFiles()) + " " + (importErrorQuery.connectionParser2.getSQLComment() != null ? importErrorQuery.connectionParser2.getSQLComment() + " " : "") + importErrorQuery.getSixthPart();
        }
        String CertificateParameters = QueryManipulator.IsCertificateVerificationParametersAreProvided(FV, addCertificateParams, publicKey, false);
        String SQL = FV.getQueryParser().getFirstPart() + (FV.isCSV() ? " CSV" : " FBV") + " AT '" + URL2 + "' " + CertificateParameters + "FILE '" + FV.getCookie() + "'";
        String FilesAndComments = RegexPattern.CreateFilenameQueryComment(FV.getFiles()) + " " + (FV.getQueryParser().connectionParser.getSQLComment() != null ? FV.getQueryParser().connectionParser.getSQLComment() + " " : "") + FV.getQueryParser().getThirdPart();
        SQL = SQL + " " + FilesAndComments + EndQuery;
        if ((SQL = FV.replaceHashWithComments(SQL)) != null) {
            SQL = QueryManipulator.addMultiFilesTagAndSemicolon(SQL, FV.getFiles().length > 1);
        }
        return SQL;
    }
}

