/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.asn1.util;

import resources.dependencies.org.bouncycastle.asn1.ASN1BMPString;
import resources.dependencies.org.bouncycastle.asn1.ASN1BitString;
import resources.dependencies.org.bouncycastle.asn1.ASN1Boolean;
import resources.dependencies.org.bouncycastle.asn1.ASN1Encodable;
import resources.dependencies.org.bouncycastle.asn1.ASN1Enumerated;
import resources.dependencies.org.bouncycastle.asn1.ASN1External;
import resources.dependencies.org.bouncycastle.asn1.ASN1GeneralizedTime;
import resources.dependencies.org.bouncycastle.asn1.ASN1GraphicString;
import resources.dependencies.org.bouncycastle.asn1.ASN1IA5String;
import resources.dependencies.org.bouncycastle.asn1.ASN1Integer;
import resources.dependencies.org.bouncycastle.asn1.ASN1Null;
import resources.dependencies.org.bouncycastle.asn1.ASN1NumericString;
import resources.dependencies.org.bouncycastle.asn1.ASN1ObjectDescriptor;
import resources.dependencies.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import resources.dependencies.org.bouncycastle.asn1.ASN1OctetString;
import resources.dependencies.org.bouncycastle.asn1.ASN1Primitive;
import resources.dependencies.org.bouncycastle.asn1.ASN1PrintableString;
import resources.dependencies.org.bouncycastle.asn1.ASN1RelativeOID;
import resources.dependencies.org.bouncycastle.asn1.ASN1Sequence;
import resources.dependencies.org.bouncycastle.asn1.ASN1Set;
import resources.dependencies.org.bouncycastle.asn1.ASN1T61String;
import resources.dependencies.org.bouncycastle.asn1.ASN1TaggedObject;
import resources.dependencies.org.bouncycastle.asn1.ASN1UTCTime;
import resources.dependencies.org.bouncycastle.asn1.ASN1UTF8String;
import resources.dependencies.org.bouncycastle.asn1.ASN1Util;
import resources.dependencies.org.bouncycastle.asn1.ASN1VideotexString;
import resources.dependencies.org.bouncycastle.asn1.ASN1VisibleString;
import resources.dependencies.org.bouncycastle.asn1.BEROctetString;
import resources.dependencies.org.bouncycastle.asn1.BERSequence;
import resources.dependencies.org.bouncycastle.asn1.BERSet;
import resources.dependencies.org.bouncycastle.asn1.BERTaggedObject;
import resources.dependencies.org.bouncycastle.asn1.DERBitString;
import resources.dependencies.org.bouncycastle.asn1.DERSequence;
import resources.dependencies.org.bouncycastle.asn1.DERSet;
import resources.dependencies.org.bouncycastle.asn1.DERTaggedObject;
import resources.dependencies.org.bouncycastle.asn1.DLBitString;
import resources.dependencies.org.bouncycastle.util.Strings;
import resources.dependencies.org.bouncycastle.util.encoders.Hex;

public class ASN1Dump {
    private static final String TAB = "    ";
    private static final int SAMPLE_SIZE = 32;

    static void _dumpAsString(String string, boolean bl, ASN1Primitive aSN1Primitive, StringBuffer stringBuffer) {
        String string2 = Strings.lineSeparator();
        stringBuffer.append(string);
        if (aSN1Primitive instanceof ASN1Null) {
            stringBuffer.append("NULL");
            stringBuffer.append(string2);
        } else if (aSN1Primitive instanceof ASN1Sequence) {
            if (aSN1Primitive instanceof BERSequence) {
                stringBuffer.append("BER Sequence");
            } else if (aSN1Primitive instanceof DERSequence) {
                stringBuffer.append("DER Sequence");
            } else {
                stringBuffer.append("Sequence");
            }
            stringBuffer.append(string2);
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Primitive;
            String string3 = string + TAB;
            int n = aSN1Sequence.size();
            for (int i = 0; i < n; ++i) {
                ASN1Dump._dumpAsString(string3, bl, aSN1Sequence.getObjectAt(i).toASN1Primitive(), stringBuffer);
            }
        } else if (aSN1Primitive instanceof ASN1Set) {
            if (aSN1Primitive instanceof BERSet) {
                stringBuffer.append("BER Set");
            } else if (aSN1Primitive instanceof DERSet) {
                stringBuffer.append("DER Set");
            } else {
                stringBuffer.append("Set");
            }
            stringBuffer.append(string2);
            ASN1Set aSN1Set = (ASN1Set)aSN1Primitive;
            String string4 = string + TAB;
            int n = aSN1Set.size();
            for (int i = 0; i < n; ++i) {
                ASN1Dump._dumpAsString(string4, bl, aSN1Set.getObjectAt(i).toASN1Primitive(), stringBuffer);
            }
        } else if (aSN1Primitive instanceof ASN1TaggedObject) {
            if (aSN1Primitive instanceof BERTaggedObject) {
                stringBuffer.append("BER Tagged ");
            } else if (aSN1Primitive instanceof DERTaggedObject) {
                stringBuffer.append("DER Tagged ");
            } else {
                stringBuffer.append("Tagged ");
            }
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Primitive;
            stringBuffer.append(ASN1Util.getTagText(aSN1TaggedObject));
            if (!aSN1TaggedObject.isExplicit()) {
                stringBuffer.append(" IMPLICIT");
            }
            stringBuffer.append(string2);
            String string5 = string + TAB;
            ASN1Dump._dumpAsString(string5, bl, aSN1TaggedObject.getBaseObject().toASN1Primitive(), stringBuffer);
        } else if (aSN1Primitive instanceof ASN1ObjectIdentifier) {
            stringBuffer.append("ObjectIdentifier(" + ((ASN1ObjectIdentifier)aSN1Primitive).getId() + ")" + string2);
        } else if (aSN1Primitive instanceof ASN1RelativeOID) {
            stringBuffer.append("RelativeOID(" + ((ASN1RelativeOID)aSN1Primitive).getId() + ")" + string2);
        } else if (aSN1Primitive instanceof ASN1Boolean) {
            stringBuffer.append("Boolean(" + ((ASN1Boolean)aSN1Primitive).isTrue() + ")" + string2);
        } else if (aSN1Primitive instanceof ASN1Integer) {
            stringBuffer.append("Integer(" + ((ASN1Integer)aSN1Primitive).getValue() + ")" + string2);
        } else if (aSN1Primitive instanceof ASN1OctetString) {
            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Primitive;
            if (aSN1Primitive instanceof BEROctetString) {
                stringBuffer.append("BER Constructed Octet String[");
            } else {
                stringBuffer.append("DER Octet String[");
            }
            stringBuffer.append(aSN1OctetString.getOctetsLength() + "]" + string2);
            if (bl) {
                ASN1Dump.dumpBinaryDataAsString(stringBuffer, string, aSN1OctetString.getOctets());
            }
        } else if (aSN1Primitive instanceof ASN1BitString) {
            ASN1BitString aSN1BitString = (ASN1BitString)aSN1Primitive;
            if (aSN1BitString instanceof DERBitString) {
                stringBuffer.append("DER Bit String[");
            } else if (aSN1BitString instanceof DLBitString) {
                stringBuffer.append("DL Bit String[");
            } else {
                stringBuffer.append("BER Bit String[");
            }
            stringBuffer.append(aSN1BitString.getBytesLength() + ", " + aSN1BitString.getPadBits() + "]" + string2);
            if (bl) {
                ASN1Dump.dumpBinaryDataAsString(stringBuffer, string, aSN1BitString.getBytes());
            }
        } else if (aSN1Primitive instanceof ASN1IA5String) {
            stringBuffer.append("IA5String(" + ((ASN1IA5String)aSN1Primitive).getString() + ") " + string2);
        } else if (aSN1Primitive instanceof ASN1UTF8String) {
            stringBuffer.append("UTF8String(" + ((ASN1UTF8String)aSN1Primitive).getString() + ") " + string2);
        } else if (aSN1Primitive instanceof ASN1NumericString) {
            stringBuffer.append("NumericString(" + ((ASN1NumericString)aSN1Primitive).getString() + ") " + string2);
        } else if (aSN1Primitive instanceof ASN1PrintableString) {
            stringBuffer.append("PrintableString(" + ((ASN1PrintableString)aSN1Primitive).getString() + ") " + string2);
        } else if (aSN1Primitive instanceof ASN1VisibleString) {
            stringBuffer.append("VisibleString(" + ((ASN1VisibleString)aSN1Primitive).getString() + ") " + string2);
        } else if (aSN1Primitive instanceof ASN1BMPString) {
            stringBuffer.append("BMPString(" + ((ASN1BMPString)aSN1Primitive).getString() + ") " + string2);
        } else if (aSN1Primitive instanceof ASN1T61String) {
            stringBuffer.append("T61String(" + ((ASN1T61String)aSN1Primitive).getString() + ") " + string2);
        } else if (aSN1Primitive instanceof ASN1GraphicString) {
            stringBuffer.append("GraphicString(" + ((ASN1GraphicString)aSN1Primitive).getString() + ") " + string2);
        } else if (aSN1Primitive instanceof ASN1VideotexString) {
            stringBuffer.append("VideotexString(" + ((ASN1VideotexString)aSN1Primitive).getString() + ") " + string2);
        } else if (aSN1Primitive instanceof ASN1UTCTime) {
            stringBuffer.append("UTCTime(" + ((ASN1UTCTime)aSN1Primitive).getTime() + ") " + string2);
        } else if (aSN1Primitive instanceof ASN1GeneralizedTime) {
            stringBuffer.append("GeneralizedTime(" + ((ASN1GeneralizedTime)aSN1Primitive).getTime() + ") " + string2);
        } else if (aSN1Primitive instanceof ASN1Enumerated) {
            ASN1Enumerated aSN1Enumerated = (ASN1Enumerated)aSN1Primitive;
            stringBuffer.append("DER Enumerated(" + aSN1Enumerated.getValue() + ")" + string2);
        } else if (aSN1Primitive instanceof ASN1ObjectDescriptor) {
            ASN1ObjectDescriptor aSN1ObjectDescriptor = (ASN1ObjectDescriptor)aSN1Primitive;
            stringBuffer.append("ObjectDescriptor(" + aSN1ObjectDescriptor.getBaseGraphicString().getString() + ") " + string2);
        } else if (aSN1Primitive instanceof ASN1External) {
            ASN1External aSN1External = (ASN1External)aSN1Primitive;
            stringBuffer.append("External " + string2);
            String string6 = string + TAB;
            if (aSN1External.getDirectReference() != null) {
                stringBuffer.append(string6 + "Direct Reference: " + aSN1External.getDirectReference().getId() + string2);
            }
            if (aSN1External.getIndirectReference() != null) {
                stringBuffer.append(string6 + "Indirect Reference: " + aSN1External.getIndirectReference().toString() + string2);
            }
            if (aSN1External.getDataValueDescriptor() != null) {
                ASN1Dump._dumpAsString(string6, bl, aSN1External.getDataValueDescriptor(), stringBuffer);
            }
            stringBuffer.append(string6 + "Encoding: " + aSN1External.getEncoding() + string2);
            ASN1Dump._dumpAsString(string6, bl, aSN1External.getExternalContent(), stringBuffer);
        } else {
            stringBuffer.append(aSN1Primitive.toString() + string2);
        }
    }

    public static String dumpAsString(Object object) {
        return ASN1Dump.dumpAsString(object, false);
    }

    public static String dumpAsString(Object object, boolean bl) {
        ASN1Primitive aSN1Primitive;
        if (object instanceof ASN1Primitive) {
            aSN1Primitive = (ASN1Primitive)object;
        } else if (object instanceof ASN1Encodable) {
            aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive();
        } else {
            return "unknown object type " + object.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        ASN1Dump._dumpAsString("", bl, aSN1Primitive, stringBuffer);
        return stringBuffer.toString();
    }

    private static void dumpBinaryDataAsString(StringBuffer stringBuffer, String string, byte[] byArray) {
        if (byArray.length < 1) {
            return;
        }
        String string2 = Strings.lineSeparator();
        string = string + TAB;
        for (int i = 0; i < byArray.length; i += 32) {
            int n = byArray.length - i;
            int n2 = Math.min(n, 32);
            stringBuffer.append(string);
            stringBuffer.append(Hex.toHexString(byArray, i, n2));
            for (int j = n2; j < 32; ++j) {
                stringBuffer.append("  ");
            }
            stringBuffer.append(TAB);
            ASN1Dump.appendAscString(stringBuffer, byArray, i, n2);
            stringBuffer.append(string2);
        }
    }

    private static void appendAscString(StringBuffer stringBuffer, byte[] byArray, int n, int n2) {
        for (int i = n; i != n + n2; ++i) {
            if (byArray[i] < 32 || byArray[i] > 126) continue;
            stringBuffer.append((char)byArray[i]);
        }
    }
}

