/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.crypto.generators;

import java.security.SecureRandom;
import resources.dependencies.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import resources.dependencies.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import resources.dependencies.org.bouncycastle.crypto.CryptoServicePurpose;
import resources.dependencies.org.bouncycastle.crypto.CryptoServicesRegistrar;
import resources.dependencies.org.bouncycastle.crypto.KeyGenerationParameters;
import resources.dependencies.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import resources.dependencies.org.bouncycastle.crypto.params.X448PrivateKeyParameters;
import resources.dependencies.org.bouncycastle.crypto.params.X448PublicKeyParameters;

public class X448KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.random = keyGenerationParameters.getRandom();
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("X448KeyGen", 224, null, CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        X448PrivateKeyParameters x448PrivateKeyParameters = new X448PrivateKeyParameters(this.random);
        X448PublicKeyParameters x448PublicKeyParameters = x448PrivateKeyParameters.generatePublicKey();
        return new AsymmetricCipherKeyPair(x448PublicKeyParameters, x448PrivateKeyParameters);
    }
}

