/*
 * Decompiled with CFR 0.152.
 */
package resources.dependencies.org.bouncycastle.pqc.jcajce.provider.mayo;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import resources.dependencies.org.bouncycastle.asn1.ASN1Set;
import resources.dependencies.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import resources.dependencies.org.bouncycastle.pqc.crypto.mayo.MayoPrivateKeyParameters;
import resources.dependencies.org.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import resources.dependencies.org.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import resources.dependencies.org.bouncycastle.pqc.jcajce.interfaces.MayoKey;
import resources.dependencies.org.bouncycastle.pqc.jcajce.spec.MayoParameterSpec;
import resources.dependencies.org.bouncycastle.util.Arrays;
import resources.dependencies.org.bouncycastle.util.Strings;

public class BCMayoPrivateKey
implements PrivateKey,
MayoKey {
    private static final long serialVersionUID = 1L;
    private transient MayoPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCMayoPrivateKey(MayoPrivateKeyParameters mayoPrivateKeyParameters) {
        this.params = mayoPrivateKeyParameters;
    }

    public BCMayoPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (MayoPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCMayoPrivateKey) {
            BCMayoPrivateKey bCMayoPrivateKey = (BCMayoPrivateKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCMayoPrivateKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return Strings.toUpperCase(this.params.getParameters().getName());
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public MayoParameterSpec getParameterSpec() {
        return MayoParameterSpec.fromName(this.params.getParameters().getName());
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    MayoPrivateKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

