/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.Column;
import com.exasol.jdbc.DateTimeColumn;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXAInputStream;
import com.exasol.jdbc.EXAOutputStream;
import com.exasol.jdbc.SimpleDate;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.exaTimestamp;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

class DateColumn
extends DateTimeColumn {
    protected int[] values = new int[initialBatchCapacity];
    private SimpleDate defDate = new SimpleDate();

    DateColumn() {
    }

    @Override
    String getClassName() {
        return "java.sql.Date";
    }

    @Override
    int getDisplaySize(EXAConnection eXAConnection) {
        if (eXAConnection != null) {
            String string = eXAConnection.getDateFormat();
            return EXAConnection.getDateFormatWidth(string);
        }
        return 10;
    }

    @Override
    int getPrecision() throws SQLException {
        return 0;
    }

    @Override
    void setPrecision(int n) throws SQLException {
        throw new SQLException("Not implemented for DateColumn");
    }

    @Override
    void setScale(int n) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not implemented for DateColumn - setScale()");
    }

    @Override
    int getType() {
        return 91;
    }

    @Override
    String getTypeName() {
        return "DATE";
    }

    @Override
    Object getObject(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException(Translator.Accessed_null_value());
        }
        return Date.valueOf(this.getString(n));
    }

    @Override
    int getInt(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException(Translator.Accessed_null_value());
        }
        return this.values[n];
    }

    @Override
    String getString(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException(Translator.Accessed_null_value());
        }
        this.defDate.fromInt(this.values[n]);
        String string = String.valueOf(this.defDate.year);
        String string2 = String.valueOf(this.defDate.month);
        String string3 = String.valueOf(this.defDate.day);
        while (string.length() < 4) {
            string = "0" + string;
        }
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        if (string3.length() < 2) {
            string3 = "0" + string3;
        }
        return string + "-" + string2 + "-" + string3;
    }

    @Override
    void setString(int n, String string) throws SQLException {
        this.validMask[n] = true;
        byte[] byArray = string.getBytes();
        if (byArray.length != 10 || byArray[0] < 48 || byArray[0] > 57 || byArray[1] < 48 || byArray[1] > 57 || byArray[2] < 48 || byArray[2] > 57 || byArray[3] < 48 || byArray[3] > 57 || byArray[4] != 45 || byArray[5] < 48 || byArray[5] > 57 || byArray[6] < 48 || byArray[6] > 57 || byArray[7] != 45 || byArray[8] < 48 || byArray[8] > 57 || byArray[9] < 48 || byArray[9] > 57) {
            throw new SQLDataException(" '" + string + "' " + Translator.invalid_datetime_format(), "007");
        }
        this.defDate.year = 1000 * (byArray[0] - 48) + 100 * (byArray[1] - 48) + 10 * (byArray[2] - 48) + (byArray[3] - 48);
        this.defDate.month = 10 * (byArray[5] - 48) + (byArray[6] - 48);
        this.defDate.day = 10 * (byArray[8] - 48) + (byArray[9] - 48);
        this.values[n] = this.defDate.toInt();
    }

    @Override
    void resize(int n) {
        int n2;
        int[] nArray = new int[n];
        boolean[] blArray = new boolean[n];
        int n3 = this.values.length;
        if (n3 > n) {
            n3 = n;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = this.values[n2];
            blArray[n2] = this.validMask[n2];
        }
        for (n2 = n3; n2 < n; ++n2) {
            blArray[n2] = false;
        }
        this.values = nArray;
        this.validMask = blArray;
    }

    static Column from_jdbc_type(EXAInputStream eXAInputStream) {
        return new DateColumn();
    }

    @Override
    long value_to_jdbc(EXAOutputStream eXAOutputStream, int n) throws IOException {
        if (this.validMask[n]) {
            eXAOutputStream.writeByte((byte)1);
            eXAOutputStream.writeInt(this.values[n]);
            return 5L;
        }
        eXAOutputStream.writeByte((byte)0);
        return 1L;
    }

    @Override
    void value_from_jdbc(EXAInputStream eXAInputStream, int n) throws IOException {
        if (eXAInputStream.nextIsNull()) {
            this.validMask[n] = false;
        } else {
            this.values[n] = eXAInputStream.readInt();
            this.validMask[n] = true;
        }
    }

    @Override
    void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.simpleDateFromCalendar(this.defDate, date.getTime(), calendar);
        this.validMask[n] = true;
        this.values[n] = this.defDate.toInt();
    }

    @Override
    void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, this.defCal);
    }

    @Override
    void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.simpleDateFromCalendar(this.defDate, timestamp.getTime(), calendar);
        this.validMask[n] = true;
        this.values[n] = this.defDate.toInt();
    }

    @Override
    void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, this.defCal);
    }

    @Override
    Date getDate(int n, Calendar calendar) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException(Translator.Accessed_null_value());
        }
        this.defDate.fromInt(this.values[n]);
        this.defDate.toCalendar(this.utcCal);
        return this.dateFromCalendar(new exaTimestamp((short)this.defDate.year, (byte)(this.defDate.month - 1), (byte)this.defDate.day, 0, 0, 0, 0), calendar);
    }

    @Override
    Date getDate(int n) throws SQLException {
        return this.getDate(n, this.defCal);
    }

    @Override
    long getLong(int n) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException(Translator.Accessed_null_value());
        }
        this.defDate.fromInt(this.values[n]);
        this.defDate.toCalendar(this.defCal);
        return this.defCal.getTimeInMillis();
    }

    @Override
    Object getObject(int n, Map map) throws SQLException {
        return this.getDate(n);
    }

    @Override
    Time getTime(int n, Calendar calendar) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException(Translator.Accessed_null_value());
        }
        this.defDate.fromInt(this.values[n]);
        this.defDate.toCalendar(this.utcCal);
        return this.timeFromCalendar(new exaTimestamp((short)this.defDate.year, (byte)(this.defDate.month - 1), (byte)this.defDate.day, 0, 0, 0, 0), calendar);
    }

    @Override
    Time getTime(int n) throws SQLException {
        return this.getTime(n, this.defCal);
    }

    @Override
    Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (!this.validMask[n]) {
            throw new SQLException(Translator.Accessed_null_value());
        }
        this.defDate.fromInt(this.values[n]);
        this.defDate.toCalendar(this.utcCal);
        return this.timestampFromCalendar(new exaTimestamp((short)this.defDate.year, (byte)(this.defDate.month - 1), (byte)this.defDate.day, 0, 0, 0, 0), calendar);
    }

    @Override
    Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, this.defCal);
    }

    @Override
    void setLong(int n, long l) throws SQLException {
        this.validMask[n] = true;
        this.defCal.setTimeInMillis(l);
        this.defDate.fromCalendar(this.defCal);
        this.values[n] = this.defDate.toInt();
    }

    @Override
    void setObject(int n, Object object) throws SQLException {
        if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else if (object instanceof Time) {
            this.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
        } else {
            super.setObject(n, object);
        }
    }

    @Override
    void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.simpleDateFromCalendar(this.defDate, time.getTime(), calendar);
        this.validMask[n] = true;
        this.values[n] = this.defDate.toInt();
    }

    @Override
    void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, this.defCal);
    }

    @Override
    int getEXAType() {
        return 14;
    }
}

