/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc.importExport;

import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.EXADriver;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.importExport.HttpPush;
import com.exasol.jdbc.importExport.HttpPushTool;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class HTTPThread
extends Thread {
    private HttpPush hp = null;
    private String[] fileNames = null;
    private String cookie = null;
    private boolean connected = false;
    private boolean interrupted = false;
    public IOException ioException;
    public Error error;
    public RuntimeException runtimeException;
    public InterruptedException interruptException;
    final DebugLog debug;
    final PrintStream logPrinterOut;
    final PrintStream logPrinterErr;

    public void InterruptThread() throws IOException {
        this.interrupted = true;
        this.hp.close();
    }

    public boolean ThreadWasInterrupted() {
        return this.interrupted;
    }

    public HTTPThread(HttpPush httpPush, String[] stringArray, String string, DebugLog debugLog, PrintStream printStream, PrintStream printStream2) {
        this.hp = httpPush;
        this.fileNames = stringArray;
        this.cookie = string;
        this.debug = debugLog;
        this.logPrinterOut = printStream;
        this.logPrinterErr = printStream2;
        this.logOut("HTTPThread successfully constructed");
    }

    public boolean isConnected() {
        return this.connected;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        try {
            Object object;
            this.hp.connect(this);
            String string = this.hp.getCommand();
            String string2 = this.hp.getURL();
            if (!string2.endsWith(this.cookie)) {
                throw new IOException(Translator.WrongCookieRecieved());
            }
            HashMap hashMap = this.hp.getHeader();
            this.logOut("[" + string + ": " + string2 + "]");
            for (Map.Entry object2 : hashMap.entrySet()) {
                object = (String)object2.getKey();
                String string3 = (String)object2.getValue();
                this.logOut("<" + (String)object + ": " + string3 + ">");
            }
            Object object3 = "";
            try {
                if (string.equals("GET")) {
                    if (this.fileNames.length != 1 || !this.fileNames[0].equals("System.in")) {
                        void securityException;
                        boolean i = false;
                        while (securityException < this.fileNames.length) {
                            object3 = this.fileNames[securityException];
                            object = new File((String)object3);
                            if (null == object || !((File)object).exists()) {
                                this.logOut(Translator.File((String)object3) + " " + Translator.not_found());
                                throw new FileNotFoundException(Translator.File((String)object3) + " " + Translator.not_found());
                            }
                            if (!((File)object).canRead()) {
                                this.logOut(Translator.File((String)object3) + " " + Translator.Permission_denied());
                                throw new FileNotFoundException(Translator.File((String)object3) + " " + Translator.Permission_denied());
                            }
                            this.logOut(Translator.UploadFileFrom((String)object3));
                            ++securityException;
                        }
                    }
                    this.hp.push(new HttpPushTool.PushFiles(this.fileNames));
                } else if (string.equals("PUT")) {
                    String string4 = (String)hashMap.get("X-Append");
                    object3 = this.fileNames[0];
                    if (string4 != null && string4.trim().equalsIgnoreCase("yes")) {
                        this.logOut(Translator.DownloadToFile_Append((String)object3));
                        this.hp.pull(new HttpPushTool.PullFile((String)object3, true));
                    } else {
                        this.logOut(Translator.DownloadToFile_Replace((String)object3));
                        this.hp.pull(new HttpPushTool.PullFile((String)object3, false));
                    }
                }
                this.hp.close();
            }
            catch (SecurityException securityException) {
                this.logOut(Translator.File((String)object3) + " " + Translator.Permission_denied());
                throw new FileNotFoundException(Translator.File((String)object3) + " " + Translator.Permission_denied());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                String string = fileNotFoundException.toString();
                if (string != null && string.indexOf(Translator.Permission_denied()) >= 0) {
                    this.hp.pushPermissionDenied(string);
                } else {
                    this.hp.pushFileNotFound(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.hp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logErr("Error:");
            this.logErr(fileNotFoundException.toString());
            this.ioException = fileNotFoundException;
        }
        catch (IOException iOException) {
            try {
                this.hp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logErr("Error:");
            this.logErr(iOException);
            this.ioException = iOException;
        }
        catch (InterruptedException interruptedException) {
            try {
                this.hp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logOut("Interrupted:" + interruptedException.toString());
            this.interruptException = interruptedException;
        }
        catch (RuntimeException runtimeException) {
            try {
                this.hp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logOut("RuntimeException:" + runtimeException.toString());
            this.runtimeException = runtimeException;
        }
        catch (Error error) {
            this.error = error;
        }
    }

    public void checkForErrors() throws IOException {
        if (this.ioException != null) {
            throw this.ioException;
        }
        if (this.runtimeException != null) {
            throw this.runtimeException;
        }
        if (this.error != null) {
            throw this.error;
        }
        try {
            int n = 0;
            while (this.isConnected() && n++ < 4999) {
                Thread.sleep(1L);
            }
            this.join(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.isAlive()) {
            throw new IOException(Translator.ThreadFromImportExportHasNotBeenFinished());
        }
    }

    public void logOut(String string) {
        if (this.debug != null) {
            this.debug.log(this.getClass().getSimpleName() + ": " + string);
        }
        if (this.logPrinterOut != null) {
            this.logPrinterOut.println(this.getClass().getSimpleName() + ": " + string);
        }
    }

    public void logErr(String string) {
        if (this.debug != null) {
            this.debug.log(this.getClass().getSimpleName() + ": " + string);
        }
        if (this.logPrinterErr != null) {
            this.logPrinterErr.println(this.getClass().getSimpleName() + ": " + string);
        }
    }

    public void logErr(Throwable throwable) {
        if (this.debug != null) {
            EXADriver.debugError(this.getClass().getSimpleName() + ": ", throwable, this.debug);
        }
        if (this.logPrinterErr != null) {
            throwable.printStackTrace(this.logPrinterErr);
        }
    }

    public synchronized void NowConnected() {
        this.connected = true;
    }

    public synchronized void NowDisconnected() {
        this.connected = false;
    }
}

