/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs.monitor;

import com.exasol.bucketfs.monitor.BucketFsMonitor;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.TimeZone;

public class TimestampState
implements BucketFsMonitor.State {
    private final Instant time;

    public static TimestampState lowResolution(Instant time) {
        return new TimestampState(time.truncatedTo(ChronoUnit.SECONDS));
    }

    public static TimestampState of(LocalDateTime time, TimeZone timeZone) {
        return new TimestampState(time.atZone(timeZone.toZoneId()).toInstant());
    }

    TimestampState(Instant time) {
        this.time = time;
    }

    public boolean accepts(BucketFsMonitor.State other) {
        if (!(other instanceof TimestampState)) {
            return false;
        }
        return !((TimestampState)other).time.isBefore(this.time);
    }

    public String toString() {
        return "time " + this.time.toString();
    }

    public Instant getTime() {
        return this.time;
    }
}

