/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs.testcontainers;

import com.exasol.bucketfs.Bucket;
import com.exasol.bucketfs.BucketFactory;
import com.exasol.bucketfs.SyncAwareBucket;
import com.exasol.bucketfs.WriteEnabledBucket;
import com.exasol.bucketfs.monitor.BucketFsMonitor;
import com.exasol.bucketfs.testcontainers.LogBasedBucketFsMonitor;
import com.exasol.clusterlogs.LogPatternDetectorFactory;
import com.exasol.config.BucketConfiguration;
import com.exasol.config.BucketFsServiceConfiguration;
import com.exasol.config.ClusterConfiguration;
import java.util.HashMap;
import java.util.Map;

public final class TestcontainerBucketFactory
implements BucketFactory {
    private final Map<String, Bucket> buckets = new HashMap<String, Bucket>();
    private String host;
    private ClusterConfiguration clusterConfiguration;
    private Map<Integer, Integer> portMappings;
    private LogPatternDetectorFactory detectorFactory;
    private LogBasedBucketFsMonitor.FilterStrategy filterStrategy = LogBasedBucketFsMonitor.FilterStrategy.TIME_STAMP;

    public static Builder builder() {
        return new Builder();
    }

    private TestcontainerBucketFactory() {
    }

    public synchronized Bucket getBucket(String serviceName, String bucketName) {
        BucketFsServiceConfiguration serviceConfiguration = this.clusterConfiguration.getBucketFsServiceConfiguration(serviceName);
        BucketConfiguration bucketConfiguration = serviceConfiguration.getBucketConfiguration(bucketName);
        String bucketPath = serviceName + "/" + bucketName;
        this.buckets.computeIfAbsent(bucketPath, key -> {
            LogBasedBucketFsMonitor monitor = new LogBasedBucketFsMonitor(this.detectorFactory, this.filterStrategy);
            return ((SyncAwareBucket.Builder)((WriteEnabledBucket.Builder)((WriteEnabledBucket.Builder)((WriteEnabledBucket.Builder)((WriteEnabledBucket.Builder)((WriteEnabledBucket.Builder)SyncAwareBucket.builder().monitor((BucketFsMonitor)monitor).stateRetriever(monitor.createStateRetriever()).serviceName(serviceName)).name(bucketName)).host(this.host)).port(this.mapPort(serviceConfiguration.getHttpPort()))).readPassword(bucketConfiguration.getReadPassword())).writePassword(bucketConfiguration.getWritePassword())).build();
        });
        return this.buckets.get(bucketPath);
    }

    private int mapPort(int internalPort) {
        return this.portMappings.get(internalPort);
    }

    public static class Builder {
        private final TestcontainerBucketFactory factory = new TestcontainerBucketFactory();

        public Builder host(String value) {
            this.factory.host = value;
            return this;
        }

        public Builder clusterConfiguration(ClusterConfiguration value) {
            this.factory.clusterConfiguration = value;
            return this;
        }

        public Builder portMappings(Map<Integer, Integer> value) {
            this.factory.portMappings = value;
            return this;
        }

        public Builder detectorFactory(LogPatternDetectorFactory value) {
            this.factory.detectorFactory = value;
            return this;
        }

        public Builder filterStrategy(LogBasedBucketFsMonitor.FilterStrategy value) {
            this.factory.filterStrategy = value;
            return this;
        }

        public TestcontainerBucketFactory build() {
            return this.factory;
        }
    }
}

