/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers;

import com.exasol.containers.ExasolDockerImageReference;

class VersionBasedExasolDockerImageReference
implements ExasolDockerImageReference {
    private static final int DEFAULT_DOCKER_IMAGE_REVISION = 1;
    public static final int VERSION_NOT_PRESENT = -1;
    public static final String PREFIX_NOT_PRESENT = null;
    public static final String SUFFIX_NOT_PRESENT = null;
    private final int major;
    private final int minor;
    private final int fix;
    private final int dockerImageRevision;
    private final String prefix;
    private final String suffix;
    private final String suffixSeparator;

    public VersionBasedExasolDockerImageReference(int major, int minor, int fix, String prefix, String suffixSeparator, String suffix, int dockerImageRevision) {
        this.major = major;
        this.minor = minor;
        this.fix = fix;
        this.prefix = prefix;
        this.suffixSeparator = suffixSeparator;
        this.suffix = suffix;
        this.dockerImageRevision = dockerImageRevision == -1 && !this.isExasolSevenOrLater() ? 1 : dockerImageRevision;
    }

    @Override
    public int getMajor() {
        return this.major;
    }

    @Override
    public boolean hasMajor() {
        return this.major != -1;
    }

    @Override
    public int getMinor() {
        return this.minor;
    }

    @Override
    public boolean hasMinor() {
        return this.minor != -1;
    }

    @Override
    public int getFixVersion() {
        return this.fix;
    }

    @Override
    public boolean hasFix() {
        return this.fix != -1;
    }

    @Override
    public int getDockerImageRevision() {
        return this.dockerImageRevision;
    }

    @Override
    public boolean hasDockerImageRevision() {
        return this.dockerImageRevision != -1;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean hasPrefix() {
        return this.prefix != null;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public boolean hasSuffix() {
        return this.suffix != null;
    }

    @Override
    public String toString() {
        return "exasol/docker-db:" + this.constructPrefixPart() + this.constructVersionPart() + this.constructOptionalSuffixPart() + this.constructOptionalDockerImageRevisionPart();
    }

    private String constructPrefixPart() {
        return this.hasPrefix() ? this.prefix + "-" : "";
    }

    private String constructVersionPart() {
        return this.major + "." + this.minor + "." + this.fix;
    }

    private String constructOptionalSuffixPart() {
        return this.hasSuffix() ? this.suffixSeparator + this.suffix : "";
    }

    private String constructOptionalDockerImageRevisionPart() {
        if (this.isExasolSevenOrLater()) {
            return this.hasDockerImageRevision() ? "-d" + this.dockerImageRevision : "";
        }
        return "-d" + (this.hasDockerImageRevision() ? this.dockerImageRevision : 1);
    }

    private boolean isExasolSevenOrLater() {
        return this.major >= 7;
    }
}

