/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;

public interface IdentityProvider {
    public static Builder builder() {
        return new Builder();
    }

    public static IdentityProvider fromPathToPrivateKey(String path) {
        return jsch -> jsch.addIdentity(path);
    }

    public void addIdentityTo(JSch var1) throws JSchException;

    public static class Builder {
        private String identityName;
        private byte[] privateKey;
        private byte[] publicKey;
        private byte[] passPhrase = null;

        public Builder identityName(String value) {
            this.identityName = value;
            return this;
        }

        public Builder publicKey(byte[] value) {
            this.publicKey = value;
            return this;
        }

        public Builder privateKey(byte[] value) {
            this.privateKey = value;
            return this;
        }

        public Builder passphrase(byte[] value) {
            this.passPhrase = value;
            return this;
        }

        public IdentityProvider build() {
            return jsch -> jsch.addIdentity(this.identityName, this.privateKey, this.publicKey, this.passPhrase);
        }
    }
}

