/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.workarounds;

import com.exasol.containers.workarounds.Workaround;
import com.exasol.containers.workarounds.WorkaroundException;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkaroundManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkaroundManager.class);
    private final Workaround[] workarounds;
    private final Set<String> previouslyAppliedWorkarounds;

    public static WorkaroundManager create(Set<String> previouslyAppliedWorkarounds, Workaround ... workarounds) {
        return new WorkaroundManager(previouslyAppliedWorkarounds, workarounds);
    }

    private WorkaroundManager(Set<String> previouslyAppliedWorkarounds, Workaround[] workarounds) {
        this.previouslyAppliedWorkarounds = previouslyAppliedWorkarounds;
        this.workarounds = workarounds;
    }

    public Set<Workaround> applyWorkarounds() throws WorkaroundException {
        HashSet<Workaround> appliedWorkarounds = new HashSet<Workaround>();
        for (Workaround workaround : this.workarounds) {
            if (!this.applyWorkaround(workaround)) continue;
            appliedWorkarounds.add(workaround);
        }
        if (!appliedWorkarounds.isEmpty() && LOGGER.isInfoEnabled()) {
            LOGGER.info("Applied workarounds: {}", (Object)this.joinWorkaroundNames(appliedWorkarounds));
        }
        return appliedWorkarounds;
    }

    private boolean applyWorkaround(Workaround workaround) throws WorkaroundException {
        if (this.isWorkaroundAlreadyApplied(workaround)) {
            LOGGER.trace("Workaround \"{}\" has previously been applied. Skipping application.", (Object)workaround.getName());
            return false;
        }
        if (workaround.isNecessary()) {
            workaround.apply();
            return true;
        }
        return false;
    }

    private boolean isWorkaroundAlreadyApplied(Workaround workaround) {
        return this.previouslyAppliedWorkarounds.contains(workaround.getName());
    }

    private String joinWorkaroundNames(Set<Workaround> workarounds) {
        return workarounds.stream().map(Workaround::getName).collect(Collectors.joining(", "));
    }
}

