/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.bucketfs.testcontainers;

import com.exasol.bucketfs.Bucket;
import com.exasol.bucketfs.BucketFactory;
import com.exasol.bucketfs.SyncAwareBucket;
import com.exasol.bucketfs.WriteEnabledBucket;
import com.exasol.bucketfs.monitor.BucketFsMonitor;
import com.exasol.bucketfs.testcontainers.LogBasedBucketFsMonitor;
import com.exasol.clusterlogs.LogPatternDetectorFactory;
import com.exasol.config.BucketConfiguration;
import com.exasol.config.BucketFsServiceConfiguration;
import com.exasol.config.ClusterConfiguration;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestcontainerBucketFactory
implements BucketFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestcontainerBucketFactory.class);
    private final Map<String, Bucket> buckets = new HashMap<String, Bucket>();
    private String host;
    private ClusterConfiguration clusterConfiguration;
    private X509Certificate certificate;
    private Map<Integer, Integer> portMappings;
    private LogPatternDetectorFactory detectorFactory;
    private LogBasedBucketFsMonitor.FilterStrategy filterStrategy = LogBasedBucketFsMonitor.FilterStrategy.TIME_STAMP;

    public static Builder builder() {
        return new Builder();
    }

    private TestcontainerBucketFactory() {
    }

    public synchronized Bucket getBucket(String serviceName, String bucketName) {
        BucketFsServiceConfiguration serviceConfiguration = this.clusterConfiguration.getBucketFsServiceConfiguration(serviceName);
        BucketConfiguration bucketConfiguration = serviceConfiguration.getBucketConfiguration(bucketName);
        String bucketPath = serviceName + "/" + bucketName;
        this.buckets.computeIfAbsent(bucketPath, key -> {
            LogBasedBucketFsMonitor monitor = new LogBasedBucketFsMonitor(this.detectorFactory, this.filterStrategy);
            SyncAwareBucket.Builder builder = (SyncAwareBucket.Builder)((WriteEnabledBucket.Builder)((WriteEnabledBucket.Builder)((WriteEnabledBucket.Builder)((WriteEnabledBucket.Builder)((WriteEnabledBucket.Builder)((WriteEnabledBucket.Builder)SyncAwareBucket.builder().monitor((BucketFsMonitor)monitor).stateRetriever(monitor.createStateRetriever()).serviceName(serviceName)).name(bucketName)).host(this.host)).certificate(this.certificate)).allowAlternativeHostName(this.host)).readPassword(bucketConfiguration.getReadPassword())).writePassword(bucketConfiguration.getWritePassword());
            if (serviceConfiguration.getHttpsPort() != 0) {
                int mappedPort = this.mapPort(serviceConfiguration.getHttpsPort());
                LOGGER.debug("Using encrypted BucketFS port {} (mapped to {})", (Object)serviceConfiguration.getHttpsPort(), (Object)mappedPort);
                ((WriteEnabledBucket.Builder)builder.port(mappedPort)).useTls(true);
            } else if (serviceConfiguration.getHttpPort() != 0) {
                int mappedPort = this.mapPort(serviceConfiguration.getHttpPort());
                LOGGER.debug("Using unencrypted BucketFS port {} (mapped to {})", (Object)serviceConfiguration.getHttpPort(), (Object)mappedPort);
                ((WriteEnabledBucket.Builder)builder.port(mappedPort)).useTls(false);
            } else {
                throw new IllegalStateException("Neither HTTPS nor HTTP port is defined for BucketFS");
            }
            return builder.build();
        });
        return this.buckets.get(bucketPath);
    }

    private int mapPort(int internalPort) {
        Integer port = this.portMappings.get(internalPort);
        if (port == null) {
            throw new IllegalStateException("Internal port " + internalPort + " is not mapped. Current port mappings: " + this.portMappings);
        }
        return port;
    }

    public static class Builder {
        private final TestcontainerBucketFactory factory = new TestcontainerBucketFactory();

        public Builder host(String value) {
            this.factory.host = value;
            return this;
        }

        public Builder clusterConfiguration(ClusterConfiguration value) {
            this.factory.clusterConfiguration = value;
            return this;
        }

        public Builder portMappings(Map<Integer, Integer> value) {
            this.factory.portMappings = Objects.requireNonNull(value, "portMappings");
            return this;
        }

        public Builder detectorFactory(LogPatternDetectorFactory value) {
            this.factory.detectorFactory = value;
            return this;
        }

        public Builder filterStrategy(LogBasedBucketFsMonitor.FilterStrategy value) {
            this.factory.filterStrategy = value;
            return this;
        }

        public Builder certificate(X509Certificate certificate) {
            this.factory.certificate = Objects.requireNonNull(certificate, "certificate");
            return this;
        }

        public TestcontainerBucketFactory build() {
            return this.factory;
        }
    }
}

