/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers;

import com.exasol.containers.ExasolDockerImageReference;
import com.exasol.containers.LiteralExasolDockerImageReference;
import com.exasol.containers.VersionBasedExasolDockerImageReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DockerImageReferenceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerImageReferenceFactory.class);
    private static final String REPOSITORY_PATTERN = "(?:(?:exasol/)?docker-db:)?";
    private static final String VERSION_PREFIX_PATTERN = "(?:(\\w+)-)?";
    private static final String EXASOL_VERSION_PATTERN = "(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?";
    private static final String SUFFIX_PATTERN = "(?:([-.])([a-zA-Z]\\w*))??";
    private static final String DOCKER_IMAGE_REVISION_PATTERN = "(?:-d(\\d+))?";
    private static final Pattern DOCKER_IMAGE_VERSION_PATTERN = Pattern.compile("(?:(?:exasol/)?docker-db:)?(?:(\\w+)-)?(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:([-.])([a-zA-Z]\\w*))??(?:-d(\\d+))?");

    private DockerImageReferenceFactory() {
    }

    static ExasolDockerImageReference parseOverridable(String imageName, boolean allowOverride) {
        return DockerImageReferenceFactory.parse(allowOverride ? DockerImageReferenceFactory.versionFromSystemPropertyOrIndividual(imageName) : imageName);
    }

    public static String versionFromSystemPropertyOrIndividual(String individual) {
        String fromProperty = System.getProperty("com.exasol.dockerdb.image");
        if (fromProperty != null) {
            return fromProperty;
        }
        LOGGER.info("System property '{}' is not set. Using docker image version '{}'.", (Object)"com.exasol.dockerdb.image", (Object)individual);
        return individual;
    }

    public static ExasolDockerImageReference parse(String reference) {
        Matcher matcher = DOCKER_IMAGE_VERSION_PATTERN.matcher(reference);
        if (matcher.matches()) {
            String prefix = matcher.group(1) == null ? VersionBasedExasolDockerImageReference.PREFIX_NOT_PRESENT : matcher.group(1);
            int major = Integer.parseInt(matcher.group(2));
            int minor = matcher.group(3) == null ? 0 : Integer.parseInt(matcher.group(3));
            int fix = matcher.group(4) == null ? 0 : Integer.parseInt(matcher.group(4));
            String suffixSeparator = matcher.group(5) == null ? VersionBasedExasolDockerImageReference.SUFFIX_NOT_PRESENT : matcher.group(5);
            String suffix = matcher.group(6) == null ? VersionBasedExasolDockerImageReference.SUFFIX_NOT_PRESENT : matcher.group(6);
            int dockerImageRevision = matcher.group(7) == null ? -1 : Integer.parseInt(matcher.group(7));
            return new VersionBasedExasolDockerImageReference(major, minor, fix, prefix, suffixSeparator, suffix, dockerImageRevision);
        }
        return new LiteralExasolDockerImageReference(reference);
    }
}

