/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.database;

import com.exasol.containers.ssh.SshException;
import com.exasol.database.DatabaseServiceException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;

public class DatabaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseService.class);
    private final String databaseName;
    private final Container<? extends Container<?>> container;

    public DatabaseService(String databaseName, Container<? extends Container<?>> container) {
        this.databaseName = databaseName;
        this.container = container;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void start() throws InterruptedException {
        LOGGER.debug("Starting database \"{}\".", (Object)this.databaseName);
        this.changeDatabaseState("start", "start-wait", "started");
    }

    private void changeDatabaseState(String action, String dwadCommand, String resultState) throws InterruptedException {
        try {
            long before = System.currentTimeMillis();
            Container.ExecResult result = this.container.execInContainer(new String[]{"dwad_client", dwadCommand, this.databaseName});
            if (result.getExitCode() != 0) {
                throw new DatabaseServiceException(this.databaseName, "Attempt to " + action + " the database \"" + this.databaseName + "\" failed");
            }
            LOGGER.debug("Database \"{}\" {} {} ms after {} request.", new Object[]{this.databaseName, resultState, System.currentTimeMillis() - before, action});
        }
        catch (SshException | IOException | UnsupportedOperationException exception) {
            throw new DatabaseServiceException(this.databaseName, "Unable to " + action + " database service.", exception);
        }
    }

    public void stop() throws InterruptedException {
        LOGGER.debug("Stopping database \"{}\".", (Object)this.databaseName);
        this.changeDatabaseState("stop", "stop-wait", "stopped");
    }
}

