/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.database;

import com.exasol.config.ClusterConfiguration;
import com.exasol.database.DatabaseService;
import java.util.HashMap;
import java.util.Map;
import org.testcontainers.containers.Container;

public final class DatabaseServiceFactory {
    private final Map<String, DatabaseService> services = new HashMap<String, DatabaseService>();
    private final ClusterConfiguration clusterConfiguration;
    private final Container<? extends Container<?>> container;

    public DatabaseServiceFactory(Container<? extends Container<?>> container, ClusterConfiguration clusterConfiguration) {
        this.container = container;
        this.clusterConfiguration = clusterConfiguration;
    }

    public DatabaseService getDatabaseService(String databaseName) {
        if (this.services.containsKey(databaseName)) {
            return this.services.get(databaseName);
        }
        if (this.clusterConfiguration.containsDatabaseService(databaseName)) {
            DatabaseService service = new DatabaseService(databaseName, this.container);
            this.services.put(databaseName, service);
            return service;
        }
        throw new IllegalArgumentException("Database service \"" + databaseName + "\" does not exist. Pick one of: " + String.join((CharSequence)", ", this.clusterConfiguration.getDatabaseNames()));
    }
}

