/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.clusterlogs;

import com.exasol.bucketfs.monitor.BucketFsMonitor;
import com.exasol.bucketfs.monitor.LineCountRetriever;
import com.exasol.bucketfs.testcontainers.LogPatternProvider;
import com.exasol.clusterlogs.LogEntryPresentPatternVerifier;
import com.exasol.clusterlogs.LogPatternDetector;
import com.exasol.containers.ExasolContainer;
import com.exasol.containers.ExasolDockerImageReference;
import org.testcontainers.containers.Container;

public class LogPatternDetectorFactory {
    private final ExasolContainer<? extends Container<?>> container;

    public LogPatternDetectorFactory(ExasolContainer<? extends ExasolContainer<?>> container) {
        this.container = container;
    }

    public LogPatternDetector createLogPatternDetector(String logPath, String logNamePattern, String pattern, BucketFsMonitor.State state) {
        return LogPatternDetector.builder().container(this.container).logPath(logPath).logNamePattern(logNamePattern).pattern(pattern).forState(state).build();
    }

    public LineCountRetriever createLineCountRetriever(String logPath, String logNamePattern) {
        return new LineCountRetriever(this.container, logPath, logNamePattern);
    }

    public LogPatternDetector createLogPatternDetector(String logPath, String logNamePattern, String pattern) {
        return LogPatternDetector.builder().container(this.container).logPath(logPath).logNamePattern(logNamePattern).pattern(pattern).logEntryVerifier(new LogEntryPresentPatternVerifier()).build();
    }

    public LogPatternProvider getLogPatternProvider() {
        ExasolDockerImageReference image = this.container.getDockerImageReference();
        return image.hasMajor() && image.getMajor() < 8 ? LogPatternProvider.DEFAULT : LogPatternProvider.VERSION_8;
    }
}

