/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.slc.fileprovider;

import com.exasol.containers.ExasolContainerConstants;
import com.exasol.containers.slc.fileprovider.FileProvider;
import com.exasol.containers.slc.fileprovider.UrlDownloader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachingUrlFileProvider
implements FileProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingUrlFileProvider.class);
    private final UrlDownloader urlDownloader;
    private final Path localCacheDir;
    private final URL url;

    CachingUrlFileProvider(URL url) {
        this(new UrlDownloader(), CachingUrlFileProvider.getDefaultCacheDir(), url);
    }

    CachingUrlFileProvider(UrlDownloader urlDownloader, Path localCacheDir, URL url) {
        this.urlDownloader = urlDownloader;
        this.localCacheDir = localCacheDir;
        this.url = url;
    }

    private static Path getDefaultCacheDir() {
        return ExasolContainerConstants.CACHE_DIRECTORY.resolve("slcs");
    }

    @Override
    public Path getLocalFile() {
        Path localPath = this.localCacheDir.resolve(this.getFileName());
        if (Files.exists(localPath, new LinkOption[0])) {
            LOGGER.debug("Using cached file {}", (Object)localPath);
            return localPath;
        }
        this.createDirectories();
        this.urlDownloader.download(this.url, localPath);
        return localPath;
    }

    private void createDirectories() {
        if (Files.exists(this.localCacheDir, new LinkOption[0])) {
            return;
        }
        CachingUrlFileProvider.createDirectories(this.localCacheDir);
    }

    private static void createDirectories(Path dir) {
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Unable to create cache directory '" + dir + "'", exception);
        }
    }

    @Override
    public String getFileName() {
        String path = this.url.getPath();
        return this.url.getPath().substring(path.lastIndexOf(47) + 1);
    }
}

