/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.wait.strategy;

import com.exasol.clusterlogs.LogPatternDetectorFactory;
import com.exasol.containers.wait.strategy.LogFileEntryWaitStrategy;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdfContainerWaitStrategy
extends LogFileEntryWaitStrategy {
    public static final String SCRIPT_LANGUAGE_CONTAINER_READY_PATTERN = "ScriptLanguages.*extracted$";
    private static final long WAIT_FOR_UDF_CONTAINER_DURATION_IN_MILLISECONDS = TimeUnit.MINUTES.toMillis(10L);
    private static final Logger LOGGER = LoggerFactory.getLogger(UdfContainerWaitStrategy.class);

    public UdfContainerWaitStrategy(LogPatternDetectorFactory detectorFactory) {
        super(detectorFactory.createLogPatternDetector("/exa/logs/cored", "bucketfsd.*.log", SCRIPT_LANGUAGE_CONTAINER_READY_PATTERN));
    }

    @Override
    protected void waitUntilReady() {
        LOGGER.debug("Waiting {} for UDF language container to be ready.", (Object)Duration.ofMillis(this.getWaitTimeOutMilliseconds()));
        Instant start = Instant.now();
        super.waitUntilReady();
        LOGGER.debug("UDF language container is ready after {}.", (Object)Duration.between(start, Instant.now()));
    }

    @Override
    protected long getWaitTimeOutMilliseconds() {
        return WAIT_FOR_UDF_CONTAINER_DURATION_IN_MILLISECONDS;
    }
}

