/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.containers.workarounds;

import com.exasol.containers.ExasolContainer;
import com.exasol.containers.ExasolDockerImageReference;
import com.exasol.containers.ssh.SshException;
import com.exasol.containers.workarounds.Workaround;
import com.exasol.containers.workarounds.WorkaroundException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;

public class LogRotationWorkaround
implements Workaround {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogRotationWorkaround.class);
    private final ExasolContainer<? extends ExasolContainer<?>> exasol;

    public LogRotationWorkaround(ExasolContainer<? extends ExasolContainer<?>> exasol) {
        this.exasol = exasol;
    }

    @Override
    public String getName() {
        return "log rotation";
    }

    @Override
    public boolean isNecessary() {
        if (this.exasol.isReused()) {
            return false;
        }
        ExasolDockerImageReference reference = this.exasol.getDockerImageReference();
        if (reference.hasMajor() && (reference.getMajor() < 7 || reference.getMajor() == 7 && reference.hasMinor() && reference.getMinor() < 1)) {
            LOGGER.trace("Log rotation workaround required, since Exasol version is below 7.1.");
            return true;
        }
        return false;
    }

    @Override
    public void apply() throws WorkaroundException {
        try {
            Container.ExecResult result = this.exasol.execInContainer(new String[]{"sed", "-i", "-es/'bucketfsd[^']*log' //", "/etc/cron.daily/exa-logrotate"});
            if (result.getExitCode() != 0) {
                throw new WorkaroundException("Unable to apply log rotation workaround. Error during command execution: " + result.getStderr());
            }
        }
        catch (SshException | IOException | UnsupportedOperationException exception) {
            throw new WorkaroundException("Unable to apply log rotation workaround.", exception);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new WorkaroundException("Interrupted during attempt to apply log rotation workaround.");
        }
    }
}

