/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.exaconf;

import com.exasol.config.ClusterConfiguration;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class ConfigurationParser {
    private String section = "";
    private String subsection = "";
    private final Map<String, String> parameters = new HashMap<String, String>();
    private final String rawConfig;
    private static final Set<String> BASE64_ENCODED_VALUES = Set.of("ReadPasswd", "WritePasswd");

    public ConfigurationParser(String rawConfig) {
        this.rawConfig = rawConfig;
    }

    public ClusterConfiguration parse() {
        try (Scanner scanner = new Scanner(this.rawConfig);){
            while (scanner.hasNext()) {
                this.parseLine(scanner.nextLine());
            }
        }
        return new ClusterConfiguration(this.parameters);
    }

    private void parseLine(String line) {
        String unindentedLine = line.stripLeading();
        this.parseUnindentedLine(unindentedLine);
    }

    private void parseUnindentedLine(String line) {
        if (!line.isBlank() && !line.startsWith("#")) {
            if (line.startsWith("[[")) {
                this.subsection = this.stripSectionName(line) + "/";
            } else if (line.startsWith("[")) {
                this.section = this.stripSectionName(line) + "/";
                this.subsection = "";
            } else {
                int assignmentOperatorPosition = line.indexOf(61);
                if (assignmentOperatorPosition > 0) {
                    String key = line.substring(0, assignmentOperatorPosition - 1).trim();
                    String value = line.substring(assignmentOperatorPosition + 1).trim();
                    String decodedValue = BASE64_ENCODED_VALUES.contains(key) ? this.decodePassword(value) : value;
                    this.parameters.put(this.section + this.subsection + key, decodedValue);
                }
            }
        }
    }

    private String stripSectionName(String line) {
        return line.replaceAll("[\\s\\[\\]]", "");
    }

    private String decodePassword(String value) {
        return new String(Base64.getDecoder().decode(value));
    }
}

